<?php // $Id: install_files.inc.php,v 1.41 2005/06/17 11:50:29 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	Install the Dokeos files
*	Notice : This script has to be included by index.php
*
*	@package dokeos.install
==============================================================================
*/

if(defined('DOKEOS_INSTALL'))
{
	$fp=@fopen('../inc/conf/claro_main.conf.php','w');

	if(!$fp)
	{
		echo '<b><font color="red">Your script doesn\'t have write access to the config directory</font></b><br>
		<em>('.str_replace('\\','/',realpath('../inc/conf/')).')</em><br><br>
		You probably do not have write access on Egnosis root directory,
		i.e. you should <em>CHMOD 777</em> or <em>755</em> or <em>775</em><br><br>
		Your problems can be related on two possible causes :<br>
		<ul>
		  <li>Permission problems. <br>Try initially with <em>chmod 777 -R</em> and increase restrictions gradually.</li>
		  <li>PHP is running in <a href="http://www.php.net/manual/en/features.safe-mode.php" target="_phpman">Safe-Mode</a>. If possible, try to switch it off.</li>
		</ul>
		<a href="http://www.dokeos.com/forum/" target="_blank">Read about this problem in Support Forum</a><br><br>
		Please go back to step 5.
	    <p><input type="submit" name="step5" value="&lt; Back"></p>
	    </td></tr></table></form></body></html>';

		exit();
	}

	$stringConfig=str_replace("\r","",'<?php
# DOKEOS version '.$clarolineVersion.'
# File generated by /install/index.php script - '.date('r').'
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/*
==============================================================================
		Configuration of virtual campus

This file contains a list of variables that can be modified by the campus
site administrator. Pay attention when changing these variables, some changes
can cause Dokeos to stop working.
==============================================================================
*/

// MySQL
$dbHost="'.$dbHostForm.'"; // your mysql server
$mysqlServer=$dbHost;
$dbLogin="'.$dbUsernameForm.'"; // your mysql username
$mysqlUser=$dbLogin;
$dbPass="'.str_replace('"','\"',$dbPassForm).'"; // your mysql password
$mysqlPassword=$dbPass;

$is_trackingEnabled='.trueFalse($enableTrackingForm).';
$singleDbEnabled='.trueFalse($singleDbForm).'; // DO NOT modify this
$courseTablePrefix="'.($singleDbForm?'crs_':'').'"; // IF NOT EMPTY, can be replaced by another prefix, else leave empty
$dbGlu="'.($singleDbForm?'_':'`.`').'"; // DO NOT modify this
$dbNamePrefix="'.$dbPrefixForm.'"; // prefix all created bases (for courses) with this string
$mysqlPrefix=$dbNamePrefix;

$mainDbName="'.$mysqlMainDb.'"; // main Dokeos database
$mysqlMainDb=$mainDbName;
$statsDbName="'.$mysqlStatsDb.'"; // stats Dokeos database
$scormDbName="'.$mysqlScormDb.'"; // Scorm Dokeos database
$user_personal_database="'.$mysqlUserDb.'"; // User Personal Database (where all the personal stuff of the user is stored (personal agenda items, course sorting)

// Directories
$rootWeb="'.$urlForm.'";
$urlServer=$rootWeb;
$serverAddress=$rootWeb;
$rootSys="'.str_replace('\\','/',realpath($pathForm).'/').'";
$webDir=$rootSys;
$urlAppend="'.$urlAppendPath.'";

$clarolineRepositoryAppend="claroline/";
$coursesRepositoryAppend="courses/";
$rootAdminAppend="admin/";

$clarolineRepositorySys=$rootSys.$clarolineRepositoryAppend;
$clarolineRepositoryWeb=$rootWeb.$clarolineRepositoryAppend;
$coursesRepositorySys=$rootSys.$coursesRepositoryAppend;
$coursesRepositoryWeb=$rootWeb.$coursesRepositoryAppend;
$rootAdminSys=$clarolineRepositorySys.$rootAdminAppend;
$rootAdminWeb=$clarolineRepositoryWeb.$rootAdminAppend;

$garbageRepositorySys="'.str_replace("\\","/",realpath($clarolineRepositorySys."../garbage/")."/").'"; // change this to a place out of web if you can

$mysqlRepositorySys="'.str_replace("\\","/",realpath($mysqlRepositorySys)."/").'";

$phpMyAdminPath="";

// For new login module
// Uncomment these lines to activate ldap
// $extAuthSource["ldap"]["login"]=$clarolineRepositorySys."auth/ldap/login.php";
// $extAuthSource["ldap"]["newUser"]=$clarolineRepositorySys."auth/ldap/newUser.php";

// General information
//$siteName="'.str_replace('"','\"',$campusForm).'"; // -> Moved to install_db.inc.php for the AWACS

$CourseProgram="http://www.ucl.ac.be/etudes/cours";

//$administratorSurname="'.str_replace('"','\"',$adminLastName).'";// -> Moved to install_db.inc.php for the AWACS
//$administratorName="'.str_replace('"','\"',$adminFirstName).'";// -> Moved to install_db.inc.php for the AWACS
//$emailAdministrator="'.str_replace('"','\"',$emailForm).'";// -> Moved to install_db.inc.php for the AWACS
// $telephone="'.str_replace('"','\"',$adminPhoneForm).'";// -> Moved to install_db.inc.php for the AWACS

//$administrator["name"]=$administratorName." ".$administratorSurname;// -> Moved to install_db.inc.php for the AWACS
//$administrator["phone"]=$telephone;// -> Moved to install_db.inc.php for the AWACS
//$administrator["email"]=$emailAdministrator;// -> Moved to install_db.inc.php for the AWACS

$educationManager["name"]="'.str_replace('"','\"',$educationForm).'";
$educationManager["phone"]="'.str_replace('"','\"',$educationPhoneForm).'";
$educationManager["email"]="'.str_replace('"','\"',$educationEmailForm).'";

// $Institution="'.str_replace('"','\"',$institutionForm).'"; // -> Moved to install_db.inc.php for the AWACS
//$InstitutionUrl="'.str_replace('"','\"',$institutionUrlForm).'"; // -> Moved to install_db.inc.php for the AWACS

//$institution["name"]=$Institution; // -> no longer in use, can probably be deleted
//$institution["url"]=$InstitutionUrl; // -> no longer in use, can probably be deleted

// Settings for new and future features
$checkEmailByHashSent='.trueFalse($checkEmailByHashSent).';
$ShowEmailnotcheckedToStudent='.trueFalse($ShowEmailnotcheckedToStudent).';
$userMailCanBeEmpty='.trueFalse($userMailCanBeEmpty).';
$userPasswordCrypted='.trueFalse($encryptPassForm).';
$allowSelfReg='.trueFalse($allowSelfReg).';
$allowSelfRegProf='.trueFalse($allowSelfRegProf).';
$storeSessionInDb=false; // You may have to restart your web server if you change this

// General tool options
$enable_student_view=true;
$homepage_view="default"; // "default" gives the default 2 column view
						  // "basic_tools_fixed" gives a 3 column view with the basic tools in fixed position

$color1="#F5F5F5"; // light grey
$color2="#E6E6E6"; // less light grey for bicolored tables, also used in forums, groups etc.

// Available Languages : look at the "lang" directory

$platformLanguage="'.$languageForm.'";
$language=$platformLanguage;

$clarolineVersion="'.$clarolineVersion.'";
$platformVersion=$clarolineVersion;

// Course backup
$dateBackup=date("Y-m-d-H-i-s");
$shortDateBackup=date("YzBs");

$verboseBackup=false;

$archiveDirName="archive";

// security word for password recovery

$security_key="'.md5(uniqid(rand().time())).'";

// plugins arrays
$plugins["main_menu"] = array();
$plugins["main_menu_logged"] = array();
$plugins["banner"] = array();
// To load a new plugin, add a line like this
// $plugins["main_menu"][] = "my_plugin";
// where "my_plugin" is the directory where your plugin is in claroline/plugin
// main_menu_logged is the same as main_menu for when a user is logged in
?>');

	fwrite($fp,$stringConfig);

	fclose($fp);

	$fp=@fopen('../../courses/.htaccess','w');

	if($fp)
	{
		$htaccess='###########################################################################################
#change this file to fit your configuration and save it as .htaccess in the courses folder#
###########################################################################################
#dokeos mod rewrite
#comment lines start with # and are not processed

<IfModule mod_rewrite.c>
RewriteEngine On
Options +FollowSymlinks

#rewrite base is the dir dokeos is installed in with trailing slash
RewriteBase '.$urlAppendPath.'/courses/

#do not rewrite on the claroline dir
#change this path to the path of your claroline folder
RewriteCond %{REQUEST_URI} !^'.$urlAppendPath.'/claroline/

#replace nasty ampersands by 3 slashes, we change these back in download.php
RewriteRule ([^/]+)/document/(.*)&(.*)$ $1/document/$2///$3 [N]
#rewrite everything in the document folder of a course to the download script
RewriteRule ([^/]+)/document/(.*)$ '.$urlAppendPath.'/claroline/document/download.php?doc_url=/$2&cDir=$1 [QSA,L]
</IfModule>';

		fwrite($fp,$htaccess);

		fclose($fp);
	}
}
else
{
	echo 'You are not allowed here !';
}
?>
