<?php // $Id: index.php,v 1.78.2.1 2005/08/23 14:03:26 roane Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Roan Embrechts, Vrije Universiteit Brussel

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* GOAL : Dokeos installation
* As seen from the user, the installation proceeds in 6 steps.
* The user is presented with several webpages where he/she has to make choices
* and/or fill in data.
*
* The aim is, as always, to have good default settings and suggestions.
*
* @todo	reduce high level of duplication in this code
* @package dokeos.install
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/

require('../inc/installedVersion.inc.php');
require('../inc/lib/main_api.lib.php');

require('../lang/english/trad4all.inc.php');
require('../lang/english/install.inc.php');
require('../inc/lib/auth.lib.inc.php');

define('DOKEOS_INSTALL',1);
define('MAX_COURSE_TRANSFER',100);

error_reporting(E_COMPILE_ERROR | E_ERROR | E_CORE_ERROR);

@set_time_limit(0);

$updateFromVersion=array('1.5','1.5.4','1.5.5');

/*
==============================================================================
		STEP 1 : INITIALIZES FORM VARIABLES IF IT IS THE FIRST VISIT
==============================================================================
*/

$badUpdatePath=false;

if($_POST['step2_install'] || $_POST['step2_update'])
{
	if($_POST['step2_install'])
	{
		$installType='new';

		$_POST['step2']=1;
	}
	else
	{
		$installType='update';

		if(empty($_POST['updatePath']))
		{
			$_POST['step1']=1;
		}
		else
		{
			if($_POST['updatePath'][strlen($_POST['updatePath'])-1] != '/')
			{
				$_POST['updatePath'].='/';
			}

			if(file_exists($_POST['updatePath']))
			{
				if(in_array(get_config_param('clarolineVersion'),$updateFromVersion))
				{
					$_POST['step2']=1;
				}
				else
				{
					$badUpdatePath=true;
				}
			}
			else
			{
				$badUpdatePath=true;
			}
		}
	}
}
elseif($_POST['step1'])
{
	$_POST['updatePath']='';
	$installType='';
	$updateFromConfigFile='';
	unset($_GET['running']);
}
else
{
	$installType=$_GET['installType'];
	$updateFromConfigFile=$_GET['updateFromConfigFile'];
}

if(!isset($_GET['running']))
{
	$dbHostForm='localhost';
	$dbUsernameForm='root';
	$dbPassForm='';
 	$dbPrefixForm='';
	$dbNameForm='dokeos_main';
	$dbStatsForm='dokeos_stats';
	$dbScormForm='dokeos_scorm';
	$dbUserForm='dokeos_user';

	// extract the path to append to the url if Dokeos is not installed on the web root directory
	$urlAppendPath=str_replace('/claroline/install/index.php','',$_SERVER['PHP_SELF']);
  	$urlForm='http://'.$_SERVER['HTTP_HOST'].$urlAppendPath.'/';
	$pathForm=str_replace('\\','/',realpath('../..')).'/';

	$emailForm=$_SERVER['SERVER_ADMIN'];

	$adminLastName='Doe';
	$adminFirstName='John';
	$loginForm='admin';
	$passForm=generePass(8);

	$campusForm='My portal';
	$educationForm='Albert Einstein';
	$adminPhoneForm='(000) 001 02 03';
	$institutionForm='My Organisation';
	$institutionUrlForm='http://www.dokeos.com';

	$languageForm='english';

	$checkEmailByHashSent=0;
	$ShowEmailnotcheckedToStudent=1;
	$userMailCanBeEmpty=1;
	$allowSelfReg=1;
	$allowSelfRegProf=1;
	$enableTrackingForm=1;
	$singleDbForm=0;
	$encryptPassForm=1;
}
else
{
	foreach($_POST as $key=>$val)
	{
		$magic_quotes_gpc=ini_get('magic_quotes_gpc')?true:false;

		if(is_string($val))
		{
			if($magic_quotes_gpc)
			{
				$val=stripslashes($val);
			}

			$val=trim($val);

			$_POST[$key]=$val;
		}
		elseif(is_array($val))
		{
			foreach($val as $key2=>$val2)
			{
				if($magic_quotes_gpc)
				{
					$val2=stripslashes($val2);
				}

				$val2=trim($val2);

				$_POST[$key][$key2]=$val2;
			}
		}

		$GLOBALS[$key]=$_POST[$key];
	}
}
?>

<html>
<head>
<title>-- Egnosis installation -- version <?php echo $platformVersion; ?></title>
<link rel="stylesheet" href="../css/default.css" type="text/css">
</head>
<body bgcolor="white" dir="<?php echo $text_dir ?>">

<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?running=1&installType=<?php echo $installType; ?>&updateFromConfigFile=<?php echo urlencode($updateFromConfigFile); ?>" autocomplete="off">
<table cellpadding="8" cellspacing="0" border="0" width="100%" bgcolor="#E6E6E6" align="center">

<tr bgcolor="#4171B5"">
  <td valign="top">
	<big><font color="white">Egnosis installation - version <?php echo $platformVersion; ?><?php if($installType == 'new') echo ' - New installation'; else if($installType == 'update') echo ' - Update from Dokeos '.implode('|',$updateFromVersion); ?></font></big>
  </td>
</tr>
<tr>
<td>
<table cellpadding="6" cellspacing="0" border="0" width="80%" align="center">
<tr bgcolor="#E6E6E6">
  <td>
	<input type="hidden" name="updatePath" value="<?php if(!$badUpdatePath) echo htmlentities($_POST['updatePath']); ?>">
	<input type="hidden" name="urlAppendPath" value="<?php echo htmlentities($urlAppendPath); ?>">
	<input type="hidden" name="pathForm" value="<?php echo htmlentities($pathForm); ?>">
	<input type="hidden" name="urlForm" value="<?php echo htmlentities($urlForm); ?>">
	<input type="hidden" name="dbHostForm" value="<?php echo htmlentities($dbHostForm); ?>">
	<input type="hidden" name="dbUsernameForm" value="<?php echo htmlentities($dbUsernameForm); ?>">
	<input type="hidden" name="dbPassForm" value="<?php echo htmlentities($dbPassForm); ?>">
	<input type="hidden" name="singleDbForm" value="<?php echo htmlentities($singleDbForm); ?>">
	<input type="hidden" name="dbPrefixForm" value="<?php echo htmlentities($dbPrefixForm); ?>">
	<input type="hidden" name="dbNameForm" value="<?php echo htmlentities($dbNameForm); ?>">
	<input type="hidden" name="dbStatsForm" value="<?php echo htmlentities($dbStatsForm); ?>">
	<input type="hidden" name="dbScormForm" value="<?php echo htmlentities($dbScormForm); ?>">
	<input type="hidden" name="dbUserForm" value="<?php echo htmlentities($dbUserForm); ?>">
	<input type="hidden" name="enableTrackingForm" value="<?php echo htmlentities($enableTrackingForm); ?>">
	<input type="hidden" name="allowSelfReg" value="<?php echo htmlentities($allowSelfReg); ?>">
	<input type="hidden" name="allowSelfRegProf" value="<?php echo htmlentities($allowSelfRegProf); ?>">
	<input type="hidden" name="emailForm" value="<?php echo htmlentities($emailForm); ?>">
	<input type="hidden" name="adminLastName" value="<?php echo htmlentities($adminLastName); ?>">
	<input type="hidden" name="adminFirstName" value="<?php echo htmlentities($adminFirstName); ?>">
	<input type="hidden" name="adminPhoneForm" value="<?php echo htmlentities($adminPhoneForm); ?>">
	<input type="hidden" name="loginForm" value="<?php echo htmlentities($loginForm); ?>">
	<input type="hidden" name="passForm" value="<?php echo htmlentities($passForm); ?>">
	<input type="hidden" name="languageForm" value="<?php echo htmlentities($languageForm); ?>">
	<input type="hidden" name="campusForm" value="<?php echo htmlentities($campusForm); ?>">
	<input type="hidden" name="educationForm" value="<?php echo htmlentities($educationForm); ?>">
	<input type="hidden" name="institutionForm" value="<?php echo htmlentities($institutionForm); ?>">
	<input type="hidden" name="institutionUrlForm" value="<?php echo stristr($institutionUrlForm,'http://')?htmlentities($institutionUrlForm):'http://'.htmlentities($institutionUrlForm); ?>">
	<input type="hidden" name="checkEmailByHashSent" value="<?php echo htmlentities($checkEmailByHashSent); ?>">
	<input type="hidden" name="ShowEmailnotcheckedToStudent" value="<?php echo htmlentities($ShowEmailnotcheckedToStudent); ?>">
	<input type="hidden" name="userMailCanBeEmpty" value="<?php echo htmlentities($userMailCanBeEmpty); ?>">
	<input type="hidden" name="encryptPassForm" value="<?php echo htmlentities($encryptPassForm); ?>">

	<img src="../img/bluelogo.gif" align="right" hspace="10" vspace="10">

<?php
/*
==============================================================================
		STEP 2 : LICENSE
==============================================================================
*/

if($_POST['step2'])
{
?>

	<h2><?php echo $langStep2.' - '.$langLicence; ?></h2>
	<p>Dokeos is free software distributed under the GNU General Public licence (GPL).
	Please read the license and click 'I accept'.
	<br><a href="../license/gpl_print.txt" target="_top"> <?php echo $langPrintVers; ?></a>
	</p>
	<table><TR><TD>
		<p><textarea cols="75" rows="15" wrap="virtual"><?php include('../license/gpl.txt'); ?></textarea></p>
		</td>
		</tr>
		<tr>
		<td>
		<table width="100%">
			<tr>
			<td></td>
			<td align="right">
			<input type="submit" name="step1" value="&lt; Back">
			<input type="submit" name="step3" value="I accept &gt;">
			</td>
			</tr>
		</table>
	</TD></TR></table>
<?php
}

/*
==============================================================================
		STEP 3 : MYSQL DATABASE SETTINGS
==============================================================================
*/

elseif($_POST['step3'])
{
	if($installType == 'update')
	{
		$dbHostForm=get_config_param('dbHost');
		$dbUsernameForm=get_config_param('dbLogin');
		$dbPassForm=get_config_param('dbPass');
		$dbPrefixForm=get_config_param('dbNamePrefix');
		$enableTrackingForm=get_config_param('is_trackingEnabled');
		$singleDbForm=get_config_param('singleDbEnabled');
		$dbNameForm=get_config_param('mainDbName');
		$dbStatsForm=get_config_param('statsDbName');
		$dbScormForm=get_config_param('scormDbName');

		$dbScormExists=true;

		if(empty($dbScormForm))
		{
			if($singleDbForm)
			{
				$dbScormForm=$dbNameForm;
			}
			else
			{
				$dbScormForm=$dbPrefixForm.'scorm';

				$dbScormExists=false;
			}
		}

		if($singleDbForm)
		{
			$dbUserForm=$dbNameForm;
		}
		else
		{
			$dbUserForm=$dbPrefixForm.'dokeos_user';
		}
	}
?>

	<h2><?php echo $langStep3.' - '.$langDBSetting; ?></h2>

	<?php echo $langDBSettingIntro; ?>
	<br><br>
  </td>
</tr>
<tr>
  <td>
	<table width="100%">
	<tr>
	  <td width="40%"><?php echo $langDBHost; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td width="30%"><input type="hidden" name="dbHostForm" value="<?php echo htmlentities($dbHostForm); ?>"><?php echo $dbHostForm; ?></td>
	  <td width="30%">&nbsp;</td>
	  <?php else: ?>
	  <td width="30%"><input type="text" size="25" maxlength="50" name="dbHostForm" value="<?php echo htmlentities($dbHostForm); ?>"></td>
	  <td width="30%"><?php echo $langEG.' localhost'; ?></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langDBLogin; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="dbUsernameForm" value="<?php echo htmlentities($dbUsernameForm); ?>"><?php echo $dbUsernameForm; ?></td>
	  <td>&nbsp;</td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbUsernameForm" value="<?php echo htmlentities($dbUsernameForm); ?>"></td>
	  <td><?php echo $langEG; ?> root</td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langDBPassword; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="dbPassForm" value="<?php echo htmlentities($dbPassForm); ?>"><?php echo $dbPassForm; ?></td>
	  <td>&nbsp;</td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbPassForm" value="<?php echo htmlentities($dbPassForm); ?>"></td>
	  <td><?php echo $langEG.' '.generePass(8); ?></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langDbPrefixForm; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="dbPrefixForm" value="<?php echo htmlentities($dbPrefixForm); ?>"><?php echo $dbPrefixForm; ?></td>
	  <td>&nbsp;</td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbPrefixForm" value="<?php echo htmlentities($dbPrefixForm); ?>"></td>
	  <td><?php echo $langDbPrefixCom; ?></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langMainDB; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="dbNameForm" value="<?php echo htmlentities($dbNameForm); ?>"><?php echo $dbNameForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbNameForm" value="<?php echo htmlentities($dbNameForm); ?>"></td>
	  <?php endif; ?>

	  <td>&nbsp;</td>
	</tr>
	<tr>
	  <td><?php echo $langStatDB; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="dbStatsForm" value="<?php echo htmlentities($dbStatsForm); ?>"><?php echo $dbStatsForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbStatsForm" value="<?php echo htmlentities($dbStatsForm); ?>"></td>
	  <?php endif; ?>

	  <td>&nbsp;</td>
	</tr>
	<tr>
	  <td><?php echo $langScormDB; ?> </td>

	  <?php if($installType == 'update' && $dbScormExists): ?>
	  <td><input type="hidden" name="dbScormForm" value="<?php echo htmlentities($dbScormForm); ?>"><?php echo $dbScormForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbScormForm" value="<?php echo htmlentities($dbScormForm); ?>"></td>
	  <?php endif; ?>

	  <td>&nbsp;</td>
	</tr>
	<tr>
	  <td><?php echo $langUserDB; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="dbUserForm" value="<?php echo htmlentities($dbUserForm); ?>"><?php echo $dbUserForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="25" maxlength="50" name="dbUserForm" value="<?php echo htmlentities($dbUserForm); ?>"></td>
	  <?php endif; ?>

	  <td>&nbsp;</td>
	</tr>
	<tr>
	  <td><?php echo $langEnableTracking; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="enableTrackingForm" value="<?php echo $enableTrackingForm; ?>"><?php echo $enableTrackingForm?$langYes:$langNo; ?></td>
	  <?php else: ?>
	  <td>
		<input class="checkbox" type="radio" name="enableTrackingForm" value="1" <?php echo $enableTrackingForm?'checked="checked"':''; ?>> <?php echo $langYes; ?>
		<input class="checkbox" type="radio" name="enableTrackingForm" value="0" <?php echo $enableTrackingForm?'':'checked="checked"'; ?>> <?php echo $langNo; ?>
	  </td>
	  <?php endif; ?>

	  <td>&nbsp;</td>
	</tr>
	<tr>
	  <td><?php echo $langSingleDb; ?> </td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="singleDbForm" value="<?php echo $singleDbForm; ?>"><?php echo $singleDbForm?$langOne:$langSeveral; ?></td>
	  <?php else: ?>
	  <td>
		<input class="checkbox" type="radio" name="singleDbForm" value="1" <?php echo $singleDbForm?'checked="checked"':''; ?>> <?php echo $langOne; ?>
		<input class="checkbox" type="radio" name="singleDbForm" value="0" <?php echo $singleDbForm?'':'checked="checked"'; ?>> <?php echo $langSeveral; ?>
	  </td>
	  <?php endif; ?>

	  <td>&nbsp;</td>
	</tr>
	<tr>
	  <td><input type="submit" name="step2" value="&lt; Back"></td>
	  <td>&nbsp;</td>
	  <td align="right"><input type="submit" name="step4" value="Next &gt;"></td>
	</tr>
	</table>

<?php
}

/*
==============================================================================
		STEP 4 : CONFIGURATION SETTINGS
==============================================================================
*/

elseif($_POST['step4'])
{
	if($installType == 'update')
	{
		$languageForm=get_config_param('platformLanguage');
		$emailForm=get_config_param('emailAdministrator');
		list($adminFirstName,$adminLastName)=explode(' ',get_config_param('administrator["name"]'));
		$adminPhoneForm=get_config_param('administrator["phone"]');
		$campusForm=get_config_param('siteName');
		$institutionForm=get_config_param('institution["name"]');
		$institutionUrlForm=get_config_param('institution["url"]');
		$encryptPassForm=get_config_param('userPasswordCrypted');
		$allowSelfReg=get_config_param('allowSelfReg');
	}
?>

	<h2><?php echo $langStep4.' - '.$langCfgSetting; ?></h2>

	The following values will be written into your configuration file <b>claroline/inc/conf/claro_main.conf.php</b>:
  </td>
</tr>
<tr>
  <td>
	<table width="100%">
	<tr>
	  <td><?php echo $langMainLang; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="languageForm" value="<?php echo htmlentities($languageForm); ?>"><?php echo $languageForm; ?></td>
	  <?php else: ?>
	  <td>
		<select name="languageForm">

<?php
	$dirname='../lang/';

	if($dir=@opendir($dirname))
	{
		while($file=readdir($dir))
		{
			if($file != '.' && $file != '..' && $file != 'CVS' && is_dir($dirname.$file))
			{
?>

		<option value="<?php echo $file; ?>" <?php if($file == $languageForm) echo 'selected="selected"'; ?>><?php echo $file; ?></option>

<?php
			}
		}

		closedir($dir);
	}
?>

		</select>
	  </td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langDokeosURL; ?> (<font color="#cc0033">required</font>) :</td>
	  <td><input type="text" size="40" maxlength="100" name="urlForm" value="<?php echo htmlentities($urlForm); ?>"></td>
	</tr>
	<tr>
	  <td><?php echo $langAdminEmail; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="emailForm" value="<?php echo htmlentities($emailForm); ?>"><?php echo $emailForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="50" name="emailForm" value="<?php echo htmlentities($emailForm); ?>"></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langAdminLastName; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="adminLastName" value="<?php echo htmlentities($adminLastName); ?>"><?php echo $adminLastName; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="50" name="adminLastName" value="<?php echo htmlentities($adminLastName); ?>"></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langAdminFirstName; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="adminFirstName" value="<?php echo htmlentities($adminFirstName); ?>"><?php echo $adminFirstName; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="50" name="adminFirstName" value="<?php echo htmlentities($adminFirstName); ?>"></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langAdminPhone; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="adminPhoneForm" value="<?php echo htmlentities($adminPhoneForm); ?>"><?php echo $adminPhoneForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="50" name="adminPhoneForm" value="<?php echo htmlentities($adminPhoneForm); ?>"></td>
	  <?php endif; ?>

	</tr>

	<?php if($installType != 'update'): ?>
	<tr>
	  <td><?php echo $langAdminLogin; ?> :</td>
	  <td><input type="text" size="40" maxlength="50" name="loginForm" value="<?php echo htmlentities($loginForm); ?>"></td>
	</tr>
	<tr>
	  <td><?php echo $langAdminPass; ?> :</td>
	  <td><input type="text" size="40" maxlength="50" name="passForm" value="<?php echo htmlentities($passForm); ?>"></td>
	</tr>
	<?php endif; ?>

	<tr>
	  <td><?php echo $langCampusName; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="campusForm" value="<?php echo htmlentities($campusForm); ?>"><?php echo $campusForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="100" name="campusForm" value="<?php echo htmlentities($campusForm); ?>"></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langInstituteShortName; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="institutionForm" value="<?php echo htmlentities($institutionForm); ?>"><?php echo $institutionForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="100" name="institutionForm" value="<?php echo htmlentities($institutionForm); ?>"></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langInstituteURL; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="institutionUrlForm" value="<?php echo htmlentities($institutionUrlForm); ?>"><?php echo $institutionUrlForm; ?></td>
	  <?php else: ?>
	  <td><input type="text" size="40" maxlength="100" name="institutionUrlForm" value="<?php echo htmlentities($institutionUrlForm); ?>"></td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langEncryptUserPass; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="encryptPassForm" value="<?php echo $encryptPassForm; ?>"><?php echo $encryptPassForm?$langYes:$langNo; ?></td>
	  <?php else: ?>
	  <td>
		<input class="checkbox" type="radio" name="encryptPassForm" value="1" <?php echo $encryptPassForm?'checked="checked"':''; ?>> <?php echo $langYes; ?>
		<input class="checkbox" type="radio" name="encryptPassForm" value="0" <?php echo $encryptPassForm?'':'checked="checked"'; ?>> <?php echo $langNo; ?>
	  </td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langAllowSelfReg; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="allowSelfReg" value="<?php echo $allowSelfReg; ?>"><?php echo $allowSelfReg?$langYes:$langNo; ?></td>
	  <?php else: ?>
	  <td>
		<input class="checkbox" type="radio" name="allowSelfReg" value="1" <?php echo $allowSelfReg?'checked="checked"':''; ?>> <?php echo $langYes.' '.$langRecommended; ?>
		<input class="checkbox" type="radio" name="allowSelfReg" value="0" <?php echo $allowSelfReg?'':'checked="checked"'; ?>> <?php echo $langNo; ?>
	  </td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><?php echo $langAllowSelfRegProf; ?> :</td>

	  <?php if($installType == 'update'): ?>
	  <td><input type="hidden" name="allowSelfRegProf" value="<?php echo $allowSelfRegProf; ?>"><?php echo $allowSelfRegProf?$langYes:$langNo; ?></td>
	  <?php else: ?>
	  <td>
		<input class="checkbox" type="radio" name="allowSelfRegProf" value="1" <?php echo $allowSelfRegProf?'checked="checked"':''; ?>> <?php echo $langYes; ?>
		<input class="checkbox" type="radio" name="allowSelfRegProf" value="0" <?php echo $allowSelfRegProf?'':'checked="checked"'; ?>> <?php echo $langNo; ?>
	  </td>
	  <?php endif; ?>

	</tr>
	<tr>
	  <td><input type="submit" name="step3" value="&lt; Back"></td>
	  <td align="right"><input type="submit" name="step5" value="Next &gt;"></td>
	</tr>
	</table>

<?php
}

/*
==============================================================================
		STEP 5 : LAST CHECK BEFORE INSTALL
==============================================================================
*/

elseif($_POST['step5'])
{
?>

	<h2><?php echo $langStep5.' - '.$langLastCheck; ?></h2>

	Here are the values you entered
	<br>
	<b>Print this page to remember your password and other settings</b>

	<blockquote>

	<?php echo $langMainLang.' : '.$languageForm; ?><br><br>

	<?php echo $langDBHost.' : '.$dbHostForm; ?><br>
	<?php echo $langDBLogin.' : '.$dbUsernameForm; ?><br>
	<?php echo $langDBPassword.' : '.$dbPassForm; ?><br>
	<?php if(!empty($dbPrefixForm)) echo $langDbPrefixForm.' : '.$dbPrefixForm.'<br>'; ?>
	<?php echo $langMainDB.' : <b>'.$dbNameForm; ?></b><?php if($installType == 'new') echo ' (<font color="#cc0033">read warning below</font>)'; ?><br>
	<?php echo $langStatDB.' : <b>'.$dbStatsForm; ?></b><?php if($installType == 'new') echo ' (<font color="#cc0033">read warning below</font>)'; ?><br>
	<?php echo $langScormDB.' : <b>'.$dbScormForm; ?></b><?php if($installType == 'new') echo ' (<font color="#cc0033">read warning below</font>)'; ?><br>
	<?php echo $langUserDB.' : <b>'.$dbUserForm; ?></b><?php if($installType == 'new') echo ' (<font color="#cc0033">read warning below</font>)'; ?><br>
	<?php echo $langEnableTracking.' : '.($enableTrackingForm?$langYes:$langNo); ?><br>
	<?php echo $langSingleDb.' : '.($singleDbForm?$langOne:$langSeveral); ?><br><br>

	<?php echo $langAllowSelfReg.' : '.($allowSelfReg?$langYes:$langNo); ?><br>
	<?php echo $langEncryptUserPass.' : '.($encryptPassForm?$langYes:$langNo); ?><br><br>

	<?php echo $langAdminEmail.' : '.$emailForm; ?><br>
	<?php echo $langAdminLastName.' : '.$adminLastName; ?><br>
	<?php echo $langAdminFirstName.' : '.$adminFirstName; ?><br>
	<?php echo $langAdminPhone.' : '.$adminPhoneForm; ?><br>

	<?php if($installType == 'new'): ?>
	<?php echo $langAdminLogin.' : <b>'.$loginForm; ?></b><br>
	<?php echo $langAdminPass.' : <b>'.$passForm; ?></b><br><br>
	<?php else: ?>
	<br>
	<?php endif; ?>

	<?php echo $langCampusName.' : '.$campusForm; ?><br>
	<?php echo $langInstituteShortName.' : '.$institutionForm; ?><br>
	<?php echo $langInstituteURL.' : '.$institutionUrlForm; ?><br>
	<?php echo $langDokeosURL.' : '.$urlForm; ?><br>

	</blockquote>

	<?php if($installType == 'new'): ?>
	<div style="background-color:#FFFFFF">
	<p align="center"><b><font color="red">
	Warning !<br>
	The install script will erase all tables of the selected databases. We heavily recommend you do a full backup of them before confirming this last install step.
	</font></b></p>
	</div>
	<?php endif; ?>

	<table width="100%">
	<tr>
	  <td><input type="submit" name="step4" value="&lt; Back"></td>
	  <td align="right"><input type="submit" name="step6" value="Install Dokeos &gt;" onclick="javascript:if(this.value == 'Please Wait...') return false; else this.value='Please Wait...';"></td>
	</tr>
	</table>

<?php
}

/*
==============================================================================
		STEP 6 : INSTALLATION PROCESS
==============================================================================
*/

elseif($_POST['step6'])
{
	if($installType == 'update')
	{
		include('update_db.inc.php');
		include('update_files.inc.php');
	}
	else
	{
		include('install_db.inc.php');
		include('install_files.inc.php');
	}
?>

	<h2><?php echo $langStep6.' - '.$langCfgSetting; ?></h2>

	When you enter your campus for the first time, the best way to understand it is to register with the option 'Create course area' and then follow the way.

	<?php if($installType == 'update' && $nbr_courses > MAX_COURSE_TRANSFER): ?>
	<br><br>
	<font color="red"><b>Warning :</b> You have more than <?php echo MAX_COURSE_TRANSFER; ?> courses on your Egnosis platform ! Only <?php echo MAX_COURSE_TRANSFER; ?> courses have been updated. To update the other courses, <a href="update_courses.php"><font color="red">click here</font></a>.</font>
	<?php endif; ?>

	<br><br>
	<b>Security advice :</b> To protect your site, make read-only (CHMOD 444) 'claroline/inc/conf/claro_main.conf.php' and 'claroline/install/index.php'.
	<br><br><br><br>

	</form>
	<form method="get" action="../../">
	<p align="right"><input type="submit" value="Go to your newly created Dokeos portal"></p>

<?php
}

/*
==============================================================================
		STEP 1 : REQUIREMENTS
==============================================================================
*/

else
{
?>

	<h2><?php echo $langStep1.' - '.$langRequirements; ?></h2>

	<b>Read thoroughly</b><br><br>
	For Dokeos to work, you need the following on your server :

	<ul>
	  <li>Webserver with PHP 4.x</li>

<?php
	check_extension('standard');
	check_extension('session');
	check_extension('mysql');
	check_extension('zlib');
	check_extension('pcre');
?>

	  <li>MySQL + login/password allowing to access and create at least one database</li>
	  <li>Write access to web directory where Egnosis files have been put</li>
	</ul>

	For more details, <a href="../../installation_guide.html" target="blank">read the installation guide</a>.<br>

<?php
	if($installType == 'update' && (empty($_POST['updatePath']) || $badUpdatePath))
	{
		if($badUpdatePath)
		{
?>

	<div style="background-color:#FFFFFF">
	<p align="center"><b><font color="red">
	Error !<br>
	Egnosis <?php echo implode('|',$updateFromVersion); ?> has not been found in that directory.
	</font></b></p>
	</div>

<?php
		}
		else
		{
			echo '<br>';
		}
?>

	<table border="0" cellpadding="5" align="center">
	<tr>
	  <td>Old version root path :</td>
	  <td><input type="text" name="updatePath" size="50" value="<?php echo $badUpdatePath?htmlentities($_POST['updatePath']):$_SERVER['DOCUMENT_ROOT_OLD'].'/old_version/'; ?>"></td>
	</tr>
	<tr>
	  <td colspan="2" align="center">
		<input type="submit" name="step1" value="&lt; Back">
		<input type="submit" name="step2_update" value="Next &gt;">
	  </td>
	</tr>
	</table>

<?php
	}
	else
	{
		$error=false;

		//First, attempt to set writing permissions if we don't have them yet
		//0xxx is an octal number, this is the required format
		if(!is_writable('../inc/conf'))
		{
			$notwritable[]="../inc/conf";
			@chmod('../inc/conf',0777);
		}

		if(!is_writable('../garbage'))
		{
			$notwritable[]="../garbage";
			@chmod('../garbage',0777);
		}

		if(!is_writable('../upload'))
		{
			$notwritable[]="../upload";
			@chmod('../upload', 0777);
		}

		if(!is_writable('../../archive'))
		{
			$notwritable[]="../../archive";
			@chmod('../../archive',0777);
		}

		if(!is_writable('../../courses'))
		{
			$notwritable[]="../../courses";
			@chmod('../../courses',0777);
		}

		if(!is_writable('../../home'))
		{
			$notwritable[]="../../home";
			@chmod('../../home',0777);
		}

		if(file_exists('../inc/conf/claro_main.conf.php') && !is_writable('../inc/conf/claro_main.conf.php'))
		{
			$notwritable[]="../inc/conf/claro_main.conf.php";
			@chmod('../inc/conf/claro_main.conf.php',0666);
		}

		//Second, if this fails, report an error
		//--> the user will have to adjust the permissions manually
		if(!is_writable('../inc/conf') ||
		   !is_writable('../garbage') ||
		   !is_writable('../upload') ||
		   !is_writable('../../archive') ||
		   !is_writable('../../courses') ||
		   !is_writable('../../home') ||
		   (file_exists('../inc/conf/claro_main.conf.php') && !is_writable('../inc/conf/claro_main.conf.php')))
		{
			$error=true;
?>

	<div style="background-color:#FFFFFF">
	<p align="center"><b><font color="#cc0033">
	Warning:<br>
	Some files don't have writing permission. To be able to install Egnosis you should first change their permissions (using CHMOD). Please read the</font> <a href="../../installation_guide.html" target="blank">installation guide</a> <font color="#cc0033">.
	<?php 
	if (is_array($notwritable) AND count($notwritable)>0)
	{
		echo "<ul>";
		foreach ($notwritable as $key=>$value)
		{
			echo '<li>'.$value.'</li>';
		}
		
		echo "<ul>";
	}
	?>
	</font></b></p>
	</div>

<?php
		}
		// check if a Dokeos configuration file doesn't already exists.
		elseif(file_exists('../inc/conf/claro_main.conf.php'))
		{
?>

	<div style="background-color:#FFFFFF">
	<p align="center"><b><font color="#cc0033">
	Warning !<br>
	The installer has detected an existing Egnosis platform on your system.
	</font></b></p>
	</div>

<?php
		}
?>

	<p align="center">
	<input type="submit" name="step2_install" value="New installation" <?php if($error) echo 'disabled="disabled"'; ?> >
	<input type="submit" name="step2_update" value="Update from Dokeos <?php echo implode('|',$updateFromVersion); ?>" <?php if($error) echo 'disabled="disabled"'; ?> >
	</p>

<?php
	}
}
?>

  </td>
</tr>
</table>
</td>
</tr>
</table>
</form>

<!--
<font color="#808080">This is a Release Candidate. If something goes wrong, <a href="http://www.dokeos.com/forum/" target="_clarodev">come talk here</a></font>
//-->

</body>
</html>

<?php
/**
 * this function checks if a php extension exists or not
 *
 * @param string  $extentionName  name of the php extension to be checked
 * @param boolean  $echoWhenOk  true => show ok when the extension exists
 * @author Christophe Gesche */

function check_extension($extentionName,$echoWhenOk=false)
{
	if(extension_loaded($extentionName))
	{
		if($echoWhenOk)
		{
			echo '<li>'.$extentionName.' - ok</li>';
		}
	}
	else
	{
		echo '<li><b>'.$extentionName.'</b> <font color="red">is missing (Egnosis can work without)</font> (<a href="http://www.php.net/'.$extentionName.'" target="_blank">'.$extentionName.'</a>)</li>';
	}
}

/**
 * this function returns a string "FALSE" or "TRUE" according to the variable in parameter
 *
 * @param integer  $var  the variable to convert
 * @return  string  the string "FALSE" or "TRUE"
 * @author Christophe Gesche */

function trueFalse($var)
{
	return $var?'true':'false';
}

/**
 * this function returns a the value of a parameter from the configuration file
 *
 * @param string  $param  the parameter which the value is returned for
 * @return  string  the value of the parameter
 * @author Olivier Brouckaert
 */

function get_config_param($param)
{
	global $configFile, $updateFromConfigFile;

	if(empty($updateFromConfigFile))
	{
		if(file_exists($_POST['updatePath'].'claroline/include/config.inc.php'))
		{
			$updateFromConfigFile='claroline/include/config.inc.php';
		}
		elseif(file_exists($_POST['updatePath'].'claroline/inc/conf/claro_main.conf.php'))
		{
			$updateFromConfigFile='claroline/inc/conf/claro_main.conf.php';
		}
		else
		{
			return;
		}
	}

	if(is_array($configFile) && isset($configFile[$param]))
	{
		return $configFile[$param];
	}
	elseif(file_exists($_POST['updatePath'].$updateFromConfigFile))
	{
		$configFile=array();

		$temp=file($_POST['updatePath'].$updateFromConfigFile);

		$val='';

		foreach($temp as $enreg)
		{
			if(strstr($enreg,'='))
			{
				$enreg=explode('=',$enreg);

				if($enreg[0][0] == '$')
				{
					list($enreg[1])=explode(' //',$enreg[1]);

					$enreg[0]=trim(str_replace('$','',$enreg[0]));
					$enreg[1]=str_replace('\"','"',ereg_replace('(^"|"$)','',substr(trim($enreg[1]),0,-1)));

					if(strtolower($enreg[1]) == 'true')
					{
						$enreg[1]=1;
					}
					if(strtolower($enreg[1]) == 'false')
					{
						$enreg[1]=0;
					}
					else
					{
						$implode_string=' ';

						if(!strstr($enreg[1],'." ".') && strstr($enreg[1],'.$'))
						{
							$enreg[1]=str_replace('.$','." ".$',$enreg[1]);
							$implode_string='';
						}

						$tmp=explode('." ".',$enreg[1]);

						foreach($tmp as $tmp_key=>$tmp_val)
						{
							if(eregi('^\$[a-z_][a-z0-9_]*$',$tmp_val))
							{
								$tmp[$tmp_key]=get_config_param(str_replace('$','',$tmp_val));
							}
						}

						$enreg[1]=implode($implode_string,$tmp);
					}

					$configFile[$enreg[0]]=$enreg[1];

					if($enreg[0] == $param)
					{
						$val=$enreg[1];
					}
				}
			}
		}

		return $val;
	}
}
?>
