<?php

// $Id: index.php,v 1.178.2.1 2005/08/19 07:51:18 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	This is the index file displayed when a user arrives at Dokeos.
*
*	There are 2 views:
*
* 	User is logged in
*	- personal course list.
*	- menu bar
*
*	Guest View
*	- tree of courses and categories
*	- login form
*	- public menu
*
*	Part of the what's new ideas were based on a rene haentjens hack
*
*	Search for
*	CONFIGURATION parameters
*	to modify settings
*
*	@todo rewrite code to separate display, logic, database code
*	@package dokeos.main
==============================================================================
*/
/*
==============================================================================
	   INIT SECTION
==============================================================================
*/
// only this script should have this constant defined
define('DOKEOS_HOMEPAGE', true);
// Don't change these settings
define("SCRIPTVAL_No", 0);
define("SCRIPTVAL_InCourseList", 1);
define("SCRIPTVAL_UnderCourseList", 2);
define("SCRIPTVAL_Both", 3);
define("SCRIPTVAL_NewEntriesOfTheDay", 4);
define("SCRIPTVAL_NewEntriesOfTheDayOfLastLogin", 5);
define("SCRIPTVAL_NoTimeLimit", 6);
// End 'don't change' section
$langFile = array ('courses', 'index');
$cidReset = true; /* Flag forcing the 'current course' reset,
                   as we're not inside a course anymore  */
                   
/*
-----------------------------------------------------------
	Included libraries
-----------------------------------------------------------
*/
//this includes main_api too:
include_once ("./claroline/inc/claro_init_global.inc.php");
include_once (api_get_library_path()."/course.lib.php");
include_once (api_get_library_path()."/debug.lib.inc.php");
include_once (api_get_library_path()."/events.lib.inc.php");
include_once (api_get_library_path()."/system_announcements.lib.php");
include_once (api_get_library_path()."/text.lib.php");
include_once (api_get_library_path()."/groupmanager.lib.php");
$_SESSION["prefix"]="2";
if ($_GET['logout'])
{
	$query_string='';

	if(!empty($_SESSION['user_language_choice']))
	{
		$query_string='?language='.$_SESSION['user_language_choice'];
	}

	LoginDelete($uid, $statsDbName);
	api_session_destroy();

	header("Location: index".$_SESSION["prefix"].".php$query_string");
	exit ();
}
/*
-----------------------------------------------------------
	Table definitions
-----------------------------------------------------------
*/
//new table definitions, using database library
//these already have backticks around them!
$main_user_table = Database :: get_main_table(MAIN_USER_TABLE);
$main_admin_table = Database :: get_main_table(MAIN_ADMIN_TABLE);
$main_course_table = Database :: get_main_table(MAIN_COURSE_TABLE);
$main_course_user_table = Database :: get_main_table(MAIN_COURSE_USER_TABLE);
$main_category_table = Database :: get_main_table(MAIN_CATEGORY_TABLE);
$track_login_table = Database :: get_statistic_table(STATISTIC_TRACK_E_LOGIN_TABLE);
/*
-----------------------------------------------------------
	Constants and CONFIGURATION parameters
-----------------------------------------------------------
*/
// ---- Category list options ----
/** defines wether or not anonymous visitors can see a list of open courses on the Dokeos homepage*/
define("DISPLAY_COURSES_TO_ANONYMOUS_USERS", false);
define("CONFVAL_showNodeEmpty", TRUE);
define("CONFVAL_showNumberOfChild", TRUE); // actually  count are only for direct childs
define("CONFVAL_ShowLinkBackToTopOfTree", false);
// ---- Course list options ----
define("CONFVAL_showCourseLangIfNotSameThatPlatform", TRUE);
// Preview of course content
// to disable all: set CONFVAL_maxTotalByCourse = 0
// to enable all: set e.g. CONFVAL_maxTotalByCourse = 5
// by default disabled since what's new icons
// by default disabled since what's new icons are better (see function display_digest() )
define("CONFVAL_maxValvasByCourse", 2); // Maximum number of entries
define("CONFVAL_maxAgendaByCourse", 2); //  collected from each course
define("CONFVAL_maxTotalByCourse", 0); //  and displayed in summary.
define("CONFVAL_NB_CHAR_FROM_CONTENT", 80);
// Order to sort data
$orderKey = array ("keyTools", "keyTime", "keyCourse"); // Default "best" Choice
//$orderKey =array("keyTools","keyCourse","keyTime");
//$orderKey =array("keyCourse","keyTime","keyTools");
//$orderKey =array("keyCourse","keyTools","keyTime");
define("CONFVAL_showExtractInfo", SCRIPTVAL_UnderCourseList);
// SCRIPTVAL_InCourseList    // /best choice if $orderKey[0]="keyCourse"
// SCRIPTVAL_UnderCourseList //best choice
// SCRIPTVAL_Both // probably only for debug
//$dateFormatForInfosFromCourses = $dateFormatShort;
$dateFormatForInfosFromCourses = $dateFormatLong;
//define("CONFVAL_limitPreviewTo",SCRIPTVAL_NewEntriesOfTheDay);
//define("CONFVAL_limitPreviewTo",SCRIPTVAL_NoTimeLimit);
define("CONFVAL_limitPreviewTo", SCRIPTVAL_NewEntriesOfTheDayOfLastLogin);
if (isset ($_uid))
{
	$nameTools = get_lang("MyCourses");
}

/*
-----------------------------------------------------------
	Check configuration parameters integrity
-----------------------------------------------------------
*/
if (CONFVAL_showExtractInfo != SCRIPTVAL_UnderCourseList and $orderKey[0] != "keyCourse")
{
	// CONFVAL_showExtractInfo must be SCRIPTVAL_UnderCourseList to accept $orderKey[0] !="keyCourse"
	if (DEBUG || api_is_platform_admin()) // Show bug if admin. Else force a new order
		die("
					<strong>
					config error:".__FILE__."</strong>
					<br/>
					set
					<UL>
						<LI>
							CONFVAL_showExtractInfo=SCRIPTVAL_UnderCourseList
							(actually : ".CONFVAL_showExtractInfo.")
						</LI>
					</UL>
					or
					<UL>
						<LI>
							\$orderKey[0] !=\"keyCourse\"
							(actually : ".$orderKey[0].")
						</LI>
					</UL>");
	else
	{
		$orderKey = array ("keyCourse", "keyTools", "keyTime");
	}
}
/*
==============================================================================
		LOGIN
==============================================================================
*/

if ($_GET["submitAuth"] == 1)
{
	echo "Attempted breakin - sysadmins notified.";
	session_destroy();
	die();
}
if ($_POST["submitAuth"])
{
	// To ensure legacy compatibility, we set the following variables.
	// But they should be removed at last.
	$uid = $_uid;
	$lastname = $_user['lastName'];
	$firstname = $_user['firstName'];
	$email = $_user['mail'];
	$status = $uData['status'];
	if (isset ($_uid))
	{
		$sqlLastLogin = "SELECT UNIX_TIMESTAMP(`login_date`)
								FROM $track_login_table
								WHERE `login_user_id` = '".$_uid."'
								ORDER BY `login_date` DESC LIMIT 1";
		$resLastLogin = api_sql_query($sqlLastLogin, __FILE__, __LINE__);
		if (!$resLastLogin)
			if (mysql_num_rows($resLastLogin) > 0)
			{
				$user_last_login_datetime = mysql_fetch_array($resLastLogin);
				$user_last_login_datetime = $user_last_login_datetime[0];
				api_session_register('user_last_login_datetime');
			}
		mysql_free_result($resLastLogin);
		event_login();
		if (api_is_platform_admin())
		{
			// decode all open event informations and fill the track_c_* tables
			include (api_get_library_path()."/stats.lib.inc.php");
			decodeOpenInfos();
		}
	}
} // end login -- if($submit)
else
{
	// only if login form was not sent because if the form is sent the user was
	// already on the page.
	event_open();
}
/*
-----------------------------------------------------------
	Header
	include the HTTP, HTML headers plus the top banner
-----------------------------------------------------------
*/
if (isset ($_uid))
{
	$help = "Mycourses";
}
else
{
	$help = "Clar";
}
Display :: display_header($nameTools, $help);

/*
==============================================================================
		FUNCTIONS

		display_anonymous_right_menu()
		display_anonymous_course_list()

		display_login_form()
		handle_login_failed()

		display_lost_password_info()
		display_admin_links()
		display_create_course_link()
		display_edit_course_list_links()
		display_digest($toolsList, $digest, $orderKey, $dateFormatForInfosFromCourses, $courses)
		get_personal_course_list($user_id)
		get_logged_user_course_html($mycours, $clarolineRepositoryWeb)
==============================================================================
*/
/*
-----------------------------------------------------------
	Database functions
	some of these can go to database layer.
-----------------------------------------------------------
*/
/**
* Database function that gets the list of courses for a particular user.
* @param $user_id, the id of the user
* @return an array with courses
*/
function get_personal_course_list($user_id)
{
	$personal_course_list=array();
	$main_user_table = Database :: get_main_table(MAIN_USER_TABLE);
	$main_course_user_table = Database :: get_main_table(MAIN_COURSE_USER_TABLE);
	$personal_course_list_sql = "SELECT course.code k, course.directory d, course.visual_code c, course.db_name db, course.title i,
										course.tutor_name t, course.course_language l, course_rel_user.status s, course_rel_user.sort sort,
										course_rel_user.user_course_cat user_course_cat
										FROM    ".$main_course_table."       course,".$main_course_user_table."   course_rel_user
										WHERE course.code = course_rel_user.course_code"."
										AND   course_rel_user.user_id = '".$user_id."'
										ORDER BY course_rel_user.user_course_cat, course_rel_user.sort ASC,course.title,course.code";
	$course_list_sql_result = api_sql_query($personal_course_list_sql, __FILE__, __LINE__);
	$personal_course_list = array ();
	while ($result_row = mysql_fetch_array($course_list_sql_result))
	{
		$personal_course_list[] = $result_row;
	}
	return $personal_course_list;
}
/*
-----------------------------------------------------------
	Display functions
-----------------------------------------------------------
*/
/**
 * Displays the right-hand menu for anonymous users:
 * login form, useful links, help section
 * Warning: function defines globals
 * @version 1.0.1
 */
function display_anonymous_right_menu()
{
	global $loginFailed, $allowSelfReg, $plugins, $user_language_choice;

	$platformLanguage = get_setting('platformLanguage');

	display_login_form();
	if ($loginFailed)
		handle_login_failed();
	if (get_setting('allow_lostpassword') == "true" OR get_setting('allow_registration') == "true")
	{
		echo "<div class=\"menusection\">", "<span class=\"menusectioncaption\">".get_lang("MenuUser")."</span>", "<ul class=\"menulist\">";
		//if ( $allowSelfReg || !isset($allowSelfReg) )
		if (get_setting('allow_registration') == "true")
		{
			echo "<li><a href=\"claroline/auth/inscription.php\">".get_lang("Reg")."</a></li>";
		}
		if (get_setting('allow_lostpassword') == "true")
		{
			display_lost_password_info();
		}
		echo "</ul>"."</div>";
	}
	echo "<div class=\"menusection\">", "<span class=\"menusectioncaption\">".get_lang("MenuGeneral")."</span>", "<ul class=\"menulist\">";

	$user_selected_language = $_SESSION["user_language_choice"];
	if (!isset ($user_selected_language))
		$user_selected_language = $platformLanguage;

	if(!file_exists('home/home_menu_'.$user_selected_language.'.html'))
	{
		include ('home/home_menu.html');
	}
	else
	{
		include('home/home_menu_'.$user_selected_language.'.html');
	}

	echo "</ul>"."</div>";
	// Load appropriate plugins for this menu bar
	if (is_array($plugins['main_menu_logged']))
	{
		foreach ($plugins['main_menu_logged'] as $this_plugin)
		{
			include (api_get_path(PLUGIN_PATH)."$this_plugin/index.php");
		}
	}
	echo "<div class=\"note\">";
	/*** includes for any files to be displayed below anonymous right menu ***/
	include ('home/home_notice_'.$user_selected_language.'.html');
	echo "<br></div>";
}
/**
*	Reacts on a failed login:
*	displays an explanation with
*	a link to the registration form.
*
*	@version 1.0.1
*/
function handle_login_failed()
{
	$message = get_lang("InvalidId");
	if (api_is_self_registration_allowed())
		$message = get_lang("InvalidForSelfRegistration");
	echo "<div id=\"login_fail\">".$message."</div>";
}
/**
*	Adds a form to let users login
*	@version 1.1
*/
function display_login_form()
{
	if (isset ($_POST['login']))
		$default_value = htmlspecialchars(stripslashes($_POST['login']));
	echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\" id=\"loginform\" name=\"formLogin\">"."<label>".get_lang("UserName")."</label>"."<input type=\"text\" name=\"login\" id=\"login\" size=\"15\" value=\"".$default_value."\" />"."<label>".get_lang("Pass")."</label>"."<input type=\"password\" name=\"password\" id=\"password\" size=\"15\" />"."<input type=\"submit\" value=\"".get_lang("Ok")."\" name=\"submitAuth\" class=\"submitauth\"/>"."</form>";
}
/**
 * Displays a link to the lost password section
 */
function display_lost_password_info()
{
	echo "<li><a href=\"claroline/auth/lostPassword.php\">".get_lang("LostPassword")."</a></li>";
}
/**
 * Warning: this function defines a global.
 */
function display_admin_links()
{
	global $rootAdminWeb;
	echo "<li><a href=\"".$rootAdminWeb."\">".get_lang("PlatformAdmin")."</a></li>";
}
function display_create_course_link()
{
	echo "<li><a href=\"claroline/create_course/add_course.php\">".get_lang("CourseCreate")."</a></li>";
}
function display_edit_course_list_links()
{
	echo "<li><a href=\"claroline/auth/courses.php\">".get_lang("CourseManagement")."</a></li>";
}
/**
* Display list of courses in a category.
* (for anonymous users)
*
* Warning: this function defines globals.
* @version 1.0
*/
function display_anonymous_course_list()
{
	//init
	global $coursesRepositoryWeb;
	$web_course_path = api_get_path(WEB_COURSE_PATH);
	$category = $_GET["category"];
	$main_course_table = Database :: get_main_table(MAIN_COURSE_TABLE);
	$main_category_table = Database :: get_main_table(MAIN_CATEGORY_TABLE);
	//code
	$sqlGetCourseList = "SELECT * FROM $main_course_table cours
								WHERE category_code = '".$category."'
								AND cours.visibility='".COURSE_VISIBILITY_OPEN_WORLD."'
								ORDER BY UPPER(visual_code)";
	$sqlGetSubCatList = "
				SELECT t1.name,t1.code,t1.parent_id,t1.children_count,COUNT(DISTINCT t3.code) AS nbCourse
				FROM $main_category_table t1
				LEFT JOIN $main_category_table t2 ON t1.code=t2.parent_id
				LEFT JOIN $main_course_table t3 ON (t3.category_code=t1.code AND t3.visibility='".COURSE_VISIBILITY_OPEN_WORLD."')
				WHERE t1.parent_id ". (empty ($category) ? "IS NULL" : "='$category'")."
				GROUP BY t1.name,t1.code,t1.parent_id,t1.children_count ORDER BY t1.tree_pos";
	$resultCourses = api_sql_query($sqlGetCourseList, __FILE__, __LINE__);
	$resCats = api_sql_query($sqlGetSubCatList, __FILE__, __LINE__);
	$thereIsSubCat = FALSE;
	if (mysql_num_rows($resCats) > 0)
	{
		$htmlListCat = "<h4 style=\"margin-top: 0px;\">".get_lang("CatList")."</h4>"."<ul>";
		while ($catLine = mysql_fetch_array($resCats))
		{
			if ($catLine['code'] != $category)
			{
				$htmlListCat .= "<li>";
				/*** --- this is the original code to display the course list with the
				     --- "(#) courses" indication behind the category ----

								if ( $catLine[nbCourse] + $catLine[children_count] > 0 )
								{
									$htmlListCat .= "<a href=\"".$_SERVER['PHP_SELF']."?category=".$catLine['code']."\">"
												.$catLine['name']
												."</a>";

									if (CONFVAL_showNumberOfChild)
									{
										$htmlListCat .= " (".$catLine[nbCourse]." " . get_lang("Courses") . ")";
									}
								}
				**** end of the original code section, what follows is code to have the
				     category display without the "(#) courses" indication
				*************************************************************************/
				/************************************************************************
				 start changed code to eliminate the (0 courses) after empty categories
				 ************************************************************************/
				if ($catLine[nbCourse] > 0)
				{
					$htmlListCat .= "<a href=\"".$PHP_SELF."?category=".$catLine['code']."\">".$catLine['name']."</a>";
					if (CONFVAL_showNumberOfChild)
					{
						$htmlListCat .= " (".$catLine[nbCourse]." ".get_lang("Courses").")";
					}
				}
				elseif ($catLine['children_count'] > 0)
				{
					$htmlListCat .= "<a href=\"".$PHP_SELF."?category=".$catLine['code']."\">".$catLine['name']."</a>";
				}
				/************************************************************************
				 end changed code to eliminate the (0 courses) after empty categories
				 ************************************************************************/
				elseif (CONFVAL_showNodeEmpty)
				{
					$htmlListCat .= $catLine['name'];
				}
				$htmlListCat .= "</li>\n";
				$thereIsSubCat = true;
			}
			else
			{
				$htmlTitre = "<p>";
				if (CONFVAL_ShowLinkBackToTopOfTree)
				{
					$htmlTitre .= "<a href=\"".$_SERVER['PHP_SELF']."\">"."&lt;&lt; ".get_lang("BackToHomePage")."</a>";
				}
				if (!is_null($catLine['parent_id']) || (!CONFVAL_ShowLinkBackToTopOfTree && !is_null($catLine['code'])))
				{
					$htmlTitre .= "<a href=\"".$_SERVER['PHP_SELF']."?category=".$catLine['parent_id']."\">"."&lt;&lt; ".get_lang("Up")."</a>";
				}
				$htmlTitre .= "</p>\n";
				if ($category != "" && !is_null($catLine['code']))
				{
					$htmlTitre .= "<h3>".$catLine['name']."</h3>\n";
				}
				else
				{
					$htmlTitre .= "<h3>".get_lang("Categories")."</h3>\n";
				}
			}
		}
		$htmlListCat .= "</ul>\n";
	}
	echo $htmlTitre;
	if ($thereIsSubCat)
		echo $htmlListCat;
	while ($categoryName = mysql_fetch_array($resCats))
	{
		echo "<h3>", $categoryName['name'], "</h3>\n";
	}
	$numrows = mysql_num_rows($resultCourses);
	if ($numrows > 0)
	{
		if ($thereIsSubCat)
			echo "<hr size=\"1\" noshade=\"noshade\">\n";
		echo "<h4 style=\"margin-top: 0px;\">", get_lang("CourseList"), "</h4>\n", "<ul>\n";
		while ($course = mysql_fetch_array($resultCourses))
		{
			echo "<li>\n", "<a href=\"".$web_course_path.$course['directory'], "/\">", $course['title'], "</a>", "<br/>", $course['visual_code'], " - ", $course['tutor_name'], ((CONFVAL_showCourseLangIfNotSameThatPlatform && $course['course_language'] != $platformLanguage) ? " - ".$course['course_language'] : ""), "\n", "</li>\n";
		}
		echo "</ul>\n";
	}
	else
	{
		// echo "<blockquote>",get_lang('_No_course_publicly_available'),"</blockquote>\n";
	}
	if ($category != "")
	{
		echo "<p>", "<a href=\"".$_SERVER['PHP_SELF']."\"><b>&lt;&lt;</b> ", get_lang("BackToHomePage"), "</a>", "</p>\n";
	}
}
/**
*	Displays a digest e.g. short summary of new agenda and announcements items.
*	This used to be displayed in the right hand menu, but is now
*	disabled by default (see config settings in this file) because most people like
*	the what's new icons better.
*
*	@version 1.0
*/
function display_digest($toolsList, $digest, $orderKey, $dateFormatForInfosFromCourses, $courses)
{
	if (is_array($digest) && (CONFVAL_showExtractInfo == SCRIPTVAL_UnderCourseList || CONFVAL_showExtractInfo == SCRIPTVAL_Both))
	{
		// // // LEVEL 1 // // //
		reset($digest);
		echo "<br/><br/>\n";
		while (list ($key1) = each($digest))
		{
			if (is_array($digest[$key1]))
			{
				// // // Title of LEVEL 1 // // //
				echo "<b>\n";
				if ($orderKey[0] == 'keyTools')
				{
					$tools = $key1;
					echo $toolsList[$key1][name];
				}
				elseif ($orderKey[0] == 'keyCourse')
				{
					$courseSysCode = $key1;
					echo "<a href=\"", $coursesRepositoryWeb, $courses[$key1][coursePath], "\">", $courses[$key1][courseCode], "</a>\n";
				}
				elseif ($orderKey[0] == 'keyTime')
				{
					echo format_locale_date($dateFormatForInfosFromCourses, strtotime($digest[$key1]));
				}
				echo "</b>\n";
				// // // End Of Title of LEVEL 1 // // //
				// // // LEVEL 2 // // //
				reset($digest[$key1]);
				while (list ($key2) = each($digest[$key1]))
				{
					// // // Title of LEVEL 2 // // //
					echo "<p>\n", "\n";
					if ($orderKey[1] == 'keyTools')
					{
						$tools = $key2;
						echo $toolsList[$key2][name];
					}
					elseif ($orderKey[1] == 'keyCourse')
					{
						$courseSysCode = $key2;
						echo "<a href=\"", $coursesRepositoryWeb, $courses[$key2]['coursePath'], "\">", $courses[$key2]['courseCode'], "</a>\n";
					}
					elseif ($orderKey[1] == 'keyTime')
					{
						echo format_locale_date($dateFormatForInfosFromCourses, strtotime($key2));
					}
					echo "\n";
					echo "</p>";
					// // // End Of Title of LEVEL 2 // // //
					// // // LEVEL 3 // // //
					reset($digest[$key1][$key2]);
					while (list ($key3, $dataFromCourse) = each($digest[$key1][$key2]))
					{
						// // // Title of LEVEL 3 // // //
						if ($orderKey[2] == 'keyTools')
						{
							$level3title = "<a href=\"".$toolsList[$key3]["path"].$courseSysCode."\">".$toolsList[$key3]["name"]."</a>";
						}
						elseif ($orderKey[2] == 'keyCourse')
						{
							$level3title = "&#8226; <a href=\"".$toolsList[$tools]["path"].$key3."\">".$courses[$key3]['courseCode']."</a>\n";
						}
						elseif ($orderKey[2] == 'keyTime')
						{
							$level3title = "&#8226; <a href=\"".$toolsList[$tools]["path"].$courseSysCode."\">".format_locale_date($dateFormatForInfosFromCourses, strtotime($key3))."</a>";
						}
						// // // End Of Title of LEVEL 3 // // //
						// // // LEVEL 4 (data) // // //
						reset($digest[$key1][$key2][$key3]);
						while (list ($key4, $dataFromCourse) = each($digest[$key1][$key2][$key3]))
						{
							echo $level3title, " - ", substr(strip_tags($dataFromCourse), 0, CONFVAL_NB_CHAR_FROM_CONTENT);
							//adding ... (three dots) if the texts are too large and they are shortened
							if (strlen($dataFromCourse) >= CONFVAL_NB_CHAR_FROM_CONTENT)
							{
								echo "...";
							}
						}
						echo "<br/>";
					}
				}
			}
		}
	}
} // end function display_digest
/**
 * Display code for one specific course a logged in user is subscribed to.
 * Shows a link to the course, what's new icons...
 *
 * Note: indices of $mycours array are completely horrible: (replace these!)
 * $mycours['d'] - course directory
 * $mycours['i'] - course title
 * $mycours['c'] - course code - SYSTEM or VISUAL ? - assuming system
 * $mycours['k']   - ???
 * $mycours['db']  - course database
 *
 * @version 1.0.3
 * @todo refactor into different functions for database calls | logic | display
 * @todo replace stupid $mycours['d'] etcetera indices
 * @todo move code for what's new icons to a separate function to clear things up
 */

function get_logged_user_course_html($mycours, $clarolineRepositoryWeb)
{
	$web_course_path = api_get_path(WEB_COURSE_PATH);
	//initialise
	$result = '';
	//$statistic_database = Database::get_statistic_database();
	$user_id = api_get_user_id();
	$course_database = $mycours["db"];
	$course_tool_table = Database :: get_course_tool_list_table($course_database);
	$tool_edit_table = Database :: get_course_last_tool_edit_table($course_database);
	$course_group_user_table = Database :: get_course_group_user_table($course_database);
	$course_system_code = $mycours['k'];
	$course_visual_code = $mycours['c'];
	$course_title = $mycours['i'];
	$course_directory = $mycours['d'];
	$course_teacher = $mycours['t'];
	$course_info = Database :: get_course_info_from_code($course_system_code);
	$course_access_settings = CourseManager :: get_access_settings($course_system_code);
	$course_id = $course_info["course_id"];
	$course_visibility = $course_access_settings["visibility"];
	$user_in_course_status = CourseManager :: get_user_in_course_status($user_id, $course_system_code);
	//function logic - act on the data
	$is_virtual_course = CourseManager :: is_virtual_course_from_system_code($mycours['c']);
	if ($is_virtual_course)
	{
		// If the current user is also subscribed in the real course to which this
		// virtual course is linked, we don't need to display the virtual course entry in
		// the course list - it is combined with the real course entry.
		$target_course_code = CourseManager :: get_target_of_linked_course($course_system_code);
		$target_course_info = Database :: get_course_info_from_code($target_course_code);
		$is_subscribed_in_target_course = CourseManager :: is_user_subscribed_in_course($user_id, $target_course_info);
		if ($is_subscribed_in_target_course)
		{
			return; //do not display this course entry
		}
	}
	$has_virtual_courses = CourseManager :: has_virtual_courses_from_code($course_system_code, $user_id);
	if ($has_virtual_courses)
	{
		$return_result = CourseManager :: determine_course_title_from_course_info($user_id, $course_info);
		$course_display_title = $return_result["title"];
		$course_display_code = $return_result["code"];
	}
	else
	{
		$course_display_title = $course_title;
		$course_display_code = $course_visual_code;
	}
	//display course entry
	$result .= "\n\t<li>";
	// show the course_code and teacher if chosen to display this
	if (get_setting("display_coursecode_in_courselist") == "true")
	{
		$result .= $course_display_code . ' - ';
	}
	//show a hyperlink to the course, unless the course is closed and user is not course admin
	if ($course_visibility != COURSE_VISIBILITY_CLOSED || $user_in_course_status == COURSEMANAGER)
	{
		$result .= "<a href=\"".$web_course_path.$course_directory."/\">".$course_display_title."</a>";
	}
	else
	{
		$result .= $course_display_title." "." ".get_lang("CourseClosed")."";
	}
	// show the course_code and teacher if chosen to display this
	if (get_setting("display_teacher_in_courselist") == "true")
	{
		$result .= ' - ' . $course_teacher;
	}
	if (get_setting("display_coursecode_in_courselist") == "true" OR get_setting("display_teacher_in_courselist") == "true")
	{
		$result .= "<br/>";
	}
	// display the what's new icons
	$result .= show_notification($mycours);
	/*
	// get the user's last access dates to all tools of this course
	$sqlLastTrackInCourse = "SELECT * FROM `$statistic_database`.`track_e_lastaccess`"
							." WHERE `access_user_id` = ".$user_id
							." AND `access_cours_code` = '".$mycours['k']."'";
	$resLastTrackInCourse = api_sql_query($sqlLastTrackInCourse,__FILE__,__LINE__);
	while($lastTrackInCourse = mysql_fetch_array($resLastTrackInCourse))
	{
		$lastTrackInCourseDate[$lastTrackInCourse["access_tool"]] = $lastTrackInCourse["access_date"];
	}

	// get the last edits of all tools of this course
	$sql = "SELECT tooledit.lastedit_date last_date, tooledit.tool tool, tooledit.ref ref,
				tooledit.lastedit_type type, tooledit.to_group_id group_id,
				accueil.image image, accueil.link link
			FROM $tool_edit_table tooledit, $course_tool_table accueil
			WHERE accueil.name = tooledit.tool
			AND accueil.visibility = '1'
			AND tooledit.insert_user_id != $user_id
			AND (tooledit.to_user_id = '$user_id' OR tooledit.to_user_id = 0)";
	$res = api_sql_query($sql,__FILE__,__LINE__);

	$sql = "SELECT group_id FROM $course_group_user_table WHERE `user_id` = '$user_id'";
	$groupres = api_sql_query($sql,__FILE__,__LINE__);
	$groups = mysql_fetch_array($groupres);
	$groups[] = 0;

	//show icons of tools where there is something new

	while($lastToolEdit = mysql_fetch_array($res))
	{
		if ($lastTrackInCourseDate[$lastToolEdit["tool"]]<$lastToolEdit["last_date"] && in_array($lastToolEdit["group_id"], $groups))
		{
			$lastDate = date("d/m/Y H:i", convert_mysql_date($lastToolEdit["last_date"]));
			$type = ($lastToolEdit["type"]=="" || $lastToolEdit["type"]==NULL) ? get_lang('_new_item') : $lastToolEdit["type"];

			$result.= "<a href=\"".$clarolineRepositoryWeb.$lastToolEdit['link']."?cidReq=".$mycours['k']."\">".
				"<img title=\"-- $lastToolEdit[tool] -- " . get_lang("_title_notification") . ": $type ($lastDate).\""
						." src=\"$clarolineRepositoryWeb"."img/".$lastToolEdit['image']."\" border=\"0\" align=\"absmiddle\" alt=\"".$lastToolEdit['image']."\" />"."</a>";

		}
	}
	unset($lastTrackInCourseDate);
	unset($groups);*/
	if ((CONFVAL_showExtractInfo == SCRIPTVAL_InCourseList || CONFVAL_showExtractInfo == SCRIPTVAL_Both) && $nbDigestEntries > 0)
	{
		reset($digest);
		$result .= "<ul>";
		while (list ($key2) = each($digest[$thisCourseSysCode]))
		{
			$result .= "<li>";
			if ($orderKey[1] == 'keyTools')
			{
				$result .= "<a href=\"$toolsList[$key2] [\"path\"] $thisCourseSysCode \">";
				$result .= "$toolsList[$key2][\"name\"]</a>";
			}
			else
			{
				$result .= format_locale_date($dateFormatForInfosFromCourses, strtotime($key2));
			}
			$result .= "</li>";
			$result .= "<ul>";
			reset($digest[$thisCourseSysCode][$key2]);
			while (list ($key3, $dataFromCourse) = each($digest[$thisCourseSysCode][$key2]))
			{
				$result .= "<li>";
				if ($orderKey[2] == 'keyTools')
				{
					$result .= "<a href=\"$toolsList[$key3] [\"path\"] $thisCourseSysCode \">";
					$result .= "$toolsList[$key3][\"name\"]</a>";
				}
				else
				{
					$result .= format_locale_date($dateFormatForInfosFromCourses, strtotime($key3));
				}
				$result .= "<ul compact=\"compact\">";
				reset($digest[$thisCourseSysCode][$key2][$key3]);
				while (list ($key4, $dataFromCourse) = each($digest[$thisCourseSysCode][$key2][$key3]))
				{
					$result .= "<li>";
					$result .= htmlspecialchars(substr(strip_tags($dataFromCourse), 0, CONFVAL_NB_CHAR_FROM_CONTENT));
					$result .= "</li>";
				}
				$result .= "</ul>";
				$result .= "</li>";
			}
			$result .= "</ul>";
			$result .= "</li>";
		}
		$result .= "</ul>";
	}
	$result .= "</li>";
	$output = array ($mycours['user_course_cat'], $result);
	return $output;
}
/**
 * Returns the "what's new" icon notifications
 *
 *
 * @version
 */
function show_notification($mycours)
{
	global $clarolineRepositoryWeb;
	$statistic_database = Database :: get_statistic_database();
	$user_id = api_get_user_id();
	$course_database = $mycours["db"];
	$course_tool_table = Database :: get_course_tool_list_table($course_database);
	$tool_edit_table = Database :: get_course_last_tool_edit_table($course_database);
	$course_group_user_table = Database :: get_course_group_user_table($course_database);
	// get the user's last access dates to all tools of this course
	$sqlLastTrackInCourse = "SELECT * FROM $statistic_database.track_e_lastaccess
									 USE INDEX (access_cours_code, access_user_id)
									 WHERE access_cours_code = '".$mycours['k']."'
									 AND access_user_id = '$user_id'";
	$resLastTrackInCourse = api_sql_query($sqlLastTrackInCourse, __FILE__, __LINE__);
	$oldestTrackDate = "3000-01-01 00:00:00";
	while ($lastTrackInCourse = mysql_fetch_array($resLastTrackInCourse))
	{
		$lastTrackInCourseDate[$lastTrackInCourse["access_tool"]] = $lastTrackInCourse["access_date"];
		if ($oldestTrackDate > $lastTrackInCourse["access_date"])
			$oldestTrackDate = $lastTrackInCourse["access_date"];
	}
	// get the last edits of all tools of this course
	$sql = "SELECT tet.*, tet.lastedit_date last_date, tet.tool tool, tet.ref ref,
						tet.lastedit_type type, tet.to_group_id group_id,
						ctt.image image, ctt.link link
					FROM $tool_edit_table tet, $course_tool_table ctt
					WHERE tet.lastedit_date > '$oldestTrackDate'
					AND ctt.name = tet.tool
					AND ctt.visibility = '1'
					AND tet.lastedit_user_id != $user_id
					ORDER BY tet.lastedit_date";
	$res = api_sql_query($sql);
	//get the group_id's with user membership
	$group_ids = GroupManager :: get_group_ids($course_database, $user_id);
	$groups_ids[] = 0; //add group 'everyone'
	//filter all selected items
	while ($res && ($item_property = mysql_fetch_array($res)))
	{
		if ((!isset ($lastTrackInCourseDate[$item_property['tool']]) || $lastTrackInCourseDate[$item_property['tool']] < $item_property['lastedit_date']) && (in_array($item_property['to_group_id'], $groups_ids) || $item_property['to_user_id'] == $user_id) && ($item_property['visibility'] == '1' || ($mycours['s'] == '1' && $item_property['visibility'] == '0') || !isset ($item_property['visibility'])))
		{
			$notifications[$item_property['tool']] = $item_property;
		}
	}
	//show all tool icons where there is something new
	$retvalue = "&nbsp;";
	if (isset ($notifications))
	{
		while (list ($key, $notification) = each($notifications))
		{
			$lastDate = date("d/m/Y H:i", convert_mysql_date($notification['lastedit_date']));
			$type = $notification['lastedit_type'];
			//$notification[image]=str_replace(".png","gif",$notification[image]);
			//$notification[image]=str_replace(".gif","_s.gif",$notification[image]);
			$retvalue .= "<a href=\"$clarolineRepositoryWeb".$notification['link']."?cidReq=".$mycours['k']."&ref=".$notification['ref']."\">"."<img title=\"-- ".get_lang($notification['tool'])." -- ".get_lang('_title_notification').": $type ($lastDate).\""." src=\"$clarolineRepositoryWeb"."img/".$notification['image']."\" border=\"0\" align=\"absmiddle\">"."</a>&nbsp;";
		}
	}
	return $retvalue;
}
/**
 * retrieves the user defined course categories
 * @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
 * @return array containing all the titles of the user defined courses with the id as key of the array
*/

function get_user_course_categories()
{
	global $_uid;
	$table_category = Database::get_user_personal_table(USER_COURSE_CATEGORY_TABLE);
	$sql = "SELECT * FROM ".$table_category." WHERE user_id='".$_uid."'";
	$result = api_sql_query($sql,__FILE__,__LINE__);
	while ($row = mysql_fetch_array($result))
	{
		$output[$row['id']] = $row['title'];
	}
	return $output;
}

/*
==============================================================================
		MAIN CODE
==============================================================================
*/
/*
==============================================================================
		PERSONAL COURSE LIST
		for users who are logged in
==============================================================================
*/
if (isset ($_uid))
{
	if (!isset ($maxValvas))
		$maxValvas = CONFVAL_maxValvasByCourse; // Maximum number of entries
	if (!isset ($maxAgenda))
		$maxAgenda = CONFVAL_maxAgendaByCourse; //  collected from each course
	if (!isset ($maxCourse))
		$maxCourse = CONFVAL_maxTotalByCourse; //  and displayed in summary.
	$maxValvas = (int) $maxValvas;
	$maxAgenda = (int) $maxAgenda;
	$maxCourse = (int) $maxCourse; // 0 if invalid
	if ($maxCourse > 0)
	{
		unset ($allentries); // we shall collect all summary$key1 entries in here:
		$toolsList['agenda']['name'] = get_lang('Agenda');
		$toolsList['agenda']['path'] = $clarolineRepositoryWeb."calendar/agenda.php?cidReq=";
		$toolsList['valvas']['name'] = get_lang('Valvas');
		$toolsList['valvas']['path'] = $clarolineRepositoryWeb."announcements/announcements.php?cidReq=";
	}
	echo "<div class=\"maincontent\">"; // start of content for logged in users
	// Display System announcements
	$announcement = $_GET['announcement'] ? $_GET['announcement'] : -1;
	$visibility = api_is_allowed_to_create_course() ? VISIBLE_TEACHER : VISIBLE_STUDENT;
	SystemAnnouncementManager :: display_announcements($visibility, $announcement);

	if (!empty ($_GET['include']) && !strstr($_GET['include'], '/') && strstr($_GET['include'], '.html'))
	{
		include ('./home/'.$_GET['include']);
		$pageIncluded = true;
	}
	else
	{
		echo "<h3>".get_lang("MyCourses")."</h3>";
		/*--------------------------------------
		              DISPLAY COURSES
		   --------------------------------------*/
		$list = '';
		$personal_course_list = get_personal_course_list($_uid);
		$status = array();
		foreach ($personal_course_list as $mycours)
		{
			$thisCourseDbName = $mycours['db'];
			$thisCourseSysCode = $mycours['k'];
			$thisCoursePublicCode = $mycours['c'];
			$thisCoursePath = $mycours['d'];
			$sys_course_path = api_get_path(SYS_COURSE_PATH);
			/*
			currently disabled functionality, should return
			$thisCoursePath = $sys_course_path . $thisCoursePath;
			if(! file_exists($thisCoursePath))
			{
			echo	"<li>".$mycours['i']."<br/>";
			echo "".get_lang("CourseDoesntExist")." (<a href=\"claroline/install/update_courses.php\">";
			echo	"".get_lang("GetCourseFromOldPortal")."</a>)</li>";
	
				continue;
			}*/
			$dbname = $mycours['k'];
			$status[$dbname] = $mycours['s'];
      $nbDigestEntries = 0; // number of entries already collected
			if ($maxCourse < $maxValvas)
				$maxValvas = $maxCourse;
			if ($maxCourse > 0)
			{
				$courses[$thisCourseSysCode]['coursePath'] = $thisCoursePath;
				$courses[$thisCourseSysCode]['courseCode'] = $thisCoursePublicCode;
			}
			/*
			-----------------------------------------------------------
				Announcements
			-----------------------------------------------------------
			*/
			$course_database = $mycours['db'];
			$course_tool_table = Database :: get_course_tool_list_table($course_database);
			$query = "SELECT visibility FROM $course_tool_table WHERE link = 'announcements/announcements.php' AND visibility = 1";
			$result = api_sql_query($query);
			// collect from announcements, but only if tool is visible for the course
			if ($result && $maxValvas > 0 && mysql_num_rows($result) > 0)
			{
				//Search announcements table
				//Take the entries listed at the top of advalvas/announcements tool
				$course_announcement_table = Database :: get_course_announcement_table($thisCourseDbName);
				$sqlGetLastAnnouncements = "SELECT end_date publicationDate, content
										                            FROM ".$course_announcement_table;
				switch (CONFVAL_limitPreviewTo)
				{
					case SCRIPTVAL_NewEntriesOfTheDay :
						$sqlGetLastAnnouncements .= "WHERE DATE_FORMAT(end_date,'%Y %m %d') >= '".date("Y m d")."'";
						break;
					case SCRIPTVAL_NoTimeLimit :
						break;
					case SCRIPTVAL_NewEntriesOfTheDayOfLastLogin :
						// take care mysql -> DATE_FORMAT(time,format) php -> date(format,date)
						$sqlGetLastAnnouncements .= "WHERE DATE_FORMAT(end_date,'%Y %m %d') >= '".date("Y m d", $_user["lastLogin"])."'";
				}
				$sqlGetLastAnnouncements .= "ORDER BY end_date DESC
										                             LIMIT ".$maxValvas;
				$resGetLastAnnouncements = api_sql_query($sqlGetLastAnnouncements, __FILE__, __LINE__);
				if ($resGetLastAnnouncements)
				{
					while ($annoncement = mysql_fetch_array($resGetLastAnnouncements))
					{
						$keyTools = "valvas";
						$keyTime = $annoncement['publicationDate'];
						$keyCourse = $thisCourseSysCode;
						$digest[$$orderKey[0]][$$orderKey[1]][$$orderKey[2]][] = htmlspecialchars(substr(strip_tags($annoncement["content"]), 0, CONFVAL_NB_CHAR_FROM_CONTENT));
						$nbDigestEntries ++; // summary has same order as advalvas
					}
				}
			}
			/*
			-----------------------------------------------------------
				Agenda
			-----------------------------------------------------------
			*/
			$course_database = $mycours['db'];
			$course_tool_table = Database :: get_course_tool_list_table($course_database);
			$query = "SELECT visibility FROM $course_tool_table WHERE link = 'calendar/agenda.php' AND visibility = 1";
			$result = api_sql_query($query);
			$thisAgenda = $maxCourse - $nbDigestEntries; // new max entries for agenda
			if ($maxAgenda < $thisAgenda)
				$thisAgenda = $maxAgenda;
			// collect from agenda, but only if tool is visible for the course
			if ($result && $thisAgenda > 0 && mysql_num_rows($result) > 0)
			{
				$tableCal = $courseTablePrefix.$thisCourseDbName.$dbGlu."calendar_event";
				$sqlGetNextAgendaEvent = "SELECT  `start_date` , title content, start_time
										                          FROM `".$tableCal."`
										                          WHERE `start_date` >= CURDATE()
										                          ORDER BY `start_date`, `start_time`
										                          LIMIT ".$maxAgenda;
				$resGetNextAgendaEvent = api_sql_query($sqlGetNextAgendaEvent, __FILE__, __LINE__);
				if ($resGetNextAgendaEvent)
				{
					while ($agendaEvent = mysql_fetch_array($resGetNextAgendaEvent))
					{
						$keyTools = "agenda";
						$keyTime = $agendaEvent['start_date'];
						$keyCourse = $thisCourseSysCode;
						$digest[$$orderKey[0]][$$orderKey[1]][$$orderKey[2]][] = htmlspecialchars(substr(strip_tags($agendaEvent["content"]), 0, CONFVAL_NB_CHAR_FROM_CONTENT));
						$nbDigestEntries ++; // summary has same order as advalvas
					}
				}
			}
			/*
			-----------------------------------------------------------
				Digest Display
				take collected data and display it
			-----------------------------------------------------------
			*/
			$list[] = get_logged_user_course_html($mycours, $clarolineRepositoryWeb);
		} //end while mycourse...
	}

	if (is_array($list))
	{
		$old_user_category = 0;
		$userdefined_categories = get_user_course_categories();
		echo "<ul>\n";
		foreach ($list as $key => $value)
		{
			if ($old_user_category<>$value[0])
			{
				if ($key<>0 OR $value[0]<>0) // there are courses in the previous category
				{
					echo "\n</ul>";
				}
				echo "\n\n\t<ul class=\"user_course_category\"><li>".$userdefined_categories[$value[0]]."</li></ul>\n";
				if ($key<>0 OR $value[0]<>0) // there are courses in the previous category
				{
					echo "<ul>";
				}
				$old_user_category=$value[0];

			}
			echo $value[1];

		}
		echo "\n</ul>\n";
	}
	echo "</div>"; // end of content section for logged in users
	// Register whether full admin or null admin course
	// by course through an array dbname x user status
	api_session_register('status');
	/*
	==============================================================================
			RIGHT MENU
			for users who are logged in
	==============================================================================
		*/
	echo "<div class=\"menu\">";

	api_display_language_form();
	echo "<div class=\"menusection\">";
	echo "<span class=\"menusectioncaption\">".get_lang("MenuUser")."</span>";
	echo "<ul class=\"menulist\">";

	$display_add_course_link = api_is_allowed_to_create_course() && ($_SESSION["studentview"] != "studentenview");
	if ($display_add_course_link)
		display_create_course_link();
	display_edit_course_list_links();
	display_digest($toolsList, $digest, $orderKey, $dateFormatForInfosFromCourses, $courses);

	echo "</ul>";
	echo "</div>";
	echo "<br><div class=\"menusection\">";
	echo "<span class=\"menusectioncaption\">".get_lang("MenuGeneral")."</span><ul class=\"menulist\">";

	$user_selected_language = $_SESSION["user_language_choice"];
	if (!isset ($user_selected_language))
		$user_selected_language = $platformLanguage;

	if(!file_exists('home/home_menu_'.$user_selected_language.'.html'))
	{
		include ('home/home_menu.html');
	}
	else
	{
		include('home/home_menu_'.$user_selected_language.'.html');
	}

	echo "</ul></div>";
	if (api_is_platform_admin())
	{
		echo "<div class=\"menusection\">";
		echo "<span class=\"menusectioncaption\">".get_lang("MenuAdmin")."</span>";
		echo "<ul class=\"menulist\">";
		display_admin_links();
		echo "</ul>";
		echo "</div>";
	}
	// Load appropriate plugins for this menu bar
	if (is_array($plugins['main_menu']))
	{
		foreach ($plugins['main_menu'] as $this_plugin)
		{
			include (api_get_path(PLUGIN_PATH)."$this_plugin/index.php");
		}
	}
	echo "</div>"; // end of menu for logged in users
} // end elseif (isset($uid)) == if visitor logged in
/*
===============================================================================
		ANONYMOUS USER SECTION (Default)
		for users who are not logged in
===============================================================================
*/
else
{
	echo "<div class=\"maincontent\">";
	if (!empty ($_GET['include']) && !strstr($_GET['include'], '/') && strstr($_GET['include'], '.html'))
	{
		include ('./home/'.$_GET['include']);
		$pageIncluded = true;
	}
	else
	{
		//$tmplang = isset($user_language_choice) ? $user_language_choice : $platformLanguage;
		//include ('home/home_top_'.$tmplang.'.html'); // Introduction message if needed
		include ('home/'.$_SESSION["prefix"].'home_top_'.$user_selected_language.'.html');
	}
	// Display System announcements
	$announcement = $_GET['announcement'] ? $_GET['announcement'] : -1;
	SystemAnnouncementManager :: display_announcements(VISIBLE_GUEST, $announcement);
	// Display courses and category list
	if (!$pageIncluded)
		:
?>
<div class="clear">&nbsp;</div>
<div class="home_cats">
		<?php
if (DISPLAY_COURSES_TO_ANONYMOUS_USERS && ($user_selected_language == 'greek')) {
	display_anonymous_course_list();
}
?>
</div>
<div class="home_news">
		<?php


	//include ('home/home_news_'.$user_selected_language.'.html');
?>
</div>                                                  
	<?php


	endif; // end if(!$pageIncluded)
	echo "</div>";
	// Right Menu
	// language form, login section + useful weblinks
	echo "<div class=\"menu\">";
	api_display_language_form();
	display_anonymous_right_menu();
	echo "</div>";
} // end of anonymous right menu
/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>
