<?php // $Id: userLog.php,v 1.39 2005/06/27 14:33:55 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Roan Embrechts (Vrije Universiteit Brussel)
    Copyright (c) Sebastien Piraux  <piraux_seb@hotmail.com>

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	@package dokeos.tracking
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/
$uInfo = 0;
$view = '';
if (isset($_REQUEST['uInfo'])) {
	$uInfo = intval($_REQUEST['uInfo']);
}

if (isset($_REQUEST['view'])) {
	$view = intval($_REQUEST['view']);
}


$langFile = "tracking";

include('../inc/claro_init_global.inc.php');

// charset determination
if ($_GET['scormcontopen'])
	{
	include_once(api_get_library_path().'/database.lib.php');
	include('../scorm/XMLencode.php');
	$TBL_SCORM_MAIN     = Database::get_scorm_main_table();
	$result = api_sql_query("SELECT contentTitle FROM $TBL_SCORM_MAIN where (contentId=".$_GET['scormcontopen'].")");
	$ar = mysql_fetch_array($result);
	$contentTitle = $ar['contentTitle'];
	$path=api_get_path('SYS_COURSE_PATH');
	$file=$path.$_cid.'/scorm'.$contentTitle.'/imsmanifest.xml';
	$charset = GetXMLEncode($file);
	header('Content-Type: text/html; charset='. $charset);
	}

/*
$interbredcrump[]= array ("url"=>"../group/group.php", "name"=> get_lang('BredCrumpGroups'));
$interbredcrump[]= array ("url"=>"../group/group_space.php?gidReq=$_gid", "name"=> get_lang('BredCrumpGroupSpace'));
*/

if($uInfo)
{
	$interbredcrump[]= array ("url"=>"../user/userInfo.php?uInfo=$uInfo", "name"=> get_lang('BredCrumpUsers'));
}


if (!isset($status_lang) && !is_array($status_lang)) {
	$status_lang = array(
		'not attempted' => $tmparrlang[0],
		'completed' => $tmparrlang[1],
		'incomplete' => $tmparrlang[2],
	);
}

/**
 * Shortcut function to use htmlspecialchars on many, many strings in this script
 * @param		string	String in a supposed encoding
 * @param		string	Supposed initial encoding (default: 'UTF-8')
 * @return	string	HTML string (no encoding dependency)
 * @author Yannick Warnier <yannick.warnier@dokeos.com>
 */
function myEnc($isostring,$supposed_encoding='UTF-8'){
	return htmlspecialchars($isostring,ENT_QUOTES,$supposed_encoding);
}

$nameTools = get_lang('ToolName');

$htmlHeadXtra[] = "<style type='text/css'>
<!--
.secLine {background-color : #E6E6E6;}
.content {padding-left : 15px;padding-right : 15px; }
.specialLink{color : #0000FF;}
-->
</style>
<STYLE media='print' type='text/css'>
<!--
TD {border-bottom: thin dashed Gray;}
-->
</STYLE>";

// regroup table names for maintenance purpose
//$TABLECOURSUSER	        = $mysqlMainDb.".cours_user";
//updated for 1.6 - YW
$TABLECOURSUSER	        = Database::get_main_table(MAIN_COURSE_USER_TABLE);
$TABLEUSER	        = $mysqlMainDb.".user";

$TABLETRACK_ACCESS      = $statsDbName.".track_e_access";
$TABLETRACK_LINKS       = $statsDbName.".track_e_links";
$TABLETRACK_LOGIN       = $statsDbName.".track_e_login";
$TABLETRACK_DOWNLOADS   = $statsDbName.".track_e_downloads";
$TABLETRACK_UPLOADS     = $statsDbName.".track_e_uploads";
$TABLETRACK_EXERCICES   = $statsDbName.".track_e_exercices";

$TABLECOURSE_LINKS		= $_course['dbNameGlu']."link";
$TABLECOURSE_WORK       = $_course['dbNameGlu']."work";
$TABLECOURSE_DOCUMENTS  = $_course['dbNameGlu']."document";
$TABLECOURSE_GROUPS     = $_course['dbNameGlu']."student_group";
$TABLECOURSE_GROUPSPROP = $_course['dbNameGlu']."group_properties";
$TABLECOURSE_GROUPSUSER = $_course['dbNameGlu']."user_group";
$TABLECOURSE_EXERCICES = $_course['dbNameGlu']."quiz";
$tbl_learnpath_main = $_course['dbNameGlu']."learnpath_main";
$tbl_learnpath_item = $_course['dbNameGlu']."learnpath_item";
$tbl_learnpath_chapter = $_course['dbNameGlu']."learnpath_chapter";
$tbl_learnpath_user = $_course['dbNameGlu']."learnpath_user";
$TBL_TRACK_HOTPOTATOES   = $statsDbName.".track_e_hotpotatoes";

Display::display_header($nameTools,"Tracking");
include(api_get_library_path()."/statsUtils.lib.inc.php");
include("../resourcelinker/resourcelinker.inc.php");
include_once($rootSys.'claroline/exercice/hotpotatoes.lib.php');
$documentPath=api_get_path(SYS_COURSE_PATH).$_course['path'].'/document';

// the variables for the days and the months
// Defining the shorts for the days
$DaysShort = array (myEnc(get_lang("SundayShort")), myEnc(get_lang("MondayShort")), myEnc(get_lang("TuesdayShort")), myEnc(get_lang("WednesdayShort")), myEnc(get_lang("ThursdayShort")), myEnc(get_lang("FridayShort")), myEnc(get_lang("SaturdayShort")));
// Defining the days of the week to allow translation of the days
$DaysLong = array (myEnc(get_lang("SundayLong")), myEnc(get_lang("MondayLong")), myEnc(get_lang("TuesdayLong")), myEnc(get_lang("WednesdayLong")), myEnc(get_lang("ThursdayLong")), myEnc(get_lang("FridayLong")), myEnc(get_lang("SaturdayLong")));
// Defining the months of the year to allow translation of the months
$MonthsLong = array (myEnc(get_lang("JanuaryLong")), myEnc(get_lang("FebruaryLong")), myEnc(get_lang("MarchLong")), myEnc(get_lang("AprilLong")), myEnc(get_lang("MayLong")), myEnc(get_lang("JuneLong")), myEnc(get_lang("JulyLong")), myEnc(get_lang("AugustLong")), myEnc(get_lang("SeptemberLong")), myEnc(get_lang("OctoberLong")), myEnc(get_lang("NovemberLong")), myEnc(get_lang("DecemberLong")));
// Defining the months of the year to allow translation of the months
$MonthsShort = array (myEnc(get_lang("JanuaryShort")), myEnc(get_lang("FebruaryShort")), myEnc(get_lang("MarchShort")), myEnc(get_lang("AprilShort")), myEnc(get_lang("MayShort")), myEnc(get_lang("JuneShort")), myEnc(get_lang("JulyShort")), myEnc(get_lang("AugustShort")), myEnc(get_lang("SeptemberShort")), myEnc(get_lang("OctoberShort")), myEnc(get_lang("NovemberShort")), myEnc(get_lang("DecemberShort")));

$is_allowedToTrack = $is_groupTutor; // allowed to track only user of one group
$is_allowedToTrackEverybodyInCourse = $is_courseAdmin; // allowed to track all student in course
?>
<h3>
    <?php echo $nameTools ?>
</h3>
<h4>
    <?php echo myEnc(get_lang('StatsOfUser')); ?>
</h4>
<table width="100%" cellpadding="2" cellspacing="3" border="0">
<?php
// check if uid is tutor of this group

if( ( ($_uid == $uInfo) || $is_allowedToTrack || $is_allowedToTrackEverybodyInCourse ) && $is_trackingEnabled )
{
    if(!$uInfo && !isset($uInfo) )
    {
        /***************************************************************************
         *
         *		Display list of user of this group
         *
         ***************************************************************************/
        echo "<h4>".myEnc(get_lang('ListStudents'))."</h4>";
        if( $is_allowedToTrackEverybodyInCourse )
        {
            // if user can track everybody : list user of course
            $sql = "SELECT count(user_id)
                        FROM $TABLECOURSUSER
                        WHERE course_code = '$_cid'";
        }
        else
        {
            // if user can only track one group : list users of this group
            $sql = "SELECT count(user)
                        FROM $TABLECOURSE_GROUPSUSER
                        WHERE group_id = '$_gid'";
        }
        $userGroupNb = getOneResult($sql);
        $step = 25; // number of student per page
        if ($userGroupNb > $step)
        {
            if(!isset($offset))
            {
                    $offset=0;
            }

            $next     = $offset + $step;
            $previous = $offset - $step;

            $navLink = "<table width='100%' border='0'>\n"
                      ."<tr>\n"
                              ."<td align='left'>";

            if ($previous >= 0)
            {
                    $navLink .= "<a href='".$_SERVER['PHP_SELF']."?offset=$previous'>&lt;&lt; ".myEnc(get_lang('PreviousPage'))."</a>";
            }

            $navLink .= "</td>\n"
                       ."<td align='right'>";

            if ($next < $userGroupNb)
            {
                    $navLink .= "<a href='".$_SERVER['PHP_SELF']."?offset=$next'>".myEnc(get_lang('NextPage'))." &gt;&gt;</a>";
            }

            $navLink .= "</td>\n"
                       ."</tr>\n"
                       ."</table>\n";
        }
        else
        {
            $offset = 0;
        }

        echo $navLink;

	if (!settype($offset, 'integer') || !settype($step, 'integer')) die('Offset or step variables are not integers.');	//sanity check of integer vars
        if( $is_allowedToTrackEverybodyInCourse )
        {
            // list of users in this course
            $sql = "SELECT u.user_id, u.firstname,u.lastname
                        FROM $TABLECOURSUSER cu , $TABLEUSER u
                        WHERE cu.user_id = u.user_id
                            AND cu.course_code = '$_cid'
                        LIMIT $offset,$step";
        }
        else
        {
            // list of users of this group
            $sql = "SELECT u.user_id, u.firstname,u.lastname
                        FROM $TABLECOURSE_GROUPSUSER gu , $TABLEUSER u
                        WHERE gu.user_id = u.user_id
                            AND gu.group_id = '$_gid'
                        LIMIT $offset,$step";
        }
        $list_users = getManyResults3Col($sql);
        echo 	"<table width='100%' cellpadding='2' cellspacing='1' border='0'>\n"
                    ."<tr align='center' valign='top' bgcolor='#E6E6E6'>\n"
                    ."<td align='left'>",myEnc(get_lang('UserName')),"</td>\n"
                    ."</tr>\n";
        for($i = 0 ; $i < sizeof($list_users) ; $i++)
        {
            echo    "<tr valign='top' align='center'>\n"
                    ."<td align='left'>"
                    ."<a href='".$_SERVER['PHP_SELF']."?uInfo=",$list_users[$i][0],"'>"
                    .$list_users[$i][1]," ",$list_users[$i][2]
                    ."</a>".
                    "</td>\n";
        }
        echo        "</table>\n";

        echo $navLink;
    }
    else // if uInfo is set
    {
        /***************************************************************************
         *
         *		Informations about student uInfo
         *
         ***************************************************************************/
        // these checks exists for security reasons, neither a prof nor a tutor can see statistics of an user from
        // another course, or group
        if( $is_allowedToTrackEverybodyInCourse )
        {
            // check if user is in this course
            $sql = "SELECT u.firstname,u.lastname, u.email
                        FROM $TABLECOURSUSER cu , $TABLEUSER u
                        WHERE cu.user_id = u.user_id
                            AND cu.course_code = '$_cid'
                            AND u.user_id = '$uInfo'";
	        $query = api_sql_query($sql,__FILE__,__LINE__);
			$res = @mysql_fetch_array($query);
        } elseif ($uInfo != $_uid) {
            // check if user is in the group of this tutor
            $sql = "SELECT u.firstname,u.lastname, u.email
                        FROM $TABLECOURSE_GROUPSUSER gu , $TABLEUSER u
                        WHERE gu.user_id = u.user_id
                            AND gu.group_id = '$_gid'
                            AND u.user_id = '$uInfo'";
	        $query = api_sql_query($sql,__FILE__,__LINE__);
			$res = @mysql_fetch_array($query);
        } else {
			$res = array($GLOBALS["HTTP_SESSION_VARS"]["_user"]["firstName"], $GLOBALS["HTTP_SESSION_VARS"]["_user"]["lastName"], $GLOBALS["HTTP_SESSION_VARS"]["_user"]["mail"]);
		}
        if(is_array($res))
        {
            $res[2] == "" ? $res2 = myEnc(get_lang('NoEmail')) : $res2 = Display::encrypted_mailto_link($res[2]);

            echo "<tr><td>";
            echo $informationsAbout." : <br>";
            echo "<ul>\n"
                    ."<li>".myEnc(get_lang('FirstName'))." : ".$res[0]."</li>\n"
                    ."<li>".myEnc(get_lang('LastName'))." : ".$res[1]."</li>\n"
                    ."<li>".myEnc(get_lang('Email'))." : ".$res2."</li>\n"
                    ."</ul>";
            echo "</td></tr>";

            // show all : number of 1 is equal to or bigger than number of categories
            // show none : number of 0 is equal to or bigger than number of categories
            echo "<tr>
                    <td>
                    [<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=1111111'>".myEnc(get_lang('ShowAll'))."</a>]
                    [<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=0000000'>".myEnc(get_lang('ShowNone'))."</a>]".
                    //"||[<a href='".$_SERVER['PHP_SELF']."'>".myEnc(get_lang('BackToList'))."</a>]".
                    "</td>
                </tr>
            ";

            if(!isset($view)) $view ="0000000";

            /***************************************************************************
             *
             *		Logins
             *
             ***************************************************************************/
            $tempView = $view;
            if($view[0] == '1')
            {
                $tempView[0] = '0';
                echo "
                    <tr>
                            <td valign='top'>
                            <font color='#0000FF'>-&nbsp;&nbsp;&nbsp;</font><b>".myEnc(get_lang('LoginsAndAccessTools'))."</b>&nbsp;&nbsp;&nbsp;[<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."'>".myEnc(get_lang('Close'))."</a>]
                            </td>
                    </tr>
                ";
                echo "<tr><td style='padding-left : 40px;' valign='top'>".myEnc(get_lang('LoginsDetails'))."<br>";

   				$sql = "SELECT UNIX_TIMESTAMP(access_date), count(access_date)
                            FROM $TABLETRACK_ACCESS
                            WHERE access_user_id = '$uInfo'
                            AND access_cours_code = '".$_cid."'
                            GROUP BY YEAR(access_date),MONTH(access_date)
                            ORDER BY YEAR(access_date),MONTH(access_date) ASC";

                /*$sql = "SELECT UNIX_TIMESTAMP(login_date), count(login_date)
                            FROM $TABLETRACK_LOGIN
                            WHERE login_user_id = '$uInfo'
                            GROUP BY MONTH(login_date)
                            ORDER BY login_date ASC";*/
                echo "<tr><td style='padding-left : 40px;padding-right : 40px;'>";
                //$results = getManyResults2Col($sql);
				$results = getManyResults3Col($sql);

                echo "<table cellpadding='2' cellspacing='1' border='0' align=center>";
                echo "<tr>
                        <td class='secLine'>
                        ".myEnc(get_lang('LoginsTitleMonthColumn'))."
                        </td>
                        <td class='secLine'>
                        ".myEnc(get_lang('LoginsTitleCountColumn'))."
                        </td>
                    </tr>";
                $total = 0;
                if (is_array($results))
                {
                    for($j = 0 ; $j < count($results) ; $j++)
                    {
                        echo "<tr>";
                        //echo "<td class='content'><a href='logins_details.php?uInfo=$uInfo&reqdate=".$results[$j][0]."'>".$langMonthNames['long'][date("n", $results[$j][0])-1]." ".date("Y", $results[$j][0])."</a></td>";
						echo "<td class='content'><a href='logins_details.php?uInfo=$uInfo&reqdate=".$results[$j][0]."&view=$view'>".$MonthsLong[date("n", $results[$j][0])-1]." ".date("Y", $results[$j][0])."</a></td>";
                        echo "<td valign='top' align='right' class='content'>".$results[$j][1]."</td>";
                        echo"</tr>";
                        $total = $total + $results[$j][1];
                    }
                    echo "<tr>";
                    echo "<td>".myEnc(get_lang('Total'))."</td>";
                    echo "<td align='right' class='content'>".$total."</td>";
                    echo"</tr>";
                }
                else
                {
                    echo "<tr>";
                    echo "<td colspan='2'><center>".myEnc(get_lang('NoResult'))."</center></td>";
                    echo"</tr>";
                }
                echo "</table>";
                echo "</td></tr>";
            }
            else
            {
                $tempView[0] = '1';
                echo "
                    <tr>
                            <td valign='top'>
                            +<font color='#0000FF'>&nbsp;&nbsp;</font><a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."' class='specialLink'>".myEnc(get_lang('LoginsAndAccessTools'))."</a>
                            </td>
                    </tr>
                ";
            }

            /***************************************************************************
             *
             *		Exercices
             *
             ***************************************************************************/
              $tempView = $view;
            if($view[1] == '1')
            {
                $tempView[1] = '0';
                echo "
                    <tr>
                            <td valign='top'>
                            <font color='#0000FF'>-&nbsp;&nbsp;&nbsp;</font><b>".myEnc(get_lang('ExercicesResults'))."</b>&nbsp;&nbsp;&nbsp;[<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."'>".myEnc(get_lang('Close'))."</a>]
                            </td>
                    </tr>
                ";
                echo "<tr><td style='padding-left : 40px;' valign='top'>".myEnc(get_lang('ExercicesDetails'))."<br>";
                $sql = "SELECT ce.title, te.exe_result , te.exe_weighting, UNIX_TIMESTAMP(te.exe_date)
                            FROM $TABLECOURSE_EXERCICES AS ce , $TABLETRACK_EXERCICES AS te
                            WHERE te.exe_cours_id = '$_cid'
                                AND te.exe_user_id = '$uInfo'
                                AND te.exe_exo_id = ce.id
                            ORDER BY ce.title ASC, te.exe_dateASC";

								$hpsql="SELECT te.exe_name, te.exe_result , te.exe_weighting, UNIX_TIMESTAMP(te.exe_date)
      											FROM $TBL_TRACK_HOTPOTATOES AS te
      											WHERE te.exe_user_id = '$uInfo' AND te.exe_cours_id = '".$_cid."'
      											ORDER BY te.exe_cours_id ASC, te.exe_date ASC";
								$hpresults=getManyResultsXCol($hpsql,4);

            		$NoTestRes = 0;
								$NoHPTestRes = 0;

                echo "<tr><td style='padding-left : 40px;padding-right : 40px;'>";
                $results = getManyResultsXCol($sql,4);
                echo "<table cellpadding='2' cellspacing='1' border='0' align='center'>";
                echo "<tr bgcolor='#E6E6E6'>
                        <td>
                        ".myEnc(get_lang('ExercicesTitleExerciceColumn'))."
                        </td>
                        <td>
                        ".myEnc(get_lang('Date'))."
                        </td>
                        <td>
                        ".myEnc(get_lang('ExercicesTitleScoreColumn'))."
                        </td>
                    </tr>";
                if (is_array($results))
                {
                    for($i = 0; $i < sizeof($results); $i++)
                    {

                        $beautifulDate = dateLocalizer($dateTimeFormatLong,$results[$i][3]);
                        echo "<tr>";
                        echo "<td class='content'>".$results[$i][0]."</td>";
                        echo "<td class='content'>".$beautifulDate."</td>";
                        echo "<td valign='top' align='right' class='content'>".$results[$i][1]." / ".$results[$i][2]."</td>";
                        echo"</tr>";
                    }

                }
                else // istvan begin
                {
                	$NoTestRes = 1;
                }
                // The Result of Tests

								if(is_array($hpresults))
								{
									for($i = 0; $i < sizeof($hpresults); $i++)
									{
												$title = GetQuizName($hpresults[$i][0],$documentPath);
													if ($title =='')
														{
																$title = GetFileName($hpresults[$i][0]);
														}
									      $beautifulDate = dateLocalizer($dateTimeFormatLong,$hpresults[$i][3]);
      								?>
      								<tr>
      								  <td class="content"><?php echo $title; ?></td>
      								  <td class="content" align="center"><?php echo $beautifulDate; ?></td>
      								  <td class="content" align="center"><?php echo $hpresults[$i][1]; ?> / <?php echo $hpresults[$i][2]; ?></td>
      								</tr>
             					<?php
      		    					}
								}
								else
								{
									$NoHPTestRes = 1;
								}


                if ($NoTestRes==1 && $NoHPTestRes==1)
                {
                    echo "<tr>";
                    echo "<td colspan='3'><center>".myEnc(get_lang('NoResult'))."</center></td>";
                    echo"</tr>";
                }
                echo "</table>";
                echo "</td></tr>";
            }
            else
            {
                $tempView[1] = '1';
                echo "
                    <tr>
                            <td valign='top'>
                            +<font color='#0000FF'>&nbsp;&nbsp;</font><a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."' class='specialLink'>".myEnc(get_lang('ExercicesResults'))."</a>
                            </td>
                    </tr>
                ";
            }


            /***************************************************************************
             *
             *		Work upload
             *
             ***************************************************************************/
            $tempView = $view;
            if($view[2] == '1')
            {
                $tempView[2] = '0';
                echo "
                    <tr>
                            <td valign='top'>
                            <font color='#0000FF'>-&nbsp;&nbsp;&nbsp;</font><b>".myEnc(get_lang('WorkUploads'))."</b>&nbsp;&nbsp;&nbsp;[<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."'>".myEnc(get_lang('Close'))."</a>]
                            </td>
                    </tr>
                ";
                echo "<tr><td style='padding-left : 40px;' valign='top'>".myEnc(get_lang('WorksDetails'))."<br>";
                $sql = "SELECT u.upload_date, w.title, w.author,w.url
                                    FROM $TABLETRACK_UPLOADS u , $TABLECOURSE_WORK w
                                    WHERE u.upload_work_id = w.id
                                        AND u.upload_user_id = '$uInfo'
                                        AND u.upload_cours_id = '$_cid'
                                    ORDER BY u.upload_date DESC";
                echo "<tr><td style='padding-left : 40px;padding-right : 40px;'>";
                $results = getManyResultsXCol($sql,4);
                echo "<table cellpadding='2' cellspacing='1' border='0' align=center>";
                echo "<tr>
                        <td class='secLine' width='40%'>
                        ".myEnc(get_lang('WorkTitle'))."
                        </td>
                        <td class='secLine' width='30%'>
                        ".myEnc(get_lang('WorkAuthors'))."
                        </td>
                        <td class='secLine' width='30%'>
                        ".myEnc(get_lang('Date'))."
                        </td>
                    </tr>";
                if (is_array($results))
                {
                    for($j = 0 ; $j < count($results) ; $j++)
                    {
                        $pathToFile = $coursesRepositoryWeb.$_course['path']."/".$results[$j][3];
                        $timestamp = strtotime($results[$j][0]);
                        $beautifulDate = dateLocalizer($dateTimeFormatLong,$timestamp);
                        echo "<tr>";
                        echo "<td class='content'>"
                                ."<a href ='".$pathToFile."'>".$results[$j][1]."</a>"
                                ."</td>";
                        echo "<td class='content'>".$results[$j][2]."</td>";
                        echo "<td class='content'>".$beautifulDate."</td>";
                        echo"</tr>";
                    }

                }
                else
                {
                    echo "<tr>";
                    echo "<td colspan='3'><center>".myEnc(get_lang('NoResult'))."</center></td>";
                    echo"</tr>";
                }
                echo "</table>";
                echo "</td></tr>";
            }
            else
            {
                $tempView[2] = '1';
                echo "
                    <tr>
                            <td valign='top'>
                            +<font color='#0000FF'>&nbsp;&nbsp;</font><a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."' class='specialLink'>".myEnc(get_lang('WorkUploads'))."</a>
                            </td>
                    </tr>
                ";
            }

           /***************************************************************************
             *
             *		Links usage
             *
             ***************************************************************************/
            $tempView = $view;
            if($view[3] == '1')
            {
                $tempView[3] = '0';
                echo "
                    <tr>
                            <td valign='top'>
                            <font color='#0000FF'>-&nbsp;&nbsp;&nbsp;</font><b>".myEnc(get_lang('LinksAccess'))."</b>&nbsp;&nbsp;&nbsp;[<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."'>".myEnc(get_lang('Close'))."</a>]
                            </td>
                    </tr>
                ";
                echo "<tr><td style='padding-left : 40px;' valign='top'>".myEnc(get_lang('LinksDetails'))."<br>";
                $sql = "SELECT cl.title, cl.url
                            FROM $TABLETRACK_LINKS AS sl, $TABLECOURSE_LINKS AS cl
                            WHERE sl.links_link_id = cl.id
                                AND sl.links_cours_id = '$_cid'
                                AND sl.links_user_id = '$uInfo'
                            GROUP BY cl.title, cl.url";
                echo "<tr><td style='padding-left : 40px;padding-right : 40px;'>";
                $results = getManyResults2Col($sql);
                echo "<table cellpadding='2' cellspacing='1' border='0' align=center>";
                echo "<tr>
                        <td class='secLine'>
                        ".myEnc(get_lang('LinksTitleLinkColumn'))."
                        </td>
                    </tr>";
                if (is_array($results))
                {
                    for($j = 0 ; $j < count($results) ; $j++)
                    {
                            echo "<tr>";
                            echo "<td class='content'><a href='".$results[$j][1]."'>".$results[$j][0]."</a></td>";
                            echo"</tr>";
                    }

                }
                else
                {
                    echo "<tr>";
                    echo "<td ><center>".myEnc(get_lang('NoResult'))."</center></td>";
                    echo"</tr>";
                }
                echo "</table>";
                echo "</td></tr>";
            }
            else
            {
                $tempView[3] = '1';
                echo "
                    <tr>
                            <td valign='top'>
                            +<font color='#0000FF'>&nbsp;&nbsp;</font><a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."' class='specialLink'>".myEnc(get_lang('LinksAccess'))."</a>
                            </td>
                    </tr>
                ";
            }

            /***************************************************************************
             *
             *		Access to documents
             *
             ***************************************************************************/
            $tempView = $view;
            if($view[4] == '1')
            {
                $tempView[4] = '0';
                echo "
                    <tr>
                            <td valign='top'>
                            <font color='#0000FF'>-&nbsp;&nbsp;&nbsp;</font><b>".myEnc(get_lang('DocumentsAccess'))."</b>&nbsp;&nbsp;&nbsp;[<a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."'>".myEnc(get_lang('Close'))."</a>]
                            </td>
                    </tr>
                ";
                echo "<tr><td style='padding-left : 40px;' valign='top'>".myEnc(get_lang('DocumentsDetails'))."<br>";

                $sql = "SELECT down_doc_path
                            FROM $TABLETRACK_DOWNLOADS
                            WHERE down_cours_id = '$_cid'
                                AND down_user_id = '$uInfo'
                            GROUP BY down_doc_path";

                echo "<tr><td style='padding-left : 40px;padding-right : 40px;'>";
                $results = getManyResults1Col($sql);
                echo "<table cellpadding='2' cellspacing='1' border='0' align='center'>";
                echo "<tr>
                        <td class='secLine'>
                        ".myEnc(get_lang('DocumentsTitleDocumentColumn'))."
                        </td>
                    </tr>";
                if (is_array($results))
                {
                    for($j = 0 ; $j < count($results) ; $j++)
                    {
                            echo "<tr>";
                            echo "<td class='content'>".$results[$j]."</td>";
                            echo"</tr>";
                    }

                }
                else
                {
                    echo "<tr>";
                    echo "<td><center>".myEnc(get_lang('NoResult'))."</center></td>";
                    echo"</tr>";
                }
                echo "</table>";
                echo "</td></tr>";
            }
            else
            {
                $tempView[4] = '1';
                echo "
                    <tr>
                            <td valign='top'>
                            +<font color='#0000FF'>&nbsp;&nbsp;</font><a href='".$_SERVER['PHP_SELF']."?uInfo=$uInfo&view=".$tempView."' class='specialLink'>".myEnc(get_lang('DocumentsAccess'))."</a>
                            </td>
                    </tr>
                ";
            }
        }
        else
        {
            echo myEnc(get_lang('ErrorUserNotInGroup'));
        }


	/***************************************************************************
         *
         *		Scorm contents and Learning Path
         *
         ***************************************************************************/
        $tempView = $view;
        if($view[5] == '1')
        {
            $tempView[5] = '0';
            echo "
                <tr>
                        <td valign='top'>
                        <font     color='#0000FF'>-&nbsp;&nbsp;&nbsp;</font><b>".myEnc(get_lang('ScormAccess'))."</b>&nbsp;&nbsp;&nbsp;[<a href='".$_SERVER['PHP_SELF']."?view=$tempView&uInfo=$uInfo'>".myEnc(get_lang('Close'))."</a>]
                        </td>
                </tr>
            ";

            $sql = "SELECT contentTitle, contentId
    					FROM $scormDbName.scorm_main
                        WHERE dokeosCourse='$_cid' ORDER BY contentTitle ASC";
    		$result=api_sql_query($sql,__FILE__,__LINE__);
    	    $ar=mysql_fetch_array($result);

	    	echo "<tr><td style='padding-left : 40px;padding-right : 40px;'>";
            echo "<table cellpadding='2' cellspacing='1' border='0' align='center'><tr>
    				                <td class='secLine'>
    								&nbsp;".myEnc(get_lang('ScormContentColumn'))."&nbsp;
    				                </td>
    		</tr>";
            if (is_array($ar))
            {
    			while ($ar != '') {
    				echo "<tr><td>";
    				echo "<a href='".$_SERVER['PHP_SELF']."?view=".$view."&scormcontopen=".$ar['contentId']."&uInfo=$uInfo' class='specialLink'>{$ar['contentTitle']}</a>";
    				echo "</td></tr>";
    				if ($ar['contentId']==$scormcontopen) { //have to list the students here
        					$contentId=$ar['contentId'];
 							$sql3 = "SELECT status, score, scoTitle, time
    									FROM $scormDbName.scorm_sco_data
    				                    WHERE (studentId='$uInfo' and contentId='$contentId') ORDER BY scoId";
   							$result3=api_sql_query($sql3,__FILE__,__LINE__);
   						    $ar3=mysql_fetch_array($result3);
                            if (is_array($ar3)) {
                                echo "<tr><td>&nbsp;&nbsp;&nbsp;</td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormTitleColumn'))."&nbsp;
       				                </td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormStatusColumn'))."&nbsp;
       				                </td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormScoreColumn'))."&nbsp;
       				                </td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormTimeColumn'))."&nbsp;
       				                </td>
       					            </tr>";
       							while ($ar3 != '') {
									$ar3status = (isset($status_lang[$ar3['status']])) ? $status_lang[$ar3['status']] : $ar3['status'];
       								echo "<tr><td>&nbsp;&nbsp;&nbsp;</td><td>";
       								echo "{$ar3['scoTitle']}</td><td align=right>{$ar3status}</td><td     align=right>{$ar3['score']}</td><td align=right>{$ar3['time']}</td>";
       								echo "</tr>";
       								$ar3=mysql_fetch_array($result3);
       							}
                            } else {
                                echo "<tr>";
                                echo "<td colspan='3'><center>".myEnc(get_lang('ScormNeverOpened'))."</center></td>";
                                echo"</tr>";
                            }
   					}
		    		$ar=mysql_fetch_array($result);
    			}

            }
            else
            {
				$noscorm=true;
            }


			$sql = "SELECT * FROM $tbl_learnpath_main";
    		$result=api_sql_query($sql,__FILE__,__LINE__);
    	    $ar=mysql_fetch_array($result);

            if (is_array($ar))
            {
    			while ($ar != '') {
    				echo "<tr><td>";
    				echo "<a href='".$_SERVER['PHP_SELF']."?view=".$view."&pathopen=".$ar['learnpath_id']."&uInfo=$uInfo' class='specialLink'>{$ar['learnpath_name']}</a>";
    				echo "</td></tr>";
    				if ($ar['learnpath_id']==$pathopen) { //have to list the students here
        					$learnpath_id=$ar['learnpath_id'];
 							$sql3 = "SELECT status
    									FROM $tbl_learnpath_user
    				                    WHERE (user_id='$uInfo' and learnpath_id='$learnpath_id')";
   							$result3=api_sql_query($sql3,__FILE__,__LINE__);
   						    $ar3=mysql_fetch_array($result3);
                            if (is_array($ar3)) {
                                echo "<tr><td>&nbsp;&nbsp;&nbsp;</td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormTitleColumn'))."&nbsp;
       				                </td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormStatusColumn'))."&nbsp;
       				                </td>
       				                <td class='secLine'>
       				                &nbsp;".myEnc(get_lang('ScormScoreColumn'))."&nbsp;
       				                </td>
       					            </tr>";

								$sql2="SELECT * FROM $tbl_learnpath_chapter WHERE (learnpath_id=$learnpath_id) ORDER BY display_order";
								$result2=api_sql_query($sql2,__FILE__,__LINE__);
								while ($row2=mysql_fetch_array($result2)) {
									$id=$row2['id'];
									$sql3="SELECT * FROM $tbl_learnpath_item WHERE (chapter_id=$id) ORDER BY display_order";
									$result3=api_sql_query($sql3,__FILE__,__LINE__);

									echo "<tr><td></td><td colspan=3>&nbsp;{$row2['chapter_name']}</td></tr>";

									while ($row3=mysql_fetch_array($result3)) {
										$sql0 = "SELECT * FROM $tbl_learnpath_user WHERE (user_id='".$uInfo."' and 	learnpath_item_id='".$row3['id']."' and learnpath_id='".$learnpath_id."')";
										$result0=api_sql_query($sql0,__FILE__,__LINE__);
										$row0=mysql_fetch_array($result0);

											echo "<tr><td></td><td>&nbsp;&nbsp;&nbsp;";
										display_addedresource_link_in_learnpath($row3['item_type'], $row3['item_id'], '', 	$row3['id'],'builder','');
										$row0status = (isset($status_lang[$row0['status']])) ? $status_lang[$row0['status']] : $row0['status'];
										echo "</td><td>{$row0status}</td><td align=right>{$row0['score']}</td></tr>";

									}
								}

                            } else {
                                echo "<tr>";
                                echo "<td colspan='3'><center>".myEnc(get_lang('ScormNeverOpened'))."</center></td>";
                                echo"</tr>";
                            }
   					}
		    		$ar=mysql_fetch_array($result);
    			}

            }
            else
            {
				$nopath=true;
            }


			if (($noscorm) and ($nopath)) {
                echo "<tr>";
                echo "<td colspan='3'><center>".myEnc(get_lang('NoResult'))."</center></td>";
                echo"</tr>";
			}
            echo "</table>";
            echo "</td></tr>";
        }
        else
        {
            $tempView[5] = '1';
            echo "
                <tr>
                        <td valign='top'>
                        +<font color='#0000FF'>&nbsp;&nbsp;</font><a href='".$_SERVER['PHP_SELF']."?view=$tempView&uInfo=$uInfo' class='specialLink'>".myEnc(get_lang('ScormAccess'))."</a>
                        </td>
                </tr>
            ";
        }

    }
}
// not allowed
else
{
    if(!$is_trackingEnabled)
    {
        echo myEnc(get_lang('TrackingDisabled'));
    }
    else
    {
        api_not_allowed();
    }
}
?>

</table>

<?php
Display::display_footer();
?>
