<?php // $Id: tool_access_details.lib.php,v 1.7 2005/05/10 12:56:30 tvhoecke Exp $
/*
============================================================================== 
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
============================================================================== 
*/
/**
============================================================================== 
*	This is the tool access library for Dokeos.
*	Include/require it in your code to use its functionality.
*
*	@package dokeos.library
============================================================================== 
*/

/*
============================================================================== 
		FUNCTIONS
============================================================================== 
*/
	//none

/*
============================================================================== 
		MAIN CODE
============================================================================== 
*/

	//Put your main code here. Keep this section short,
	//it's better to use functions for any non-trivial code
 
include(api_get_library_path()."/statsUtils.lib.inc.php");

// the variables for the days and the months
// Defining the shorts for the days
$DaysShort = array (get_lang("SundayShort"), get_lang("MondayShort"), get_lang("TuesdayShort"), get_lang("WednesdayShort"), get_lang("ThursdayShort"), get_lang("FridayShort"), get_lang("SaturdayShort"));
// Defining the days of the week to allow translation of the days
$DaysLong = array (get_lang("SundayLong"), get_lang("MondayLong"), get_lang("TuesdayLong"), get_lang("WednesdayLong"), get_lang("ThursdayLong"), get_lang("FridayLong"), get_lang("SaturdayLong"));
// Defining the months of the year to allow translation of the months
$MonthsLong = array (get_lang("JanuaryLong"), get_lang("FebruaryLong"), get_lang("MarchLong"), get_lang("AprilLong"), get_lang("MayLong"), get_lang("JuneLong"), get_lang("JulyLong"), get_lang("AugustLong"), get_lang("SeptemberLong"), get_lang("OctoberLong"), get_lang("NovemberLong"), get_lang("DecemberLong"));
// Defining the months of the year to allow translation of the months
$MonthsShort = array (get_lang("JanuaryShort"), get_lang("FebruaryShort"), get_lang("MarchShort"), get_lang("AprilShort"), get_lang("MayShort"), get_lang("JuneShort"), get_lang("JulyShort"), get_lang("AugustShort"), get_lang("SeptemberShort"), get_lang("OctoberShort"), get_lang("NovemberShort"), get_lang("DecemberShort"));

$tool=$_REQUEST['tool'];
$period=$_REQUEST['period'];
$reqdate=$_REQUEST['reqdate'];
?>
<table width="100%" cellpadding="2" cellspacing="0" border="0">
<?php 
    
    
    $TABLETRACK_ACCESS = $statsDbName."`.`track_e_access";
    
    if(isset($_cid)) //stats for the current course
    {
        // to see stats of one course user must be courseAdmin of this course
        $is_allowedToTrack = $is_courseAdmin;
        $courseCodeEqualcidIfNeeded = "AND `access_cours_code` = '$_cid'";
    }
    else // stats for all courses
    {
        // to see stats of all courses user must be platformAdmin
        $is_allowedToTrack = $is_platformAdmin;
        $courseCodeEqualcidIfNeeded = "";
    }
    if( $is_allowedToTrack && $is_trackingEnabled)
    {
        // list of all tools
        if (!isset($tool))
        {
            $sql = "SELECT `access_tool`, count( access_tool ) 
                        FROM `$TABLETRACK_ACCESS`
                        WHERE `access_tool` IS NOT NULL
                            ".$courseCodeEqualcidIfNeeded."
                        GROUP BY `access_tool`";
            echo "<tr><td>";  
            echo "<tr>
                    <td>
                    ";
            if(isset($_cid)) echo "<b>$_cid : </b>";
            echo "		<b>$langToolList</b>
					</td>
                </tr>
            ";
    
            $results = getManyResults2Col($sql);
            echo "<table cellpadding='0' cellspacing='0' border='0' align=center>";
            echo "<tr bgcolor='#E6E6E6'>
                    <td width='70%'>
                    $langToolTitleToolnameColumn
                    </td>
                    <td width='30%'>
                    $langToolTitleCountColumn
                    </td>
                </tr>";
            if (is_array($results))
            { 
                for($j = 0 ; $j < count($results) ; $j++)
                { 
                        echo "<tr>"; 
                        echo "<td><a href='toolaccess_details.php?tool=".urlencode($results[$j][0])."'>".get_lang($results[$j][0])."</a></td>";
                        echo "<td align='right'>".$results[$j][1]."</td>";
                        echo"</tr>";
                }
            
            }
            else
            {
                echo "<tr>"; 
                echo "<td colspan='2'><center>".$langNoResult."</center></td>";
                echo"</tr>";
            }
            echo "</table></td></tr>";
        }
        else
        {
            // this can prevent bug if there is special chars in $tool
            $encodedTool = urlencode($tool);
            $tool = urldecode($tool);
            
            if( !isset($reqdate) )
                $reqdate = time();
            echo "<tr>
                    <td>
					";
            if(isset($_cid)) echo "<b>$_cid : </b>";
            echo "        <b>".get_lang($tool)."</b>
					</td>
                </tr>
            ";
            
            /* ------ display ------ */
            // displayed period
            echo "<tr><td>";
            switch($period)
            {
                case "month" : 
                    echo $MonthsLong[date("n", $reqdate)-1].date(" Y", $reqdate);
                    break;
                case "week" : 
                    $weeklowreqdate = ($reqdate-(86400*date("w" , $reqdate)));
                    $weekhighreqdate = ($reqdate+(86400*(6-date("w" , $reqdate)) ));
                    echo "<b>".$langFrom."</b> ".date("d " , $weeklowreqdate).$MonthsLong[date("n", $weeklowreqdate)-1].date(" Y" , $weeklowreqdate);
                    echo " <b>".$langTo."</b> ".date("d " , $weekhighreqdate ).$MonthsLong[date("n", $weekhighreqdate)-1].date(" Y" , $weekhighreqdate);
                    break;
                // default == day
                default :
                    $period = "day";            
                case "day" : 
                    echo $DaysLong[date("w" , $reqdate)].date(" d " , $reqdate).$MonthsLong[date("n", $reqdate)-1].date(" Y" , $reqdate);
                    break;
            }
            echo "</tr></td>";
            // periode choice
            echo "<tr>
                    <td>
                    <small>
                    [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=day&reqdate=$reqdate' class='specialLink'>$langPeriodDay</a>] 
                    [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=week&reqdate=$reqdate' class='specialLink'>$langPeriodWeek</a>]
                    [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=month&reqdate=$reqdate' class='specialLink'>$langPeriodMonth</a>]
                    &nbsp;&nbsp;&nbsp;||&nbsp;&nbsp;&nbsp;
                    
                    ";
            switch($period)
            {
                case "month" :
                    // previous and next date must be evaluated
                    // 30 days should be a good approximation
                    $previousReqDate = mktime(1,1,1,date("m",$reqdate)-1,1,date("Y",$reqdate));
                    $nextReqDate = mktime(1,1,1,date("m",$reqdate)+1,1,date("Y",$reqdate));
                    echo   "
                        [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=month&reqdate=$previousReqDate' class='specialLink'>$langPreviousMonth</a>] 
                        [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=month&reqdate=$nextReqDate' class='specialLink'>$langNextMonth</a>]
                    ";
                    break;
                case "week" :
                    // previous and next date must be evaluated
                    $previousReqDate = $reqdate - 7*86400;
                    $nextReqDate = $reqdate + 7*86400;
                    echo   "
                        [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=week&reqdate=$previousReqDate' class='specialLink'>$langPreviousWeek</a>] 
                        [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=week&reqdate=$nextReqDate' class='specialLink'>$langNextWeek</a>]
                    ";
                    break;
                case "day" :
                    // previous and next date must be evaluated
                    $previousReqDate = $reqdate - 86400;
                    $nextReqDate = $reqdate + 86400;
                    echo   "
                        [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=day&reqdate=$previousReqDate' class='specialLink'>$langPreviousDay</a>] 
                        [<a href='".$_SERVER['PHP_SELF']."?tool=$encodedTool&period=day&reqdate=$nextReqDate' class='specialLink'>$langNextDay</a>]
                    ";
                    break;
            }
            
            echo"   &nbsp;&nbsp;&nbsp;||&nbsp;&nbsp;&nbsp;
                    [<a href='".$_SERVER['PHP_SELF']."' class='specialLink'>$langViewToolList</a>]
                    </small>
                    </td>
                </tr>
            ";
            // display information about this period
            switch($period)
            {
                // all days
                case "month" :
                    $sql = "SELECT UNIX_TIMESTAMP(`access_date`)
                            FROM `$TABLETRACK_ACCESS`
                            WHERE `access_tool` = '$tool' 
                                ".$courseCodeEqualcidIfNeeded."
                                AND MONTH(`access_date`) = MONTH(FROM_UNIXTIME('$reqdate'))
                                AND YEAR(`access_date`) = YEAR(FROM_UNIXTIME('$reqdate'))
                                ORDER BY `access_date` ASC";
                    
                    $days_array = daysTab($sql);
                    makeHitsTable($days_array,$langDay);
                    break;
                // all days
                case "week" :
                    $sql = "SELECT UNIX_TIMESTAMP(`access_date`)
                            FROM `$TABLETRACK_ACCESS`
                            WHERE `access_tool` = '$tool' 
                                ".$courseCodeEqualcidIfNeeded."
                                AND WEEK(`access_date`) = WEEK(FROM_UNIXTIME('$reqdate'))
                                AND YEAR(`access_date`) = YEAR(FROM_UNIXTIME('$reqdate'))
                                ORDER BY `access_date` ASC";
    
                    $days_array = daysTab($sql);
                    makeHitsTable($days_array,$langDay);
                    break;
                // all hours
                case "day"  :
                    $sql = "SELECT UNIX_TIMESTAMP(`access_date`)
                                FROM `$TABLETRACK_ACCESS`
                                WHERE `access_tool` = '$tool' 
                                    ".$courseCodeEqualcidIfNeeded."
                                    AND DAYOFYEAR(`access_date`) = DAYOFYEAR(FROM_UNIXTIME('$reqdate'))
                                    AND YEAR(`access_date`) = YEAR(FROM_UNIXTIME('$reqdate'))
                                ORDER BY `access_date` ASC";
                    
                    $hours_array = hoursTab($sql,$reqdate);
                    makeHitsTable($hours_array,$langHour);
                    break;
            }
        }
    }
    else // not allowed to track
    {
        if(!$is_trackingEnabled)
        {
            echo $langTrackingDisabled;
        }
        else
        {
            echo $langNotAllowed;
        }
    }
    
    
?>
</table>