<?php    // $Id: system_announcements.lib.php,v 1.16 2005/06/01 07:28:13 bmol Exp $  
/*
============================================================================== 
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) 2004 Bart Mollet (HoGent)
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
============================================================================== 
*/
define('VISIBLE_GUEST', 1);
define('VISIBLE_STUDENT', 2);
define('VISIBLE_TEACHER', 3);
/**
============================================================================== 
*	This is the system announcements library for Dokeos.
*
*	@package dokeos.library
============================================================================== 
*/
class SystemAnnouncementManager
{
	/** 
	 * Displays all announcements
	 * @author Bart Mollet <bart.mollet@hogent.be>
	 * @param int $visible VISIBLE_GUEST, VISIBLE_STUDENT or VISIBLE_TEACHER
	 * @param int $id The identifier of the announcement to display
	 */
	function display_announcements($visible, $id = -1)
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		$sql = "SELECT *, DATE_FORMAT(date_start,'%d/%m/%y (%H:%i)') AS display_date FROM ".$db_table." WHERE NOW() BETWEEN date_start AND date_end  ";
		switch ($visible)
		{
			case VISIBLE_GUEST :
				$sql .= " AND visible_guest = 'true'";
				break;
			case VISIBLE_STUDENT :
				$sql .= " AND visible_student = 'true'";
				break;
			case VISIBLE_TEACHER :
				$sql .= " AND visible_teacher = 'true'";
				break;
		}
		$sql .= " ORDER BY date_start DESC";
		$announcements = api_sql_query($sql,__FILE__,__LINE__);
		if (mysql_num_rows($announcements))
		{
			$query_string = ereg_replace('announcement=[1-9]+', '', $_SERVER['QUERY_STRING']);
			$query_string = ereg_replace('&$', '', $query_string);
			$url = $_SERVER['PHP_SELF'];
			echo '<div class="system_announcements">';
			echo '<h3>'.get_lang('SystemAnnouncements').'</h3>';
			echo '<ul>';
			while ($announcement = mysql_fetch_object($announcements))
			{
				echo '<li>';
				if ($id != $announcement->id)
				{
					if (strlen($query_string) > 0)
					{
						$show_url = $url.'?'.$query_string.'&announcement='.$announcement->id;
					}
					else
					{
						$show_url = $url.'?announcement='.$announcement->id;
					}
					echo '<div class="system_announcement"><div class="system_announcement_title"><a href="'.$show_url.'">'.$announcement->title.'</a></div></div>';
				}
				else
				{
					echo '<div class="system_announcement"><div class="system_announcement_title"><a href="'.$url.'?'.$query_string.'">'.$announcement->title.'</a></div><div class="system_announcement_content">'.$announcement->content.'</div>';
				}
				echo '</li>';
			}
			echo '</ul>';
			echo '</div>';
		}
		return;
	}
	/**
	 * Get all announcements
	 */
	function get_all_announcements()
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		$sql = "SELECT *, IF( NOW() BETWEEN date_start AND date_end, '1', '0') AS visible FROM ".$db_table." ORDER BY date_start ASC";
		$announcements = api_sql_query($sql,__FILE__,__LINE__);
		$all_announcements = array();
		while ($announcement = mysql_fetch_object($announcements))
		{
			$all_announcements[] = $announcement;
		}
		return $all_announcements;
	}
	/**
	 * Adds an announcement to the database
	 * @param string $title : title of the announcement
	 * @param string $content : content of the announcement
	 * @param array $date_start: start date of announcement (0 => day ; 1 => month ; 2 => year)
	 * @param array $date_end : end date of announcement (0 => day ; 1 => month ; 2 => year)
	 */
	function add_announcement($title, $content, $date_start, $date_end, $visible_teacher = 'false', $visible_student = 'false', $visible_guest = 'false')
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		if (!checkdate($date_start[1], $date_start[0], $date_start[2]))
		{
			Display :: display_normal_message(get_lang('InvalidStartDate'));
			return false;
		}
		if (!checkdate($date_end[1], $date_end[0], $date_end[2]))
		{
			Display :: display_normal_message(get_lang('InvalidEndDate'));
			return false;
		}
		if( strlen(trim($title)) == 0)
		{
			Display::display_normal_message(get_lang('InvalidTitle'));
			return false;	
		}
		$start = $date_start[2]."-".$date_start[1]."-".$date_start[0]." ".$date_start[3].":".$date_start[4].":00";
		$end = $date_end[2]."-".$date_end[1]."-".$date_end[0]." ".$date_end[3].":".$date_end[4].":00";
		$sql = "INSERT INTO ".$db_table." (`title`,`content`,`date_start`,`date_end`,`visible_teacher`,`visible_student`,`visible_guest`) 
												VALUES ('".$title."','".$content."','".$start."','".$end."','".$visible_teacher."','".$visible_student."','".$visible_guest."')";
		return api_sql_query($sql,__FILE__,__LINE__);
	}
	/**
	 * Updates an announcement to the database
	 * @param integer $id      : id of the announcement
	 * @param string  $title   : title of the announcement
	 * @param string  $content : content of the announcement
	 * @param array $date_start: start date of announcement (0 => day ; 1 => month ; 2 => year ; 3 => hour ; 4 => minute)
	 * @param array $date_end : end date of announcement (0 => day ; 1 => month ; 2 => year ; 3 => hour ; 4 => minute)
	 */
	function update_announcement($id, $title, $content, $date_start, $date_end, $visible_teacher = 'false', $visible_student = 'false', $visible_guest = 'false')
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		if (!checkdate($date_start[1], $date_start[0], $date_start[2]))
		{
			Display :: display_normal_message(get_lang('InvalidStartDate'));
			return false;
		}
		if (!checkdate($date_end[1], $date_end[0], $date_end[2]))
		{
			Display :: display_normal_message(get_lang('InvalidEndDate'));
			return false;
		}
		$start = $date_start[2]."-".$date_start[1]."-".$date_start[0]." ".$date_start[3].":".$date_start[4].":00";
		$end = $date_end[2]."-".$date_end[1]."-".$date_end[0]." ".$date_end[3].":".$date_end[4].":00";
		$sql = "UPDATE ".$db_table." SET title='".$title."',content='".$content."',date_start='".$start."',date_end='".$end."', ";
		$sql .= " visible_teacher = '".$visible_teacher."', visible_student = '".$visible_student."', visible_guest = '".$visible_guest."' WHERE id='".$id."'";
		return api_sql_query($sql,__FILE__,__LINE__);
	}
	/**
	 * Deletes an announcement
	 * @param string $id : the identifier of the announcement that should be deleted
	 */
	function delete_announcement($id)
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		$sql = "DELETE FROM ".$db_table." WHERE id='".$id."'";
		return api_sql_query($sql,__FILE__,__LINE__);
	}
	/**
	 * Gets an announcement
	 * @param string $id : the identifier of the announcement that should be deleted
	 */
	function get_announcement($id)
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		$sql = "SELECT *,UNIX_TIMESTAMP(date_start) AS dateS, UNIX_TIMESTAMP(date_end) AS dateE FROM ".$db_table." WHERE id='".$id."'";
		$announcement = mysql_fetch_object(api_sql_query($sql,__FILE__,__LINE__));
		$announcement->dateStart['d'] = date("j", $announcement->dateS);
		$announcement->dateStart['m'] = date("n", $announcement->dateS);
		$announcement->dateStart['y'] = date("Y", $announcement->dateS);
		$announcement->dateStart['h'] = date("G", $announcement->dateS);
		$announcement->dateStart['i'] = date("i", $announcement->dateS);
		$announcement->dateEnd['d'] = date("j", $announcement->dateE);
		$announcement->dateEnd['m'] = date("n", $announcement->dateE);
		$announcement->dateEnd['y'] = date("Y", $announcement->dateE);
		$announcement->dateEnd['h'] = date("G", $announcement->dateE);
		$announcement->dateEnd['i'] = date("i", $announcement->dateE);
		$announcement->dateS = $announcement->dateStart;
		$announcement->dateE = $announcement->dateEnd;
		return $announcement;
	}
	/** 
	 * Displays a form-element from which the user can choose a date. 
	 * @param string $name : the name of the form element. The result of a POST of the form will be an array:
	 * 						$name[0] = day
	 *						$name[1] = month
	 * 						$name[2] = year
	 *						$name[3] = hour
	 *						$name[4] = minute
	 */
	function display_date_form_element($name = "", $selected_date = array (0, 0, 0, 0, 0))
	{
		$month_names = array (1 => get_lang("JanuaryLong"), get_lang("FebruaryLong"), get_lang("MarchLong"), get_lang("AprilLong"), get_lang("MayLong"), get_lang("JuneLong"), get_lang("JulyLong"), get_lang("AugustLong"), get_lang("SeptemberLong"), get_lang("OctoberLong"), get_lang("NovemberLong"), get_lang("DecemberLong"));
		$selected_date[0] == 0 ? intval(date("j")) : $selected_date[0];
		$selected_date[2] == 0 ? date("Y") : $selected_date[2];
		echo "<select name=\"".$name."[]\">\n";
		for ($day = 1; $day <= 31; $day ++)
		{
			echo "<option value=\"". ($day < 10 ? "0".$day : $day)."\" ". ($day == $selected_date[0] ? "selected" : "").">".$day."</option>\n";
		}
		echo "</select>\n";
		echo "<select name=\"".$name."[]\">\n";
		for ($month = 1; $month <= 12; $month ++)
		{
			echo "<option value=\"". ($month < 10 ? "0".$month : $month)."\"". ($month == $selected_date[1] ? "selected" : "").">".$month_names[$month]."</option>\n";
		}
		echo "</select>\n";
		echo "<select name=\"".$name."[]\">\n";
		for ($year = date("Y") - 1; $year <= date("Y") + 2; $year ++)
		{
			echo "<option value=\"".$year."\"". ($year == $selected_date[2] ? "selected" : "").">".$year."</option>\n";
		}
		echo "</select>\n";
		echo '<span style="margin-left:50px;">&nbsp;</span>';
		echo "<select name=\"".$name."[]\">\n";
		for ($hour = 0; $hour <= 23; $hour ++)
		{
			echo "<option value=\"". ($hour < 10 ? "0".$hour : $hour)."\"". ($hour == $selected_date[3] ? "selected" : "").">".$hour."</option>\n";
		}
		echo "</select> \n";
		echo get_lang("HourMinuteDivider");
		echo " <select name=\"".$name."[]\">\n";
		for ($minute = 0; $minute < 60; $minute += 5)
		{
			echo "<option value=\"". ($minute < 10 ? "0".$minute : $minute)."\"". ($minute == $selected_date[4] ? "selected" : "").">".$minute."</option>\n";
		}
		echo "</select>\n";
		//echo get_lang('DateFormatLabel')."\n";
	}
	/**
	 * Change the visibility of an announcement
	 */
	function set_visibility($announcemnet_id, $user, $visible)
	{
		$db_table = Database :: get_main_table(MAIN_SYSTEM_ANNOUNCEMENTS_TABLE);
		$field = ($user == VISIBLE_TEACHER ? 'visible_teacher' : ($user == VISIBLE_STUDENT ? 'visible_student' : 'visible_guest'));
		$sql = "UPDATE ".$db_table." SET ".$field." = '".$visible."' WHERE id='".$announcemnet_id."'";
		return api_sql_query($sql,__FILE__,__LINE__);
	}
}
?>