<?php // $Id: display.lib.php,v 1.53.2.1 2005/08/19 14:12:28 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) Roan Embrechts, Vrije Universiteit Brussel
	Copyright (c) Wolfgang Schneider
	Copyright (c) Bert Vanderkimpen, Ghent University
	Copyright (c) Bart Mollet, Hogeschool Gent
	Copyright (c) Rene Haentjens, Ghent University
	Copyright (c) Yannick Warnier, Dokeos S.A.
	Copyright (c) Sandra Matthys, Hogeschool Gent
	Copyright (c) Denes Nagy, Dokeos S.A.

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	This is a display library for Dokeos.
*
*	Include/require it in your code to use its functionality.
*	There are also several display functions in the main api library.
*
*	All functions static functions inside a class called Display,
*	so you use them like this: e.g.
*	Display::display_normal_message($message)
*
*	@package dokeos.library
==============================================================================
*/
/*
==============================================================================
	   CONSTANTS
==============================================================================
*/
/** the light grey often used in Dokeos*/
define("DOKEOSLIGHTGREY", "#E6E6E6");
/** the orange often used in warning messages*/
define("DOKEOSORANGE", "#FFCC00");
/** plain white colour*/
define("HTML_WHITE", "white");
/*
==============================================================================
	   LIBRARIES
==============================================================================
*/
//no other libraries needed at the moment
/*
==============================================================================
		FUNCTIONS
==============================================================================
*/
//all functions are stored inside the Display class
/*
==============================================================================
		CLASS Display

		functions inside
		----------------
		Display::display_localised_html_file($full_file_name)
		Display::display_table_header()
		Display::display_complex_table_header($properties, $column_header)
		Display::display_table_row($bgcolor, $table_row, $is_alternating=true)
		Display::display_table_footer()
		Display::display_normal_message($message)
		Display::display_error_message($message)
		Display::encrypted_mailto_link($email, $clickable_text, $style_class='')
		Display::get_platform_home_link_html($name = '')
==============================================================================
*/
/**
*	Display class
*	contains several functions dealing with the display of
*	table data, messages, help topics, ...
*
*	@version 1.0.4
*	@package dokeos.library
*/
class Display
{
	/*
	*	Displays a localised html file
	*
	*	tries to show the file "$full_file_name"."_".$languageInterface.".html"
	*	and if this does not exist, shows the file "$full_file_name".".html"
	*
	*	warning this function defines a global
	*
	*	@param $full_file_name, the (path) name of the file, without .html
	*/
	function display_localised_html_file($full_file_name)
	{
		global $languageInterface;
		$localised_file_name = $full_file_name."_".$languageInterface.".html";
		$default_file_name = $full_file_name.".html";
		if (file_exists($localised_file_name))
		{
			include ($localised_file_name);
		}
		else
			include ($default_file_name); //default
	}

	/**
	*	Display simple html header of table.
	*/
	function display_table_header()
	{
		$bgcolor = "bgcolor='white'";
		echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"4\" width=\"85%\"><tbody>";
		return $bgcolor;
	}

	/**
	*	Display html header of table with several options.
	*
	*	@param $properties, array with elements, all of which have defaults
	*	"width" - the table width, e.g. "100%", default is 85%
	*	"class"	 - the class to use for the table, e.g. "class=\"data_table\""
	*   "cellpadding"  - the extra border in each cell, e.g. "8",default is 4
	*   "cellspacing"  - the extra space between cells, default = 0
	*
	*	@param column_header, array with the header elements.
	*	@author Roan Embrechts
	*	@version 1.01
	*/
	function display_complex_table_header($properties, $column_header)
	{
		$width = $properties["width"];
		if (!isset ($width))
			$width = "85%";
		$class = $properties["class"];
		if (!isset ($class))
			$class = "class=\"data_table\"";
		$cellpadding = $properties["cellpadding"];
		if (!isset ($cellpadding))
			$cellpadding = "4";
		$cellspacing = $properties["cellspacing"];
		if (!isset ($cellspacing))
			$cellspacing = "0";
		//... add more properties as you see fit
		//api_display_debug_info("Dokeos light grey is " . DOKEOSLIGHTGREY);
		$bgcolor = "bgcolor='".DOKEOSLIGHTGREY."'";
		echo "<table $class border=\"0\" cellspacing=\"$cellspacing\" cellpadding=\"$cellpadding\" width=\"$width\">\n";
		echo "<thead><tr $bgcolor>";
		foreach ($column_header as $table_element)
		{
			echo "<th>".$table_element."</th>";
		}
		echo "</tr></thead>\n";
		echo "<tbody>\n";
		$bgcolor = "bgcolor='".HTML_WHITE."'";
		return $bgcolor;
	}

	/**
	*	Displays a table row.
	*
	*	@param $bgcolor the background colour for the table
	*	@param $table_row an array with the row elements
	*	@param $is_alternating true: the row colours alternate, false otherwise
	*/
	function display_table_row($bgcolor, $table_row, $is_alternating = true)
	{
		echo "<tr $bgcolor>";
		foreach ($table_row as $table_element)
		{
			echo "<td>".$table_element."</td>";
		}
		echo "</tr>\n";
		if ($is_alternating)
		{
			if ($bgcolor == "bgcolor='".HTML_WHITE."'")
				$bgcolor = "bgcolor='".DOKEOSLIGHTGREY."'";
			else
				if ($bgcolor == "bgcolor='".DOKEOSLIGHTGREY."'")
					$bgcolor = "bgcolor='".HTML_WHITE."'";
		}
		return $bgcolor;
	}

	/**
	*	Displays a table row.
	*	This function has more options and is easier to extend than display_table_row()
	*
	*	@param $properties, array with properties:
	*	["bgcolor"] - the background colour for the table
	*	["is_alternating"] - true: the row colours alternate, false otherwise
	*	["align_row"] - an array with, per cell, left|center|right
	*	@todo add valign property
	*/
	function display_complex_table_row($properties, $table_row)
	{
		$bgcolor = $properties["bgcolor"];
		$is_alternating = $properties["is_alternating"];
		$align_row = $properties["align_row"];
		echo "<tr $bgcolor>";
		$number_cells = count($table_row);
		for ($i = 0; $i < $number_cells; $i ++)
		{
			$cell_data = $table_row[$i];
			$cell_align = $align_row[$i];
			echo "<td align=\"$cell_align\">".$cell_data."</td>";
		}
		echo "</tr>\n";
		if ($is_alternating)
		{
			if ($bgcolor == "bgcolor='".HTML_WHITE."'")
				$bgcolor = "bgcolor='".DOKEOSLIGHTGREY."'";
			else
				if ($bgcolor == "bgcolor='".DOKEOSLIGHTGREY."'")
					$bgcolor = "bgcolor='".HTML_WHITE."'";
		}
		return $bgcolor;
	}

	/**
	*	display html footer of table
	*/
	function display_table_footer()
	{
		echo "</tbody></table>";
	}

	/**
	 * Display a table
	 * @param array $header Titles for the table header
	 * 						each item in this array can contain 3 values
	 * 						- 1st element: the column title
	 * 						- 2nd element: true or false (column sortable?)
	 * 						- 3th element: additional attributes for
	 *  						th-tag (eg for column-width)
	 * 						- 4the element: additional attributes for the td-tags
	 * @param array $content 2D-array with the tables content
	 * @param array $sorting_options Keys are:
	 * 					'column' = The column to use as sort-key
	 * 					'direction' = SORT_ASC or SORT_DESC
	 * @param array $paging_options Keys are:
	 * 					'per_page_default' = items per page when switching from
	 * 										 full-	list to per-page-view
	 * 					'per_page' = number of items to show per page
	 * 					'page_nr' = The page to display
	 * @param array $query_vars Additional variables to add in the query-string
	 * @author bart.mollet@hogent.be
	 */
	function display_sortable_table($header, $content, $sorting_options = array (), $paging_options = array (), $query_vars = null)
	{
		global $origin;
		require_once ('tablesort.lib.php');
		if (!isset ($paging_options['per_page_default']))
		{
			$paging_options['per_page_default'] = 10;
		}
		if (!isset ($paging_options['page_nr']))
		{
			$paging_options['page_nr'] = (isset ($_GET['page_nr']) ? $_GET['page_nr'] : 1);
		}
		if (!isset ($paging_options['per_page']))
		{
			$paging_options['per_page'] = (isset ($_GET['per_page']) ? $_GET['per_page'] : $paging_options['per_page_default']);
		}
		if (!isset ($sorting_options['column']))
		{
			$sorting_options['column'] = (isset ($_GET['column']) ? $_GET['column'] : 0);
		}
		if (!isset ($sorting_options['direction']))
		{
			$sorting_options['direction'] = (isset ($_GET['direction']) ? $_GET['direction'] : SORT_ASC);
		}
		// Build the query_string
		if (is_array($query_vars))
		{
			foreach ($query_vars as $key => $value)
			{
				$query_string .= '&amp;'.urlencode($key).'='.urlencode($value);
			}
		}
		$content = TableSort :: sort_table($content, $sorting_options['column'], $sorting_options['direction']);
		// Get data for selected page
		$page_nav = '';
		$page_content = array ();
		$pages = array_chunk($content, intval($paging_options['per_page']));
		if( $paging_options['page_nr'] > count($pages))
		{
			$paging_options['page_nr'] = count($pages);
		}
		$page_content = $pages[$paging_options['page_nr'] - 1];
		// Build navigation bar
		if (count($pages) > 1)
		{
			$page_nav = get_lang('Page').' : ';
			if ($paging_options['page_nr'] > 1)
			{
				$page_nav .= '<a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$sorting_options['column'].'&amp;direction='.$sorting_options['direction'].'&amp;page_nr='. ($paging_options['page_nr'] - 1).'&amp;per_page='.$paging_options['per_page'].''.$query_string.'">&laquo;</a> ';
			}
			for ($i = $paging_options['page_nr'] - 3; $i < $paging_options['page_nr']; $i ++)
			{
				if ($i > 0)
				{
					$page_nav .= '<a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$sorting_options['column'].'&amp;direction='.$sorting_options['direction'].'&amp;page_nr='.$i.'&amp;per_page='.$paging_options['per_page'].''.$query_string.'">'.$i.'</a> ';
				}
			}
			if ($i == $paging_options['page_nr'])
			{
				$page_nav .= '<b>'.$i.'</b> ';
			}
			for ($i = $paging_options['page_nr'] + 1; $i < $paging_options['page_nr'] + 4; $i ++)
			{
				if ($i <= count($pages))
				{
					$page_nav .= '<a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$sorting_options['column'].'&amp;direction='.$sorting_options['direction'].'&amp;page_nr='.$i.'&amp;per_page='.$paging_options['per_page'].''.$query_string.'">'.$i.'</a> ';
				}
			}
			if ($paging_options['page_nr'] < count($pages))
			{
				$page_nav .= '<a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$sorting_options['column'].'&amp;direction='.$sorting_options['direction'].'&amp;page_nr='. ($paging_options['page_nr'] + 1).'&amp;per_page='.$paging_options['per_page'].''.$query_string.'">&raquo;</a> ';
			}
		}
		$view_switch = '';
		if (count($pages) == 1 && count($page_content) > $paging_options['per_page_default'])
		{
			$view_switch = ' <a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$sorting_options['column'].'&amp;direction='.$sorting_options['direction'].'&amp;page_nr=1&amp;per_page='.$paging_options['per_page_default'].''.$query_string.'">'.get_lang('Show').' '.$paging_options['per_page_default'].'</a>';
		}
		elseif (count($pages) > 1)
		{
			$view_switch = ' <a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$sorting_options['column'].'&amp;direction='.$sorting_options['direction'].'&amp;page_nr=1&amp;per_page='.count($content).''.$query_string.'">'.get_lang('ShowAll').'</a>';
		}
		$page_nav = '<table width="100%"><tr><td>'.$view_switch.'</td><td align="right">'.$page_nav.'</td></tr></table>';
		// Determine new direction
		$new_direction = ($sorting_options['direction'] == SORT_ASC ? SORT_DESC : SORT_ASC);
		echo "\n";
		echo $page_nav;
		// Show the table
		echo '<table class="data_table" width="100%">';
		echo "\n";
		echo '<tr>';
		foreach ($header as $key => $value)
		{
			echo '<th '.$value[2].'>';
			if ($value[1])
			{
				echo '<a href="'.$_SERVER['PHP_SELF'].'?origin='.$origin.'&amp;column='.$key.'&amp;direction='.$new_direction.'&amp;page_nr='.$paging_options['page_nr'].'&amp;per_page='.$paging_options['per_page'].''.$query_string.'">'.$value[0].'</a>';
				if ($sorting_options['column'] == $key)
				{
					echo $sorting_options['direction'] == SORT_ASC ? '&nbsp;&#8595; ' : '&nbsp;&#8593; ';
				}
			}
			else
			{
				echo $value[0];
			}
			echo '</th>';
		}
		echo '</tr>';
		echo "\n";
		if( is_array($page_content))
		{
			foreach ($page_content as $row => $data)
			{
				echo '<tr class="'. ($row % 2 == 0 ? 'row_even' : 'row_odd').'">';
				foreach( $data as $column => $value)
				{
					echo '<td '.(isset($header[$column][3])? $header[$column][3] : '' ).'>';
					echo $value;
					echo '</td>';
				}
				echo '</tr>';
				echo "\n";
			}
		}
		echo '</table>';
		echo $page_nav;
	}

	/**
	* Displays a normal message. It is recommended to use this function
	* to display any normal information messages.
	*
	* @author Roan Embrechts
	* @param string $message - include any additional html
	*                          tags if you need them
	* @return void
	*/
	function display_normal_message($message)
	{
		if(!headers_sent())
		{
?>

<style type="text/css" media="screen, projection">
/*<![CDATA[*/
@import "<?php echo api_get_path(WEB_CODE_PATH); ?>css/default.css";
/*]]>*/
</style>

<?php
		}
?>
		<div class="normal-message">
		<?php echo $message ?>
		</div>

<?php
	}

	/**
	* Displays a message. It is recommended to use this function
	* to display any confirmation or error messages.
	*
	* @author Hugues Peeters
	* @author Roan Embrechts
	* @param string $message - include any additional html
	*                          tags if you need them
	* @return void
	*/
	function display_error_message($message)
	{
		if(!headers_sent())
		{
?>

<style type="text/css" media="screen, projection">
/*<![CDATA[*/
@import "<?php echo api_get_path(WEB_CODE_PATH); ?>css/default.css";
/*]]>*/
</style>

<?php
		}
?>
		<div class="error-message">
			<?php echo $message ?>
		</div>
		<?php

	}

	function display_nice_header($title)
	{
?>
		<br>
		<table cellspacing="0" border="0" cellpadding="4" bgcolor="#E6E6E6" width="100%">
			<tr><td align="left" width="24" colspan="1" bgcolor="#E6E6E6" height="24" valign="middle" rowspan="1">
				<b><font size="3" face="Arial, Helvetica, sans-serif">
				<?php echo $title; ?>
				</font></b>
			</td></tr>
		</table>
		<br>
		<?php

	}

	/**
	 * Return an encrypted mailto hyperlink
	 *
	 * @param - $email (string) - e-mail
	 * @param - $text (string) - clickable text
	 * @param - $style_class (string) - optional, class from stylesheet
	 * @return - encrypted mailto hyperlink
	 */
	//echo(encrypted_mailto_link("me@privacy.net","mail me!","fancystyle"));
	function encrypted_mailto_link($email, $clickable_text = null, $style_class = '')
	{
		if( is_null($clickable_text))
		{
			$clickable_text = $email;
		}
		//mailto already present?
		if (substr($email, 0, 7) != 'mailto:')
			$email = 'mailto:'.$email;

		//class (stylesheet) defined?
		if ($style_class != '')
			$style_class = ' class="'.$style_class.'"';

		//encrypt email
		$hmail = '';
		for ($i = 0; $i < strlen($email); $i ++)
			$hmail .= '&#'.ord($email {
			$i }).';';

		//encrypt clickable text if @ is present
		if (strpos($clickable_text, '@'))
		{
			for ($i = 0; $i < strlen($clickable_text); $i ++)
				$hclickable_text .= '&#'.ord($clickable_text {
				$i }).';';
		}
		else
		{
			$hclickable_text = htmlspecialchars($clickable_text);
		}

		//return encrypted mailto hyperlink
		return '<a href="'.$hmail.'"'.$style_class.'>'.$hclickable_text.'</a>';
	}

	/**
	*	Create a hyperlink to the platform homepage.
	*	@param string $name, the visible name of the hyperlink, default is sitename
	*	@return string with html code for hyperlink
	*/
	function get_platform_home_link_html($name = '')
	{
		if ($name == '')
			$name = get_setting('siteName');
		return "<a href=\"".api_get_path(WEB_PATH)."index.php\">$name</a>";
	}

	function display_header($tool_name,$help = NULL)
	{
		$nameTools = $tool_name;
		global $httpHeadXtra, $htmlHeadXtra, $_course, $_user, $clarolineRepositoryWeb, $text_dir, $plugins, $_uid, $rootAdminWeb, $_cid, $shortBanner, $interbredcrump, $charset, $langFile, $noPHP_SELF;
		include(api_get_include_path()."/claro_init_header.inc.php");
	}

	function display_footer()
	{
		global $platformVersion; //necessary to have the value accessible in the footer
		include(api_get_include_path()."/claro_init_footer.inc.php");
	}

	/**
	 * Print an <option>-list with all letters (A-Z).
	 * @param char $selected_letter The letter that should be selected
	 */
	function get_alphabet_options($selected_letter = '')
	{
		$result = '';
		for ($i = 65; $i <= 90; $i ++)
		{
			$letter = chr($i);
			$result .= '<option value="'.$letter.'"';
			if ($selected_letter == $letter)
			{
				$result .=  ' selected="selected"';
			}
			$result .=  '>'.$letter.'</option>';
		}
		return $result;
	}

} //end class Display
?>