<?php
/**
============================================================================== 
 * The INTRODUCTION MICRO MODULE is used to insert and edit
 * an introduction section on a Claroline Module.
 * It can be inserted on any Claroline Module, provided a connection
 * to a course Database is already active.
 *
 * The introduction content are stored on a table called "introduction"
 * in the course Database. Each module introduction has an Id stored on
 * the table. It is this id that can make correspondance to a specific module.
 *
 * 'introduction' table description
 *   id : int
 *   intro_text :text
 *
 *
 * usage :
 *
 * $moduleId = XX // specifying the module Id
 * include(moduleIntro.inc.php);
*
*	@package dokeos.include
============================================================================== 
*/


include_once(api_get_library_path().'/text.lib.php');

/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/
$TBL_INTRODUCTION = Database::get_course_tool_intro_table();
$intro_editAllowed = $is_allowed_to_edit;

$intro_cmdEdit = $_GET['intro_cmdEdit'];
$intro_content = $_POST['intro_content'];
$intro_cmdUpdate = $_POST['intro_cmdUpdate'];
$intro_cmdDel= $_GET['intro_cmdDel'];
$intro_cmdAdd= $_GET['intro_cmdAdd'];

/*=========================================================
  INTRODUCTION MICRO MODULE - COMMANDS SECTION (IF ALLOWED)
  ========================================================*/

if ($intro_editAllowed)
{
	/* Replace command */

	if( $intro_cmdUpdate )
	{
		$intro_content = trim($intro_content);

		if ( ! empty($intro_content) )
		{
			api_sql_query("REPLACE $TBL_INTRODUCTION SET id='$moduleId',intro_text='$intro_content'",__FILE__,__LINE__);
		}
		else
		{
			$intro_cmdDel = true;	// got to the delete command
		}
	}

	/* Delete Command */

	if($intro_cmdDel)
	{
		api_sql_query("DELETE FROM $TBL_INTRODUCTION WHERE id='".$moduleId."'",__FILE__,__LINE__);
	}
}

/*===========================================
  INTRODUCTION MICRO MODULE - DISPLAY SECTION
  ===========================================*/

/* Retrieves the module introduction text, if exist */

$sql = "SELECT intro_text FROM $TBL_INTRODUCTION WHERE id='".$moduleId."'";
$intro_dbQuery = api_sql_query($sql,__FILE__,__LINE__);
$intro_dbResult = mysql_fetch_array($intro_dbQuery);
$intro_content = $intro_dbResult['intro_text'];

/* Determines the correct display */

if ($intro_cmdEdit || $intro_cmdAdd)
{
	$intro_dispDefault = false;
	$intro_dispForm = true;
	$intro_dispCommand = false;
}
else
{
	$intro_dispDefault = true;
	$intro_dispForm = false;

	if ($intro_editAllowed)
	{
		$intro_dispCommand = true;
	}
	else
	{
		$intro_dispCommand = false;
	}
}


/* Executes the display */

if ($intro_dispForm)
{
	echo "<div id=\"courseintro\">";
	echo	"<form action=\"".$_SERVER['PHP_SELF']."\" method=\"POST\" style=\"margin:0px;\">\n";
	echo	"<table border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\"><tr><td>";

    api_disp_html_area('intro_content',$intro_content,'250px');

	echo	"</td></tr><tr><td>"
			."<input type=\"submit\" value=\"".get_lang('Ok')."\" name=\"intro_cmdUpdate\">\n"
			."</td></tr></table>"
			."</form>\n</div>";
}

if ($intro_dispDefault)
{
	//$intro_content = nl2br(($intro_content));
	$intro_content = make_clickable($intro_content); // make url in text clickable
	$intro_content = api_parse_tex($intro_content); // parse [tex] codes

	if (!empty($intro_content))
	{
		echo	"<div id=\"courseintro\"><p>\n",
				$intro_content,"\n",
				"</p>\n</div>";
	}
}

if ($intro_dispCommand)
{
	if( empty($intro_content) ) // displays "Add intro" Commands
	{
		echo	"<div id=\"courseintro\"><p>\n",
				"<a href=\"".$_SERVER['PHP_SELF']."?intro_cmdAdd=1\">\n",get_lang('AddIntro'),"</a>\n",
				"</p>\n</div>";
	}
	else // displays "edit intro && delete intro" Commands
	{
		echo	"<div id=\"courseintro_icons\"><p>\n",
				"<a href=\"".$_SERVER['PHP_SELF']."?intro_cmdEdit=1\"><img src=\"" . api_get_code_web_path() . "img/edit.gif\" alt=\"",get_lang('Modify'),"\" border=\"0\" /></a>\n",
				"<a href=\"".$_SERVER['PHP_SELF']."?intro_cmdDel=1\" onclick=\"javascript:if(!confirm('".addslashes(htmlspecialchars(get_lang('ConfirmYourChoice')))."')) return false;\"><img src=\"" . api_get_code_web_path() . "img/delete.gif\" alt=\"",get_lang('Delete'),"\" border=\"0\" /></a>\n",
				"</p>\n</div>";
	}
}
?>
