<?php // $Id: claro_init_global.inc.php,v 1.67.2.1 2005/08/19 14:38:44 bmol Exp $
/**
==============================================================================
* It is recommended that ALL dokeos scripts include this important file.
* This script manages
* - http get, post, post_files, session, server-vars extraction into global namespace;
*   (which doesn't occur anymore when servertype config setting is set to test,
*    and which will disappear completely in Dokeos 1.6.1)
* - include of /conf/claro_main.conf.php and /lib/main_api.lib.php;
* - selecting the main database;
* - include of language files.
*
* @package dokeos.include
==============================================================================
*/

// Determine the directory path where this current file lies
// This path will be useful to include the other intialisation files

function get_path_info()
{

           $pos = strpos($_SERVER['HTTP_HOST'],'/');
           $domain_string = substr($_SERVER['HTTP_HOST'], 0, $pos);
           $domain_string =   $domain_string.$_SERVER['REQUEST_URI'];

    return trim($domain_string);

}
$includePath = dirname(__FILE__);
// include the main Dokeos platform configuration file
$main_configuration_file_path = $includePath."/conf/claro_main.conf.php";
$already_installed = false;
if (file_exists($main_configuration_file_path)) {
	require_once($main_configuration_file_path);
	$already_installed = true;
}
// include the main Dokeos platform library file
require_once($includePath.'/lib/main_api.lib.php');

// Include the database and display libraries
require_once(api_get_library_path().'/database.lib.php');
require_once(api_get_library_path().'/display.lib.php');

// Start session
api_session_start($already_installed);

$error_message = "<center>"
	   ."<br><br><form action=\"claroline/install/index.php\" method=\"get\"><input type=\"submit\" value=\"&nbsp;&nbsp;Click to INSTALL DOKEOS&nbsp;&nbsp;\"></form> "
	   ."<br>or <a target=\"_new\" href=\"installation_guide.html\" target=\"_blank\">read the installation guide</a>"
	   ."</center></body></html>";

if (! $already_installed) die($error_message);

if(empty($statsDbName) && $already_installed)
{
	$statsDbName=$mainDbName;
}

// connect to the server database and select the main claroline DB

$dokeos_database_connection = @mysql_connect($dbHost, $dbLogin, $dbPass) or die ($error_message);

if (! $dbHost) die($error_message);

unset($error_message);

$selectResult = mysql_select_db($mainDbName,$dokeos_database_connection)

or die ( "<center>"
		."WARNING ! SYSTEM UNABLE TO SELECT THE MAIN DOKEOS DATABASE"
		."</center>");

mysql_query("SET NAMES 'utf8'", $dokeos_database_connection);
mysql_query("SET CHARACTER SET 'utf8'", $dokeos_database_connection);
// include the local (contextual) parameters of this course or section

require($includePath."/claro_init_local.inc.php");

// ===== "who is logged in?" module section =====

include_once($includePath."/lib/online.inc.php");
// check and modify the date of user in the track.e.online table
if (!$x=strpos($_SERVER['PHP_SELF'],'whoisonline.php')) { LoginCheck(isset($_uid) ? $_uid : '',$statsDbName); }

// ===== end "who is logged in?" module section =====

/*
--------------------------------------------
  RETRIEVING ALL THE DOKEOS CONFIG SETTINGS
--------------------------------------------
*/

$sql="SELECT * FROM settings_current";
$result=mysql_query($sql) or die(mysql_error());
while ($row=mysql_fetch_array($result))
{
	if ($row['subkey']==NULL)
		{ $_setting[$row['variable']]=$row['selected_value']; }
	else
		{ $_setting[$row['variable']][$row['subkey']]=$row['selected_value']; }
}


if(get_setting('server_type') == 'test')
{
	/*
	--------------------------------------------
	Server type is test
	- high error reporting level
	- only do addslashes on $_GET and $_POST
	--------------------------------------------
	*/
	error_reporting(E_ALL & ~E_NOTICE);
	//error_reporting(E_ALL);

	//Addslashes to all $_GET variables
	foreach($_GET as $key=>$val)
	{
		if(!ini_get('magic_quotes_gpc'))
		{
			if(is_string($val))
			{
				$_GET[$key]=addslashes($val);
			}
		}
	}

	//Addslashes to all $_POST variables
	foreach($_POST as $key=>$val)
	{
		if(!ini_get('magic_quotes_gpc'))
		{
			if(is_string($val))
			{
				$_POST[$key]=addslashes($val);
			}
		}
	}
}
else
{
	/*
	--------------------------------------------
	Server type is not test
	- normal error reporting level
	- full fake register globals block
	--------------------------------------------
	*/
	error_reporting(E_COMPILE_ERROR | E_ERROR | E_CORE_ERROR);

	if(!isset($HTTP_GET_VARS)) { $HTTP_GET_VARS=$_GET; }
	if(!isset($HTTP_POST_VARS)) { $HTTP_POST_VARS=$_POST; }
	if(!isset($HTTP_POST_FILES)) { $HTTP_POST_FILES=$_FILES; }
	if(!isset($HTTP_SESSION_VARS)) { $HTTP_SESSION_VARS=$_SESSION; }
	if(!isset($HTTP_SERVER_VARS)) { $HTTP_SERVER_VARS=$_SERVER; }

	// Register GET variables into $GLOBALS
	if(sizeof($HTTP_GET_VARS))
	{
		$_GET=array();

		foreach($HTTP_GET_VARS as $key=>$val)
		{
			if(!ini_get('magic_quotes_gpc'))
			{
				if(is_string($val))
				{
					$HTTP_GET_VARS[$key]=addslashes($val);
				}
			}

			$_GET[$key]=$HTTP_GET_VARS[$key];

			if(!isset($_SESSION[$key]) && $key != 'includePath')
			{
				$GLOBALS[$key]=$HTTP_GET_VARS[$key];
			}
		}
	}

	// Register POST variables into $GLOBALS
	if(sizeof($HTTP_POST_VARS))
	{
		$_POST=array();

		foreach($HTTP_POST_VARS as $key=>$val)
		{
			if(!ini_get('magic_quotes_gpc'))
			{
				if(is_string($val))
				{
					$HTTP_POST_VARS[$key]=addslashes($val);
				}
			}

			$_POST[$key]=$HTTP_POST_VARS[$key];

			if(!isset($_SESSION[$key]) && $key != 'includePath')
			{
				$GLOBALS[$key]=$HTTP_POST_VARS[$key];
			}
		}
	}

	if(sizeof($HTTP_POST_FILES))
	{
		$_FILES=array();

		foreach($HTTP_POST_FILES as $key=>$val)
		{
			$_FILES[$key]=$HTTP_POST_FILES[$key];

			if(!isset($_SESSION[$key]) && $key != 'includePath')
			{
				$GLOBALS[$key]=$HTTP_POST_FILES[$key];
			}
		}
	}

	// Register SESSION variables into $GLOBALS
	if(sizeof($HTTP_SESSION_VARS))
	{
		if(!is_array($_SESSION))
		{
			$_SESSION=array();
		}

		foreach($HTTP_SESSION_VARS as $key=>$val)
		{
			$_SESSION[$key]=$HTTP_SESSION_VARS[$key];
			$GLOBALS[$key]=$HTTP_SESSION_VARS[$key];
		}
	}

	// Register SERVER variables into $GLOBALS
	if(sizeof($HTTP_SERVER_VARS))
	{
		$_SERVER=array();
		foreach($HTTP_SERVER_VARS as $key=>$val)
		{
			$_SERVER[$key]=$HTTP_SERVER_VARS[$key];

			if(!isset($_SESSION[$key]) && $key != 'includePath')
			{
				$GLOBALS[$key]=$HTTP_SERVER_VARS[$key];
			}
		}
	}
}



/*
-----------------------------------------------------------
	LOAD LANGUAGE FILES SECTION
-----------------------------------------------------------
*/

// if we use the javascript version (without go button) we receive a get
// if we use the non-javascript version (with the go button) we receive a post
$user_language = $_GET["language"];
if ($_POST["language_list"]) {
	$user_language = str_replace("index.php?language=","",$_POST["language_list"]);
}

// Checking if we have a valid language. If not we set it to the platform language. 
$valid_languages=api_get_languages();

if (!in_array($user_language,$valid_languages['folder'])) {
	if (!in_array($_SESSION["user_language_choice"], $valid_languages['folder'])) {
		$user_language = get_setting('platformLanguage');
	} else {
		$user_language = $_SESSION["user_language_choice"];
	}
}
if (isset($user_language)) {
	$user_selected_language = $user_language; // $_GET["language"];
	$_SESSION["user_language_choice"] = $user_selected_language;
	$platformLanguage = $user_selected_language;
}

if (isset($_SESSION["user_language_choice"])) {
	$languageInterface = $_SESSION["user_language_choice"];
} else {
	$languageInterface = get_setting('platformLanguage');
}

if ($_course['language']) {
	$languageInterface = $_course['language'];
}


/*
 * Include all necessary language files
 * - trad4all
 * - notification
 * - custom tool language files
 */
$language_files = array();
$language_files[] = 'trad4all';
$language_files[] = 'notification';
if( isset($langFile) ) {
	if( !is_array($langFile)) {
		$language_files[] = $langFile;
	} else {
		$language_files = array_merge($language_files,$langFile);
	}
}
// Include all files (first english and then current interface language)
foreach($language_files as $index => $language_file) {
	include($includePath.'/../lang/english/'.$language_file.'.inc.php');
	include($includePath.'/../lang/'.$languageInterface.'/'.$language_file.'.inc.php');
}
?>