<?php
// $Id: group_edit.php,v 1.44 2005/05/11 10:41:39 bmol Exp $
/*
============================================================================== 
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors
	Copyright (c) Bart Mollet
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
============================================================================== 
*/
/**
============================================================================== 
*	This script displays an area where teachers can edit the group properties and member list.
*	Groups are also often called "teams" in the Dokeos code.
*
*	@author various contributors
*	@author Roan Embrechts (VUB), partial code cleanup, initial virtual course support
*	@author Bart Mollet (HoGent), code cleanup, use GroupManager
*	@package dokeos.group
*	@todo course admin functionality to create groups based on who is in which course (or class).
*	@todo move group-speficic functions into a group library
============================================================================== 
*/
/*
============================================================================== 
		INIT SECTION
============================================================================== 
*/
$langFile = "group";
include ('../inc/claro_init_global.inc.php');
/*
-----------------------------------------------------------
	Libraries & settings
-----------------------------------------------------------
*/
include_once (api_get_library_path()."/course.lib.php");
include_once (api_get_library_path()."/groupmanager.lib.php");
/*
-----------------------------------------------------------
	Constants & variables
-----------------------------------------------------------
*/
$current_group = GroupManager :: get_group_properties($_SESSION['_gid']);
/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/
$nameTools = get_lang('EditGroup');
$interbredcrump[] = array ("url" => "group.php", "name" => get_lang('GroupManagement'));
//add javascript to header in a clean way: 
$htmlHeadXtra[] = '
<script type="text/javascript" language="JavaScript">
 <!-- Begin javascript menu swapper
 function move(fbox, tbox) {
  var arrFbox = new Array();
  var arrTbox = new Array();
  var arrLookup = new Array();
  var i;
  for (i = 0; i < tbox.options.length; i++) 
  {
   arrLookup[tbox.options[i].text] = tbox.options[i].value;
   arrTbox[i] = tbox.options[i].text;
  }
  var fLength = 0;
  var tLength = arrTbox.length;
  for(i = 0; i < fbox.options.length; i++) 
  {
   arrLookup[fbox.options[i].text] = fbox.options[i].value;
   if (fbox.options[i].selected && fbox.options[i].value != "") 
   {
    arrTbox[tLength] = fbox.options[i].text;
    tLength++;
   }
   else
   {
    arrFbox[fLength] = fbox.options[i].text;
    fLength++;
   }
  }
  arrFbox.sort();
  arrTbox.sort();
  fbox.length = 0;
  tbox.length = 0;
  var c;
  for(c = 0; c < arrFbox.length; c++) 
  {
   var no = new Option();
   no.value = arrLookup[arrFbox[c]];
   no.text = arrFbox[c];
   fbox[c] = no;
  }
  for(c = 0; c < arrTbox.length; c++) 
  {
   var no = new Option();
   no.value = arrLookup[arrTbox[c]];
   no.text = arrTbox[c];
   tbox[c] = no;
  }
}
 function selectAll(cbList,bSelect) {
  for (var i=0; i<cbList.length; i++){
    cbList[i].selected = cbList[i].checked = bSelect
  }
 }
 function reverseAll(cbList) {
  for (var i=0; i<cbList.length; i++) {
    cbList[i].checked = !(cbList[i].checked)
    cbList[i].selected = !(cbList[i].selected)
  }
 }
 //  End -->
</script>
';
unset($message);
if (isset ($_POST['action']))
{
	if ($_POST['action'] == 'save_settings')
	{
		if ($_POST['max_member_no_limit'] == MEMBER_PER_GROUP_NO_LIMIT)
		{
			$max_member = MEMBER_PER_GROUP_NO_LIMIT;
		}
		else
		{
			$max_member = $_POST['max_member'];
		}
		if(strlen($_POST['name']) == 0)
		{
			$message = get_lang('NoTitleGiven');
		}
		elseif( ! is_numeric($max_member))
		{
			$message = get_lang('InvalidMaxNumberOfMembers');
		}
		elseif ($max_member < count($_POST['group_members']) && $max_member != MEMBER_PER_GROUP_NO_LIMIT)
		{
			$message = get_lang('GroupTooMuchMembers');
		}
		else
		{
			$self_registration_allowed = isset ($_POST['self_registration_allowed']) ? 1 : 0;
			$self_unregistration_allowed = isset ($_POST['self_unregistration_allowed']) ? 1 : 0;
			GroupManager :: set_group_properties($current_group['id'], strip_tags($_POST['name']), strip_tags($_POST['description']), $_POST['tutor_id'], $max_member, $_POST['forum_id'], $_POST['forum_state'], $_POST['doc_state'], $self_registration_allowed, $self_unregistration_allowed);


			// custom code added for the wiki settings
			$table_group = Database :: get_course_table(GROUP_TABLE);
            // check if the wiki_state field already exists
            if (mysql_query("SELECT wiki_state FROM $table_group") == FALSE)
            {
                mysql_query("ALTER TABLE $table_group ADD `wiki_state` enum('0','1','2') NOT NULL default '1';");
            }

			$sql="UPDATE $table_group SET wiki_state='".$_POST['wiki_state']."' WHERE id ='".$current_group['id']."'";
			$result=api_sql_query($sql); 


			GroupManager :: unsubscribe_all_users($current_group['id']);
			if (isset ($_POST['group_members']) && count($_POST['group_members']) > 0)
			{
				GroupManager :: subscribe_users($_POST['group_members'], $current_group['id']);
			}
			$cat = GroupManager :: get_category_from_group($current_group['id']);
			header('Location: '.$_POST['referer'].'?action=show_msg&msg='.get_lang('GroupSettingsModified').'&category='.$cat['id']);
		}
		$current_group = GroupManager :: get_group_properties($current_group['id']);
	}
}
Display::display_header($nameTools,"Group");
api_display_tool_title($nameTools);
if (!api_is_allowed_to_edit())
{
	api_not_allowed();
}
if( isset($message))
{
	Display::display_normal_message($message);
}
/*
============================================================================== 
		FUNCTIONS
============================================================================== 
*/
function display_user_select_list($complete_user_list, $select_name)
{
	echo '<select name="'.$select_name.'" size="10" multiple="multiple" style="width:200px;">';
	foreach ($complete_user_list as $this_user)
	{
		$full_name = $this_user['full_name'];
		echo '<option value="'.$this_user['user_id'].'">'.$this_user["lastname"].' '.$this_user["firstname"].'</option>';
	}
	echo '</select>';
}
/*
============================================================================== 
		MAIN CODE
============================================================================== 
*/
/*
-----------------------------------------------------------
	Display form with 
	- options concerning this group
	- list of users that can be added to the group
	- list of users already in the group
-----------------------------------------------------------

*/
$referer = parse_url($_SERVER['HTTP_REFERER']);
$referer = basename($referer['path']);
if ($referer != 'group_space.php' && $referer != 'group.php')
{
	$referer = 'group.php';
}
?>
<a href="group_space.php"><?php  echo get_lang('GroupSpace') ?></a>
<br/>
<br/>
<form name="groupedit" method="post" action="<?php  echo $_SERVER['PHP_SELF']; ?>">
 <input type="hidden" name="action" value="save_settings"/>
 <input type="hidden" name="referer" value="<?php echo $referer ?>"/>
 <input type="hidden" name="forum_id" value="<?php  echo $current_group['forum_id']; ?>"/>
 <table>
  <tr>
   <td valign="top"><?php  echo get_lang('GroupName'); ?></td>
   <td>
    <input type="text" name="name" size="40" value="<?php  echo htmlspecialchars($current_group['name']); ?>"/>
   </td>
  </tr>
 <tr>
  
 <td valign="top"><?php  echo get_lang('GroupDescription'); ?>&nbsp;<?php  echo get_lang('Optional'); ?>
 </td>
 <td>
  <textarea name="description" rows="3" cols="70"><?php  echo $current_group['description']; ?></textarea>
 </td>
 </tr>
 <tr><td colspan="2"><hr noshade="noshade" size="1"/></td></tr>
  <tr>
   <td valign="top"><?php  echo get_lang('GroupTutor') ?></td>
   <td>
    <select name="tutor_id">
<?php

$tutors = GroupManager :: get_all_tutors();
echo '<option value="0">'.get_lang('GroupNoTutor').'</option>';
foreach ($tutors as $index => $tutor)
{
	echo '<option value="'.$tutor['user_id'].'" '. ($current_group['tutor_id'] == $tutor['user_id'] ? ' selected="selected" ' : '').'>'.$tutor['lastname'].' '.$tutor['firstname'].'</option>';
}
?>
  </select>
  &nbsp;&nbsp;
  <a href="../user/user.php"><?php  echo get_lang('AddTutors') ?></a>
 </td>
 </tr>
 <tr><td valign="top"><?php  echo get_lang('GroupLimit') ?></td>
 <td>
<input type="radio" class="checkbox" id="max_member_no_limit"  name="max_member_no_limit" value="<?php echo MEMBER_PER_GROUP_NO_LIMIT; ?>" <?php echo ($current_group['maximum_number_of_students'] == MEMBER_PER_GROUP_NO_LIMIT ? ' checked="checked" ' : '') ?> /> <label for="max_member_no_limit"><?php echo get_lang('NoLimit') ?></label>
<br/>
<input type="radio" class="checkbox" id="max_member_limit" name="max_member_no_limit" <?php echo ($current_group['maximum_number_of_students'] != MEMBER_PER_GROUP_NO_LIMIT ? ' checked="checked" ' : '') ?>/>

  	<?php

echo '<label for="max_member_limit">'.get_lang('Max').'</label>';
echo ' <input type="text" name="max_member" size="2" value="'. ($current_group['maximum_number_of_students'] == MEMBER_PER_GROUP_NO_LIMIT ? '' : $current_group['maximum_number_of_students']).'" maxlength="3"/> ';
echo '<label for="max_member_limit">'.get_lang('GroupPlacesThis').'</label>';
?>
 </td>
 </tr>
 <tr>
 <td valign="top"><?php echo get_lang("GroupSelfRegistration") ?></td>
 <td>
  <?php

echo '<input class="checkbox" type="checkbox"  id="self_registration_allowed"  name="self_registration_allowed" value="1" '. ($current_group['self_registration_allowed'] ? 'checked="checked"' : '').'/>';
echo ' <label for="self_registration_allowed">'.get_lang('GroupAllowStudentRegistration').'</label>';
echo '<br/>';
echo '<input class="checkbox" type="checkbox"  id="self_unregistration_allowed"  name="self_unregistration_allowed" value="1" '. ($current_group['self_unregistration_allowed'] ? 'checked="checked"' : '').'/>';
echo ' <label for="self_unregistration_allowed">'.get_lang('GroupAllowStudentUnregistration').'</label>';
?>
  </td>
  </tr>
  <tr>
  <td valign="top">
  <?php echo get_lang('GroupForum'); ?>
  </td>
  <td>
  <input type="radio" id="forum_state1" class="checkbox" name="forum_state" value="<?php echo TOOL_NOT_AVAILABLE ?>" <?php echo $current_group['forum_state'] == TOOL_NOT_AVAILABLE ? 'checked="checked"' : '' ?>/> <label for="forum_state1"><?php echo get_lang('NotAvailable') ?></label><br/>
  <input type="radio" id="forum_state2"  class="checkbox" name="forum_state" value="<?php echo TOOL_PUBLIC ?>" <?php echo $current_group['forum_state'] == TOOL_PUBLIC ? 'checked="checked"' : '' ?>/> <label for="forum_state2"><?php echo get_lang('Public') ?></label><br/>
  <input type="radio" id="forum_state3"  class="checkbox" name="forum_state" value="<?php echo TOOL_PRIVATE ?>" <?php echo $current_group['forum_state'] == TOOL_PRIVATE ? 'checked="checked"' : '' ?>/> <label for="forum_state3"><?php echo get_lang('Private') ?></label><br/>

  </td>
  </tr>
    <tr>
  <td valign="top">
  <?php echo get_lang('Documents'); ?>
  </td>
  <td>
  <input type="radio" id="doc_state1" class="checkbox" name="doc_state" value="<?php echo TOOL_NOT_AVAILABLE ?>" <?php echo $current_group['doc_state'] == TOOL_NOT_AVAILABLE ? 'checked="checked"' : '' ?>/> <label for="doc_state1"><?php echo get_lang('NotAvailable') ?></label><br/>
  <input type="radio" id="doc_state2"  class="checkbox" name="doc_state" value="<?php echo TOOL_PUBLIC ?>" <?php echo $current_group['doc_state'] == TOOL_PUBLIC ? 'checked="checked"' : '' ?>/> <label for="doc_state2"><?php echo get_lang('Public') ?></label><br/>
  <input type="radio" id="doc_state3"  class="checkbox" name="doc_state" value="<?php echo TOOL_PRIVATE ?>" <?php echo $current_group['doc_state'] == TOOL_PRIVATE ? 'checked="checked"' : '' ?>/> <label for="doc_state3"><?php echo get_lang('Private') ?></label><br/>

  </td>
  </tr>
  <tr>
  <td valign="top">
  <?php echo get_lang('Wiki'); ?>
  </td>
  <td>
  <input type="radio" id="wiki_state1" class="checkbox" name="wiki_state" value="<?php echo TOOL_NOT_AVAILABLE ?>" <?php echo $current_group['wiki_state'] == TOOL_NOT_AVAILABLE ? 'checked="checked"' : '' ?>/> <label for="forum_state1"><?php echo get_lang('NotAvailable') ?></label><br/>
  <input type="radio" id="wiki_state2"  class="checkbox" name="wiki_state" value="<?php echo TOOL_PUBLIC ?>" <?php echo $current_group['wiki_state'] == TOOL_PUBLIC ? 'checked="checked"' : '' ?>/> <label for="forum_state2"><?php echo get_lang('Public') ?></label><br/>
  <input type="radio" id="wiki_state3"  class="checkbox" name="wiki_state" value="<?php echo TOOL_PRIVATE ?>" <?php echo $current_group['wiki_state'] == TOOL_PRIVATE ? 'checked="checked"' : '' ?>/> <label for="forum_state3"><?php echo get_lang('Private') ?></label><br/>

  </td>
  </tr>
  <tr><td colspan="2"><hr noshade="noshade" size="1"/></td></tr>
 <tr>
 <td valign="top"><?php  echo get_lang("GroupMembers") ?></td>
 <td>
 <table>
  <tr>
   <td>
    <?php echo get_lang('StudentsNotInThisGroups')  ?>
   </td>
   <td>&nbsp; 
    
   </td>
   <td>
    <?php  echo get_lang('GroupMembers') ?>
   </td>
  </tr>
  <tr>
   <td align="center">
   <?php

$complete_user_list = GroupManager :: get_complete_list_of_users_that_can_be_added_to_group($course_id, $current_group['id']);
display_user_select_list($complete_user_list, "no_group_members[]");
?>
   </td>
   <td>
    <input type="button" onclick="move(this.form.elements[20],this.form.elements[23])" value="   &gt;&gt;   "/>
	<br/>
	<br/>
	<input type="button" onclick="move(this.form.elements[23],this.form.elements[20])" value="   &lt;&lt;   "/>
   </td>
   <td align="center">
    <?php

$group_member_list = GroupManager :: get_subscribed_users($current_group['id']);
display_user_select_list($group_member_list, "group_members[]");
?>
   </td>
  </tr>
 </table>
 </td>
 </tr>
 </table>
 <input type="submit" value="<?php      echo get_lang("Ok") ?>" onclick="selectAll(this.form.elements[23],true)"/>
</form>
<?php

/*
============================================================================== 
		FOOTER 
============================================================================== 
*/
Display::display_footer();
?>


