<?php
// $Id: group_creation.php,v 1.39 2005/05/12 09:03:20 bmol Exp $
/*
===============================================================================
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Hugues Peeters
	Copyright (c) Thomas Depraetere
	Copyright (c) Christophe Gesche
	Copyright (c) Roan Embrechts
	Copyright (c) Bart Mollet
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
===============================================================================
*/
/**
============================================================================== 
*	@package dokeos.group
============================================================================== 
*/
/*
===============================================================================
       DOKEOS INIT SETTINGS
===============================================================================
*/
$langFile = "group";
include ('../inc/claro_init_global.inc.php');
include_once (api_get_library_path()."/groupmanager.lib.php");
include_once (api_get_library_path()."/course.lib.php");
/*
--------------------------------------
        Create the groups
--------------------------------------
*/
if (isset ($_POST['action']))
{
	switch ($_POST['action'])
	{
		case 'create_groups' :
			$groups = array();
			for($i=0; $i<$_POST['number_of_groups'];$i++)
			{
				$group['name'] = $_POST['group_'.$i.'_name'];
				$group['category'] = $_POST['group_'.$i.'_category'];
				$group['tutor'] = $_POST['group_'.$i.'_tutor'];
				$group['places']= $_POST['group_'.$i.'_places'];
				$groups[] = $group;
			}
			foreach ($groups as $index => $group)
			{
				if ($_POST['same_tutor'])
				{
					$group['tutor'] = $_POST['group_0_tutor'];
				}
				if ($_POST['same_places'])
				{
					$group['places'] = $_POST['group_0_places'];
				}
				if (get_setting('allow_group_categories') == 'false')
				{
					$group['category'] = DEFAULT_GROUP_CATEGORY;
				}
				elseif ($_POST['same_category'])
				{
					$group['category'] = $_POST['group_0_category'];
				}
				GroupManager :: create_group(strip_tags($group['name']), $group['category'], $group['tutor'], $group['places']);
			}
			$msg = urlencode(count($groups).' '.get_lang('GroupsAdded'));
			header('Location: group.php?action=show_msg&msg='.$msg);
			break;
		case 'create_virtual_groups' :
			$ids = GroupManager :: create_groups_from_virtual_courses();
			$msg = urlencode(count($ids).' '.get_lang('GroupsAdded'));
			header('Location: group.php?action=show_msg&msg='.$msg);
			break;
		case 'create_subgroups' :
			GroupManager :: create_subgroups($_POST['base_group'], $_POST['number_of_groups']);
			$msg = urlencode($_POST['number_of_groups'].' '.get_lang('GroupsAdded'));
			header('Location: group.php?action=show_msg&msg='.$msg);
			break;
	}
}
$nameTools = get_lang('GroupCreation');
$interbredcrump[] = array ("url" => "group.php", "name" => get_lang('GroupManagement'));
Display::display_header($nameTools,"Group");
api_display_tool_title($nameTools);
if (!is_allowed_to_edit())
{
	api_not_allowed();
}
/*
===============================================================================
       MAIN TOOL CODE
===============================================================================
*/
/*
--------------------------------------
        Show group-settings-form
--------------------------------------
*/
elseif (isset ($_POST['number_of_groups']))
{
	if (!is_numeric($_POST['number_of_groups']) || intval($_POST['number_of_groups']) < 1)
	{
		Display :: display_error_message(get_lang('PleaseEnterValidNumber').'<br/><br/><a href="group_creation.php">&laquo; '.get_lang('Back').'</a>');
	}
	$number_of_groups = intval($_POST['number_of_groups']);
	if ($number_of_groups > 1)
	{
?>
	<script type="text/javascript">
	<!--
	var number_of_groups = <?php echo $number_of_groups; ?>;
	function switch_state(key)
	{
		for( i=1; i<number_of_groups; i++)
		{
			element = document.getElementById(key+'_'+i);
			element.disabled = !element.disabled;
			disabled = element.disabled;
		}
		ref = document.getElementById(key+'_0');
		if( disabled )
		{
			ref.addEventListener("change", copy, false);
		}
		else
		{
			ref.removeEventListener("change", copy, false);
		}
		copy_value(key);
	}
	function copy(e)
	{
		key = e.currentTarget.id;
		var re = new RegExp ('_0', '') ;
		var key = key.replace(re, '') ;
		copy_value(key);
	}
	function copy_value(key)
	{
		ref = document.getElementById(key+'_0');
		for( i=1; i<number_of_groups; i++)
		{
			element = document.getElementById(key+'_'+i);
			element.value = ref.value;
		}
	}
	-->
	</script>
	<?php

	}
	$group_categories = GroupManager :: get_categories();
	$group_id = GroupManager :: get_number_of_groups() + 1;
	$tutors = GroupManager :: get_all_tutors();
	$tutor_options = '<option value="0">'.get_lang('GroupNoTutor').'</option>';
	foreach ($tutors as $index => $tutor)
	{
		$tutor_options .= '<option value="'.$tutor['user_id'].'">'.$tutor['firstname'].' '.$tutor['lastname'].'</option>';
	}
	$cat_options = '';
	foreach ($group_categories as $index => $category)
	{
		// Don't allow new groups in the virtual course category!
		if ($category['id'] != VIRTUAL_COURSE_CATEGORY)
		{
			$cat_options .= '<option value="'.$category['id'].'">'.$category['title'].'</option>';
		}
	}
	echo '<form method="post" action="group_creation.php" name="group_settings_form"  id="group_settings_form">';
	$column_header[] = get_lang('GroupName');
	if (get_setting('allow_group_categories') == 'true')
	{
		$column_header[] = get_lang('GroupCategory');
	}
	$column_header[] = get_lang('GroupTutor');
	$column_header[] = get_lang('GroupPlacesThis');
	$bgcolor = Display :: display_complex_table_header(array ('class' => '', 'cellspacing' => '1', 'width' => ''), $column_header);
	if ($number_of_groups > 1)
	{
		$row[] = '';
		if (get_setting('allow_group_categories') == 'true')
		{
			$row[] = '<input type="checkbox" id="same_category" name="same_category" onclick="javascript:switch_state('."'category'".')" /><label for="same_category">'.get_lang('SameForAll').'</label>';
		}
		$row[] = '<input type="checkbox" name="same_tutor" id="same_tutor" onclick="javascript:switch_state('."'tutor'".')"  /><label for="same_tutor">'.get_lang('SameForAll').'</label>';
		$row[] = '<input type="checkbox" name="same_places" id="same_places" onclick="javascript:switch_state('."'places'".')" /><label for="same_places">'.get_lang('SameForAll').'</label>';
		$bgcolor = Display :: display_table_row($bgcolor, $row, true);
	}
	echo '<input type="hidden" name="number_of_groups" value="'.$_POST['number_of_groups'].'"/>';
	$default_places_per_group = '';
	if( get_setting('allow_group_categories') != 'true')
	{
			$category = GroupManager::get_category(DEFAULT_GROUP_CATEGORY);
			$default_places_per_group = $category['max_student'] == MEMBER_PER_GROUP_NO_LIMIT ? '-' :  $category['max_student'] ;
	}
	for ($group_number = 0; $group_number < $_POST['number_of_groups']; $group_number ++)
	{
		$row = array ();
		$row[] = '<input type="text" name="group_'.$group_number.'_name" value="'.get_lang('Group').' '.$group_id.'"/>';
		if (get_setting('allow_group_categories') == 'true')
		{
			$row[] = '<select id="category_'.$group_number.'" name="group_'.$group_number.'_category">'.$cat_options.'</select>';
		}
		$row[] = '<select id="tutor_'.$group_number.'" name="group_'.$group_number.'_tutor">'.$tutor_options.'</select>';
		$row[] = '<input id="places_'.$group_number.'" type="text" name="group_'.$group_number.'_places" value="'.$default_places_per_group.'" size="3"/>';
		$bgcolor = Display :: display_table_row($bgcolor, $row, true);
		$group_id ++;
	}
	Display :: display_table_footer();
	echo '<blockquote><p>';
	echo '<input type="hidden" name="action" value="create_groups"/>';
	echo '<input type="submit" value="'.get_lang('Create').'"/>';
	echo '</p></blockquote>';
	echo '</form>';
}
else
{
	/*
	 * Show form to generate new groups
	 */
	$categories = GroupManager :: get_categories();
	echo '<b>'.get_lang('NewGroups').'</b>';
	echo '<blockquote>';
	if (count($categories) > 1 || isset ($categories[0]) && $categories[0]['id'] != VIRTUAL_COURSE_CATEGORY)
	{
		echo '<form method="post" action="group_creation.php">';
		echo '<p>';
		echo get_lang('Create');
		echo ' <input type="text" name="number_of_groups" size="3" value="1"/> ';
		echo get_lang('NewGroups');
		echo ' <input type="submit" value="'.get_lang('Ok').'" name="creation"/>';
		echo '</p>';
		echo '</form>';
	}
	else
	{
		echo get_lang('NoCategoriesDefined');
	}
	echo '</blockquote>';
	/*
	 * Show form to generate groups from virtual courses
	 */
	$virtual_courses = CourseManager :: get_virtual_courses_linked_to_real_course($_course['sysCode']);
	if (count($virtual_courses) > 0)
	{
		echo '<b>'.get_lang('CreateGroupsFromVirtualCourses').'</b>';
		echo '<blockquote>';
		echo '<form method="post" action="group_creation.php">';
		echo '<input type="hidden" name="action" value="create_virtual_groups"/>';
		echo get_lang('CreateGroupsFromVirtualCoursesInfo').' ';
		echo '<input type="submit" value="'.get_lang('Ok').'"/>';
		echo '</form>';
		echo '</blockquote>';
	}
	/*
	 * Show form to generate subgroups
	 */
	if (get_setting('allow_group_categories') == 'true' && count(GroupManager :: get_group_list()) > 0)
	{
		$groups_with_users = array ();
		$categories = GroupManager :: get_categories();
		foreach ($categories as $index => $category)
		{
			$groups = GroupManager :: get_group_list($category['id']);
			foreach ($groups as $index => $group)
			{
				$number_of_students = GroupManager :: number_of_students($group['id']);
				if ($number_of_students > 0)
				{
					$groups_with_users[$category['title']][$group['id']]['name'] = $group['name'];
					$groups_with_users[$category['title']][$group['id']]['users'] = $number_of_students;
				}
			}
		}
		if (count($groups_with_users) > 0)
		{
			echo '<b>'.get_lang('CreateSubgroups').'</b>';
			echo '<blockquote>';
			echo '<p>'.get_lang('CreateSubgroupsInfo').'</p>';
			echo '<form method="post" action="group_creation.php">';
			echo '<p>';
			echo '<input type="hidden" name="action" value="create_subgroups"/>';
			echo get_lang('CreateNumberOfGroups');
			echo ' <input type="text" name="number_of_groups" size="2"/> ';
			echo get_lang('WithUsersFrom');
			echo ' <select name="base_group">';
			foreach ($groups_with_users as $category => $groups)
			{
				echo '<optgroup label="'.$category.'">';
				foreach ($groups as $id => $group)
				{
					echo '<option value="'.$id.'">'.$group['name'];
					echo ' ('.$group['users'].' '.get_lang('Users').')';
					echo '</option>';
				}
				echo '</optgroup>';
			}
			echo '</select>';
			echo ' <input type="submit" value="'.get_lang('Ok').'"/>';
			echo '</p>';
			echo '</form>';
			echo '</blockquote>';
		}
	}
}
/*
===============================================================================
       DOKEOS FOOTER
===============================================================================
*/
Display::display_footer();
?>