<?php
// $Id: group_category.php,v 1.15 2005/04/28 11:07:25 bmol Exp $
/*
============================================================================== 
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
============================================================================== 
*/
/**
============================================================================== 
*	@package dokeos.group
============================================================================== 
*/
/*
============================================================================== 
		INIT SECTION
============================================================================== 
*/
$langFile = "group";
include ('../inc/claro_init_global.inc.php');
include_once (api_get_library_path().'/groupmanager.lib.php');
include_once (api_get_library_path().'/debug.lib.inc.php');
if (!api_is_allowed_to_edit() || !(isset ($_GET['id']) || isset ($_POST['id']) || isset ($_GET['action']) || isset ($_POST['action'])))
{
	api_not_allowed();
}
unset($message);
if (isset ($_POST['action']))
{
	if ($_POST['max_member_no_limit'] == MEMBER_PER_GROUP_NO_LIMIT)
	{
		$max_member = MEMBER_PER_GROUP_NO_LIMIT;
	}
	else
	{
		$max_member = $_POST['max_member'];
	}
	$self_reg_allowed = isset ($_POST['self_registration_allowed']) ? $_POST['self_registration_allowed'] : 0;
	$self_unreg_allowed = isset ($_POST['self_unregistration_allowed']) ? $_POST['self_unregistration_allowed'] : 0;
	if (strlen($_POST['title']) == 0)
	{
		$message = get_lang("NoTitleGiven");
	}
	if(! is_numeric($max_member))
	{
		$message = get_lang('InvalidMaxNumberOfMembers');	
	}
	elseif (isset ($_POST['id']) && intval($_POST['groups_per_user']) != GROUP_PER_MEMBER_NO_LIMIT && GroupManager :: get_current_max_groups_per_user($_POST['id']) > intval($_POST['groups_per_user']))
	{
		$message = get_lang("MaxGroupsPerUserInvalid");
	}
	else
	{
		switch ($_POST['action'])
		{
			case 'update_settings' :
				GroupManager :: update_category($_POST['id'], $_POST['title'], $_POST['description'], $_POST['forum_state'], $_POST['doc_state'], $self_reg_allowed, $self_unreg_allowed, $max_member, $_POST['groups_per_user']);
				$msg = urlencode(get_lang("GroupPropertiesModified"));
				header('Location: group.php?action=show_msg&msg='.$msg.'&category='.$_POST['id']);
				break;
			case 'add_category' :
				GroupManager :: create_category($_POST['title'], $_POST['description'], $_POST['forum_state'],  $_POST['doc_state'],  $self_reg_allowed, $self_unreg_allowed, $max_member, $_POST['groups_per_user']);
				$msg = urlencode(get_lang("CategoryCreated"));
				header('Location: group.php?action=show_msg&msg='.$msg);
				break;
		}
	}
}

if (get_setting('allow_group_categories') == 'true')
{
	if (isset ($_GET['id']))
	{
		$category = GroupManager :: get_category($_GET['id']);
		$nameTools = get_lang('Edit').' '.$category['title'];
	}
	else
	{
		$nameTools = get_lang('AddCategory');
		// default values for new category
		$category = array ('groups_per_user' => 1, 'forum_state' => TOOL_PRIVATE, 'doc_state'=>TOOL_PRIVATE, 'max_student' => 0);
	}
}
else
{
	$category = GroupManager :: get_category($_GET['id']);
	$nameTools = get_lang('PropModify');
}
$interbredcrump[] = array ("url" => "group.php", "name" => get_lang('GroupManagement'));
Display::display_header($nameTools,"Group");
api_display_tool_title($nameTools);
if (isset ($message))
{
	Display :: display_normal_message($message);
}
if (isset ($_GET['id']))
{
?>
	<form method="post" action="group_category.php?id=<?php echo $_GET['id'] ?>">
	<blockquote>
	<input type="hidden" name="id" value="<?php echo $_GET['id'] ?>"/>
	<input type="hidden" name="action" value="update_settings"/>
	<?php

}
else
{
?>
	<form method="post" action="group_category.php">
	<blockquote>
	<input type="hidden" name="action" value="add_category"/>
	<?php

}
if (get_setting('allow_group_categories') == 'true')
{
	echo get_lang('Title');
?>
	<br/><input type="text" name="title" value="<?php echo $category['title'] ?>" size="50"/>
	<br/><br/>
	<?php

	echo get_lang('Description')
?><br/>
	  <textarea name="description" rows="5" cols="80"><?php echo $category['description'] ?></textarea>
 	<?php

}
else
{
?>
	<input type="hidden" name="title" value="<?php echo $category['title'] ?>"/>	
	<input type="hidden" name="description" value="<?php echo $category['description'] ?>"/>
	<?php

}
?> 
</blockquote>
<p>
				<b><?php echo get_lang('GroupLimit') ?>:</b>
				</p>
				<blockquote>
				<p>
				<?php

echo get_lang('QtyOfUserCanSubscribe_PartBeforeNumber');
$number_of_groups_per_user = $category['groups_per_user'];
?>
				<select name="groups_per_user" >
				<?php

for ($i = 1; $i <= 10; $i ++)
{
	echo '<option value="'.$i.'"';
	echo $number_of_groups_per_user == $i ? ' selected="selected" ' : '';
	echo '>'.$i.'</option>';
}
echo '<option value="'.GROUP_PER_MEMBER_NO_LIMIT.'"';
echo $number_of_groups_per_user == GROUP_PER_MEMBER_NO_LIMIT ? ' selected="selected" ' : '';
echo '>'.get_lang('All').'</option>';
?>
				</select>
				<?php echo get_lang('QtyOfUserCanSubscribe_PartAfterNumber') ?>
				</p>
			</blockquote>
<p>
<b><?php echo get_lang('DefaultSettingsForNewGroups') ?>:</b>
</p>
<blockquote>
<p>		
<b><?php echo get_lang('GroupLimit'); ?></b>	
</p>
  <blockquote>

  	
<input type="radio" class="checkbox" id="max_member_no_limit"  name="max_member_no_limit" value="<?php echo MEMBER_PER_GROUP_NO_LIMIT; ?>" <?php echo ($category['max_student'] == MEMBER_PER_GROUP_NO_LIMIT ? ' checked="checked" ' : '') ?> /> <label for="max_member_no_limit"><?php echo get_lang('NoLimit') ?></label>
<br/>
<input type="radio" class="checkbox" id="max_member_limit" name="max_member_no_limit" <?php echo ($category['max_student'] != MEMBER_PER_GROUP_NO_LIMIT ? ' checked="checked" ' : '') ?>/>
<?php

echo '<label for="max_member_limit">'.get_lang('Max').'</label>';
echo ' <input type="text" name="max_member" size="2" value="'. ($category['max_student'] == MEMBER_PER_GROUP_NO_LIMIT ? '' : $category['max_student']).'"/> ';
echo '<label for="max_member_limit">'.get_lang('GroupPlacesThis').'</label>';
?>

  </blockquote>
<p>
<b><?php echo get_lang("GroupSelfRegistration") ?></b>
</p>
  <blockquote>
  <p>
  <?php

echo '<input class="checkbox" type="checkbox" id="self_registration_allowed" name="self_registration_allowed" value="1" '. ($category['self_reg_allowed'] ? 'checked' : '').'/>';
echo '&nbsp;<label for="self_registration_allowed">'.get_lang('GroupAllowStudentRegistration').'</label>';
echo '<br/>';
echo '<input class="checkbox" type="checkbox" id="self_unregistration_allowed" name="self_unregistration_allowed" value="1" '. ($category['self_unreg_allowed'] ? 'checked' : '').'/>';
echo '&nbsp;<label for="self_unregistration_allowed">'.get_lang('GroupAllowStudentUnregistration').'</label>';
?>
	  </p>
	  </blockquote>
<p><b><?php echo get_lang('GroupTools') ?>:</b></p>
<blockquote>
<p>
<input type="hidden" name="forum" value="1"/>
<?php echo get_lang('GroupForum') ?> :<br/>
  <input type="radio" id="forum_state1" class="checkbox" name="forum_state" value="<?php echo TOOL_NOT_AVAILABLE ?>" <?php echo $category['forum_state'] == TOOL_NOT_AVAILABLE ? 'checked="checked"' : '' ?>/>&nbsp;<label for="forum_state1"><?php echo get_lang('NotAvailable') ?></label><br/>
  <input type="radio" id="forum_state2"  class="checkbox" name="forum_state" value="<?php echo TOOL_PUBLIC ?>" <?php echo $category['forum_state'] == TOOL_PUBLIC ? 'checked="checked"' : '' ?>/>&nbsp;<label for="forum_state2"><?php echo get_lang('Public') ?></label><br/>
  <input type="radio" id="forum_state3"  class="checkbox" name="forum_state" value="<?php echo TOOL_PRIVATE ?>" <?php echo $category['forum_state'] == TOOL_PRIVATE ? 'checked="checked"' : '' ?>/>&nbsp;<label for="forum_state3"><?php echo get_lang('Private') ?></label><br/>
</p>
<p>
<?php echo get_lang('GroupDocument') ?> :<br/>
  <input type="radio" id="doc_state1" class="checkbox" name="doc_state" value="<?php echo TOOL_NOT_AVAILABLE ?>" <?php echo $category['doc_state'] == TOOL_NOT_AVAILABLE ? 'checked="checked"' : '' ?>/>&nbsp;<label for="doc_state1"><?php echo get_lang('NotAvailable') ?></label><br/>
  <input type="radio" id="doc_state2"  class="checkbox" name="doc_state" value="<?php echo TOOL_PUBLIC ?>" <?php echo $category['doc_state'] == TOOL_PUBLIC ? 'checked="checked"' : '' ?>/>&nbsp;<label for="doc_state2"><?php echo get_lang('Public') ?></label><br/>
  <input type="radio" id="doc_state3"  class="checkbox" name="doc_state" value="<?php echo TOOL_PRIVATE ?>" <?php echo $category['doc_state'] == TOOL_PRIVATE ? 'checked="checked"' : '' ?>/>&nbsp;<label for="doc_state3"><?php echo get_lang('Private') ?></label><br/>
<input type="hidden" name="document" value="1"/>
<br/>
</p>
</blockquote>
</blockquote>
<p>
<input type="submit" value="<?php echo get_lang('Ok') ?>"/>
</p>
</form>
<?php
Display::display_footer();
?>