<?php // $Id: statement_admin.inc.php,v 1.28 2005/06/06 12:12:51 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	STATEMENT ADMINISTRATION
*	This script allows to manage the statements of questions.
*	It is included from the script admin.php
*
*	@author Olivier Brouckaert
*	@package dokeos.exercise
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/


// ALLOWED_TO_INCLUDE is defined in admin.php
if(!defined('ALLOWED_TO_INCLUDE'))
{
	exit();
}

//debug var. Set to 0 if you don't want any debug display
$debug = 0;

// the question form has been submitted
// this question form is the one below.
// In case the form has been submitted, at the end of the process part of this script, we "skip" the form
// display and pass to answer_admin.inc.php which displays a form for the answer itself
if($submitQuestion)
{
    if($debug>0){echo str_repeat('&nbsp;',2).'$submitQuestion is true'."<br />\n";}

    $questionName=trim(stripslashes($_POST['questionName']));
    $questionDescription=trim(stripslashes($_POST['questionDescription']));
    $_FILES['imageUpload']['name']=strtolower($_FILES['imageUpload']['name']);

    // no name given
    if(empty($questionName))
    {
        $msgErr=get_lang('GiveQuestion');
    }
    // checks if the question is used in several exercises
    elseif($exerciseId && !$modifyIn && $objQuestion->selectNbrExercises() > 1)
    {
        if($debug>0){echo str_repeat('&nbsp;',4).'$exerciseId is set and $modifyIn is unset and this question is in more than one exercise'."<br />\n";}
        $usedInSeveralExercises=1;

        // if a picture has been set
        if($_FILES['imageUpload']['size'])
        {
            // saves the picture into a temporary file
            $objQuestion->setTmpPicture($_FILES['imageUpload']['tmp_name'],$_FILES['imageUpload']['name']);
        }
    }
    else
    {
        if($debug>0){echo str_repeat('&nbsp;',4).'You have chosen to modify/add a question locally'."<br />\n";}
        // if the user has chosed to modify the question only in the current exercise
        if($modifyIn == 'thisExercise')
        {
        	// duplicates the question
        	$questionId=$objQuestion->duplicate();

            // deletes the old question
            $objQuestion->delete($exerciseId);

            // removes the old question ID from the question list of the Exercise object
            $objExercise->removeFromList($modifyQuestion);

            $nbrQuestions--;

            // construction of the duplicated Question
            $objQuestion=new Question();

            $objQuestion->read($questionId);

            // adds the exercise ID into the exercise list of the Question object
            $objQuestion->addToList($exerciseId);

            // construction of the Answer object
            $objAnswerTmp=new Answer($modifyQuestion);

            // copies answers from $modifyQuestion to $questionId
            $objAnswerTmp->duplicate($questionId);

            // destruction of the Answer object
            unset($objAnswerTmp);
        }

        $objQuestion->updateTitle($questionName);
        $objQuestion->updateDescription($questionDescription);
        $objQuestion->updateType($answerType);
        $objQuestion->save($exerciseId);

        // if a picture has been set or checkbox "delete" has been checked
        if($_FILES['imageUpload']['size'] || $deletePicture)
        {
            // we remove the picture
            $objQuestion->removePicture();

            // if we add a new picture
            if($_FILES['imageUpload']['size'])
            {
                // image is already saved in a temporary file
                if($modifyIn)
                {
                    $objQuestion->getTmpPicture();
                }
                // saves the picture coming from POST FILE
                else
                {
                    $objQuestion->uploadPicture($_FILES['imageUpload']['tmp_name'],$_FILES['imageUpload']['name']);
                }
            }

            $objQuestion->save($exerciseId);
        }

        $questionId=$objQuestion->selectId();

        if($exerciseId)
        {
            // adds the question ID into the question list of the Exercise object
            if($objExercise->addToList($questionId))
            {
                $objExercise->save();

                $nbrQuestions++;
            }
        }

        if($newQuestion)
        {
            // goes to answer administration
            // -> answer_admin.inc.php
            $modifyAnswers=$questionId;
        }
        else
        {
            // goes to exercise viewing
            $editQuestion=$questionId;
        }

        // avoids displaying the following form in case we're editing the answer
        unset($newQuestion,$modifyQuestion);
    }
    if($debug>0){echo str_repeat('&nbsp;',2).'$submitQuestion is true - end'."<br />\n";}

}
else
{
    if($debug>0){echo str_repeat('&nbsp;',2).'$submitQuestion was unset'."<br />\n";}

    // if we don't come here after having cancelled the warning message "used in serveral exercises"
    if(!$buttonBack)
    {
        if($debug>0){echo str_repeat('&nbsp;',4).'$buttonBack was unset'."<br />\n";}
        $questionName=$objQuestion->selectTitle();
        $questionDescription=$objQuestion->selectDescription();
        $answerType=$objQuestion->selectType();
        $pictureName=$objQuestion->selectPicture();
    }

    $okPicture=empty($pictureName)?false:true;
    if($debug>0){echo str_repeat('&nbsp;',2).'$submitQuestion was unset - end'."<br />\n";}
}

if(($newQuestion || $modifyQuestion) && !$usedInSeveralExercises)
{
    if($debug>0){echo str_repeat('&nbsp;',2).'$newQuestion or modifyQuestion was set but the question only exists in this exercise'."<br />\n";}

?>

<h3>
  <?php echo $questionName; ?>
</h3>

<form enctype="multipart/form-data" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?modifyQuestion=<?php echo $modifyQuestion; ?>&newQuestion=<?php echo $newQuestion; ?>" style="margin:0px;">
<table border="0" cellpadding="5">

<?php
	if($okPicture)
	{
?>

<tr>
  <td colspan="2" align="center"><img src="../document/download.php?doc_url=%2Fimages%2F<?php echo $pictureName; ?>" border="0"></td>
</tr>

<?php
	}

	if(!empty($msgErr))
	{
?>

<tr>
  <td colspan="2">

<?php
	Display::display_normal_message($msgErr); //main API
?>

  </td>
</tr>

<?php
	}
?>

<tr>
  <td><?php echo get_lang('Question'); ?> :</td>
  <td><input type="text" name="questionName" size="50" maxlength="200" value="<?php echo htmlspecialchars($questionName); ?>" style="width:400px;"></td>
</tr>
<tr>
  <td valign="top"><?php echo get_lang('QuestionDescription'); ?> :</td>
  <td>

<?php
    api_disp_html_area('questionDescription',$questionDescription,'250px');
?>

  </td>
</tr>

<!--
<tr>
  <td valign="top"><?php echo $okPicture?get_lang('ReplacePicture'):get_lang('AddPicture'); ?> :</td>
  <td><input type="file" name="imageUpload" size="50" style="width:400px;">

<?php
	if($okPicture)
	{
?>

	<br><input class="checkbox" type="checkbox" name="deletePicture" value="1" <?php if($deletePicture) echo 'checked="checked"'; ?>> <?php echo get_lang('DeletePicture'); ?>

<?php
	}
?>

  </td>
</tr>
//-->

<?php
	if($okPicture)
	{
?>

<tr>
  <td valign="top"><?php echo get_lang('DeletePicture'); ?> :</td>
  <td><input class="checkbox" type="checkbox" name="deletePicture" value="1" <?php if($deletePicture) echo 'checked="checked"'; ?>> <?php echo get_lang('Yes'); ?></td>
</tr>

<?php
	}
?>

  </td>
</tr>

<tr>
  <td valign="top"><?php echo get_lang('AnswerType'); ?> :</td>
  <td><input class="checkbox" type="radio" name="answerType" value="1" <?php if($answerType <= 1) echo 'checked="checked"'; ?>> <?php echo get_lang('langUniqueSelect'); ?><br />
	  <input class="checkbox" type="radio" name="answerType" value="2" <?php if($answerType == 2) echo 'checked="checked"'; ?>> <?php echo get_lang('langMultipleSelect'); ?><br />
	  <input class="checkbox" type="radio" name="answerType" value="4" <?php if($answerType == 4) echo 'checked="checked"'; ?>> <?php echo get_lang('langMatching'); ?><br />
	  <input class="checkbox" type="radio" name="answerType" value="3" <?php if($answerType == 3) echo 'checked="checked"'; ?>> <?php echo get_lang('langFillBlanks'); ?><br />
    <!--input class="checkbox" type="radio" name="answerType" value="5" <?php #if($answerType >= 5) echo 'checked="checked"'; ?>--> <?php #echo get_lang('freeAnswer'); ?>
  </td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td>
	<input type="submit" name="submitQuestion" value="<?php echo get_lang('Ok'); ?>">
	<!-- &nbsp;&nbsp;<input type="submit" name="cancelQuestion" value="<?php echo get_lang('Cancel'); ?>" onclick="javascript:if(!confirm('<?php echo addslashes(htmlspecialchars(get_lang('ConfirmYourChoice'))); ?>')) return false;"> //-->
  </td>
</tr>
</table>
</form>

<?php
}
?>