<?php // $Id: exercise_admin.inc.php,v 1.25 2005/06/27 13:13:31 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	EXERCISE ADMINISTRATION
*
*	This script allows to manage an exercise.
*	It is included from the script admin.php
*
*	@author Olivier Brouckaert
*	@package dokeos.exercise
==============================================================================
*/


  // added by MArk111
  // same language vars for timed, max passage, report after test taken : to be in lang file
  // to take care about : calendar and date-time input fields uses agenda.inc.php lang file
  /*$showExtendedResults='Show extended results'; 
  $showExtendedResultsExt='If checked, shows correct answers and comments after test is taken.';
  $maxNrOfPassages='Max nr. of passages';
  $maxNrOfPassagesExt='maximum number of passages for every student. 0 : unlimited.';
  $timedTest='Timed test';
  $timedTestExt='Test cannot be taken by students outside given time interval if option is checked.';
  $calendarAlt='Calendar';*/
  



// ALLOWED_TO_INCLUDE is defined in admin.php
if(!defined('ALLOWED_TO_INCLUDE'))
{
	exit();
}

// the exercise form has been submitted
if($submitExercise)
{
	$exerciseTitle=trim($exerciseTitle);
	$exerciseDescription=trim($exerciseDescription);
	$randomQuestions=$randomQuestions?$questionDrawn:0;
	$deleteSound=$deleteSound?true:false;

	// no title given
	if(empty($exerciseTitle))
	{
		$msgErr=get_lang('GiveExerciseName');
	}
	else
	{
		$objExercise->updateTitle($exerciseTitle);
		$objExercise->updateDescription($exerciseDescription);
		$objExercise->updateSound($_FILES['exerciseSound'],$deleteSound);
		$objExercise->updateType($exerciseType);
		$objExercise->setRandom($randomQuestions);
                // added by MArk111
                $objExercise->setShowResults($shwResults);
                $objExercise->updateMaxPassages($maxPassages);

                $start_date=(int)$fyear."-".(int)$fmonth."-".(int)$fday." ".(int)$fhour.":".(int)$fminute.":00";
                $end_date=(int)$end_fyear."-".(int)$end_fmonth."-".(int)$end_fday." ".(int)$end_fhour.":".(int)$end_fminute.":00";
                echo $start_date;
                echo $end_date;
                $objExercise->updateTimed($isTimed);
                $objExercise->updateDates($start_date,$end_date);
		$objExercise->save();

		if($deleteSound)
		{
			$exerciseSound='';
		}
		else
		{
			$exerciseSound=$objExercise->selectSound();
		}

		// reads the exercise ID (only usefull for a new exercise)
		$exerciseId=$objExercise->selectId();

		unset($modifyExercise);
	}
}
else
{
	$exerciseTitle=$objExercise->selectTitle();
	$exerciseDescription=$objExercise->selectDescription();
	$exerciseSound=$objExercise->selectSound();
	$exerciseType=$objExercise->selectType();
	$randomQuestions=$objExercise->isRandom();
        // added by MArk111
        $shwResults=$objExercise->showRez();
        $maxPassages=$objExercise->maxPassages();
        $isTimed=$objExercise->getIsTimed();
        $start_date=$objExercise->getStartDate();
        $end_date=$objExercise->getEndDate();

        
        
}

// shows the form to modify the exercise
if($modifyExercise)
{
?>

<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?modifyExercise=<?php echo $modifyExercise; ?>" style="margin:0px;" enctype="multipart/form-data" name="new_calendar_item">
<table border="0" cellpadding="5">

<?php
if(!empty($msgErr))
{
?>

<tr>
  <td colspan="2">

<?php
	Display::display_normal_message($msgErr); //main API
?>

  </td>
</tr>

<?php
}
?>

<tr>
  <td><?php echo get_lang('langExerciseName'); ?> :</td>
  <td><input type="text" name="exerciseTitle" size="50" maxlength="200" value="<?php echo htmlspecialchars($exerciseTitle); ?>" style="width:400px;"></td>
</tr>
<tr>
  <td valign="top"><?php echo get_lang('langExerciseDescription'); ?> :</td>
  <td>

<?php
    api_disp_html_area('exerciseDescription',$exerciseDescription,'250px');
?>

  </td>
</tr>

<!--
<tr>
  <td valign="top"><?php echo get_lang('langSound'); ?> :

  <?php if(!empty($exerciseSound)): ?>
  <a href="../document/download.php?doc_url=%2Faudio%2F<?php echo $exerciseSound; ?>" target="_blank"><img src="../img/wav.gif" border="0" align="absmiddle" alt="<?php echo get_lang('langSound'); ?>"></a>
  <?php endif; ?>

  </td>
  <td><input type="file" name="exerciseSound" size="50" style="width:400px;">

  <?php if(!empty($exerciseSound)): ?>
  <br>
  <input class="checkbox" type="checkbox" name="deleteSound" value="1"> <?php echo get_lang('langDeleteSound'); ?>
  <?php endif; ?>

  </td>
</tr>
//-->

<tr>
  <td valign="top"><?php echo get_lang('langExerciseType'); ?> :</td>
  <td><input class="checkbox" type="radio" name="exerciseType" value="1" <?php if($exerciseType <= 1) echo 'checked="checked"'; ?>> <?php echo get_lang('langSimpleExercise'); ?><br>
      <input class="checkbox" type="radio" name="exerciseType" value="2" <?php if($exerciseType >= 2) echo 'checked="checked"'; ?>> <?php echo get_lang('langSequentialExercise'); ?></td>
</tr>

<tr>
 
<!-- Added by MArk111 extended quiz controls -->
 
<td><?php echo $showExtendedResults; ?></td> <!-- show correct answers & comments ?-->
 <td><input class="checkbox" 
            type="checkbox" 
            name="shwResults" value="1" <?php if($shwResults == 1) echo 'checked="checked"'; ?> >
            <?php echo $showExtendedResultsExt; ?>
</td>
</tr>
<tr> 
 <td><?php echo $maxNrOfPassages; ?></td>   <!-- max number of passages -->
 <td> <input type="text" 
       name="maxPassages" 
       size="50" 
       maxlength="5" 
       value="<?php echo $maxPassages?>"
       style="width:50px;">
       <?php echo $maxNrOfPassagesExt; ?>
 </td>
</tr> 

<!--    timed                                           -->
<tr>
 <td><?php echo $timedTest; ?></td> <!-- is this quiz timed ?-->
 <td><input class="checkbox" 
            type="checkbox" 
            name="isTimed" value="1" <?php if($isTimed == 1) echo 'checked="checked"'; ?> >
            <?php echo $timedTestExt; ?>
</td>
</tr>

<!-- START date and time -->
          <script src="../calendar/tbl_change.js" type="text/javascript" language="javascript"></script>

                <?php
                $langFile='agenda'; 
                
                $day	= date("d",strtotime($start_date));
		$month	= date("m",strtotime($start_date));
		$year	= date("Y",strtotime($start_date));
		$hours	= date("H",strtotime($start_date));
		$minutes= date("i",strtotime($start_date));

		$end_day	= date("d",strtotime($end_date));
		$end_month	= date("m",strtotime($end_date));
		$end_year	= date("Y",strtotime($end_date));
		$end_hours	= date("H",strtotime($end_date));
		$end_minutes	= date("i",strtotime($end_date));

                $MonthsLong = array (get_lang("JanuaryLong"), get_lang("FebruaryLong"), get_lang("MarchLong"), get_lang("AprilLong"), get_lang("MayLong"), get_lang("JuneLong"), get_lang("JulyLong"), get_lang("AugustLong"), get_lang("SeptemberLong"), get_lang("OctoberLong"), get_lang("NovemberLong"), get_lang("DecemberLong"));

                  ?>
                
		<tr id="subtitle">
			<td align=right>
				<!-- date: 1 -> 31 -->
				<?php echo get_lang("StartDate").": \n";?>
                        </td><td>
                                <table width=100%><td>
				<select name="fday" onchange="javascript:document.new_calendar_item.end_fday.value=this.value;">
					<?php
					// small loop for filling all the dates
					// 2do: the available dates should be those of the selected month => february is from 1 to 28 (or 29) and not to 31
					echo "\n";
					for ($i=1; $i<=31; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current day is indicated with [] around the date
						if ($value==$day)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected> ".$i." </option>\n";}
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$i."</option>\n"; }
						}?>
				</select>

				<!-- month: january -> december -->
				<select name="fmonth" onchange="javascript:document.new_calendar_item.end_fmonth.value=this.value;">
					<?php
					echo "\n";
					for ($i=1; $i<=12; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						if ($value==$month)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected>".$MonthsLong[$i-1]."</option>\n"; }
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$MonthsLong[$i-1]."</option>\n"; }
						}?>
				</select>

				<select name="fyear" onchange="javascript:document.new_calendar_item.end_fyear.value=this.value;">
					<option value="<?php echo ($year-1) ?>"><?php echo ($year-1) ?></option>
					<option value="<?php echo $year ?>" selected> <?php echo $year ?> </option>
					<?php
					echo "\n";
					for ($i=1; $i<=5; $i++)
						{
						$value=$year+$i;
						echo "\t\t\t\t<option value=\"".$value."\">".$value."</option>\n";
						}
					?>
				</select>
				<?php echo "<a title=".$calendarAlt." href=\"javascript:openCalendar('new_calendar_item', 'f')\"><img src=\"../img/calendar_select.gif\" border=\"0\" align=\"absmiddle\"/></a>"; ?>
			 </td>
                         <td width=3%>&nbsp;</td>
			<td align=right> 
				<?php echo get_lang("StartTime").": ";?>
                         </td><td>      
				<select name="fhour" onchange="javascript:document.new_calendar_item.end_fhour.value=this.value;">
					<option value="--">--</option>
					<?php
					echo "\n";
					for ($i=1; $i<=24; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current hour is indicated with [] around the hour
						if ($hours==$value)
							{ echo "\t\t\t\t<option value=\"".$value."\" selected> ".$value." </option>\n"; }
						else
							{ echo "\t\t\t\t<option value=\"".$value."\"> ".$value." </option>\n"; }
						}
					?>
				</select>
			  <?php echo get_lang("HourMinuteDivider");?>
          <select name="fminute" onchange="javascript:document.new_calendar_item.end_fminute.value=this.value;">
            <option value="<?php echo $minutes ?>"><?php echo $minutes ?></option>
            <option value="--">--</option>
            <option value="00">00</option>
            <option value="05">05</option>
            <option value="10">10</option>
            <option value="15">15</option>
            <option value="20">20</option>
            <option value="25">25</option>
            <option value="30">30</option>
            <option value="35">35</option>
            <option value="40">40</option>
            <option value="45">45</option>
            <option value="50">50</option>
            <option value="55">55</option>
          </select>
        </td>
        </table>
        </td>
      </tr>

<!-- END date and time -->
		<tr id="subtitle">
			<td align=right>
				<!-- date: 1 -> 31 -->
				<?php echo get_lang("EndDate").": \n";?>
                         </td><td>
                                <table width=100%><td>
				<select name="end_fday">
					<?php
					// small loop for filling all the dates
					// 2do: the available dates should be those of the selected month => february is from 1 to 28 (or 29) and not to 31
					echo "\n";
					for ($i=1; $i<=31; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current day is indicated with [] around the date
						if ($value==$end_day)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected> ".$i." </option>\n";}
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$i."</option>\n"; }
						}?>
				</select>

				<!-- month: january -> december -->
				<select name="end_fmonth">
					<?php
					echo "\n";
					for ($i=1; $i<=12; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						if ($value==$end_month)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected>".$MonthsLong[$i-1]."</option>\n"; }
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$MonthsLong[$i-1]."</option>\n"; }
						}?>
				</select>

				<select name="end_fyear">
					<option value="<?php echo ($end_year-1) ?>"><?php echo ($end_year-1) ?></option>
					<option value="<?php echo $end_year ?>" selected> <?php echo $end_year ?> </option>
					<?php
					echo "\n";
					for ($i=1; $i<=5; $i++)
						{
						$value=$end_year+$i;
						echo "\t\t\t\t<option value=\"".$value."\">".$value."</option>\n";
						}
					?>
				</select>
				<?php echo "<a title=".$calendarAlt." href=\"javascript:openCalendar('new_calendar_item', 'end_f')\"><img src=\"../img/calendar_select.gif\" border=\"0\" align=\"absmiddle\"/></a>"; ?>
			</td>
			<td width=3%>&nbsp;</td>
			<td align=right>
				<?php echo get_lang("EndTime").": ";?>
                        </td><td>  
				<select name="end_fhour">
					<option value="--">--</option>
					<?php
					echo "\n";
					for ($i=1; $i<=24; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current hour is indicated with [] around the hour
						if ($end_hours==$value)
							{ echo "\t\t\t\t<option value=\"".$value."\" selected> ".$value." </option>\n"; }
						else
							{ echo "\t\t\t\t<option value=\"".$value."\"> ".$value." </option>\n"; }
						}
					?>
				</select>
			  <?php echo get_lang("HourMinuteDivider");?>
          <select name="end_fminute">
            <option value="<?php echo $end_minutes ?>"><?php echo $end_minutes ?></option>
            <option value="--">--</option>
            <option value="00">00</option>
            <option value="05">05</option>
            <option value="10">10</option>
            <option value="15">15</option>
            <option value="20">20</option>
            <option value="25">25</option>
            <option value="30">30</option>
            <option value="35">35</option>
            <option value="40">40</option>
            <option value="45">45</option>
            <option value="50">50</option>
            <option value="55">55</option>
          </select>
        </td>
        </table></td>
      </tr>

<!--        end timed                                   -->

<?php $langFile='exercice'; ?> <!-- switch back lang file -->
<?php
	if($exerciseId && $nbrQuestions)
	{
?>

<tr>
  <td valign="top"><?php echo get_lang('langRandomQuestions'); ?> :</td>
  <td><input class="checkbox" type="checkbox" name="randomQuestions" value="1" <?php if($randomQuestions) echo 'checked="checked"'; ?>> <?php echo get_lang('langYes'); ?>, <?php echo get_lang('langTake'); ?>
    <select name="questionDrawn">

<?php
		for($i=1;$i <= $nbrQuestions;$i++)
		{
?>

	<option value="<?php echo $i; ?>" <?php if(($formSent && $questionDrawn == $i) || (!$formSent && ($randomQuestions == $i || ($randomQuestions <= 0 && $i == $nbrQuestions)))) echo 'selected="selected"'; ?>><?php echo $i; ?></option>

<?php
		}
?>

	</select> <?php echo mb_strtolower(get_lang('langQuestions')).' '.get_lang('langAmong').' '.$nbrQuestions; ?>
  </td>
</tr>

<?php
	}
?>

<tr>
  <td>&nbsp;</td>
  <td>
	<input type="submit" name="submitExercise" value="<?php echo get_lang('langOk'); ?>">
	<!-- &nbsp;&nbsp;<input type="submit" name="cancelExercise" value="<?php echo get_lang('langCancel'); ?>" onclick="javascript:if(!confirm('<?php echo addslashes(htmlspecialchars(get_lang('langConfirmYourChoice'))); ?>')) return false;"> //-->
  </td>
</tr>
</table>
</form>

<?php
}
else
{
?>

<h3>
  <?php
  $exerciseTitle = api_parse_tex($exerciseTitle);
  echo $exerciseTitle; ?>
  <?php if(!empty($exerciseSound)): ?>
  <a href="../document/download.php?doc_url=%2Faudio%2F<?php echo $exerciseSound; ?>" target="_blank"><img src="../img/wav.gif" border="0" align="absmiddle" alt="<?php echo get_lang('langSound'); ?>"></a>
  <?php endif; ?>
</h3>

<blockquote>
  <?php
  $exerciseDescription = api_parse_tex($exerciseDescription);
  echo $exerciseDescription; ?>
</blockquote>

<a href="<?php echo $_SERVER['PHP_SELF']; ?>?modifyExercise=yes"><img src="../img/edit.gif" border="0" align="absmiddle" alt="<?php echo get_lang('langModify'); ?>"></a>

<?php
}
?>
