<?php // $Id: exercice_submit.php,v 1.38 2005/06/28 22:24:43 yannoo Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Denes Nagy

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
	EXERCISE SUBMISSION
 *
 * This script allows to run an exercise. According to the exercise type, questions
 * can be on an unique page, or one per page with a Next button.
 *
 * One exercise may contain different types of answers (unique or multiple selection,
 * matching and fill in blanks).
 *
 * Questions are selected randomly or not.
 *
 * When the user has answered all questions and clicks on the button "Ok",
 * it goes to exercise_result.php
 *
 * Notice : This script is also used to show a question before modifying it by
 * the administrator
 *
 *	@author Olivier Brouckaert
 *	@package dokeos.exercise
==============================================================================
 */
include('exercise.class.php');
include('question.class.php');
include('answer.class.php');

include('exercise.lib.php');

// --------------------------------------------------langvars added by MArk111 - to be moved to lang file
/*$max_passNegResp ='Number of passages excided max number. You may try another quiz.';
$negResp ='Click';
$negRespSec = 'here';
$negRespExt = 'to continue';
$max_passage = 'Passage';
$max_outOf ='out of';
$timed_passNegResp = 'Out of the time limit for this quiz.';*/



// debug var. Set to 0 to hide all debug display. Set to 1 to display debug messages.
$debug = 0;

// answer types
define('UNIQUE_ANSWER',	1);
define('MULTIPLE_ANSWER',	2);
define('FILL_IN_BLANKS',	3);
define('MATCHING',		4);
define('FREE_ANSWER', 5);

$langFile='exercice';

include_once('../inc/claro_init_global.inc.php');

include_once(api_get_library_path().'/text.lib.php');

$is_allowedToEdit=$is_courseAdmin;

$TBL_EXERCICE_QUESTION = $_course['dbNameGlu'].'quiz_rel_question';
$TBL_EXERCICES         = $_course['dbNameGlu'].'quiz';
$TBL_QUESTIONS         = $_course['dbNameGlu'].'quiz_question';
$TBL_REPONSES          = $_course['dbNameGlu'].'quiz_answer';
// -------------------------------------------------------------------- added by MArk111
 $TBL_EXERCICE_TRACKING = Database::get_statistic_database().Database::get_database_glue().'track_e_exercices'; //tracking table : number of passages


// general parameters passed via POST/GET
if ( empty ( $origin ) ) {
    $origin = $_REQUEST['origin'];
}
if ( empty ( $learnpath_id ) ) {
    $learnpath_id       = mysql_real_escape_string($_REQUEST['learnpath_id']);
}
if ( empty ( $learnpath_item_id ) ) {
    $learnpath_item_id  = mysql_real_escape_string($_REQUEST['learnpath_item_id']);
}
if ( empty ( $formSent ) ) {
    $formSent       = $_REQUEST['formSent'];
}
if ( empty ( $exerciseResult ) ) {
    $exerciseResult = $_REQUEST['exerciseResult'];
}
if ( empty ( $exerciseType ) ) {
    $exerciseType = $_REQUEST['exerciseType'];
}
if ( empty ( $exerciseId ) ) {
    $exerciseId = $_REQUEST['exerciseId'];
}
if ( empty ( $choice ) ) {
    $choice = $_REQUEST['choice'];
}
if ( empty ( $questionNum ) ) {
    $questionNum    = mysql_real_escape_string($_REQUEST['questionNum']);
}
if ( empty ( $nbrQuestions ) ) {
    $nbrQuestions   = mysql_real_escape_string($_REQUEST['nbrQuestions']);
}
if ( empty ($buttonCancel) ) {
	$buttonCancel 	= $_REQUEST['buttonCancel'];
}

// if the user has clicked on the "Cancel" button
if($buttonCancel)
{
	// returns to the exercise list
	header("Location: exercice.php?origin=$origin&learnpath_id=$learnpath_id&learnpath_item_id=$learnpath_item_id");
	exit();
}




if ($origin=='builder') {
	/*******************************/
	/* Clears the exercise session */
	/*******************************/
	if(isset($_SESSION['objExercise']))		{ api_session_unregister('objExercise');	unset($objExercise); }
	if(isset($_SESSION['objQuestion']))		{ api_session_unregister('objQuestion');	unset($objQuestion); }
	if(isset($_SESSION['objAnswer']))		{ api_session_unregister('objAnswer');		unset($objAnswer);   }
	if(isset($_SESSION['questionList']))	{ api_session_unregister('questionList');	unset($questionList); }
	if(isset($_SESSION['exerciseResult']))	{ api_session_unregister('exerciseResult');	unset($exerciseResult); }
}

// if the user has submitted the form
if($formSent)
{
    if($debug>0){echo str_repeat('&nbsp;',0).'$formSent was set'."<br />\n";}

    // initializing
    if(!is_array($exerciseResult))
    {
        $exerciseResult=array();
    }

    // if the user has answered at least one question
    if(is_array($choice))
    {
        if($debug>0){echo str_repeat('&nbsp;',0).'$choice is an array'."<br />\n";}

        if($exerciseType == 1)
        {
            // $exerciseResult receives the content of the form.
            // Each choice of the student is stored into the array $choice
            $exerciseResult=$choice;
        }
        else
        {
            // gets the question ID from $choice. It is the key of the array
            list($key)=array_keys($choice);

            // if the user didn't already answer this question
            if(!isset($exerciseResult[$key]))
            {
                // stores the user answer into the array
                $exerciseResult[$key]=$choice[$key];
            }
        }
        if($debug>0){echo str_repeat('&nbsp;',0).'$choice is an array - end'."<br />\n";}
    }

    // the script "exercise_result.php" will take the variable $exerciseResult from the session
    api_session_register('exerciseResult');

    // if it is the last question (only for a sequential exercise)
    if($exerciseType == 1 || $questionNum >= $nbrQuestions)
    {
        if($debug>0){echo str_repeat('&nbsp;',0).'Redirecting to exercise_result.php - Remove debug option to let this happen'."<br />\n";}

        // goes to the script that will show the result of the exercise
        header("Location: exercise_result.php?origin=$origin&learnpath_id=$learnpath_id&learnpath_item_id=$learnpath_item_id");
        exit();
    }
    if($debug>0){echo str_repeat('&nbsp;',0).'$formSent was set - end'."<br />\n";}
} //-------------------------------------------------------------------------------------eo form sent



// if the object is not in the session
if(!isset($_SESSION['objExercise']))
{
    if($debug>0){echo str_repeat('&nbsp;',0).'$_SESSION[objExercise] was unset'."<br />\n";}
    // construction of Exercise
    $objExercise=new Exercise();

    #$sql="SELECT title,description,sound,type,random,active FROM `$TBL_EXERCICES` WHERE id='$exerciseId'";

    // if the specified exercise doesn't exist or is disabled
    if(!$objExercise->read($exerciseId) || (!$objExercise->selectStatus() && !$is_allowedToEdit && ($origin != 'learnpath') ))
    {
        die(get_lang('ExerciseNotFound'));
    }

    // saves the object into the session
    api_session_register('objExercise');
    if($debug>0){echo str_repeat('&nbsp;',0).'$_SESSION[objExercise] was unset - set now - end'."<br />\n";}

}

if(!is_object($objExercise))
{
	header('Location: exercice.php');
	exit();
}



$exerciseTitle=$objExercise->selectTitle();
$exerciseDescription=$objExercise->selectDescription();
$exerciseSound=$objExercise->selectSound();
$randomQuestions=$objExercise->isRandom();
$exerciseType=$objExercise->selectType();
// -----------------------------------------added by MArk111: timed&passages
$maxPassages=$objExercise->maxPassages();
$isTimed=$objExercise->getIsTimed();
$end_date=$objExercise->getEndDate();
$start_date=$objExercise->getStartDate();

if(!isset($_SESSION['questionList']))
{
    if($debug>0){echo str_repeat('&nbsp;',0).'$_SESSION[questionList] was unset'."<br />\n";}
    // selects the list of question ID
    $questionList = ($randomQuestions?$objExercise->selectRandomList():$objExercise->selectQuestionList());
    // saves the question list into the session
    api_session_register('questionList');
    if($debug>0){echo str_repeat('&nbsp;',0).'$_SESSION[questionList] was unset - set now - end'."<br />\n";}
}

$nbrQuestions=sizeof($questionList);

// if questionNum comes from POST and not from GET
if(!$questionNum || $_POST['questionNum'])
{
    // only used for sequential exercises (see $exerciseType)
    if(!$questionNum)
    {
        $questionNum=1;
    }
    else
    {
        $questionNum++;
    }
}

$nameTools=get_lang('Exercice');

$interbredcrump[]=array("url" => "exercice.php","name" => get_lang('Exercices'));

if ($origin != 'learnpath') { //so we are not in learnpath tool
	Display::display_header($nameTools,"Exercise");
}
else
{
	?>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-7" />
	<link rel="stylesheet" type="text/css" href="<?php echo api_get_path(WEB_CODE_PATH); ?>css/frames.css" />

<?php
}

 $exerciseTitle=api_parse_tex($exerciseTitle);

echo "<h3>".$exerciseTitle."</h3>";

if(!empty($exerciseSound))
{
	echo "<a href=\"../document/download.php?doc_url=%2Faudio%2F".$exerciseSound."\" target=\"_blank\">",
		"<img src=\"../img/sound.gif\" border=\"0\" align=\"absmiddle\" alt=",get_lang("Sound")."\" /></a>";
}


//-----------------------------------------------------------------------> entry point for checking
// 


// ------------- max passages
if ((1==0) && ($maxPassages !=0) && (!$is_courseAdmin)){// skip checking for unlimited passages (maxPassage==0) and for courseAdmin
  
  $sql = "SELECT  COUNT(`te`.`exe_weighting`) AS nrOfPassages
	FROM `$TBL_EXERCICES` AS ce ,  `$TBL_EXERCICE_TRACKING` AS te
	WHERE `te`.`exe_exo_id` = `ce`.`id` AND `te`.`exe_user_id`='$_uid' AND `te`.`exe_cours_id`='$_cid'";
  $query = api_sql_query($sql,__FILE__,__LINE__);
  $res = @mysql_fetch_array($query);

  $numberOfPassages = $res[0];

  if ($numberOfPassages >= $maxPassages){
       echo '<br>'.$max_passNegResp.'<br>';
       echo $negResp.' <a href="./exercice.php">'.$negRespSec.' </a>'.$negRespExt;
       exit();
  } else 
     echo $max_passage.' '.($numberOfPassages+1).' '.$max_outOf.' '.$maxPassages.' ';

} 

  // -----------timed ?
 $currentDate = date("Y-m-d H:i");
 if (($isTimed !=0) && (!$is_courseAdmin)){ //skip checking for not timed and for courseAdmin
    if(($currentDate<$start_date)||($currentDate>$end_date)) {
       echo '<br>'.$timed_passNegResp.'<br>';
       echo $negResp.' <a href="./exercice.php">'.$negRespSec.' </a>'.$negRespExt;
       exit();
    }
 }

// --------------------------------------------------------------------------------end of checking

$exerciseDescription = api_parse_tex($exerciseDescription);

$s="
<p>$exerciseDescription</p>
<table width='100%' border='0' cellpadding='1' cellspacing='0'>
 <form method='post' action='".$_SERVER['PHP_SELF']."?autocomplete=off'>
 <input type='hidden' name='formSent' value='1' />
 <input type='hidden' name='exerciseType' value='".$exerciseType."' />
 <input type='hidden' name='questionNum' value='".$questionNum."' />
 <input type='hidden' name='nbrQuestions' value='".$nbrQuestions."' />
 <input type='hidden' name='origin' value='".$origin."' />
 <input type='hidden' name='learnpath_id' value='".$learnpath_id."' />
 <input type='hidden' name='learnpath_item_id' value='".$learnpath_item_id."' />
 <tr>
  <td>
  <table width='100%' cellpadding='4' cellspacing='2' border='0'>";

echo $s;

$i=0;

foreach($questionList as $questionId)
{
	$i++;

	// for sequential exercises
	if($exerciseType == 2)
	{
		// if it is not the right question, goes to the next loop iteration
		if($questionNum != $i)
		{
			continue;
		}
		else
		{
			// if the user has already answered this question
			if(isset($exerciseResult[$questionId]))
			{
				// construction of the Question object
				$objQuestionTmp=new Question();

				// reads question informations
				$objQuestionTmp->read($questionId);

				$questionName=$objQuestionTmp->selectTitle();

				// destruction of the Question object
				unset($objQuestionTmp);

				echo '<tr><td>'.get_lang("AlreadyAnswered").' &quot;'.$questionName.'&quot;</td></tr>';

				break;
			}
		}
	}

	$s="<tr bgcolor='#e6e6e6'>
	 <td valign='top' colspan='2'>
		".get_lang('Question')." ";
	$s.=$i;
	if($exerciseType == 2) $s.=' / '.$nbrQuestions;
	$s.='</td></tr>';

	echo $s;

	// shows the question and its answers
	showQuestion($questionId, false, $origin);

	// for sequential exercises
	if($exerciseType == 2)
	{
		// quits the loop
		break;
	}
}	// end foreach()

$s="</table>
  </td>
 </tr>
 <tr>
  <td><br/>
	 <!-- <input type='submit' name='buttonCancel' value=".get_lang('Cancel')." />
   &nbsp;&nbsp; //-->
	 <input type='submit' value='";

  if ($exerciseType == 1 || $nbrQuestions == $questionNum) {
	$s.=get_lang('Ok');
  }
  else
  {
	$s.=get_lang('Next').' &gt;';
  }
  $s.='\'&gt;';
  $s.="</td></tr></form></table>";

$b=2;
echo $s;

if ($origin != 'learnpath') { //so we are not in learnpath tool
    Display::display_footer();
} else {
	?>
	<link rel="stylesheet" type="text/css" href="<?php echo $clarolineRepositoryWeb ?>css/frames.css" />
<?php
}
?>
