<?php // $Id: index.php,v 1.45 2005/07/07 14:55:34 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software
	
	Copyright (c) Jan Bols

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
 * Dropbox module for Claroline
 * GUI interface page for Dropbox. This contains the upload form and the sent and received files list
 *
 * 1. Initialises vars and check installed tables
 * 2. Form upload
 * 3. Received & sent lists
 *
 * RH: Mailing: this form is called with ?mailing=pseudo_id for detail window
 *
 * @version 1.21
 * @copyright 2004-2005
 * @author Jan Bols <jan@ivpv.UGent.be>, main programmer
 * @author Ren Haentjens <rene.haentjens@UGent.be>, several contributions  (see RH)
 * @author Roan Embrechts, virtual course support
 *
 * @package dokeos.dropbox
==============================================================================
 */

/*
==============================================================================
		INITIALISING VAR & CHECKING DROPBOX INSTALLATION
==============================================================================
*/ 
require_once( "dropbox_init1.inc.php");
require_once(api_get_library_path().'/tablesort.lib.php');

/*
* Check if the dropbox tables are installed in the DB and that the correct fields are installed
	--> not needed anymore, because tables are created during course creation or dokeos update
*/
/*if ( api_sql_query( "SELECT last_upload_date FROM `" . dropbox_cnf("fileTbl") . "`") == FALSE)
{
	if ( api_sql_query( "SELECT id FROM `" . dropbox_cnf("fileTbl") . "`") == FALSE)
	{
		//the dropbox_file table doesn't exist yet, so create all dropbox tables
	    api_sql_query( "CREATE TABLE `" . dropbox_cnf("fileTbl") . "` (
	  					`id` int(11) unsigned NOT NULL auto_increment,
	  					`uploader_id` int(11) unsigned NOT NULL default '0',
						`filename` varchar(250) NOT NULL default '',
						`filesize` int(11) unsigned NOT NULL default '0',
						`title` varchar(250) default '',
						`description` varchar(250) default '',
						`author` varchar(250) default '',
						`upload_date` datetime NOT NULL default '0000-00-00 00:00:00',
						`last_upload_date` datetime NOT NULL default '0000-00-00 00:00:00',
						PRIMARY KEY  (`id`),
						UNIQUE KEY `UN_filename` (`filename`)
						)") or die( dropbox_lang("installError")." (code 301)");
	    api_sql_query( "CREATE TABLE `" . dropbox_cnf("postTbl") . "` (
	  					`file_id` int(11) unsigned NOT NULL default '0',
	  					`dest_user_id` int(11) unsigned NOT NULL default '0',
    					`feedback_date` datetime NOT NULL default '0000-00-00 00:00:00',  // RH: Feedback
    					`feedback` text default '',                                      // RH: Feedback
	  					PRIMARY KEY  (`file_id`,`dest_user_id`)
						)") or die( dropbox_lang("installError")." (code 302)");
	    api_sql_query( "CREATE TABLE `" . dropbox_cnf("personTbl") . "` (
	  					`file_id` int unsigned NOT NULL default '0',
	  					`user_id` mediumint unsigned NOT NULL default '0',
	  					PRIMARY KEY  (`file_id`,`user_id`)
						)") or die( dropbox_lang("installError")." (code 303)");
	} else {
		//the dropbox_file table exists, but not the last_upload_date field
		api_sql_query( "ALTER TABLE `" . dropbox_cnf("fileTbl") . "` ADD COLUMN
						`last_upload_date` datetime NOT NULL default '0000-00-00 00:00:00'
	  					") or die( dropbox_lang("installError")." (code 305)");
		//update the last_upload_date field: set it equal to the upload_date field
		api_sql_query( "Update `" . dropbox_cnf("fileTbl") . "` SET last_upload_date = upload_date
	  					") or die( dropbox_lang("installError")." (code 306)");
	}

    /**
     * api_sql_query("INSERT INTO `".dropbox_cnf("introTbl")."` (id, intro_text)
     * VALUES (5001
     * , 'This page allows any student to send a document to a teacher and vice versa.'
     * )") or die( dropbox_lang("installError")." (code xxx)");
     *
}
*/

/*
*   new columns (1.30) // RH: Feedback
	--> not needed anymore, because tables are created during course creation or dokeos update
*
if ( api_sql_query( "SELECT feedback_date FROM `" . dropbox_cnf("postTbl") . "`") == FALSE)
{
	api_sql_query( "ALTER TABLE `" . dropbox_cnf("postTbl") . "` ADD COLUMN
					`feedback_date` datetime NOT NULL default '0000-00-00 00:00:00'
  					") or die( dropbox_lang("installError")." (code 307)");
	api_sql_query( "ALTER TABLE `" . dropbox_cnf("postTbl") . "` ADD COLUMN
					`feedback` text default ''
  					") or die( dropbox_lang("installError")." (code 308)");
}
*/

/*
* register use of tool in stats tables
*/
include_once(api_get_library_path().'/events.lib.inc.php');

event_access_tool(TOOL_DROPBOX);

/*
* get order status of sent list.
* The sessionvar sentOrder keeps preference of user to by what field to order the sent files list by
*/
if (isset($_GET["sentOrder"]) && in_array($_GET["sentOrder"], array("lastDate", "firstDate", "title", "size", "author", "recipient")))
{
    $sentOrder = $_GET["sentOrder"];
}
else
{
	if (isset($_SESSION["sentOrder"]) && in_array($_SESSION["sentOrder"], array("lastDate", "firstDate", "title", "size", "author", "recipient")))
	{
		$sentOrder = $_SESSION["sentOrder"];
	}
	else
	{
		$sentOrder = "lastDate"; //default sortorder value if nothing is specified
	}
}
api_session_register("sentOrder");


/*
* get order status of received list.
* The sessionvar receivedOrder keeps preference of user to by what field to order the received files list by
*/
if (isset($_GET["receivedOrder"]) && in_array($_GET["receivedOrder"], array("lastDate", "firstDate", "title", "size", "author", "sender")))
{
    $receivedOrder = $_GET["receivedOrder"];
}
else
{
	if (isset($_SESSION["receivedOrder"]) && in_array($_SESSION["receivedOrder"], array("lastDate", "firstDate", "title", "size", "author", "sender")))
	{
		$receivedOrder = $_SESSION["receivedOrder"];
	}
	else
	{
		$receivedOrder = "lastDate"; //default sortorder value if nothing is specified
	}
}
api_session_register("receivedOrder");

/*
* rest of variables
*/
require_once( "dropbox_class.inc.php");

if ( $_GET['mailing'])  // RH: Mailing detail window passes parameter
{
	getUserOwningThisMailing($_GET['mailing'], $_uid, '304');  // RH or die
	$dropbox_person = new Dropbox_Person( $_GET['mailing'], $is_courseAdmin, $is_courseTutor);
	$mailingInUrl = "&mailing=" . urlencode( $_GET['mailing']);
}
else
{
	$dropbox_person = new Dropbox_Person( $_uid, $is_courseAdmin, $is_courseTutor);
	$mailingInUrl = "";
}
$dropbox_person->orderReceivedWork ($receivedOrder);
if( isset($_GET['dropbox_user_filter']) && $_GET['dropbox_user_filter'] != -1)
{
	$dropbox_person->filter_received_work('uploader_id',$_GET['dropbox_user_filter']);
}
$dropbox_person->orderSentWork ($sentOrder);

if (isset($_POST["feedbackid"]) && isset($_POST["feedbacktext"]))  // RH: Feedback
{
	$dropbox_person->updateFeedback ($_POST["feedbackid"], get_magic_quotes_gpc() ? 
	stripslashes($_POST["feedbacktext"]) : $_POST["feedbacktext"]);
}

/*
* create javascript and htmlHeaders  // RH: Mailing: new function confirmsend
*/
$javascript = "<script>
	function confirmsend ()
	{
		if (confirm(\"".dropbox_lang("mailingConfirmSend", "noDLTT")."\")){
			return true;
		} else {
			return false;
		}
		return true;
	}

	function confirmation (name)
	{
		if (confirm(\"".dropbox_lang("confirmDelete", "noDLTT")." : \"+ name )){
			return true;
		} else {
			return false;
		}
		return true;
	}

	function checkForm (frm)
	{
		if (frm.elements['recipients[]'].selectedIndex < 0){
			alert(\"".dropbox_lang("noUserSelected", "noDLTT")."\");
			return false;
		} else if (frm.file.value == '') {
			alert(\"".dropbox_lang("noFileSpecified", "noDLTT")."\");
			return false;
		} else {
			return true;
		}
	}
	";

if (dropbox_cnf("allowOverwrite"))
{
	$javascript .= "
		var sentArray = new Array(";	//sentArray keeps list of all files still available in the sent files list
										//of the user.
										//This is used to show or hide the overwrite file-radio button of the upload form
	for($i=0; $i<count($dropbox_person->sentWork); $i++)
	{
		if ($i > 0)
		{
		    $javascript .= ", ";
		}
		$javascript .= "'".$dropbox_person->sentWork[$i]->title."'";
	}
	$javascript .=");

		function checkfile(str)
		{

			ind = str.lastIndexOf('/'); //unix separator
			if (ind == -1) ind = str.lastIndexOf('\\\');	//windows separator
			filename = str.substring(ind+1, str.length);

			found = 0;
			for (i=0; i<sentArray.length; i++) {
				if (sentArray[i] == filename) found=1;
			}

			//always start with unchecked box
			el = getElement('cb_overwrite');
			el.checked = false;

			//show/hide checkbox
			if (found == 1) {
				displayEl('overwrite');
			} else {
				undisplayEl('overwrite');
			}
		}

		function getElement(id)
		{
			return document.getElementById ? document.getElementById(id) :
			document.all ? document.all(id) : null;
		}

		function displayEl(id)
		{
			var el = getElement(id);
			if (el && el.style) el.style.display = '';
		}

		function undisplayEl(id)
		{
			var el = getElement(id);
			if (el && el.style) el.style.display = 'none';
		}";
}

$javascript .="
	</script>";

$htmlHeadXtra[] = $javascript;
api_session_register('javascript');

$htmlHeadXtra[] = '<meta http-equiv="cache-control" content="no-cache">
	<meta http-equiv="pragma" content="no-cache">
	<meta http-equiv="expires" content="-1">';




require_once( "dropbox_init2.inc.php");

/*
-----------------------------------------------------------
	Introduction section
	(editable by course admins)
-----------------------------------------------------------
*/
if (!$_GET['mailing']) api_introductionsection(TOOL_DROPBOX);


$dropbox_unid = md5( uniqid( rand( ), true));	//this var is used to give a unique value to every
												//page request. This is to prevent resubmiting data

/*
==============================================================================
		FORM UPLOAD FILE
==============================================================================
*/ 
if ( $_GET['mailing']) {
// RH: Mailing detail: no form upload
	echo "<h3>", htmlspecialchars( getUserNameFromId ( $_GET['mailing'])), "</h3>";
	echo "<a href='index.php?".api_get_cidreq()."&origin=$origin'>".dropbox_lang("mailingBackToDropbox").'</a><br><br>';
} else {
	?>
	<form method="post" action="dropbox_submit.php?<?php echo "origin=$origin"; ?>" enctype="multipart/form-data" onsubmit="return checkForm(this)">
	<table border="0">
		<tr>
			<td  align="right">
				<?php echo dropbox_lang("uploadFile")?>:
			</td>
			<td>
				<input type="hidden" name="MAX_FILE_SIZE" value='<?php echo dropbox_cnf("maxFilesize")?>' />
				<input type="file" name="file" size="20" <?php if (dropbox_cnf("allowOverwrite")) echo 'onChange="checkfile(this.value)"'; ?> />
				<input type="hidden" name="dropbox_unid" value="<?php echo $dropbox_unid?>" />
				<?php
				if ($origin=='learnpath')
				{
					echo "<input type='hidden' name='origin' value='learnpath' />";
				}
				?>
			</td>
		</tr>
	<?php
	if (dropbox_cnf("allowOverwrite"))
	{
		?>
		<tr id="overwrite" style="display: none">
			<td valign="top"  align="right">
			</td>
			<td>
				<input type="checkbox" name="cb_overwrite" id="cb_overwrite" value="true" /><?php echo dropbox_lang("overwriteFile")?>
			</td>
		</tr>
		<?php
	}
	?>
		<tr>
			<td valign="top"  align="left">
				<?php echo dropbox_lang("authors")?>:
			</td>
			<td>
				<input type="text" name="authors" value="<?php echo getUserNameFromId( $_uid)?>" size="32" />
			</td>
		</tr>
		<tr>
			<td valign="top"  align="left">
				<?php echo dropbox_lang("description")?>:
			</td>
			<td>
				<textarea name="description" cols="24" rows="2"></textarea>
			</td>
		</tr>
		<tr>
			<td valign="top"  align="left">
				<?php echo dropbox_lang("sendTo")?>:
			</td>
			<td valign="top"  align="left">
				<select name="recipients[]" size="
	<?php
		if ( $dropbox_person -> isCourseTutor || $dropbox_person -> isCourseAdmin)
		{
			echo 5;
		}
		else
		{
			echo 3;
		}
	?>" multiple style="width: 220px;">
	<?php
	
	//list of all users in this course and all virtual courses combined with it
	$complete_user_list_for_dropbox = CourseManager::get_real_and_linked_user_list($course_info);
	
	foreach ($complete_user_list_for_dropbox as $k => $e) 
	    $complete_user_list_for_dropbox[$k] = $e + 
	        array('lastcommafirst' => $e['lastname'] . ', ' . $e['firstname']);

	$complete_user_list_for_dropbox = TableSort::sort_table($complete_user_list_for_dropbox, 'lastcommafirst');
	
	/*
	*  if current user is a teacher then show all users of current course
	*
	if ( $dropbox_person -> isCourseTutor || $dropbox_person -> isCourseAdmin
			|| dropbox_cnf("allowStudentToStudent"))  // RH: also if option is set
	{
		//list of all users in this course and all virtual courses combined with it
		$complete_user_list_for_dropbox = CourseManager::get_real_and_linked_user_list($course_info);
	}

	/*
	* if current user is student then show all teachers of current course
	*
	else
	{
		// select all the teachers except yourself
		$sql_query = "SELECT DISTINCT u.user_id , CONCAT(u.lastname,' ', u.firstname) AS name
							FROM `" . dropbox_cnf("userTbl") . "` u, `" . dropbox_cnf("courseUserTbl") . "` cu
							WHERE cu.course_code='" . dropbox_cnf("courseId") . "'
							AND cu.user_id=u.user_id
							AND (cu.status!=5 OR cu.tutor_id=1)
							AND u.user_id != '" . $_uid . "'
							ORDER BY UPPER(u.lastname), UPPER(u.firstname)";
		$sql_result = api_sql_query($sql_query,__FILE__,__LINE__);
		while ( $result = mysql_fetch_array($sql_result) )
		{
			$complete_user_list_for_dropbox[] = $result;
		}
	}*/

	/*
		Create the options inside the select box:
		List all selected users their user id as value and a name string as display
	*/
	foreach ($complete_user_list_for_dropbox as $current_user)
	{
		if ( ($dropbox_person -> isCourseTutor 
		|| $dropbox_person -> isCourseAdmin
		|| dropbox_cnf("allowStudentToStudent")	// RH: also if option is set
		|| $current_user['status']!=5				// always allow teachers
		|| $current_user['tutor_id']==1				// always allow tutors	
		) && $current_user['user_id'] != $_uid ) 	// don't include yourself
		{
			$full_name = $current_user['lastcommafirst'];
			echo '<option value="user_' . $current_user['user_id'] . '">' . $full_name . '</option>';
		}
	}
	
	/*
	* Show groups
	*/
    if ( ($dropbox_person -> isCourseTutor || $dropbox_person -> isCourseAdmin) 
    && dropbox_cnf("allowGroup") || dropbox_cnf("allowStudentToStudent"))  
    {
		$complete_group_list_for_dropbox = GroupManager::get_group_list(null,dropbox_cnf("courseId"));
		
		if (count($complete_group_list_for_dropbox) > 0) 
		{
			foreach ($complete_group_list_for_dropbox as $current_group) 
			{
				if ($current_group['number_of_members'] > 0) 
				{
					echo '<option value="group_'.$current_group['id'].'">G: '.$current_group['name'].' - '.$current_group['number_of_members'].' '.$langUsers.'</option>';
				}
			}
		}
    }

    if ( ($dropbox_person -> isCourseTutor || $dropbox_person -> isCourseAdmin) && dropbox_cnf("allowMailing"))  // RH: Mailing starting point
	{
			echo '<option value="mailing">'.dropbox_lang("mailingInSelect").'</option>';
	}

    if ( dropbox_cnf("allowJustUpload"))  // RH
    {
	  echo '<option value="upload">'.dropbox_lang("justUploadInSelect").'</option>';
    }

	echo "</select>",
		"</td></tr>", 
		"<tr><td></td>",
		"<td><input type=\"Submit\" name=\"submitWork\" value=\"".dropbox_lang("ok", "noDLTT")."\" />",
		"</td></tr>",
		"</table>",
		"</form>";
}  // RH: Mailing: end of 'Mailing detail: no form upload'

/*
==============================================================================
		FILES LIST
==============================================================================
*/ 

echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">",
	"<tr>",
	"<td valign=\"top\" align=\"center\">";

/*
-----------------------------------------------------------
	RECEIVED FILES LIST:  TABLE HEADER
-----------------------------------------------------------
*/ 
if ( !$_GET['mailing'])  // RH: Mailing detail: no received files
{
	?>
			<table cellpadding="5" cellspacing="1" border="0" width="100%">
				<tr class="cell_header">
					<td colspan="2">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td>
								<form name="formReceived" method="get" action="index.php?<?php echo "origin=$origin"; ?>">
								  <span class="dropbox_listTitle"><?php echo dropbox_lang("orderBy")?></span>
						  		  <?php if ($origin=='learnpath') { echo "<input type='hidden' name='origin' value='learnpath'>"; } ?>
								  <select name="receivedOrder" onchange="javascript: this.form.submit()">
								    <option value="lastDate" <?php if ($receivedOrder=="lastDate") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("lastDate")?></option>
								    <?php if (dropbox_cnf("allowOverwrite")) { ?>
								    <option value="firstDate" <?php if ($receivedOrder=="firstDate") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("firstDate")?></option>
								    <?php } ?>
								    <option value="title" <?php if ($receivedOrder=="title") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("title")?></option>
								    <option value="size" <?php if ($receivedOrder=="size") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("size")?></option>
								    <option value="author" <?php if ($receivedOrder=="author") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("author")?></option>
								    <option value="sender" <?php if ($receivedOrder=="sender") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("sender")?></option>
								  </select>
								   <span class="dropbox_listTitle"><?php echo dropbox_lang('sentBy'); ?></span>
								  <select name="dropbox_user_filter" onchange="javascript: this.form.submit()">
								  <option value="-1"><?php echo get_lang('All'); ?></option>
								  <?php
								  	foreach ($complete_user_list_for_dropbox as $current_user)
									{
										$full_name = $current_user['lastcommafirst'];
										echo '<option value="' . $current_user['user_id'] . '"'.($_GET['dropbox_user_filter'] == $current_user['user_id'] ? 'selected="selected"' : '').'>' . $full_name . '</option>';
									}
								  ?>
								  </select>
								  <noscript><input type="submit" value="OK"/></noscript>
								</form>
								</td>
								<td align="right"><div class="dropbox_listTitle"><?php echo strtoupper( dropbox_lang("receivedTitle"))?></div></td>
								<td align="right" width="30px">
									<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&deleteReceived=all&dropbox_unid=<?php echo urlencode( $dropbox_unid)?>"
										onClick="return confirmation('<?php echo addslashes( dropbox_lang("all", "noDLTT"))?>');">
									<img src="../img/delete.gif" border="0" title="<?php echo get_lang("Delete"); ?>" alt="" /></a>
									<?php if ($origin=='learnpath') { echo "<input type='hidden' name='origin' value='learnpath' />"; } ?>
								</td>
			  				</tr>
						</table>
		  			</td>
				</tr>
	<?php

/*
-----------------------------------------------------------
	RECEIVED FILES LIST
-----------------------------------------------------------
*/ 

$numberDisplayed = count($dropbox_person -> receivedWork);  // RH
$i = 0;

// RH: Feedback: pencil for Give/Edit Feedback, UI rearranged, feedback added
  
foreach ( $dropbox_person -> receivedWork as $w)
{
	if ( $w -> uploader_id == $_uid)  // RH: justUpload
	{
		$numberDisplayed -= 1; continue;
	}
    ?>

					<tr class="cell_header">
					<td valign="top" algin="left" width="25">
						<a href="dropbox_download.php?<?php echo api_get_cidreq()."&origin=$origin"; ?>&id=<?php echo urlencode($w->id)?>">
							<img  src="../img/travaux.gif" border="0" alt="" /></a>
					</td>
					<td valign="top" align="left">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td valign="top">
									<a href="dropbox_download.php?<?php echo api_get_cidreq()."&origin=$origin"; ?>&id=<?php echo urlencode($w->id)?>">
										<?php echo $w -> title?></a> <span class="dropbox_detail">(<?php echo ceil(($w->filesize)/1024)?> kB)</span>
								</td>
								<td align="right" valign="top">
									<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&editFeedback=<?php echo urlencode($w->id)?>&dropbox_unid=<?php echo urlencode($dropbox_unid)?>">
										<img src="../img/comment.gif" border="0" title="<?php echo dropbox_lang("giveFeedback", "noDLTT"); ?>" alt="" /></a>
									<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&deleteReceived=<?php echo urlencode($w->id)?>&dropbox_unid=<?php echo urlencode($dropbox_unid)?>"
										onClick='return confirmation("<?php echo htmlspecialchars($w->title, ENT_COMPAT)?>");'>
										<img src="../img/delete.gif" border="0" title="<?php echo $langDelete; ?>" alt="" /></a>
								</td>
							</tr>
							<tr><td>
						<?php
    if ( $w -> author != '')  //only show if filled in in DB
    {
                        ?>  <span class="dropbox_detail"><?php echo dropbox_lang("authors").': '.$w -> author?></span><br>
						<?php
    }
    if ( $w -> description != '')
    {
                        ?>  <span class="dropbox_detail"><?php echo dropbox_lang("description").': '.$w -> description?></span><br>
						<?php
    }
                        ?>  <span class="dropbox_detail"><?php echo dropbox_lang("sentBy")?> <span class="dropbox_person"><?php echo $w -> uploaderName?></span> <?php echo dropbox_lang("sentOn")?> <span class="dropbox_date"><?php echo $w -> upload_date?></span></span>
						<?php
	if ($w -> upload_date != $w->last_upload_date)
	{
                    	?>  <br>
                    	    <span class="dropbox_detail"><?php echo dropbox_lang("lastUpdated")?> <span class="dropbox_date"><?php echo $w->last_upload_date?></span></span>
                        <?php
	}
                        ?>
                            </td>
                            <td align="right">
						<?php
	if (($fbtext = $w -> feedback))
	{
                    	?>  <div class="dropbox_feedback"><?php echo dropbox_lang("sentOn")?> <span class="dropbox_date">
                    	    <?php echo htmlspecialchars($w->feedback_date), ':</span><br>', 
                    	        nl2br(htmlspecialchars($fbtext)); ?>
                    	    </div>
                        <?php
	}
                        ?>
                            </td></tr>
						</table>
					</td>
				</tr>
	<?php
    $i++;
} //end of foreach
if ( $numberDisplayed == 0)
{  // RH
    ?>
				<tr>
					<td align="center"><?php echo dropbox_lang("tableEmpty")?>
					</td>
				</tr>
	<?php
}

?>

			</table>
			<br>

	<?php
}  // RH: Mailing: end of 'Mailing detail: no received files'

/**
 * --------------------------------------
 * SENT FILES LIST:  TABLE HEADER
 * --------------------------------------
 */
?>
			<table cellpadding="5" cellspacing="1" border="0" width="100%">
				<tr class="cell_header">
					<td colspan="2">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td>
								<form name="formSent" method="get" action="index.php?<?php echo "origin=$origin"; ?>">
								  <?php if ($origin=='learnpath') { echo "<input type='hidden' name='origin' value='learnpath' />"; } ?>
								  <span class="dropbox_listTitle"><?php echo dropbox_lang("orderBy")?></span>
								  <select name="sentOrder" onchange="javascript: this.form.submit()">
								    <option value="lastDate" <?php if ($sentOrder=="lastDate") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("lastDate")?></option>
								    <?php if (dropbox_cnf("allowOverwrite")) { ?>
									<option value="firstDate" <?php if ($sentOrder=="firstDate") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("firstDate")?></option>
									<?php } ?>
								    <option value="title" <?php if ($sentOrder=="title") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("title")?></option>
								    <option value="size" <?php if ($sentOrder=="size") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("size")?></option>
								    <option value="author" <?php if ($sentOrder=="author") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("author")?></option>
								    <option value="recipient" <?php if ($sentOrder=="recipient") {
								                                   echo "selected";
								                               }?>><?php echo dropbox_lang("recipient")?></option>
								  </select>
								  <noscript><input type="submit" value="OK"/></noscript>
								</form>
								</td>
								<td align="right"><div class="dropbox_listTitle"><?php echo strtoupper( dropbox_lang("sentTitle"))?></div></td>
								<td align="right" width="30px">
<!--	Users cannot delete their own sent files
								<img src="shim.gif" width="20" height="20" border="0">
-->

								<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&deleteSent=all&dropbox_unid=<?php echo urlencode( $dropbox_unid).$mailingInUrl?>"
											onClick="return confirmation('<?php echo addslashes( dropbox_lang("all", "noDLTT"))?>');">
									<img src="../img/delete.gif" border="0" title="<?php echo $langDelete; ?>" alt="" /></a>
<!--	-->
 								</td>
			  				</tr>
						</table>
		  			</td>
				</tr>

<?php

/**
 * --------------------------------------
 * SENT FILES LIST
 * --------------------------------------
 */
$i = 0;

// RH: Feedback: UI rearranged, feedback added
  
foreach ( $dropbox_person -> sentWork as $w)
{
	$langSentTo = dropbox_lang("sentTo", "noDLTT") . '&nbsp;';  // RH: Mailing: not for unsent

	// RH: Mailing: clickable folder image for detail

	if ( $w->recipients[0]['id'] > dropbox_cnf("mailingIdBase"))
	{
		$ahref = "index.php?".api_get_cidreq()."&origin=$origin&mailing=" . urlencode($w->recipients[0]['id']);
		$imgsrc = '../img/folder.gif';
	}
	else
	{
		$ahref = "dropbox_download.php?".api_get_cidreq()."&origin=$origin&id=" . urlencode($w->id) . $mailingInUrl;
		$imgsrc = '../img/travaux.gif';
	}
?>
				<tr>
					<td valign="top" algin="left"  width="25">
						<a href="<?php echo $ahref?>">
							<img  src="<?php echo $imgsrc?>" border="0" alt="" /></a>
					</td>
					<td valign="top" align="left">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td valign="top">
									<a href="<?php echo $ahref?>">
										<?php echo $w -> title?></a> <span class="dropbox_detail">(<?php echo ceil(($w->filesize)/1024)?> kB)</span>
								</td>
								<td align="right" valign="top">

<?php  // RH: Mailing: clickable images for examine and send
if ( $w->recipients[0]['id'] == $_uid)
{
	$langSentTo = dropbox_lang("justUploadInList", "noDLTT") . '&nbsp;';  // RH: justUpload
}
elseif ( $w->recipients[0]['id'] > dropbox_cnf("mailingIdBase"))
{
?>
									<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&mailingIndex=<?php echo urlencode( $i)?>&dropbox_unid=<?php echo urlencode( $dropbox_unid).$mailingInUrl?>">
										<img src="../img/checkzip.gif" border="0" title="<?php echo dropbox_lang("mailingExamine", "noDLTT")?>" alt="" /></a>
<?php  // RH: Mailing: filesize is set to zero on send, allow no 2nd send!
	if ( $w->filesize != 0)
	{
		$langSentTo = '';  // unsent: do not write 'Sent to'
?>
									<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&mailingIndex=<?php echo urlencode( $i)?>&mailingSend=yes&dropbox_unid=<?php echo urlencode( $dropbox_unid).$mailingInUrl?>"
										onClick='return confirmsend();'>
										<img src="../img/sendzip.gif" border="0" title="<?php echo dropbox_lang("mailingSend", "noDLTT")?>" alt="" /></a>
<?php  // RH: Mailing: end of 'clickable images for examine and send'
	}
}


// RH: Feedback

$lastfeedbackdate = ''; $lastfeedbackfrom = '';
foreach ($w -> recipients as $r) if (($fb = $r["feedback"]))
    if ($r["feedback_date"] > $lastfeedbackdate)
    {
        $lastfeedbackdate = $r["feedback_date"]; $lastfeedbackfrom = $r["name"];
    }

if ($lastfeedbackdate)
{
?>
									<span class="dropbox_feedback" title="<?php echo $lastfeedbackfrom; ?>"><?php echo $lastfeedbackdate; ?></span>
                                    <a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&showFeedback=<?php echo urlencode($w->id)?>&dropbox_unid=<?php echo urlencode($dropbox_unid)?>">
										<img src="../img/comment.gif" border="0" alt=""  title="<?php echo dropbox_lang("showFeedback", "noDLTT"); ?>"/></a>
<?php
}
?>
									<a href="dropbox_submit.php?<?php echo "origin=$origin"; ?>&deleteSent=<?php echo urlencode($w->id)?>&dropbox_unid=<?php echo urlencode($dropbox_unid) . $mailingInUrl?>"
										onClick='return confirmation("<?php echo htmlspecialchars($w->title, ENT_COMPAT)?>");'>
										<img src="../img/delete.gif" border="0" title="<?php echo $langDelete; ?>" alt="" /></a>
        					</td>
        				</tr>
        				<tr><td>
        				<?php
    if ( $w -> author != '')  //only show if filled in in DB
    {
                        ?>  <span class="dropbox_detail"><?php echo dropbox_lang("authors").': '.$w -> author?></span><br>
						<?php
    }
    if ( $w -> description != '')
    {
                        ?>  <span class="dropbox_detail"><?php echo dropbox_lang("description").': '.$w -> description?></span><br>
						<?php
    }
                            echo '<span class="dropbox_detail">', $langSentTo, '<span class="dropbox_person">';
                        	foreach( $w -> recipients as $r){ echo $r["name"], ', '; }
                        	echo '</span>', dropbox_lang("sentOn"), ' <span class="dropbox_date">', $w -> upload_date, '</span></span>';
                    	
	if ($w -> upload_date != $w->last_upload_date)
	{
                    	?>  <br>
                    	    <span class="dropbox_detail"><?php echo dropbox_lang("lastResent")?> <span class="dropbox_date"><?php echo $w->last_upload_date?></span></span>
						<?php
	}
                        ?>
                        </td>
                        <td align="right">
                            <div class="dropbox_feedback">&nbsp;</div>
                        </td>
                        </tr>
						</table>
					</td>
				</tr>

	<?php
    $i++;
} //end of foreach

if (count($dropbox_person -> sentWork)==0) 
{
	echo "<tr>",
			"<td align=\"center\">",dropbox_lang("tableEmpty"),
			"</td>",
			"</tr>";
}

echo "</table>",

	"</td>",
	"</tr>",
	"</table>";

if ($origin != 'learnpath')
{
	//we are not in the learning path tool
	Display::display_footer();
}
?>
