<?php // $Id: dropbox_init2.inc.php,v 1.21 2005/05/19 13:41:09 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software
	
	Copyright (c) Jan Bols
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
 * Dropbox module for Claroline
 * Second part of initialisation file with output.
 * This must be used after all session registration and headers.
 *
 * 1. Headers & title
 * 2. Introduction section
 * 3. Authorisation
 *
 * @version 1.21
 * @copyright 2004-2005
 * @author Jan Bols <jan@ivpv.UGent.be>, main programmer
 * @author Ren Haentjens <rene.haentjens@UGent.be>, several contributions (see RH)
 * @author Roan Embrechts, virtual course support
 * @author Patrick Cool <patrick.cool@UGent.be>, Ghent University: refactoring and tool introduction
 * @package dokeos.dropbox
==============================================================================
 */

/*
==============================================================================
		HEADER & TITLE
==============================================================================
*/ 

$nameTools = dropbox_lang("dropbox", "noDLTT");

if ($origin != 'learnpath')
{
    Display::display_header($nameTools,"Dropbox");
}
else
{
	echo '<link rel="stylesheet" type="text/css" href="', 
	    api_get_path(WEB_CODE_PATH), 'css/default.css">', $javascript;
}

api_display_tool_title($nameTools);

/*
 * ========================================
 *         AUTHORISATION SECTION
 * ========================================
 * Prevents access of all users that are not course members
 */

if(! $is_allowed_in_course || ! $is_course_member)
{
	api_not_allowed();

	if ($origin != 'learnpath')
	{
		Display::display_footer();
	}

	exit();
}
?>