<?php // $Id: edit_document.php,v 1.80.2.2 2005/08/23 13:52:44 roane Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Roan Embrechts
	Copyright (c) Rene Haentjens (RH) (update 2004/09/30)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	This file allows editing documents.
*
*	Based on create_document, this file allows
*	- edit name
*	- edit comments
*	- edit metadata (requires a document table entry)  // RH: metadata
*	- edit html content (only for htm/html files)
*
*	For all files
*	- show editable name field
*	- show editable comments field
*	Additionally, for html and text files
*	- show RTE
*
*	Remember, all files and folders must always have an entry in the
*	database, regardless of wether they are visible/invisible, have
*	comments or not.
*
*	@package dokeos.document
==============================================================================
*/

/*
==============================================================================
		THIS PAGE SHOULD BE *COMPLETELY* REWRITTEN!!!
==============================================================================
*/



/*
==============================================================================
		INIT SECTION
==============================================================================
*/

$langFile = "document";

/*
------------------------------------------------------------------------------
	Included libraries
------------------------------------------------------------------------------
*/
include('../inc/claro_init_global.inc.php');

include(api_get_library_path().'/fileManage.lib.php');
include(api_get_library_path().'/fileUpload.lib.php');
include(api_get_library_path().'/events.lib.inc.php');
include(api_get_library_path().'/document.lib.php');

/*
------------------------------------------------------------------------------
	Constants & Variables
------------------------------------------------------------------------------
*/
$file = $_GET['file'];
//echo('file: '.$file.'<br>');
$doc=basename($file);
//echo('doc: '.$doc.'<br>');
$dir=$_GET['curdirpath'];
//echo('dir: '.$dir.'<br>');
$file_name = $doc;
//echo('file_name: '.$file_name.'<br>');

$baseServDir = api_get_path(SYS_COURSE_PATH);
$baseServUrl = $urlAppend."/";
$courseDir   = $_course['path']."/document";
$baseWorkDir = $baseServDir.$courseDir;
$group_document = false;
$langFile = "document";
$use_document_title = (get_setting('use_document_title')=='true')?true:false;
$noPHP_SELF=true;

/*
------------------------------------------------------------------------------
	Other init code
------------------------------------------------------------------------------
*/

/* please do not modify this dirname formatting */

if(strstr($dir,'..'))
{
	$dir='/';
}

if($dir[0] == '.')
{
	$dir=substr($dir,1);
}

if($dir[0] != '/')
{
	$dir='/'.$dir;
}

if($dir[strlen($dir)-1] != '/')
{
	$dir.='/';
}

$filepath=api_get_path('SYS_COURSE_PATH').$_course['path'].'/document'.$dir;

if(!is_dir($filepath))
{
	$filepath=api_get_path('SYS_COURSE_PATH').$_course['path'].'/document/';

	$dir='/';
}

/**************************************************/

$nameTools = get_lang('EditDocument');

$dbTable = Database::get_course_document_table();

if(isset($_SESSION['_gid']) && $_SESSION['_gid']!='')
{
	$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	$interbredcrump[]= array ("url"=>"../group/group_space.php?gidReq=".$_SESSION['_gid'], "name"=> get_lang('GroupSpace'));
	$group_document = true;
	$noPHP_SELF=true;
}

$interbredcrump[]=array("url"=>"./document.php?curdirpath=".urlencode($_GET['curdirpath']).$req_gid, "name"=> get_lang('Documents'));

$is_allowedToEdit = is_allowed_to_edit() || $_SESSION['group_member_with_upload_rights'];

if(!$is_allowedToEdit)
{
	api_not_allowed();
}

event_access_tool(TOOL_DOCUMENT);

/*
==============================================================================
	   MAIN TOOL CODE
==============================================================================
*/

/*
------------------------------------------------------------------------------
	General functions
------------------------------------------------------------------------------
*/

function display_title($file_name)
{
	api_display_tool_title(get_lang("EditDocument") . ": $file_name");
}

function show_table($content)
{
	echo "<table cellpadding=\"4\" width=\"100%\">";
	echo "<tr>";
	echo 	"<td bgcolor=\"#F5F5F5\">",
			"<!-- dialog box -->",
			$content,
			"</td>\n";
	echo "</tr>";
	echo "</table>";
}

/*
------------------------------------------------------------------------------
	Workhorse functions

	These do the actual work that is expected from of this tool, other functions
	are only there to support these ones.
------------------------------------------------------------------------------
*/

/**
	This function changes the name of a certain file.
	It needs no global variables, it takes all info from parameters.
	It returns nothing.
*/
function change_name($baseWorkDir, $sourceFile, $renameTo, $dir, $doc)
{
	//$debug_info .= "param : baseWorkDir = $baseWorkDir";
	//$debug_info .= "param from form: sourceFile = $sourceFile";
	//$debug_info .= "param from form: renameTo = $renameTo";
	//$debug_info .= "param from form: dir = $dir";
	//$debug_info .= "param from form: doc = $doc";
	//api_display_debug_info($debug_info);

	$file_name_for_change = $baseWorkDir.$dir.$sourceFile;

	//api_display_debug_info("call my_rename: params $file_name_for_change, $renameTo");

	$renameTo = my_rename($file_name_for_change, stripslashes($renameTo)); //fileManage API

	if ($renameTo)
	{
		if (isset($dir) && $dir != "")
		{
			$sourceFile = $dir.$sourceFile;
			$new_full_file_name = dirname($sourceFile)."/".$renameTo;
		}
		else
		{
			$sourceFile = "/".$sourceFile;
			$new_full_file_name = "/".$renameTo;
		}

		//DEBUG:
		//Display::display_normal_message("call update_db_info: params $sourceFile, $new_full_file_name");

		update_db_info("update", $sourceFile, $new_full_file_name); //fileManage API
		$name_changed = get_lang("ElRen");
		//Display::display_normal_message($name_changed); //main API
		$info_message = get_lang('fileModified');

		$GLOBALS['file_name'] = $renameTo;
		$GLOBALS['doc'] = $renameTo;

		return $info_message;
	}
	else
	{
		$dialogBox = get_lang('FileExists');

		/* return to step 1 */
		$rename = $sourceFile;
		unset($sourceFile);
	}
}


/*
------------------------------------------------------------------------------
	Code to change the comment
------------------------------------------------------------------------------
	Step 2. React on POST data
	(Step 1 see below)
*/
if (isset($_POST['newComment']))
{
	//to try to fix the path if it is wrong
	$commentPath = str_replace("//", "/", $_POST['commentPath']);

	$newComment = trim($_POST['newComment']); // remove spaces
	$newTitle = trim($_POST['newTitle']); // remove spaces
	// Check if there is already a record for this file in the DB

	$result = mysql_query ("SELECT * FROM $dbTable WHERE path='".$commentPath."'");

	while($row = mysql_fetch_array($result, MYSQL_ASSOC))
	{
		$attribute['path'      ] = $row['path'      ];
		$attribute['comment'   ] = $row['title'   ];
	}

	//Determine the correct query to the DB

	//new code always keeps document in database
	$query = "UPDATE $dbTable SET comment='".$newComment."', title='".$newTitle."' WHERE path='".$commentPath."'";
	mysql_query($query);
	//this is an UPDATE page... we shouldn't be creating new documents here.
	/*
	if (mysql_affected_rows() == 0)
	{
		mysql_query("INSERT INTO $dbTable SET path='".$commentPath."', title='".$newTitle."', comment='".$newComment."'");
	}
	*/
	$oldComment = $newComment;
	$oldTitle = $newTitle;
	$comments_updated = get_lang('ComMod');
	$info_message = get_lang('fileModified');
}

/*
------------------------------------------------------------------------------
	Code to change the name
------------------------------------------------------------------------------
	Step 2. react on POST data - change the name
	(Step 1 see below)
*/

if (isset($_POST['renameTo']))
{
	$info_message = change_name($baseWorkDir, $_GET['sourceFile'], $_POST['renameTo'], $dir, $doc);
	//assume name change was successful
}

/*
------------------------------------------------------------------------------
	Code to change the comment
------------------------------------------------------------------------------
	Step 1. Create dialog box.
*/



/* Search the old comment */  // RH: metadata: added 'id,'
$result = mysql_query ("SELECT id,comment,title FROM $dbTable WHERE path='$dir$doc'");

$message = "<i>Debug info</i><br>directory = $dir<br>";
$message .= "document = $file_name<br>";
$message .= "comments file = " . $file . "<br>";
//Display::display_normal_message($message);

while($row = mysql_fetch_array($result, MYSQL_ASSOC))
{
	$oldComment = $row['comment'];
	$oldTitle = $row['title'];
	$docId = $row['id'];  // RH: metadata
}

/*
------------------------------------------------------------------------------
	WYSIWYG HTML EDITOR - Program Logic
------------------------------------------------------------------------------
*/

if($is_allowedToEdit)
{
	if($_POST['formSent']==1)
	{
		if(isset($_POST['renameTo']))
		{
			$_POST['filename']=$_POST['renameTo'];

			$extension=explode('.',$_POST['filename']);
			$extension=$extension[sizeof($extension)-1];

			$_POST['filename']=str_replace('.'.$extension,'',$_POST['filename']);
		}

		$filename=stripslashes($_POST['filename']);

		$texte=trim(str_replace(array("\r","\n"),"",stripslashes($_POST['texte'])));

		if(!strstr($texte,'/css/frames.css'))
		{
			$texte=str_replace('</title></head>','</title><link rel="stylesheet" href="./css/frames.css" type="text/css" /></head>',$texte);
		}

		// RH commented: $filename=replace_dangerous_char($filename,'strict');

		if($_POST['extension'] != 'htm' && $_POST['extension'] != 'html')
		{
			$extension='html';
		}
		else
		{
			$extension = $_POST['extension'];
		}

		$file=$dir.$filename.'.'.$extension;

		if(empty($texte))
		{
			$msgError=get_lang('NoText');
		}
		elseif(empty($filename))
		{
			$msgError=get_lang('NoFileName');
		}
		else
		{
			if($fp=@fopen($filepath.$filename.'.'.$extension,'w'))

			{
				//echo('file path: '.$filepath.$filename.'.'.$extension);
				$path_to_remove=api_get_path('WEB_COURSE_PATH').$_course['path'].'/document'.$dir;

				$texte=str_replace($path_to_remove,'./',$texte);

				$texte=str_replace('mp3player.swf?son='.urlencode($path_to_remove),'mp3player.swf?son=.%2F',$texte);
				//echo('texte: '.$texte);

				//echo (fputs($fp,$texte))?'FPUTS OK':'FPUTS NIET OK';
				fputs($fp,$texte);

				fclose($fp);

				if(!is_dir($filepath.'css'))
				{
					mkdir($filepath.'css',0777);

					$doc_id=add_document($_course,$dir.'css','folder',0,'css');

					item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'FolderCreated', $_uid);
					item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'invisible', $_uid);
				}

				if(!is_file($filepath.'css/frames.css'))
				{
					copy(api_get_path(SYS_CODE_PATH).'css/frames.css',$filepath.'css/frames.css');

					$doc_id=add_document($_course,$dir.'css/frames.css','file',filesize($filepath.'css/frames.css'),'frames.css');

					item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'DocumentAdded', $_uid);
					item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'invisible', $_uid);
				}

				// "WHAT'S NEW" notification: update table item_property (previously last_tooledit)
				$document_id = DocumentManager::get_document_id($_course,$file);
				if($document_id)
				{
					$file_size = filesize($filepath.$filename.'.'.$extension);
					update_existing_document($_course, $document_id,$file_size);
					item_property_update($_course, TOOL_DOCUMENT, $document_id, 'DocumentUpdated', $_uid);
					//update parent folders
					item_property_update_on_folder($_course,$dir,$_uid);
					header('Location: document.php?curdirpath='.urlencode($_GET['curdirpath']).$req_gid);
					exit();
				}
				else
				{
					//$msgError=get_lang('Impossible');
				}
			}
			else
			{
				$msgError=get_lang('Impossible');
			}
		}
	}
}

if(file_exists($filepath.$doc))
{
	$extension=explode('.',$doc);
	$extension=$extension[sizeof($extension)-1];

	$filename=str_replace('.'.$extension,'',$doc);

	$extension=strtolower($extension);

	if(!in_array($extension,array('html','htm')))
	{
		$extension=$filename=$texte='';
	}
	else
	{
		$texte=file($filepath.$doc);
		$texte=implode('',$texte);

		$path_to_append=api_get_path('WEB_COURSE_PATH').$_course['path'].'/document'.$dir;

		$texte=str_replace('="./','="'.$path_to_append,$texte);

		$texte=str_replace('mp3player.swf?son=.%2F','mp3player.swf?son='.urlencode($path_to_append),$texte);
	}
}


/*
==============================================================================
		MAIN EDIT_DOCUMENT CODE

		- react on input
		- display user interface
==============================================================================
*/
Display::display_header($nameTools,"Doc");


display_title($file_name);

if(isset($msgError))
{
	Display::display_normal_message($msgError); //main API
}
if( isset($info_message))
{
	Display::display_normal_message($info_message); //main API
}

/*
------------------------------------------------------------------------------
	WYSIWYG HTML Editor - GUI - display editor
------------------------------------------------------------------------------
*/
//show only if file is editable by the editor - text or html
?>

<br>

<form name="formEdit" action="<?php echo $_SERVER['PHP_SELF']; ?>?sourceFile=<?php echo urlencode($file_name); ?>&curdirpath=<?php echo urlencode($_GET['curdirpath']); ?>&file=<?php echo urlencode($_GET['file']); ?>&doc=<?php echo urlencode($doc); ?>" method="POST" style="margin:0px;" onsubmit="javascript:if(document.formEdit.texte.value.toLowerCase().indexOf('<html>') == -1) { document.formEdit.texte.value='&lt;html&gt;&lt;head&gt;&lt;title&gt;'+document.formEdit.renameTo.value+'&lt;/title&gt;&lt;/head&gt;&lt;body&gt;'+document.formEdit.texte.value+'&lt;/body&gt;&lt;/html&gt;'; }">

<?php
if($extension == "htm" || $extension == "html")
{
?>

<input type="hidden" name="formSent" value="1">

<?php
}
?>

<input type="hidden" name="filename" value="<?php echo htmlspecialchars($filename); ?>">
<input type="hidden" name="extension" value="<?php echo $extension; ?>">
<input type="hidden" name="file_path" value="<?php echo $_GET['file']; ?>">
<input type="hidden" name="commentPath" value="<?php echo $file; ?>">

<table border="0" cellpadding="5" cellspacing="0" width="100%">
<tr>
  <td width="5%" nowrap="nowrap"><?php echo get_lang('FileName'); ?> :</td>
  <td width="95%"><input type="text" size="20" name="renameTo" value="<?php echo htmlspecialchars($file_name); ?>" style="width:300px;"></td>
</tr>
<?php
if($use_document_title)
{
	?>
	<tr>
  		<td><?php echo get_lang('Title'); ?> :</td>
  		<td><input type="text" size="20" name="newTitle" value="<?php echo htmlspecialchars($oldTitle); ?>" style="width:300px;"></td>
	</tr>
	<?php
}

if($extension == "htm" || $extension == "html")
{
?>

<tr>
  <td colspan="2">

<script type="text/javascript">
<!--
_document_path='<?php echo api_get_path(SYS_COURSE_PATH).$_course['path'].'/document'.$dir; ?>';
//-->
</script>

<?php
    api_disp_html_area('texte',$texte,'400px');
?>

  </td>
</tr>

<?php
}

if(!$group_document)
{
?>

	<tr>
 	 <td width="5%" nowrap="nowrap"><?php echo get_lang('Metadata') ?> :</td>
  	<td width="95%"><a href="../metadata/index.php?eid=<?php echo urlencode('Document.'.$docId); ?>"><?php echo get_lang('AddMetadata') ?></a></td>
	</tr>

<?php
}
?>

<tr>
  <td width="5%" nowrap="nowrap"><?php echo get_lang('Comment'); ?> :</td>
  <td width="95%"><textarea rows="3" cols="20" name="newComment" wrap="virtual" style="width:300px;"><?php echo htmlspecialchars($oldComment); ?></textarea></td>
</tr>
<tr>
  <td colspan="2"><input type=submit value="<?php echo get_lang('Ok'); ?>"></td>
</tr>
</table>

</form>

<?php
/*
==============================================================================
	   DOKEOS FOOTER
==============================================================================
*/

Display::display_footer();
?>
