<?php // $Id: document.php,v 1.163.2.3 2005/08/12 09:35:18 roane Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* Main script for the documents tool
*
* This script allows the user to manage files and directories on a remote http server.
*
* The user can : - navigate through files and directories.
*				 - upload a file
*				 - delete, copy a file or a directory
*				 - edit properties & content (name, comments, html content)
*
* The script is organised in four sections.
*
* 1) Execute the command called by the user
*				Note: somme commands of this section are organised in two steps.
*			    The script always begins with the second step,
*			    so it allows to return more easily to the first step.
*
*				Note (March 2004) some editing functions (renaming, commenting)
*				are moved to a separate page, edit_document.php. This is also
*				where xml and other stuff should be added.
*
* 2) Define the directory to display
*
* 3) Read files and directories from the directory defined in part 2
* 4) Display all of that on an HTML page
*
* @todo eliminate code duplication between
* document/document.php, scormdocument.php
*
* @package dokeos.document
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/

$langFile = "document";
include("../inc/claro_init_global.inc.php");
include('document.inc.php');
api_protect_course_script();

$htmlHeadXtra[] =
"<script>
function confirmation (name)
{
	if (confirm(\" ". get_lang("AreYouSureToDelete") ." \"+ name + \" ?\"))
		{return true;}
	else
		{return false;}
}
</script>";

/*
-----------------------------------------------------------
	Variables
	- some need defining before inclusion of libraries
-----------------------------------------------------------
*/

//what's the current path?
//we will verify this a bit further down
if(isset($_GET['curdirpath']) && $_GET['curdirpath']!='')
{
	$curdirpath = $_GET['curdirpath'];
}
elseif (isset($_POST['curdirpath']) && $_POST['curdirpath']!='')
{
	$curdirpath = $_POST['curdirpath'];
}
else 
{
	$curdirpath = '/';
}
$curdirpathurl = urlencode($curdirpath);

$course_dir   = $_course['path']."/document";
$sys_course_path = api_get_path(SYS_COURSE_PATH);
$base_work_dir = $sys_course_path.$course_dir;
$http_www = api_get_path('WEB_COURSE_PATH').$_course['path'].'/document';
$dbl_click_id = 0; // used to avoid double-click

$is_allowed_to_edit = api_is_allowed_to_edit();
$group_member_with_upload_rights=false;

//if the group id is set, we show them group documents
if(isset($_SESSION['_gid']) && $_SESSION['_gid']!='') 
{
	//needed for group related stuff
	include_once(api_get_library_path() . "/groupmanager.lib.php");
	//get group info
	$group_properties = GroupManager::get_group_properties($_SESSION['_gid']);
	$noPHP_SELF=true;
	//let's assume the user cannot upload files for the group
	$group_member_with_upload_rights = false;
		
	if($group_properties['doc_state']==2) //documents are private
	{
		if($is_allowed_to_edit || GroupManager::is_subscribed($_uid,$_SESSION['_gid'])) //only courseadmin or group members allowed
		{
			$to_group_id = $_SESSION['_gid'];
			$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
			$interbredcrump[]= array ("url"=>"../group/group_space.php?gidReq=".$_SESSION['_gid'], "name"=> get_lang('GroupSpace'));
			//they are allowed to upload
			$group_member_with_upload_rights = true;
		}
		else
		{
			$to_group_id = 0;
			$req_gid = '';
		}
	}
	elseif($group_properties['doc_state']==1)  //documents are public
	{
		$to_group_id = $_SESSION['_gid'];
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
		$interbredcrump[]= array ("url"=>"../group/group_space.php?gidReq=".$_SESSION['_gid'], "name"=> get_lang('GroupSpace'));
		//allowed to upload?
		if($is_allowed_to_edit || GroupManager::is_subscribed($_uid,$_SESSION['_gid'])) //only courseadmin or group members can upload
		{
			$group_member_with_upload_rights = true;
		}
	}
	else //documents not active for this group
	{
		$to_group_id = 0;
		$req_gid = '';
	}
	$_SESSION['group_member_with_upload_rights'] = $group_member_with_upload_rights;
}
else 
{
	$to_group_id = 0;
	$req_gid = '';
}

/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
//the main_api.lib.php, database.lib.php and display.lib.php
//libraries are included by default

include_once(api_get_library_path() . "/fileDisplay.lib.php");
include_once(api_get_library_path() . "/events.lib.inc.php");
include_once(api_get_library_path() . "/document.lib.php");
include_once(api_get_library_path() . "/tablesort.lib.php");
if($is_allowed_to_edit)
{
	include_once(api_get_library_path() . "/fileUpload.lib.php");
}

//-----------------------------------------------------------
//check the path
//if the path is not found (no document id), set the path to /
if(!DocumentManager::get_document_id($_course,$curdirpath)){
	$curdirpath = '/';
	//urlencoded version
	$curdirpathurl = '%2F';
}
//if they are looking at group documents they can't see the root
if($to_group_id!=0 && $curdirpath=='/')
{
	$curdirpath = $group_properties['directory'];
	$curdirpathurl = urlencode($group_properties['directory']);
}
//-----------------------------------------------------------

/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/

$course_quota = DocumentManager::get_course_quota();

/*
==============================================================================
		MAIN SECTION
==============================================================================
*/

//-------------------------------------------------------------------//
if ($_GET['action']=="download")
{
	//check if the document is in the database
	if(!DocumentManager::get_document_id($_course,$_GET['id']))
	{
		//file not found!
		header("HTTP/1.0 404 Not Found");
		$error404 = '<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">';
		$error404 .= '<html><head>';
		$error404 .= '<title>404 Not Found</title>';
		$error404 .= '</head><body>';
		$error404 .= '<h1>Not Found</h1>';
		$error404 .= '<p>The requested URL was not found on this server.</p>';
		$error404 .= '<hr>';
		$error404 .= '</body></html>';
		echo($error404);
		exit;
	}
	// launch event
	event_download($_GET['id']);
	$doc_url=$_GET['id'];
	$full_file_name = $base_work_dir.$doc_url;
	DocumentManager::file_send_for_download($full_file_name,true);
	exit;
 }
//-------------------------------------------------------------------//

//download of an completed folder
if($_GET['action']=="downloadfolder")
{
	include('downloadfolder.inc.php');
}
//-------------------------------------------------------------------//

// slideshow inititalisation
$_SESSION["image_files_only"]="";
$image_files_only="";

/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/

$tool_name = get_lang("Doc"); // title of the page (should come from the language file)
Display::display_header($tool_name,"Doc");
$is_allowed_to_edit  = api_is_allowed_to_edit();



/*
 * Lib for event log, stats & tracking
 * plus record of the access
 */

event_access_tool(TOOL_DOCUMENT);

/*
==============================================================================
		DISPLAY
==============================================================================
*/
if($to_group_id !=0) //add group name after for group documents
{
	$add_group_to_title = ' ('.$group_properties['name'].')';
}
api_display_tool_title($tool_name.$add_group_to_title);

/*
-----------------------------------------------------------
	Introduction section
	(editable by course admins)
-----------------------------------------------------------
*/

api_introductionsection(TOOL_DOCUMENT);

/*============================================================================*/

if($is_allowed_to_edit || $group_member_with_upload_rights) // TEACHER ONLY
{

	/*======================================
				MOVE FILE OR DIRECTORY
	  ======================================*/

	if (isset($_GET['move']) && $_GET['move']!='')
	{
		if(DocumentManager::get_document_id($_course,$_GET['move']))
		{
			$folders = DocumentManager::get_all_document_folders($_course,$to_group_id,$is_allowed_to_edit || $group_member_with_upload_rights);
			Display::display_normal_message(build_move_to_selector($folders,$_GET['curdirpath'],$_GET['move'],$group_properties['directory']));
		}
	}
	
	if (isset($_POST['move_to']) && isset($_POST['move_file']))
	{
		include_once(api_get_library_path() . "/fileManage.lib.php");
		//this is needed for the update_db_info function
		//$dbTable = $_course['dbNameGlu']."document";
		$dbTable = Database::get_course_document_table();
		
		//security fix: make sure they can't move files that are not in the document table
		if(DocumentManager::get_document_id($_course,$_POST['move_file']))
		{
			//Display::display_normal_message('We want to move '.$_POST['move_file'].' to '.$_POST['move_to']);
			if ( move($base_work_dir.$_POST['move_file'],$base_work_dir.$_POST['move_to']) )
			{
				update_db_info("update", $_POST['move_file'], $_POST['move_to']."/".basename($_POST['move_file']));
				//set the current path
				$curdirpath = $_POST['move_to'];
				$curdirpathurl = urlencode($_POST['move_to']);
				Display::display_normal_message(get_lang('DirMv'));
			}
			else
			{
				Display::display_error_message(get_lang('Impossible'));
			}
		}
		else
		{
			Display::display_error_message(get_lang('Impossible'));
		}
	}


	/*======================================
			DELETE FILE OR DIRECTORY
	  ======================================*/

	if ( isset($_GET['delete']) )
	{	
		include_once(api_get_library_path() . "/fileManage.lib.php");
		if(DocumentManager::delete_document($_course,$_GET['delete'],$base_work_dir))
		{
			Display::display_normal_message(get_lang('DocDeleted'));
		}
		else 
		{
			Display::display_normal_message(get_lang('DocDeleteError'));
		}
	}


	/*======================================
	   		CREATE DIRECTORY
	  ======================================*/

	//create directory with $_POST data
	if(isset($_POST['create_dir']) && $_POST['dirname']!='')
	{
		//needed for directory creation
		include_once(api_get_library_path() . "/fileUpload.lib.php");
		$added_slash = ($curdirpath=='/')?'':'/';
		$dir_name = $curdirpath.$added_slash.replace_dangerous_char($_POST['dirname']);
		$created_dir = create_unexisting_directory($_course,$_uid,$to_group_id,$to_user_id,$base_work_dir,$dir_name,$_POST['dirname']);
		if($created_dir)
		{
			//Display::display_normal_message("<strong>".$created_dir."</strong> was created!");
			Display::display_normal_message('<span title="'.$created_dir.'">'.get_lang('DirCr').'</span>');
			//uncomment if you want to enter the created dir 
			//$curdirpath = $created_dir;
			//$curdirpathurl = urlencode($curdirpath);
		}
		else 
		{
			Display::display_error_message(get_lang('CannotCreateDir'));
		}
	}
	//show them the form for the directory name
	if(isset($_GET['createdir']))
	{
		//create the form that asks for the directory name
		$new_folder_text = '<form action="'.$_SERVER['PHP_SELF'].'" method="POST">';
		$new_folder_text .= '<input type="hidden" name="curdirpath" value="'.$curdirpath.'"/>';
		$new_folder_text .= get_lang('NewDir') .' ';
		$new_folder_text .= '<input type="text" name="dirname"/>';
		$new_folder_text .= '<input type="submit" name="create_dir" value="'.get_lang('Ok').'"/>';
		$new_folder_text .= '</form>';
		//show the form
		Display::display_normal_message($new_folder_text);
	}


	/*======================================
	   	  VISIBILITY COMMANDS
	  ======================================*/

	if ((isset($_GET['set_invisible']) && !empty($_GET['set_invisible'])) || (isset($_GET['set_visible']) && !empty($_GET['set_visible'])))
	{
		//make visible or invisible?
		if(isset($_GET['set_visible'])) 
		{
			$update_id = $_GET['set_visible'];
			$visibility_command = 'visible';
		}
		else 
		{
			$update_id = $_GET['set_invisible'];
			$visibility_command = 'invisible';
		}
		//update item_property to change visibility
		if(item_property_update($_course, TOOL_DOCUMENT, $update_id, $visibility_command, $_uid))
		{
			Display::display_normal_message(get_lang("ViMod"));
		}
		else
		{
			Display::display_error_message(get_lang("ViModProb"));
		}

	}
} // END is allowed to edit

/*
-----------------------------------------------------------
	GET ALL DOCUMENT DATA FOR CURDIRPATH
-----------------------------------------------------------
*/

$docs_and_folders = DocumentManager::get_all_document_data($_course,$curdirpath,$to_group_id,NULL,$is_allowed_to_edit || $group_member_with_upload_rights);

?>


<div id="folderselector">
<?php 
$folders = DocumentManager::get_all_document_folders($_course,$to_group_id,$is_allowed_to_edit || $group_member_with_upload_rights);
echo(build_directory_selector($folders,$curdirpath,$group_properties['directory']));
?>
</div>

<?php
	// Slideshow by Patrick Cool, May 2004
	include("document_slideshow.inc.php");
	// including the language file for the slideshow
	include(api_get_path(SYS_LANG_PATH).$languageInterface."/"."slideshow.inc.php");
	if ($image_present)
	{ 
		echo "<p><a href=\"slideshow.php?curdirpath=".$curdirpathurl."\">". get_lang('ViewSlideshow') . "</a></p>";
	}
?>

	<?php
	echo "<div id=\"doc_links\">";

	/* GO TO PARENT DIRECTORY */

	if ($curdirpath!= '/'&& $curdirpath!=$group_properties['directory'])
	{
	?>
		 <a href="<?php echo $_SERVER['PHP_SELF']; ?>?curdirpath=<?php echo urlencode((dirname($curdirpath)=='\\')?'/':dirname($curdirpath)) ?>">
				<img src="../img/parent.gif" border="0" align="absbottom" hspace="5" alt="" />
				<?php echo get_lang("Up"); ?></a>&nbsp;
	<?php
	}

	if ($is_allowed_to_edit || $group_member_with_upload_rights)
	{
		/* CREATE NEW DOCUMENT OR NEW DIRECTORY / GO TO UPLOAD / DOWNLOAD ZIPPED FOLDER */
		?>
			<!-- create new document or directory -->
			<a href="create_document.php?dir=<?php echo $curdirpathurl; ?>"><img src="../img/new_doc.gif" border="0" align="absmiddle" alt="" title="<?php echo get_lang("CreateDoc"); ?>"/></a>
			<a href="create_document.php?dir=<?php echo $curdirpathurl; ?>"><?php echo get_lang("CreateDoc"); ?></a>&nbsp;&nbsp;
			<!-- file upload link -->
			<a href="upload.php?path=<?php echo $curdirpathurl.$req_gid; ?>"><img src="../img/upload.gif" border="0" align="absmiddle" title="<?php echo get_lang('UplUploadDocument'); ?>" alt="" /></a>
			<a href="upload.php?path=<?php echo $curdirpathurl.$req_gid; ?>"><?php echo get_lang('UplUploadDocument'); ?></a>&nbsp;
			<!-- create directory -->			
			<a href="<?php echo $_SERVER['PHP_SELF']; ?>?curdirpath=<?php echo $curdirpathurl; ?>&amp;createdir=1"><img src="../img/new_folder.gif" border="0" align="absmiddle" alt ="" /></a>
			<a href="<?php echo $_SERVER['PHP_SELF']; ?>?curdirpath=<?php echo $curdirpathurl; ?>&amp;createdir=1"><?php echo get_lang("CreateDir"); ?></a>&nbsp;
		<?php
	}
	?>
	<!-- download zipped folder -->	
	<a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=downloadfolder&amp;path=<?php echo $curdirpathurl; ?>"><img src="../img/save_zip.gif" border="0" align="absmiddle" title="<?php echo get_lang("Save"); ?> (ZIP)" alt="" /></a>
	<a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=downloadfolder&amp;path=<?php echo $curdirpathurl; ?>"><?php echo get_lang("Save"); ?> (ZIP)</a>&nbsp;
	<?php
	echo "</div>";

//==============================================================================

if($docs_and_folders)
{
	//echo('<pre>');
	//print_r($docs_and_folders);
	//echo('</pre>');
	//*************************************************************************************************
	//do we need the title field for the document name or not?
	//we get the setting here, so we only have to do it once
	$use_document_title = get_setting('use_document_title');
	//create a sortable table with our data
	$sortable_data = array();
	while (list ($key, $id) = each($docs_and_folders))
	{
		$row = array ();
		
		//if the item is invisible, wrap it in a span with class invisible
		$invisibility_span_open = ($id['visibility']==0)?'<span class="invisible">':'';
		$invisibility_span_close = ($id['visibility']==0)?'</span>':'';
		//size (or total size of a directory)
		$size = $id['filetype']=='folder' ? get_total_folder_size($id['path'],$is_allowed_to_edit) : $id[size];
		//get the title or the basename depending on what we're using
		$document_name = ($use_document_title=='true')?$id['title']:basename($id['path']);
		//$row[] = $key; //testing
		//icons
		$row[]= build_document_icon_tag($id['filetype'],$id['path']);
		//document title with hyperlink
		$row[] = create_document_link($http_www,$document_name,$id['path'],$id['filetype'],$size,$id['visibility']);
		//comments
		$row[] = $invisibility_span_open.nl2br(htmlspecialchars($id['comment'])).$invisibility_span_close;
		$display_size = format_file_size($size);
		$row[] = '<span style="display:none;">'.$size.'</span>'.$invisibility_span_open.$display_size.$invisibility_span_close; 
		//last edit date
		$display_date = format_date(strtotime($id['lastedit_date']));
		$row[] = '<span style="display:none;">'.$id['lastedit_date'].'</span>'.$invisibility_span_open.$display_date.$invisibility_span_close; 
		
		//admins get an edit column
		if ($is_allowed_to_edit || $group_member_with_upload_rights)
		{
			$row[] = build_edit_icons($curdirpath,$id['filetype'],$id['path'],$id['visibility'],$key);
		}
		$sortable_data[] = $row;
	}
	
	
	//$column_header[] = array('Item ID',true);
	$column_header[] = array(get_lang('Type'),true,'style="width:40px"','style="text-align:center"');
	$column_header[] = array(get_lang('Name'),true);
	$column_header[] = array(get_lang('Comment'),true);
	$column_header[] = array(get_lang('Size'),true,'style="width:100px"');
	$column_header[] = array(get_lang('Date'),true,'style="width:140px"','style="text-align:center"');
	//admins get an edit column
	if ($is_allowed_to_edit || $group_member_with_upload_rights)
	{
		$column_header[] = array(get_lang('Modify'),false,'style="width:100px"');
	}
	
	$paging_options['per_page_default'] = 100;
	$paging_options['page_nr'] = (isset ($_GET['page_nr']) ? $_GET['page_nr'] : 1);
	$paging_options['per_page'] = (isset ($_GET['per_page']) ? $_GET['per_page'] : 100);
	$sorting_options['column'] = (isset ($_GET['column']) ? $_GET['column'] : 0);
	$sorting_options['direction'] = (isset ($_GET['direction']) ? $_GET['direction'] : SORT_ASC);
	$query_vars['curdirpath'] = $curdirpath;
	if(isset($_SESSION['_gid']))
	{
		$query_vars['gidReq'] = $_SESSION['_gid'];
	}

	Display::display_sortable_table($column_header, $sortable_data, $sorting_options, $paging_options,$query_vars);
	//*******************************************************************************************

}
else {
	echo('<p><strong>'.get_lang('NoDocsInFolder').'</strong></p>');
}

/*
==============================================================================
		Quota section
			
		Proposal: perhaps move/add the quota display to another section, e.g. course info
==============================================================================
*/ 
if ($is_allowed_to_edit) display_document_options();

/*
==============================================================================
		Footer
==============================================================================
*/
Display::display_footer();
?>
