<?php // $Id: add_course.php,v 1.48 2005/05/13 09:13:09 roane Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* COURSE SITE CREATION TOOL
*
* This script allows professors and administrative staff to create course sites.
*
* This big script does, basically, 6 things:
*     1. Create a database whose name=course code (sort of course id)
*     2. Create tables in this base and fill some of them
*     3. Create a www directory with the same name as the db name
*     4. Add the course to the main icampus/course table
*     5. Check whether the course code is not already taken.
*     6. Associate the current user id with the course in order to let
*        him administer it.
*
* One of the functions of this script is to merge the different
* Open Source Tools used in the courses (statistics by EzBoo,
* forum by phpBB...) under one unique user session and one unique
* course id.
*
* @author X X main author
* @author Roan Embrechts, refactoring
* @todo structure this "700 lines no functions" code
* @package dokeos.create_course
==============================================================================
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
/*

List of Events
	- can't create course
		show displayNotForU and exit
	-

List  of  views
	- displayNotForU
		the  user  is not allowed to use this script
	- displayWhatAdd
		here  user select  what take in the archive
	- displayCoursePropertiesForm
		User  can enter/edit  parameter  for the  new  course. 
		If  they use an archive, value are proposed but can be edited
	- displayCourseAddResult
		New course is added.  Show  success message.
*/

$langFile = "create_course";
include ('../inc/claro_init_global.inc.php');
$fromAdmin = $_GET['fromAdmin'] ? 1 : 0;

/*
-----------------------------------------------------------
	Configuration file
-----------------------------------------------------------
*/
include (api_get_configuration_path()."/add_course.conf.php");

/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
//main_api.lib.php by default included
include_once (api_get_library_path()."/text.lib.php");
include_once (api_get_library_path()."/add_course.lib.inc.php");
include_once (api_get_library_path()."/debug.lib.inc.php");
include_once (api_get_library_path()."/fileManage.lib.php");
include_once (api_get_configuration_path()."/course_info.conf.php");

/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/
$nameTools = get_lang('CreateSite');

$TABLECOURSE 		= Database::get_main_table(MAIN_COURSE_TABLE); 
$TABLECOURSDOMAIN 	= Database::get_main_table(MAIN_CATEGORY_TABLE);
$TABLELANGUAGES		= Database::get_main_table(MAIN_LANGUAGE_TABLE);

$can_create_courses = (bool) ( api_is_allowed_to_create_course() );

/*
==============================================================================
		MAIN CODE
==============================================================================
*/ 

$submitFromCoursProperties = $_POST["submitFromCoursProperties"];

$displayNotForU = FALSE;
if (!$can_create_courses) // if (!$is_platformAdmin)
{
	$displayNotForU = TRUE;
}
else
{
	$displayCoursePropertiesForm = TRUE;
	$valueTitular = $_user['lastName']." ".$_user['firstName'];
	$valueLanguage = $platformLanguage;
	if (isset ($_POST['fromWhatAdd']))
	{
		$displayWhatAdd = FALSE;
		if ($_POST['whatAdd'] == "newCourse")
		{
			$displayCoursePropertiesForm = TRUE;
			$valueTitular = $_user['lastName']." ".$_user['firstName'];
			$valueLanguage = $platformLanguage;
		}
		else
		{
			$displayWhatAdd = TRUE;
		}
	}
}
if ($submitFromCoursProperties)
{
	$wantedCode = trim(strip_tags($_POST['wantedCode']));
	$tutor_name = trim(strip_tags($_POST['tutor_name']));
	$category = trim($_POST['category']);
	$title = trim(strip_tags($_POST['title']));
	$course_language = trim($_POST['course_language']);
	$keys = define_course_keys($wantedCode, "", $dbNamePrefix);
	if (sizeof($keys))
	{
		$currentCourseCode = $keys["currentCourseCode"];
		$currentCourseId = $keys["currentCourseId"];
		$currentCourseDbName = $keys["currentCourseDbName"];
		$currentCourseRepository = $keys["currentCourseRepository"];
		$expiration_date = time() + $firstExpirationDelay;
		if (empty ($tutor_name))
		{
			$tutor_name = $_user['lastName']." ".$_user['firstName'];
		}
		if (empty ($title))
		{
			$title = $keys["currentCourseCode"];
		}
		prepare_course_repository($currentCourseRepository, $currentCourseId);
		update_Db_course($currentCourseDbName);
		fill_course_repository($currentCourseRepository);
		fill_Db_course($currentCourseDbName, $currentCourseRepository, $course_language);
		register_course($currentCourseId, $currentCourseCode, $currentCourseRepository, $currentCourseDbName, $tutor_name, $category, $title, $course_language, $_uid, $expiration_date);
		$displayCourseAddResult = true;
		$displayCoursePropertiesForm = false;
		$displayWhatAdd = false;
	}
}

Display::display_header($nameTools);
api_display_tool_title($nameTools);

/*
-----------------------------------------------------------
	COURSE CREATION FORM
-----------------------------------------------------------
*/
if ($displayNotForU)
{
	Display :: display_normal_message(get_lang("NotAllowed"));
}
if ($displayCoursePropertiesForm)
{
?>
<b><?php echo get_lang('FieldsRequ') ?></b>
<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?fromAdmin=<?php echo $fromAdmin; ?>">
<table>
<tr valign="top">
<td colspan="2">

</td>
</tr>

<tr valign="top">
<td align="right">
<?php echo get_lang('Title') ?> :
</td>
<td valign="top">
<input type="text" name="title" size="60" value="<?php echo $valueIntitule ?>" />
<br /><?php echo get_lang('Ex') ?>
</td>
</tr>

<tr valign="top">
<td align="right"><?php echo get_lang('Fac') ?> : </td>
<td>
<select name="category">
<?php

  $table_category = Database :: get_main_table(MAIN_CATEGORY_TABLE);
	$resultFac = api_sql_query("SELECT `code`, `name`
		                              FROM ".$TABLECOURSDOMAIN."
		                              WHERE `auth_course_child` ='TRUE'
		                              ORDER BY `tree_pos`", __FILE__, __LINE__);
	while ($myfac = mysql_fetch_array($resultFac))
	{

		echo "<option value=\"", $myfac["code"], "\"";
		echo ">(", $myfac["code"], ") ", $myfac["name"];
		echo "</option>\n";
	}
?>
<!-- <option value="">- - - - <?php echo get_lang('OtherCategory'); ?> - - - -</option> //-->
</select>
<br /><?php echo get_lang('TargetFac') ?>
</td>
</tr>

<tr valign="top">
<td align="right"><?php echo get_lang('Code') ?> : </td>
<td ><input type="text" name="wantedCode" maxlength="20" value="<?php echo $valuePublicCode ?>" />
<br /><?php echo get_lang('Max') ?>
</td>
</tr>

<tr valign="top">
<td align="right">
<?php echo get_lang('Professors') ?> :
</td>
<td>
<input type="text" name="tutor_name" size="60" value="<?php echo htmlspecialchars($valueTitular); ?>" />
</td>
</tr>

<tr valign="top">
<td align="right">
<?php echo get_lang('Ln') ?> :
</td>
<td>
<select name="course_language">
<?php 
$sql="SELECT * FROM $TABLELANGUAGES WHERE available='1' ORDER BY original_name ASC";
$result=api_sql_query($sql,__FILE__,__LINE__);
while ($row=mysql_fetch_array($result))
{ 
	if ($row['dokeos_folder'] == get_setting("platformLanguage"))
	{ $selected=" selected=\"selected\""; }
	else
	{ $selected=""; }
	echo "\t<option value=\"".$row['dokeos_folder']."\" $selected>".$row['original_name']."</option>\n";
}
?>
</select>
</td>
</tr>
<tr valign="top">
<td>
</td>
<td>
<input type="submit" name="submitFromCoursProperties" value="<?php echo get_lang('Ok') ?>" />
</td>
</tr>
</table>
</form>
<p><?php echo get_lang('Explanation') ?>.</p>

<?php
}
	/*
		$valueCode			= $courseProperties["official_code"];
		$valueIntitule		= $courseProperties["name"];
		$valueFacultyName	= $courseProperties["categoryName"];
		$valueFacultyCode	= $courseProperties["categoryCode"];
		$valueLanguage 		= $courseProperties["language"];
		$valueAdminCode		= $courseProperties["adminCode"];
		$valueDbName		= $courseProperties["dbName"];
		$valuePath			= $courseProperties["path"];
		$valueRegAllowed 	= $courseProperties["registrationAllowed"];
	*/
	/*
	==============================================================================
		SORT THE FORM
		1. CHECK IF DIRECTORY/COURSE_CODE ALREADY TAKEN
		CREATE THE COURSE AND THE DATABASE OF I
	==============================================================================
	*/
	if ($displayCourseAddResult)
	{
		$message = get_lang('JustCreated');
		$message .= " <strong>".$currentCourseCode."</strong>";
		$message .= "<br/><br/>";
		$message .= '<a href="'.api_get_path(WEB_PATH).'">'.get_lang('Enter').'</a>';
		Display::display_normal_message($message);
	} // if all fields fulfilled

	/*
	==============================================================================
			FOOTER
	==============================================================================
	*/
	Display::display_footer();
?>
