<?php
// $Id: infocours.php,v 1.73 2005/07/05 14:13:27 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Hugues Peeters
	Copyright (c) Roan Embrechts (Vrije Universiteit Brussel)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	Code to display the course settings form (for the course admin)
*	and activate the changes.
*
*	See ./inc/conf/course_info.conf.php for settings
*
* @todo (busy) check visibility / registration settings, and refine them
*	e.g. visible for the world | visible for registered users | invisible
*	instead of current visible | invisible
*	or extra option:
*	visible for users registered in the platform
*	visible for users registered in the course
*	completely invisible for everyone except the course teacher
* @author Patrick Cool <patrick.cool@UGent.be>
* @author Roan Embrechts, refactoring
* and improved course visibility|subscribe|unsubscribe options
* @package dokeos.course_info
==============================================================================
*/
/*
==============================================================================
	   INIT SECTION
==============================================================================
*/
$langFile = "course_info";
include ('../inc/claro_init_global.inc.php');
$nameTools = get_lang("ModifInfo");
/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
require_once (api_get_library_path()."/course.lib.php");
require_once (api_get_include_path()."/conf/course_info.conf.php");
require_once (api_get_include_path()."/lib/text.lib.php");
require_once (api_get_include_path()."/lib/debug.lib.inc.php");
/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/
define("MODULE_HELP_NAME", "Settings");
define("COURSE_CHANGE_PROPERTIES", "COURSE_CHANGE_PROPERTIES");
$TABLECOURSE = Database :: get_main_table(MAIN_COURSE_TABLE);
$TABLEFACULTY = Database :: get_main_table(MAIN_CATEGORY_TABLE);
$TABLECOURSEHOME = Database :: get_course_tool_list_table();
$TABLELANGUAGES = Database :: get_main_table(MAIN_LANGUAGE_TABLE);
$TABLEBBCONFIG = $_course['dbNameGlu']."bb_config";
$currentCourseID = $_course['sysCode'];
$currentCourseRepository = $_course["path"];
$is_allowedToEdit = $is_courseAdmin;
/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/
Display::display_header($nameTools,"Settings");
/*
==============================================================================
		IO FUNCTIONS
==============================================================================
*/
/**
*	Return a list of language directories.
*	@todo function does not belong here, move to code library,
*	also see infocours.php which contains similar function
*/
function get_language_folder_list()
{
	//read list of language directories
	$dirname = api_get_code_sys_path()."/lang/";
	if ($dirname[strlen($dirname) - 1] != '/')
		$dirname .= '/';
	$handle = opendir($dirname);
	while ($entries = readdir($handle))
	{
		if ($entries == '.' || $entries == '..' || $entries == 'CVS')
			continue;
		if (is_dir($dirname.$entries))
		{
			$language_list[] = $entries;
		}
	}
	closedir($handle);
	return $language_list;
}
/*
==============================================================================
		DISPLAY FUNCTIONS
==============================================================================
*/
function get_table_row_html($row_text)
{
	return "<tr>".$row_text."</tr>";
}
function get_table_cell_html($align, $cell_text)
{
	if (isset ($align) && $align != "")
		$align_option = "align=\"$align\"";
	else
		$align_option = "";
	return "<td $align_option>".$cell_text."</td>";
}
function get_form_field_title_html($title)
{
	return $title."&nbsp;&nbsp;";
}
/*
==============================================================================
		LOGIC FUNCTIONS
==============================================================================
*/
function is_settings_editable()
{
	return $GLOBALS["course_info_is_editable"];
}
$course_code = $_course["sysCode"];
$course_access_settings = CourseManager :: get_access_settings($course_code);
/*
==============================================================================
		MAIN CODE
==============================================================================
*/

api_display_tool_title($nameTools);
if (!$is_allowedToEdit)
	api_not_allowed();
// check if form submitted
if (isset ($_POST[COURSE_CHANGE_PROPERTIES]))
{
	$course_title = $_POST['course_title'];
	$course_category = $_POST['course_category'];
	$visibility = $_POST['visibility'];
	$allowedToSubscribe = $_POST['allowedToSubscribe'];
	$allowedToUnsubscribe = $_POST['allowedToUnsubscribe'];
	$titulary =  $_POST['titulary'];
	$screenCode = $_POST['screenCode'];
	$course_language = $_POST['course_language'];
	$department_name = $_POST['department_name'];
	$department_url = $_POST['department_url'];

	$fieldsToUpdate=array();

	if ($course_title != "" || $canBeEmpty["course_title"])
	{
		$fieldsToUpdate[] = "title='".$course_title."'";
	}
	if ($course_category != "" || $canBeEmpty["course_category"])
		$fieldsToUpdate[] = "category_code='".$course_category."'";
	/*		if ($description!="" || $canBeEmpty["description"])
				$fieldsToUpdate[]= "description='".$description."'";*/
	if ($visibility == "closed")
		$fieldsToUpdate[] = "visibility='".COURSE_VISIBILITY_CLOSED."'";
	elseif ($visibility == "registered") $fieldsToUpdate[] = "visibility='".COURSE_VISIBILITY_REGISTERED."'";
	elseif ($visibility == "open_platform") $fieldsToUpdate[] = "visibility='".COURSE_VISIBILITY_OPEN_PLATFORM."'";
	elseif ($visibility == "open_world") $fieldsToUpdate[] = "visibility='".COURSE_VISIBILITY_OPEN_WORLD."'";
	if ($allowedToSubscribe == "false")
		$fieldsToUpdate[] = "subscribe='".SUBSCRIBE_NOT_ALLOWED."'";
	elseif ($allowedToSubscribe == "true") $fieldsToUpdate[] = "subscribe='".SUBSCRIBE_ALLOWED."'";
	if ($allowedToUnsubscribe == "false")
		$fieldsToUpdate[] = "unsubscribe='".UNSUBSCRIBE_NOT_ALLOWED."'";
	elseif ($allowedToUnsubscribe == "true")
		$fieldsToUpdate[] = "unsubscribe='".UNSUBSCRIBE_ALLOWED."'";
	if ($titulary != "" || $canBeEmpty["titulary"])
		$fieldsToUpdate[] = "tutor_name='".$titulary."'";
	if ($screenCode != "" || $canBeEmpty["screenCode"])
		$fieldsToUpdate[] = "visual_code='".strtoupper($screenCode)."'";
	if ($course_language != "" || $canBeEmpty["course_language"])
		$fieldsToUpdate[] = "course_language='".$course_language."'";
	if ($department_name != "" || $canBeEmpty["department_name"])
		$fieldsToUpdate[] = "department_name='".$department_name."'";
	if ($department_url != "" || $canBeEmpty["department_url"])
		$fieldsToUpdate[] = "department_url='".$department_url."'";
	$sql = "UPDATE ".$TABLECOURSE."
						 SET ".implode(",", $fieldsToUpdate)."
						 WHERE code='".$currentCourseID."'";// die($sql);
	api_sql_query($sql, __FILE__, __LINE__);
	/*
	-----------------------------------------------------------
		Change the language of the icons on the course homepage
		These are stored in the database of each course
		(Yes, that should be optimized)
	-----------------------------------------------------------
	*/
	include (api_get_code_sys_path()."/lang/english/create_course.inc.php");
	if (isset ($_POST['course_language']))
	{
		include (api_get_code_sys_path()."/lang/".$_POST['course_language']."/create_course.inc.php");
	}
	api_sql_query("UPDATE `".$TABLEBBCONFIG."` SET default_lang='".$_POST['course_language']."'", __FILE__, __LINE__);
	/*
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('CourseDesc'))."' WHERE link LIKE 'course_description/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Agenda'))."' WHERE link LIKE 'calendar/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Doc'))."' WHERE link LIKE 'document/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Announcements'))."' WHERE link LIKE 'announcements/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Forums'))."' WHERE link LIKE 'phpbb/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Links'))."' WHERE link LIKE 'link/%'", __FILE__, __LINE__);
	api_sql_query("Update ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Dropbox'))."' WHERE link LIKE 'dropbox/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Exercices'))."' WHERE link LIKE 'exercice/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Users'))."' WHERE link LIKE 'user/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Groups'))."' WHERE link LIKE 'group/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Chat'))."' WHERE link LIKE 'chat/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('OnlineConference'))."' WHERE link LIKE 'online/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Works'))."' WHERE link LIKE 'work/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Statistics'))."' WHERE link LIKE 'tracking/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('LinkSite'))."' WHERE link LIKE 'external_module/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('ModifyInfo'))."' WHERE link LIKE 'course_info/%'", __FILE__, __LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".addslashes(get_lang('Scormtool'))."' WHERE link LIKE 'scorm/%'", __FILE__, __LINE__);
	*/

	//next lines are temporary and can be deleted when course tool names are updated to their language independent values in the dokeos update script.
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_COURSE_DESCRIPTION."' WHERE link LIKE 'course_description/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_CALENDAR_EVENT."' WHERE link LIKE 'calendar/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_DOCUMENT."' WHERE link LIKE 'document/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_ANNOUNCEMENT."' WHERE link LIKE 'announcements/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_BB_FORUM."' WHERE link LIKE 'phpbb/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_LINK."' WHERE link = 'link/link.php'",__FILE__,__LINE__);
	api_sql_query("Update ".$TABLECOURSEHOME." SET name='".TOOL_DROPBOX."' WHERE link LIKE 'dropbox/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_QUIZ."' WHERE link LIKE 'exercice/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_USER."' WHERE link LIKE 'user/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_GROUP."' WHERE link LIKE 'group/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_CHAT."' WHERE link LIKE 'chat/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_CONFERENCE."' WHERE link LIKE 'online/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_STUDENTPUBLICATION."' WHERE link LIKE 'work/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_TRACKING."' WHERE link LIKE 'tracking/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_HOMEPAGE_LINK."' WHERE link = 'link/link.php?action=addlink'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_COURSE_SETTING."' WHERE link LIKE 'course_info/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_LEARNPATH."' WHERE link LIKE 'scorm/%'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_BACKUP."' WHERE link = 'coursecopy/backup.php'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_COPY_COURSE_CONTENT."' WHERE link = 'coursecopy/copy_course.php'",__FILE__,__LINE__);
	api_sql_query("UPDATE ".$TABLECOURSEHOME." SET name='".TOOL_RECYCLE_COURSE."' WHERE link = 'coursecopy/recycle_course.php'",__FILE__,__LINE__);


	$controlMsg = array (get_lang('ModifDone'));
	api_display_array($controlMsg);

	echo "
			<br>
			<a href=\"".$_SERVER['PHP_SELF']."?cidReset=true&cidReq=".$_cid."\">".get_lang('Back')."</a>
			|
			<a href=\"".api_get_path(WEB_COURSE_PATH).$currentCourseRepository."/index.php?cidReset=true&cidReq=".$_cid."\">".get_lang('Home')."</a>
			<br>";
	//unset($_SESSION['_cid']);
}
else
{
	/*
	-----------------------------------------------------------
		Gather form data
	-----------------------------------------------------------
	*/
	/*
	$sqlCourseExtention = "SELECT last_visit, last_edit, creation_date, disk_quota, expiration_date
	                       FROM ".$TABLECOURSE." WHERE code = '".$_cid."'";

	$resultCourseExtention 			= api_sql_query($sqlCourseExtention);
	$currentCourseExtentionData 	= mysql_fetch_array($resultCourseExtention);

	$currentCourseDiskQuota 		= $currentCourseExtentionData["disk_quota"     ];
	$currentCourseLastVisit 		= $currentCourseExtentionData["last_visit"     ];
	$currentCourseLastEdit			= $currentCourseExtentionData["last_edit"      ];
	$currentCourseCreationDate 		= $currentCourseExtentionData["creation_date"  ];
	$currentCourseExpirationDate	= $currentCourseExtentionData["expiration_date"];
	*/
	$course_title = $_course['name'];
	$course_category = $_course['categoryCode'];
	$currentCourseCode = $_course['official_code'];
	$titulary = $_course['titular'];
	$course_language = $_course['language'];
	$department_name = $_course['extLink']['name'];
	$department_url = $_course['extLink']['url'];
	$visibleChecked[$_course['visibility']] = "checked";
	$registrationAllowedChecked[$_course['registrationAllowed']] = "checked";
	// is it allowed to edit the course settings?
	if (!is_settings_editable())
		$disabled_output = "disabled";
	/*
	-----------------------------------------------------------
		Display form
	-----------------------------------------------------------
	*/
	echo "<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."\" style=\"margin:0px\">";
	echo "<table cellpadding=\"3\" border=\"0\">";
	// "FAKE" (Screen) Course Code
	$left_cell = get_table_cell_html("right", get_form_field_title_html(get_lang("Code")));
	$right_cell = get_table_cell_html("", "<input type=\"text\" name=\"screenCode\" $disabled_output value=\"".$currentCourseCode."\" size=\"20\" >");
	$table_row = get_table_row_html($left_cell.$right_cell);
	echo $table_row;
	// Teacher(s)
	$left_cell = get_table_cell_html("right", get_form_field_title_html(get_lang("Professor")));
	$right_cell = get_table_cell_html("", "<input type=\"text\" name=\"titulary\" $disabled_output value=\"".htmlspecialchars($titulary)."\" size=\"60\" >");
	$table_row = get_table_row_html($left_cell.$right_cell);
	echo $table_row;
	// Course title
	$left_cell = get_table_cell_html("right", get_form_field_title_html(get_lang("Title")));
	$right_cell = get_table_cell_html("", "<input type=\"text\" name=\"course_title\" $disabled_output value=\"".htmlspecialchars($course_title)."\" size=\"60\" >");
	$table_row = get_table_row_html($left_cell.$right_cell);
	echo $table_row;
?>

<tr>
<td align="right"><?php echo get_form_field_title_html(get_lang("Faculty")); ?></td>
<td>
<select name="course_category" <?php echo $disabled_output;?> >
<?php

	$sql_faculty_result = api_sql_query("
					SELECT `code`, `name`
					FROM ".$TABLEFACULTY."
					WHERE `auth_course_child` ='TRUE'
					ORDER BY `tree_pos`");
	while ($myfac = mysql_fetch_array($sql_faculty_result))
	{
		echo "<option value=\"", $myfac["code"], "\"";
		if ($myfac["code"] == $course_category)
			echo " selected ";
		echo ">(", $myfac["code"], ") ", $myfac["name"];
		echo "</option>\n";
	}
?>
<!-- <option value="" <?php if(empty($course_category)) echo 'selected="selected"'; ?>>---- <?php echo get_lang('OtherCategory'); ?> ----</option> //-->
</select>
</td>
</tr>

<?php

	// Department URL
	$left_cell = get_table_cell_html("right", get_form_field_title_html(get_lang("DepartmentUrlName")));
	$right_cell = get_table_cell_html("", "<input type=\"text\" name=\"department_name\" $disabled_output value=\"".htmlspecialchars($department_name)."\" size=\"20\" maxlength=\"30\">");
	$table_row = get_table_row_html($left_cell.$right_cell);
	echo $table_row;
?>

<tr>
<td align="right" nowrap><?php echo get_form_field_title_html(get_lang("DepartmentUrl")); ?></td>
<td><input type="text" name="department_url" <?php echo $disabled_output;?> value="<?php if( isset($department_url) && $department_url) echo htmlspecialchars($department_url); else echo 'http://';?>" size="60" maxlength="180"></td>
</tr>

<tr>
<td valign="top" align="right"><?php echo get_form_field_title_html(get_lang("Language")); ?></td>
<td>
<select <?php echo $disabled_output;?> name="course_language">
<?php

	$sql = "SELECT * FROM $TABLELANGUAGES WHERE available='1' ORDER BY original_name ASC";
	$result = api_sql_query($sql, __FILE__, __LINE__);
	while ($row = mysql_fetch_array($result))
	{
		if ($row['dokeos_folder'] == $course_language)
		{
			$selected = " selected=\"selected\"";
		}
		else
		{
			$selected = "";
		}
		echo "\t<option value=\"".$row['dokeos_folder']."\" $selected>".$row['original_name']."</option>\n";
	}
?>
</select>

<br><font color="gray"><?php echo get_lang("TipLang"); ?></font>
</td>
</td>
</tr>

<?php

	//Course access - visibility options
	if ($course_access_settings["visibility"] == COURSE_VISIBILITY_CLOSED)
		$visibility_closed_html = "checked";
	if ($course_access_settings["visibility"] == COURSE_VISIBILITY_REGISTERED)
		$visibility_registered_html = "checked";
	if ($course_access_settings["visibility"] == COURSE_VISIBILITY_OPEN_PLATFORM)
		$visibility_open_platform_html = "checked";
	if ($course_access_settings["visibility"] == COURSE_VISIBILITY_OPEN_WORLD)
		$visibility_open_world_html = "checked";
	echo "<tr>";
	echo "<td valign=\"top\" align=\"right\" nowrap>".get_form_field_title_html(get_lang("CourseAccess"))."</td>";
	echo "<td>";
	echo "<input class=\"checkbox\" type=\"radio\" name=\"visibility\" id=\"visibility_open_world\"".$disabled_output." value=\"open_world\"".$visibility_open_world_html."> <label for=\"visibility_open_world\">".get_lang("OpenToTheWorld")."</label>";
	echo "<br/>";
	echo "<input class=\"checkbox\" type=\"radio\" name=\"visibility\" id=\"visibility_open_platform\"".$disabled_output." value=\"open_platform\"".$visibility_open_platform_html."> <label for=\"visibility_open_platform\">".get_lang("OpenToThePlatform")."</label>";
	echo "<br/>";
	echo "<input class=\"checkbox\" type=\"radio\" name=\"visibility\" id=\"visibility_registered\"".$disabled_output." value=\"registered\"".$visibility_registered_html."> <label for=\"visibility_registered\">".get_lang("Private")."</label>";
	echo "<br/>";
	echo "<input class=\"checkbox\" type=\"radio\" name=\"visibility\" id=\"visibility_closed\"".$disabled_output." value=\"closed\"".$visibility_closed_html."> <label for=\"visibility_closed\">".get_lang("CourseVisibilityClosed")."</label>";
	echo "</td></tr>";
	//Are platform users allowed to subscribe?
	if ($course_access_settings["subscribe"] == true)
		$subscribe_allowed_html_output = ' checked="checked" ';
	else
		$subscribe_not_allowed_html_output = ' checked="checked" ';
?>
<tr>
<td valign="top"align="right"><?php echo get_form_field_title_html(get_lang("Subscription")); ?></td>
<td>
<input class="checkbox" type="radio" name="allowedToSubscribe" id="allowedToSubscribeTrue"  <?php echo $disabled_output;?> value="true" <?php echo $subscribe_allowed_html_output; ?>> <label for="allowedToSubscribeTrue"><?php echo get_lang("Allowed"); ?></label><br>

<input class="checkbox" type="radio" name="allowedToSubscribe" id="allowedToSubscribeFalse" <?php echo $disabled_output;?> value="false" <?php echo $subscribe_not_allowed_html_output; ?>> <label for="allowedToSubscribeFalse"><?php echo get_lang("Denied"); ?></label>
</td>
</tr>

<?php

	//Are users registered in the course allowed to unsubscribe?
	//print_r($course_access_settings);
	if ($course_access_settings["unsubscribe"] == true)
		$unsubscribe_allowed_html_output = ' checked="checked" ';
	else
		$unsubscribe_not_allowed_html_output = ' checked="checked" ';
	echo "<tr>";
	echo "<td valign=\"top\" align=\"right\">".get_form_field_title_html(get_lang("Unsubscription"))."</td>";
	echo "<td>";
	echo "<input class=\"checkbox\" type=\"radio\" name=\"allowedToUnsubscribe\" id=\"allowedToUnsubscribeTrue\" $disabled_output value=\"true\"".$unsubscribe_allowed_html_output."> <label for=\"allowedToUnsubscribeTrue\">".get_lang("AllowedToUnsubscribe")."</label><br>";
	echo "<input class=\"checkbox\" type=\"radio\" name=\"allowedToUnsubscribe\" id=\"allowedToUnsubscribeFalse\"  $disabled_output value=\"false\"".$unsubscribe_not_allowed_html_output."> <label for=\"allowedToUnsubscribeFalse\">".get_lang("NotAllowedToUnsubscribe")."</label>";
	echo "</td></tr>";
?>

<tr>
<td></td>
<td><font color="gray"><?php echo get_lang("ConfTip"); ?></font></td>
</tr>

<?php

	//show submit (OK) button when allowed
	if (is_settings_editable())
	{
		echo "<tr><td></td><td>";
		echo "<input type=\"submit\" name=\"".COURSE_CHANGE_PROPERTIES."\" value=\"".get_lang("Ok")."\">";
		echo "</td></tr>";
	}
	if ($showDiskQuota && $currentCourseDiskQuota != "")
	{
?>
	<tr>
	<td><?php echo get_lang("DiskQuota"); ?>&nbsp;:</td>
	<td><?php echo $currentCourseDiskQuota; ?> <?php echo $byteUnits[0] ?></td>
	</tr>
	<?php

	}
	if ($showLastEdit && $currentCourseLastEdit != "" && $currentCourseLastEdit != "0000-00-00 00:00:00")
	{
?>
	<tr>
	<td><?php echo get_lang('LastEdit'); ?>&nbsp;:</td>
	<td><?php echo format_locale_date($dateTimeFormatLong,strtotime($currentCourseLastEdit)); ?></td>
	</tr>
	<?php

	}
	if ($showLastVisit && $currentCourseLastVisit != "" && $currentCourseLastVisit != "0000-00-00 00:00:00")
	{
?>
	<tr>
	<td><?php echo get_lang('LastVisit'); ?>&nbsp;:</td>
	<td><?php echo format_locale_date($dateTimeFormatLong,strtotime($currentCourseLastVisit)); ?></td>
	</tr>
	<?php

	}
	if ($showCreationDate && $currentCourseCreationDate != "" && $currentCourseCreationDate != "0000-00-00 00:00:00")
	{
?>
	<tr>
	<td><?php echo get_lang('CreationDate'); ?>&nbsp;:</td>
	<td><?php echo format_locale_date($dateTimeFormatLong,strtotime($currentCourseCreationDate)); ?></td>
	</tr>
	<?php

	}
	if ($showExpirationDate && $currentCourseExpirationDate != "" && $currentCourseExpirationDate != "0000-00-00 00:00:00")
	{
?>
	<tr>
	<td><?php echo get_lang('ExpirationDate'); ?>&nbsp;:</td>
	<td>
	<?php

		echo format_locale_date($dateTimeFormatLong, strtotime($currentCourseExpirationDate));
		echo "<BR>Soit dans : ";
		$nbJour = (strtotime($currentCourseExpirationDate) - time()) / (60 * 60 * 24);
		$nbAnnees = round($nbJour / 365);
		$nbJour = round($nbJour - $nbAnnees * 365);
		switch ($nbAnnees)
		{
			case "1" :
				echo $nbAnnees, " an ";
				break;
			case "0" :
				break;
			default :
				echo $nbAnnees, " ans ";
		};
		switch ($nbJour)
		{
			case "1" :
				echo $nbJour, " jour ";
				break;
			case "0" :
				break;
			default :
				echo $nbJour, " jours ";
		}
		if ($canReportExpirationDate)
		{
			echo " -&gt; <a href=\"".$urlScriptToReportExpirationDate."\">".get_lang('PostPone')."</a>";
		}
?>
</td>
</tr>

<?php

	}
?>
<tr>
<td colspan="2">

<?php
	if ($showLinkToBackupThisCourse || $showLinkToDeleteThisCourse || $showLinkToRecycleThisCourse)
	{
?>

<hr noshade size="1">

<?php

	}

	if ($showLinkToDeleteThisCourse)
	{
?>
				<a href="delete_course.php"><?php echo get_lang("DelCourse"); ?></a>
<?php
		if($showLinkToBackupThisCourse || $showLinkToRecycleThisCourse)
		{
			echo '|';
		}
	}

	if ($showLinkToBackupThisCourse)
	{
?>
				<a href="../coursecopy/backup.php"><?php echo get_lang("backup"); ?></a>
<?php

		if($showLinkToRecycleThisCourse)
		{
			echo '|';
		}
	}

	if ($showLinkToRecycleThisCourse)
	{
?>
				<a href="../coursecopy/recycle_course.php"><?php echo get_lang("recycle_course"); ?></a>
<?php

	}
?>

	</td>
	</tr>
	</table>
	</form>
	<?php

} // end else
/*
==============================================================================
		FOOTER
==============================================================================
*/
Display::display_footer();
?>

