<?php
// $Id: delete_course.php,v 1.28 2005/07/08 09:26:56 roane Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier brouckaert
	Copyright (c) Roan Embrechts

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	This script is about deleting a course.
*	It displays a message box ('are you sure you wish to delete this course')
*	and deletes the course if the user answers affirmatively
*
*	@package dokeos.course_info
==============================================================================
*/

$langFile = 'course_info';

include ('../inc/claro_init_global.inc.php');
api_protect_course_script();

$isAllowedToDelete = $is_courseAdmin;

$currentCourseId = $_course['sysCode'];
$currentCourseDbName = $_course['dbName'];
$currentCourseDbNameGlu = $_course['dbNameGlu'];
$currentCoursePath = $_course['path'];
$currentCourseCode = $_course['official_code'];
$currentCourseName = $_course['name'];

$tbl_course = Database :: get_main_table(MAIN_COURSE_TABLE);
$tbl_relCourseUser = Database :: get_main_table(MAIN_COURSE_USER_TABLE);
$tbl_course_class = Database :: get_main_table(MAIN_COURSE_CLASS_TABLE);
$delete = $_REQUEST['delete'];

$nameTools = get_lang('DelCourse');

include (api_get_library_path()."/fileManage.lib.php");

if ($isAllowedToDelete)
{
	if ($delete)
	{
		// recheck if the DB is really a Dokeos course
		// and if the user is an administrator of the concerned course

		$sql = "SELECT course_code, user_id, status
				        FROM  ".$tbl_relCourseUser."
				        WHERE course_code = '".$currentCourseId."'
				        AND   user_id    = '".$_uid."'
				        AND   status     = '1'";

		$result = api_sql_query($sql, __FILE__, __LINE__);

		if (mysql_num_rows($result))
		{

			if (!$singleDbEnabled) // IF THE PLATFORM IS IN MULTI DATABASE MODE
			{

				$sql = "DROP DATABASE `".$currentCourseDbName."`";

				api_sql_query($sql, __FILE__, __LINE__);
			}
			else // IF THE PLATFORM IS IN MONO DATABASE MODE
				{
				// SEARCH ALL TABLES RELATED TO THE CURRENT COURSE

				$sql = "SHOW TABLES LIKE \"".str_replace('_', '\_', $currentCourseDbNameGlu)."%\"";
				$result = api_sql_query($sql, __FILE__, __LINE__);

				// DELETE ALL TABLES OF THE CURRENT COURSE

				while (list ($courseTable) = mysql_fetch_row($result))
				{
					$sql = "DROP TABLE `".$courseTable."`";
					api_sql_query($sql, __FILE__, __LINE__);
				}
			}

			// DELETE THE COURSE INSIDE THE PLATFORM COURSE REGISTERY

			$sql = "DELETE FROM ".$tbl_course."
						        WHERE code= '".$currentCourseId."'";

			api_sql_query($sql, __FILE__, __LINE__);

			// DELETE USER ENROLLMENT INTO THIS COURSE

			$sql = "DELETE FROM ".$tbl_relCourseUser."
						        WHERE course_code='".$currentCourseId."'";

			api_sql_query($sql, __FILE__, __LINE__);

			$sql = "DELETE FROM ".$tbl_course_class."
						        WHERE course_code='".$currentCourseId."'";

			api_sql_query($sql, __FILE__, __LINE__);

			// MOVE THE COURSE DIRECTORY INTO THE COURSE GARABAGE COLLECTOR

			mkPath($garbageRepositorySys);
			rename($coursesRepositorySys.$currentCoursePath."/", $garbageRepositorySys.$currentCoursePath.'_'.time());

			// DELETE CONFIRMATION MESSAGE
			unset ($_course);
			unset($_cid);
			$noPHP_SELF = true;
			Display :: display_header($nameTools, "Settings");
			api_display_tool_title($nameTools);
			echo "<p>".get_lang('Course')." &quot;".$currentCourseName."&quot; "."(", $currentCourseCode, ") ".get_lang('HasDel')."</p>";
		}
		else
		{
			$noPHP_SELF = true;
			Display :: display_header($nameTools, "Settings");
			api_display_tool_title($nameTools);
		}

		echo "<p>"."<a href=\"../../index.php\">".get_lang('BackHome')." ".get_setting('siteName')."</a>"."</p>";
	} // end if $delete
	else
	{
		// ASK DELETE CONFIRMATION TO THE USER

		$ask_delete_message = "&quot;".$currentCourseName."&quot; "."(".$currentCourseCode.") "."<p>".get_lang("ByDel")."</p>"."<p>"."<a href=\"infocours.php\">".get_lang("N")."</a>"."&nbsp;&nbsp;|&nbsp;&nbsp;"."<a href=\"".$_SERVER['PHP_SELF']."?delete=yes\">".get_lang("Y")."</a>"."</p>";
		$interbredcrump[] = array ("url" => "infocours.php", "name" => get_lang('ModifInfo'));
		Display :: display_header($nameTools, "Settings");
		api_display_tool_title($nameTools);
		Display :: display_normal_message($ask_delete_message);

	} // end else if $delete
} // end if $isAllowedToDelete
else
{
	echo get_lang('NotAllowed');
}

/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>