<?php

/**
============================================================================== 
*                  HOME PAGE FUNCTIONS (BASIC TOOLS FIXED)
*
*	This page, included in every course's index.php is the home
*	page.To make administration simple, the professor edits his
*	course from it's home page. Only the login detects that the
*	visitor is allowed to activate, deactivate home page links,
*	access to Professor's tools (statistics, edit forums...).
*
*	@package dokeos.course_home
============================================================================== 
*/


function showtools2($cat)
{
	GLOBAL $_user;

	$clarolineRepositoryWeb = api_get_path(WEB_CODE_PATH);
	$TBL_ACCUEIL = Database::get_course_tool_list_table();
	$TABLE_TOOLS = Database::get_main_table(MAIN_COURSE_MODULE_TABLE);

	$numcols = 3;
	$iconcolprops = "width=\"1%\"";
	$toolcolprops= "width=\"32%\" height=\"45\"";
	$toolsRow_all = array();
	switch ($cat)
	{
		case 'Basic':
				$sql = "SELECT a.*, t.image img, t.row, t.column  FROM $TBL_ACCUEIL a, $TABLE_TOOLS t
						WHERE a.link=t.link AND t.position='basic' ORDER BY t.row, t.column";
				break;

		case 'External':
				if (api_is_allowed_to_edit())
					$sql = "SELECT a.*, t.image img FROM $TBL_ACCUEIL a, $TABLE_TOOLS t
						WHERE (a.link=t.link AND t.position='external')
						OR (a.visibility <= 1 AND (a.image = 'external.gif' OR a.image = 'scormbuilder.gif') AND a.image=t.image)
						ORDER BY a.id";
				else
					$sql = "SELECT a.*, t.image img FROM $TBL_ACCUEIL a, $TABLE_TOOLS t
						WHERE a.visibility = 1 AND ((a.link=t.link AND t.position='external')
						OR ((a.image = 'external.gif' OR a.image = 'scormbuilder.gif') AND a.image=t.image))
						 ORDER BY a.id";
				break;

		case 'courseAdmin':
				$sql = "SELECT a.*, t.image img, t.row, t.column  FROM $TBL_ACCUEIL a, $TABLE_TOOLS t
						WHERE admin=1 AND a.link=t.link ORDER BY t.row, t.column";
				break;

		case 'claroAdmin':
				$sql = "SELECT *, image img FROM $TBL_ACCUEIL WHERE visibility = 2 ORDER BY id";
	}
	$result = api_sql_query($sql,__FILE__,__LINE__);
	
	// grabbing all the tools from $course_tool_table
	while ($tempRow = mysql_fetch_array($result))
	{
		if($tempRow['img'] != "scormbuilder.gif")
		{
			$tempRow['name'] = get_lang($tempRow['name']);
		}
		$toolsRow_all[]=$tempRow;
	}
	// grabbing all the links that have the property on_homepage set to 1
	if ($cat=="External")
	{
		$tbl_link = Database::get_course_link_table();
		$tbl_item_property = Database::get_course_table(ITEM_PROPERTY_TABLE);
		if (api_is_allowed_to_edit())
		{
			$sql_links="SELECT tl.*, tip.visibility 
					FROM $tbl_link tl
					LEFT JOIN $tbl_item_property tip ON tip.tool='link' AND tip.ref=tl.id
					WHERE tl.on_homepage='1'";
		}
		else
		{
			$sql_links="SELECT tl.*, tip.visibility 
					FROM $tbl_link tl
					LEFT JOIN $tbl_item_property tip ON tip.tool='link' AND tip.ref=tl.id
					WHERE tl.on_homepage='1' AND tip.visibility = 1";
		}
		$result_links=api_sql_query($sql_links);
		while ($links_row=mysql_fetch_array($result_links))
		{
			unset($properties); 
			$properties['name']=$links_row['title'];
			$properties['link']=$links_row['url'];
			$properties['visibility']=$links_row['visibility'];
			$properties['img']="external.gif";
			$properties['adminlink']=api_get_code_web_path()."link/link.php?action=editlink&id=".$links_row['id'];
			$toolsRow_all[]=$properties;
		}
	}

	// draw line between basic and external, only if there are entries in External
	if ($cat == "External" && count($toolsRow_all)) 
	{
	    echo	"<tr><td colspan=\"6\"><hr color=\"#DEDEDE\"noshade size=\"1\"></td></tr>\n";
	}
	
	$i=0;
	foreach ($toolsRow_all as $toolsRow)
	{
		// the name of the tool
		$tool_name = ($toolsRow['name'] != "" ? $toolsRow['name'] : htmlspecialchars($toolsRow['link']));  // RH: added htmlspecialchars

		$link_annex = "";
		// the url of the tool
		if($toolsRow['img'] != "external.gif")
		{
			$toolsRow['link']=$clarolineRepositoryWeb.$toolsRow['link'];
			$qm_or_amp = ((strpos($toolsRow['link'],'?')===FALSE)?'?':'&amp;');
			$link_annex = $qm_or_amp.api_get_cidreq();
		}
		else // if an external link ends with 'login=', add the actual login...
		{
			$pos = strpos($toolsRow['link'],"?login=");
			$pos2 = strpos($toolsRow['link'],"&login=");
			if ($pos !== false or $pos2 !== false)
			{
				$link_annex = $_user['username'];
			}
		}

		// setting the actual image url 
		$toolsRow['img'] = $clarolineRepositoryWeb."img/".$toolsRow['img'];
		
		if ($i%$numcols==0)
			echo	"<tr>\n";

		echo	"<td $iconcolprops>\n";
		if ($cat == 'Basic' and ($toolsRow["column"]-1 != $i%$numcols)) // put basic tools in the defined column/row position
		{
			do
			{
				$i++;
				echo "&nbsp;</td>\n<td $toolcolprops>&nbsp;\n</td>\n";

				if($i%$numcols==0)
				{
					echo "</tr>\n<tr>\n";
				}
				echo	"<td $iconcolprops>\n";
			}
			while(($toolsRow["column"]-1-$i%$numcols!=0) and $i<100);
		}
		// VISIBLE
		if ($toolsRow["visibility"]==1 or $cat == 'courseAdmin' or $cat == 'claroAdmin')
			{
			echo "<a href=\"".$toolsRow['link'].$link_annex."\" target=\"$toolsRow[target]\"><img src=\"",$toolsRow['img'],
				"\" alt=\"\" border=\"0\">","</a></td>\n";
			echo "<td $toolcolprops>\n",
				"<a href=\"".$toolsRow['link'].$link_annex."\" target=\"$toolsRow[target]\">".$tool_name."</a>\n";
			}
		// INVISIBLE 
		else
		{
			if (api_is_allowed_to_edit())
			{
				echo "<a href=\"".$toolsRow['link'].$link_annex."\" target=\"$toolsRow[target]\"><img src=\"",str_replace(".gif", "_na.gif" , $toolsRow['img']),
					"\" alt=\"\" border=\"0\">","</a></td>\n";
				echo "<td $toolcolprops>\n",
					"<a href=\"".$toolsRow['link'].$link_annex."\" target=\"$toolsRow[target]\" class=\"invisible\">".$tool_name."</a>\n";
			}
			else
			{
				echo "<img src=\"",str_replace(".gif", "_na.gif", $toolsRow['img']),
					"\" alt=\"\" border=\"0\"></td>\n";
				echo "<td $toolcolprops>\n";
				echo "<span class=\"invisible\">".$tool_name."</span>";
			}
		}

		unset($lnk);

		if (api_is_allowed_to_edit() and $cat!="courseAdmin"  && !strpos($toolsRow['link'],'learnpath_handler.php?learnpath_id'))
		{
			if ($toolsRow["visibility"]==1 )
			{
				$link['name'] = '<img src="'.api_get_path(WEB_CODE_PATH).'img/visible.gif" align="absmiddle" alt="'.get_lang('Deactivate').'"/>'; 
				$link['cmd']  = "hide=yes";
				$lnk[] = $link;
			}
			else
			{
				$link['name'] = '<img src="'.api_get_path(WEB_CODE_PATH).'img/invisible.gif" align="absmiddle" alt="'.get_lang('Activate').'"/>';  
				$link['cmd']  = "restore=yes";
				$lnk[] = $link;

				/*if($toolsRow["img"] == $clarolineRepositoryWeb."img/external.gif")
				{
					$link['name'] = get_lang('Remove'); $link['cmd']  = "remove=yes";
					if ($toolsRow["visibility"]==2 and $cat=="claroAdmin")
					{
						$link['name'] = get_lang('Delete'); $link['cmd'] = "askDelete=yes";
						$lnk[] = $link;
					}
				}*/
			}
			//echo "<div class=courseadmin>";
			if (is_array($lnk))
			{
				foreach($lnk as $thisLnk)
				{
					if ($toolsRow['adminlink'])
						{
						echo	'<a href="'.$properties['adminlink'].'">'.'<img src="'.api_get_path(WEB_CODE_PATH).'/img/edit.gif" alt="'.get_lang('Edit').'"/>'.'</a>';
						//echo "edit link:".$properties['adminlink'];
						}
					else
						{
						echo	"<a href=\"".$_SERVER['PHP_SELF']."?id=".$toolsRow["id"]."&".$thisLnk['cmd']."\">"
							.$thisLnk['name']."</a>";
						}
					}
			}
			
    		// RH: Allow editing of invisible homepage links (modified external_module)
    		
    		if ($toolsRow["added_tool"] == 1 && api_is_allowed_to_edit() && !$toolsRow["visibility"])
    			echo	"<a class=\"nobold\" href=\"" . api_get_path(WEB_PATH) . 
                        'claroline/external_module/external_module.php' . 
                        "?id=".$toolsRow["id"]."\">". get_lang("Edit"). "</a>";

			//echo "</div>\n";
		}

		echo "</td>\n\n";

		if(($i+1)%$numcols==0)	// if this is the last column
			echo "</tr>\n";
		$i++;
	}

	if ($i%$numcols!=0) //complete the number of columns in the table
	{
		while($i%$numcols!=0)
		{
			echo	"<td $iconcolprops>&nbsp;</td>\n<td $toolcolprops>&nbsp;\n</td>\n";
			$i++;
		}
		echo 	"</tr>\n";
	}

}  // end function showtools2($cat)

?>
