<?php // $Id: index.php,v 1.28 2005/05/19 13:41:08 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* This script displays the course description to the user.
*
* If the user has editing rights (course admin), (s)he can edit the description.
*
* Proposals (not implemented yet)
*	- edit the colour of the description background (Thierry De Henau)
* 	- one block is linked with the agenda tool. To propose a big step in the course.
*  	- one block is linked with the link tool. To propose important resources in the course.
*
* @author Thomas Depraetere
* @author Hugues Peeters
* @author Christophe Gesch
* @author Olivier brouckaert
* @author Wolfgang Schneider
* @author Roan Embrechts, refactoring
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @package dokeos.course_description
==============================================================================
*/
	
/*
==============================================================================
		INIT SECTION
==============================================================================
*/

$langFile = "course_description";

include('../inc/claro_init_global.inc.php');

/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/ 
include_once(api_get_library_path()."/text.lib.php");
include_once(api_get_library_path()."/events.lib.inc.php");

$nameTools=get_lang('CourseProgram');

if ($origin != 'learnpath')
{
	//we are not in learnpath tool
	Display::display_header($nameTools,"Description");
}
else
{
	//there has to be a better way than this?
	?> <link rel="stylesheet" type="text/css" href="<?php echo api_get_path(WEB_CODE_PATH); ?>css/default.css"/> 
	<?php
}

event_access_tool(TOOL_COURSE_DESCRIPTION);

$course_description_table = Database::get_course_table(COURSE_DESCRIPTION_TABLE);
$is_allowed_to_edit = api_is_allowed_to_edit();



api_display_tool_title($nameTools);

if (! $is_allowed_in_course) api_not_allowed();

/*
-----------------------------------------------------------
	Introduction section
	(editable by course admins)
-----------------------------------------------------------
*/
api_introductionsection(TOOL_COURSE_DESCRIPTION);

if($is_allowed_to_edit and ($origin != 'learnpath'))
{
	echo "<p><a href=\"edit.php\">" . get_lang("EditCourseProgram") . "</a></p>";
}

$result = api_sql_query("SELECT `id`,`title`,`content` FROM ".$course_description_table." ORDER BY id",__FILE__,__LINE__);

if(mysql_num_rows($result))
{
	echo "<hr noshade=\"noshade\" size=\"1\" />";

	while($row=mysql_fetch_array($result))
	{
		echo "<h4>$row[title]</h4>";

		$content=make_clickable(nl2br($row['content']));
		$content=api_parse_tex($content);

		echo $content;
	}
}
else
{
	echo "<br/><em>".get_lang("ThisCourseDescriptionIsEmpty")."</em>";
}

/*
==============================================================================
		FOOTER 
==============================================================================
*/ 

if ($origin != 'learnpath')
{
	//we are not in learnpath tool
	Display::display_footer();
}

?>
