<?php 
// $Id: edit.php,v 1.27 2005/05/12 07:07:06 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	This script edits the course description.
*	This script is reserved for users with write access on the course.
*
*	@author Thomas Depraetere
*	@author Hugues Peeters
*	@author Christophe Gesch
*	@author Olivier brouckaert
*	@package dokeos.course_description
==============================================================================
*/
	
/*
==============================================================================
		INIT SECTION
==============================================================================
*/ 

$langFile= array('course_description','pedaSuggest');

include('../inc/claro_init_global.inc.php');
api_protect_course_script();

include(api_get_library_path().'/text.lib.php');
/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/ 
$numBloc = $_REQUEST['numBloc'];
$add = $_REQUEST['add'];
$edTitleBloc = $_REQUEST['edTitleBloc'];
$edIdBloc = $_REQUEST['edIdBloc'];
$edContentBloc = $_REQUEST['edContentBloc'];
$save = $_REQUEST['save'];
$delete = $_REQUEST['delete'];

$nameTools = get_lang('EditCourseProgram') ;

$interbredcrump[] = array("url" => "index.php", "name"=> get_lang('CourseProgram'));

$tbl_course_description = $_course['dbNameGlu'].'course_description';

$showPedaSuggest = true;

$titreBloc = array(
					1 => get_lang('GeneralDescription'),
					2 => get_lang('Objectives'),
					3 => get_lang('Topics'),
					4 => get_lang('Methodology'),
					5 => get_lang('CourseMaterial'),
					6 => get_lang('HumanAndTechnicalResources'),
					7 => get_lang('Assessment')
				);
$questionPlan = array(
					1 => get_lang('GeneralDescriptionQuestions'),
					2 => get_lang('ObjectivesQuestions'),
					3 => get_lang('TopicsQuestions'),
					4 => get_lang('MethodologyQuestions'),
					5 => get_lang('CourseMaterialQuestions'),
					6 => get_lang('HumanAndTechnicalResourcesQuestions'),
					7 => get_lang('AssessmentQuestions')
				);
$info2Say = array(
					1 => get_lang('GeneralDescriptionInformation'),
					2 => get_lang('ObjectivesInformation'),
					3 => get_lang('TopicsInformation'),
					4 => get_lang('MethodologyInformation'),
					5 => get_lang('CourseMaterialInformation'),
					6 => get_lang('HumanAndTechnicalResourcesInformation'),
					7 => get_lang('AssessmentInformation')
				);		
$titreBlocNotEditable = array(
					1 => true,
					2 => false,
					3 => false,
					4 => false,
					5 => false,
					6 => false,
					7 => false
				);

if($delete == 'ask')
{
	api_sql_query("DELETE FROM `$tbl_course_description` WHERE id='".$_GET['numBloc']."'",__FILE__,__LINE__);

	header('Location: '.$_SERVER['PHP_SELF']);
	exit();
}

/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/
$htmlHeadXtra[]='<style type="text/css">
<!--
.QuestionDePlanification {  background-color: '.$color2.'; background-position: left center; letter-spacing: normal; text-align: justify; word-spacing: normal; padding: 5px; }
.InfoACommuniquer { background-color: '.$color1.'; background-position: left center; letter-spacing: normal; text-align: justify; word-spacing: normal; padding-top: 2px; padding: 5px; }
-->
</style>';

Display::display_header($nameTools,"Description");
if( ! api_is_allowed_to_edit() )
{
	api_not_allowed();
}
api_display_tool_title($nameTools);

/*
==============================================================================
		MAIN CODE
==============================================================================
*/ 
if(isset($save))
{
	if($_POST['edIdBloc'] == 'add')
	{
		$result=api_sql_query("SELECT MAX(id) FROM `$tbl_course_description`",__FILE__,__LINE__);

		list($idMax)=mysql_fetch_row($result);

		$idMax=max(sizeof($titreBloc),$idMax);

		$sql="INSERT IGNORE INTO `$tbl_course_description`(`id`) VALUES('".($idMax+1)."')";

		$_POST['edIdBloc']=$idMax+1;
	}
	else
	{
		$sql="INSERT IGNORE INTO `$tbl_course_description`(`id`) VALUES('".$_POST['edIdBloc']."')";
	}

	api_sql_query($sql,__FILE__,__LINE__);

	if(empty($edTitleBloc))
	{
		$edTitleBloc=$titreBloc[$edIdBloc];
	}

	api_sql_query("UPDATE `$tbl_course_description` SET `title`='".trim(htmlspecialchars($edTitleBloc))."',`content`='".trim($edContentBloc)."' WHERE id='".$_POST['edIdBloc']."'",__FILE__,__LINE__);
}

if(isset($numBloc))
{
	if (is_numeric($numBloc))
	{
		$result=api_sql_query("SELECT * FROM `$tbl_course_description` WHERE id='$numBloc'",__FILE__,__LINE__);

		if($blocs=mysql_fetch_array($result))
		{
			$titreBloc[$numBloc]=$blocs['title'];
			$contentBloc=$blocs['content'];
		}
	}

	echo '<form method="post" action="'.$_SERVER['PHP_SELF'].'" onsubmit="javascript:updateRTEs();"><p><b>'.$titreBloc[$numBloc].'</b><br/>';

	if(($numBloc == 'add') || !$titreBlocNotEditable[$numBloc])
	{
		echo '<br/>'.get_lang('OuAutreTitre').' : <input type="text" name="edTitleBloc" size="50" value="'.$titreBloc[$numBloc].'" />';
	}
	else
	{
		echo '<input type="hidden" name="edTitleBloc" value="'.$titreBloc[$numBloc].'" />';
	}

	if ($numBloc =="add")
	{
		echo '<input type="hidden" name="edIdBloc" value="add" />';
	}
	else
	{
		echo '<input type="hidden" name="edIdBloc" value="'.$numBloc.'" />';
	}

	echo '</p><table border="0"><tr><td valign="top">';

	api_disp_html_area('edContentBloc',$contentBloc,'250px');

	echo '</td>';

	if($showPedaSuggest)
	{
		if(isset($questionPlan[$numBloc]))
		{
			echo '<td valign="top">',
			'<table border="0" cellpadding="5" cellspacing="0" style="margin: 5px;">',
			'<tr><td valign="top" class="QuestionDePlanification"><b>'.get_lang('QuestionPlan').'</b></td></tr>',
			'<tr><td valign="top" class="QuestionDePlanification">'.$questionPlan[$numBloc].'</td></tr>',
			'</table>';
		}

		if(isset($info2Say[$numBloc]))
		{
			echo '<table border="0" cellpadding="5" cellspacing="0" style="margin: 5px;">',
			 '<tr><td valign="top" class="InfoACommuniquer"><b>'.get_lang('Info2Say').'</b></td></tr>',
			'<tr><td valign="top" class="InfoACommuniquer">'.$info2Say[$numBloc].'</td></tr>',
			'</table>',
			'</td>';
		}
	}

	echo '</tr>',
			'</table>',
			'<input type="submit" name="save" value="'.get_lang('Ok').'" />&nbsp;&nbsp;',
			'</form>';
}
else
{
	$result=api_sql_query("SELECT * FROM `$tbl_course_description` ORDER BY id",__FILE__,__LINE__);

	while($bloc=mysql_fetch_array($result))
	{
		$blocState[$bloc['id']]='used';
		$titreBloc[$bloc['id']]=$bloc['title'];
		$contentBloc[$bloc['id']]=$bloc['content'];
	}

	echo '<table border="0" width="100%">',
		'<tr><td valign="middle"><b>'.get_lang("AddCat").'</b></td><td align="right" valign="middle">',
		'<form method="post" action="'.$_SERVER['PHP_SELF'].'"><select name="numBloc" size="1">';

	while(list($numBloc,) = each($titreBloc))
	{
		if(!isset($blocState[$numBloc]) || $blocState[$numBloc] != 'used')

		echo '<option value="'.$numBloc.'">'.$titreBloc[$numBloc].'</option>';
	}

	echo '<option value="add">'.get_lang("NewBloc").'</option></select> <input type="submit" name="add" value="'.get_lang("Add").'"></form>',
		'</td></tr></table>',
		'<table border="0" width="100%">',
		'<tr><td colspan="2" bgcolor="'.$color2.'" class="alternativeBgDark"></td></tr>';

	reset($titreBloc);

	while(list($numBloc,) = each($titreBloc))
	{
		if(isset($blocState[$numBloc]) && $blocState[$numBloc] == 'used')
		{
		echo '<tr><td bgcolor="'.$color1.'" class="alternativeBgLight"><h4>'.$titreBloc[$numBloc].'</h4></td>',
			'<td align="left"><a href="'.$_SERVER['PHP_SELF'].'?numBloc='.$numBloc.'">',
			'<img src="../img/edit.gif" alt="'.get_lang('Modify').'" border="0" /></a>',
			' <a href="'.$_SERVER['PHP_SELF'].'?delete=ask&numBloc='.$numBloc.'" onclick="javascript:if(!confirm(\''.addslashes(htmlspecialchars(get_lang('ConfirmYourChoice'))).'\')) return false;">',
  		'<img src="../img/delete.gif" alt="'.get_lang("Delete").'" border="0" /></a></td></tr>',
			'<tr><td colspan="2">';

			$contentBloc[$numBloc]=nl2br($contentBloc[$numBloc]);
			$contentBloc[$numBloc]=api_parse_tex($contentBloc[$numBloc]);

			echo $contentBloc[$numBloc].'</td></tr>';
		}
	}

	echo '</table>';
}

/*
==============================================================================
		FOOTER 
==============================================================================
*/ 
Display::display_footer();
?>