<?php

/*
-----------------------------------------------------------
-----------------------------------------------------------
						HEADER
-----------------------------------------------------------
-----------------------------------------------------------
*/ 

// setting the language file
$langFile = "agenda";

// setting the global file that gets the general configuration, the databases, the languages, ...
include('../inc/claro_init_global.inc.php');
//error_reporting(E_ALL);
require (api_get_library_path()."/groupmanager.lib.php");

/* ============================================================================== 
  			ACCESS RIGHTS
============================================================================== */
// notice for unauthorized people. 
api_protect_course_script();

/*
============================================================================== 
	   RESOURCE LINKER (Patrick Cool, march 2004)
============================================================================== 
*/
$_SESSION['source_type']="Agenda";
include('../resourcelinker/resourcelinker.inc.php');
if ($addresources) // When the "Add Resource" button is clicked we store all the form data into a session
{
$form_elements= array ('day'=>$_POST['fday'], 'month'=>$_POST['fmonth'], 'year'=>$_POST['fyear'], 'hour'=>$_POST['fhour'], 'minutes'=>$_POST['fminute'],
						'end_day'=>$_POST['end_fday'], 'end_month'=>$_POST['end_fmonth'], 'end_year'=>$_POST['end_fyear'], 'end_hours'=>$_POST['end_fhour'], 'end_minutes'=>$_POST['end_fminute'], 
						'title'=>stripslashes($_POST['title']), 'content'=>stripslashes($_POST['content']), 'id'=>$_POST['id'], 'action'=>$_POST['action'], 'to'=>$_POST['selectedform']);
$_SESSION['formelements']=$form_elements;
if($id) // this is to correctly handle edits
	{$action="edit";}
//print_r($form_elements);
header("Location: ../resourcelinker/resourcelinker.php?source_id=1&action=$action&id=$id&originalresource=no");
exit;
}
/*
============================================================================== 
  			INCLUDING THE NECESSARY FILES
============================================================================== 
*/
// containing the functions for the agenda tool
include "agenda.inc.php";
// some text manipulation functions
include($includePath."/lib/text.lib.php");
// some debug functions
include($includePath."/lib/debug.lib.inc.php");

/*============================================================================== 
  			TREATING THE PARAMETERS 
			1. viewing month only or everything
			2. sort ascending or descending
			3. showing or hiding the send-to-specific-groups-or-users form
			4. filter user or group
  ============================================================================== */
	// 1. show all or show current month?
	if (!$_SESSION['show'])
		{
		$_SESSION['show']="showall";
		}
	if ($_GET['action']=="showcurrent")
		{
		$_SESSION['show']="showcurrent";
		}
	if ($_GET['action']=="showall")
		{
		$_SESSION['show']="showall";
		}
	//echo $_SESSION['show'];
	
	// 2. sorting order (ASC or DESC)
	if (!$_GET['sort'] and !$_SESSION['sort'])
		{
		$_SESSION['sort']="DESC";
		}
	if ($_GET['sort']=="asc")
		{
		$_SESSION['sort']="ASC";
		}
	if ($_GET['sort']=="desc")
		{
		$_SESSION['sort']="DESC";
		}
		
	// 3. showing or hiding the send-to-specific-groups-or-users form	
	  $setting_allow_individual_calendar=true; 
	  if (!$_POST['To'] and !$_SESSION['allow_individual_calendar'])
	  	{
		$_SESSION['allow_individual_calendar']="hide";
		}
	  $allow_individual_calendar_status=$_SESSION['allow_individual_calendar']; 
	  if ($_POST['To'] and ($allow_individual_calendar_status=="hide"))
	  	{
		$_SESSION['allow_individual_calendar']="show";
		}
	  if ($_POST['To'] and ($allow_individual_calendar_status=="show"))
	  	{
		$_SESSION['allow_individual_calendar']="hide";
		}
		
	// 4. filter user or group
	if ($_GET['user'] or $_GET['group'])
		{
		$_SESSION['user']=$_GET['user'];
		$_SESSION['group']=$_GET['group'];
		}
	if ($_GET['user']=="none" or $_GET['group']=="none")
		{
		api_session_unregister("user"); 
		api_session_unregister("group"); 
		}	
	if ($_GET['isStudentView']=="false")
		{
		api_session_unregister("user"); 
		api_session_unregister("group"); 
		}

// setting the javascripts 
if ($_SESSION['allow_individual_calendar']=="show")
	{
	// this javascript should only be loaded when we show the forms to send messages to individual users/groups
	// because otherwise it produces a bug (=> year is set to 2009 on submit due to the javascript selectAll
	$htmlHeadXtra[] = to_javascript();
	}
$htmlHeadXtra[] = user_group_filter_javascript(); 
// this loads the javascript that is needed for the date popup selection
$htmlHeadXtra[] = "<script src=\"tbl_change.js\" type=\"text/javascript\" language=\"javascript\"></script>";

// setting the name of the tool
$nameTools = get_lang("langcalendar_event"); // language variable in trad4all.inc.php

// showing the header if we are not in the learning path, if we are in 
// the learning path, we do not include the banner so we have to explicitly 
// include the stylesheet, which is normally done in the header
if ($_GET['origin'] != 'learnpath') 
	{ 
	Display::display_header($nameTools,'Agenda');
	}
else 
	{
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$clarolineRepositoryWeb."css/default.css\"/>";
	}


/* ============================================================================== 
  			TRACKING
==============================================================================  */
include('../inc/lib/events.lib.inc.php');
event_access_tool(TOOL_CALENDAR_EVENT);

/* ============================================================================== 
  			SETTING SOME VARIABLES
============================================================================== */
// Variable definitions
$dateNow 			= format_locale_date($dateTimeFormatLong);
// Defining the shorts for the days. We use camelcase because these are arrays of language variables
$DaysShort = array (get_lang("SundayShort"), get_lang("MondayShort"), get_lang("TuesdayShort"), get_lang("WednesdayShort"), get_lang("ThursdayShort"), get_lang("FridayShort"), get_lang("SaturdayShort"));
// Defining the days of the week to allow translation of the days. We use camelcase because these are arrays of language variables
$DaysLong = array (get_lang("SundayLong"), get_lang("MondayLong"), get_lang("TuesdayLong"), get_lang("WednesdayLong"), get_lang("ThursdayLong"), get_lang("FridayLong"), get_lang("SaturdayLong"));
// Defining the months of the year to allow translation of the months. We use camelcase because these are arrays of language variables
$MonthsLong = array (get_lang("JanuaryLong"), get_lang("FebruaryLong"), get_lang("MarchLong"), get_lang("AprilLong"), get_lang("MayLong"), get_lang("JuneLong"), get_lang("JulyLong"), get_lang("AugustLong"), get_lang("SeptemberLong"), get_lang("OctoberLong"), get_lang("NovemberLong"), get_lang("DecemberLong"));

// setting the database variables
$TABLEAGENDA 		= Database::get_course_table(AGENDA_TABLE);
$TABLE_ITEM_PROPERTY = Database::get_course_table(LAST_TOOL_EDIT_TABLE);
$tbl_user       = Database::get_main_table(MAIN_USER_TABLE);
$tbl_courseUser = Database::get_main_table(MAIN_COURSE_USER_TABLE);
$tbl_group      = Database::get_course_table(GROUP_TABLE);
$tbl_groupUser  = Database::get_course_table(GROUP_USER_TABLE);


/* ============================================================================== 
  			ACCESS RIGHTS
============================================================================== */
// permission stuff
$is_allowedToEdit 	= is_allowed_to_edit();
$is_allowed_to_edit = is_allowed_to_edit();

/* ============================================================================== 
  			TITLE 
============================================================================== */
// Displaying the title of the tool 
api_display_tool_title($nameTools);

// tool introduction
api_introductionsection(TOOL_CALENDAR_EVENT);

// inserting an anchor (top) so one can jump back to the top of the page
echo "<a name=\"top\"></a>";

/*-----------------------------------------------------------
-----------------------------------------------------------
					MAIN CODE
-----------------------------------------------------------
-----------------------------------------------------------
*/ 

//setting the default year and month
$select_year = $_GET['year'];
$select_month = $_GET['month'];
if (($select_year==NULL) && ($select_month==NULL))
{
	$today = getdate();
	$select_year = $today['year'];
	$select_month = $today['mon'];
}



echo "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">"
		. "<tr>";

// THE LEFT PART
	if ($_GET['origin']!='learnpath') 
	{ 
		echo '<td width="220" height="19" valign="top">';
		// the small calendar
		$MonthName = $MonthsLong[$select_month -1];
		$agenda_items=get_kalender_items($select_month,$select_year);
		display_minimonthcalendar($agenda_items, $select_month,$select_year, $MonthName); 
		// the links for adding, filtering, showall, ...
		echo "<ul id=\"agenda_select\">";
		if (is_allowed_to_edit())
		{
			display_courseadmin_links(); 
		}
		display_student_links();
		echo "</ul>";
		echo "</td>";
		echo "<td width=\"20\" background=\"../img/verticalruler.gif\">&nbsp;</td>";
	}
	



// THE RIGHT PART
echo "<td valign=\"top\">";

if (is_allowed_to_edit())
{
	switch ($_GET['action'])
	{
		case "add":
		
			if ($_POST['submit_event'])
			{
				store_new_agenda_item();
				display_agenda_items();
			}
			else
			{
				show_add_form();
			}
			break;
		
		case "edit":
			if ($_POST['submit_event'])
			{
					store_edited_agenda_item();
					display_agenda_items();
			}
			else
			{
					$id=(int)$_GET['id'];
					show_add_form($id);
			}
			break;
	
		case "delete":
			$id=(int)$_GET['id'];
			delete_agenda_item($id);
			display_agenda_items();
			break;
	
		case "showhide":
			$id=(int)$_GET['id'];
			showhide_agenda_item($id);
			display_agenda_items();
			break;		
	}
}


// this is for students and whenever the courseaministrator has not chosen any action. It is in fact the default behaviour
if (!$_GET['action'] OR $_GET['action']=="showall"  OR $_GET['action']=="showcurrent" OR $_GET['action']=="view")
{
	if ($_GET['origin'] != 'learnpath') 
	{
		display_agenda_items();
	}
	else 
	{
		display_one_agenda_item($_GET['agenda_id']);
	}
}
echo "&nbsp;</td></tr></table>";


// The footer is displayed only if we are not in the learnpath
if ($_GET['origin'] != 'learnpath') 
{ 
	include($includePath."/claro_init_footer.inc.php");
}	
?>