<?php
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
	@author: Patrick Cool, patrick.cool@UGent.be
	@version: 1.1
	@todo: synchronisation with the function in myagenda.php (for instance: using one function for the mini_calendar
==============================================================================
	Large parts of the code are recycled from the old agenda tool, but I
	reworked it and cleaned the code to make it more readable. The code for
	the small calender on the left is taken from the My Agenda tool. 
	
	Reabability is also the reason why I use the if ($is_allowedToEdit) 
	check for each part of the code. I'm aware that is duplication, but
	it makes the code much easier to read.
==============================================================================
*/


/*======================================
	   DEFINING THE NECESSARY ARRAYS
  ======================================*/

// the variables for the days and the months
// Defining the shorts for the days
$DaysShort = array (get_lang("SundayShort"), get_lang("MondayShort"), get_lang("TuesdayShort"), get_lang("WednesdayShort"), get_lang("ThursdayShort"), get_lang("FridayShort"), get_lang("SaturdayShort"));
// Defining the days of the week to allow translation of the days
$DaysLong = array (get_lang("SundayLong"), get_lang("MondayLong"), get_lang("TuesdayLong"), get_lang("WednesdayLong"), get_lang("ThursdayLong"), get_lang("FridayLong"), get_lang("SaturdayLong"));
// Defining the months of the year to allow translation of the months
$MonthsLong = array (get_lang("JanuaryLong"), get_lang("FebruaryLong"), get_lang("MarchLong"), get_lang("AprilLong"), get_lang("MayLong"), get_lang("JuneLong"), get_lang("JulyLong"), get_lang("AugustLong"), get_lang("SeptemberLong"), get_lang("OctoberLong"), get_lang("NovemberLong"), get_lang("DecemberLong"));


/*======================================
	   DEFINING THE NECESSARY ARRAYS
  ======================================*/


/**
* Retrieves all the agenda items from the table
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param integer $month: the integer value of the month we are viewing
* @param integer $year: the 4-digit year indication e.g. 2005
* @return array
*/
function get_kalender_items($month, $year)
{
	global $courseTablePrefix, $dbGlu;
	global $_uid, $_course; 
	global $is_allowedToEdit; 
	
	// database variables
	$TABLEAGENDA=Database::get_course_table(AGENDA_TABLE);
	$TABLE_ITEM_PROPERTY=Database::get_course_table(LAST_TOOL_EDIT_TABLE);

	$group_memberships=GroupManager::get_group_ids($_course['dbName'], $_uid);

	if (is_allowed_to_edit())
		{
		//echo "course admin";
		// added GROUP BY `agenda`.`id` to prevent double display of a message that has been sent to two groups
		$sql="SELECT 
			DISTINCT agenda.*, toolitemproperties.*
			FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
			WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
			AND MONTH(`agenda`.`start_date`)='".$month."' AND YEAR(`agenda`.`start_date`)='".$year."'
			AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
			AND `toolitemproperties`.`visibility`='1'
			GROUP BY `agenda`.`id`
			ORDER BY  start_date ".$sort;
		}
	// if the user is not an administrator of that course
	else
		{
		//echo "GEEN course admin";
		if (is_array($group_memberships))
			{
			$sql="SELECT 
				agenda.*, toolitemproperties.* 
				FROM ".$TABLEAGENDA." agenda,	".$TABLE_ITEM_PROPERTY." toolitemproperties 
				WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
				AND MONTH(`agenda`.`start_date`)='".$month."'
				AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
				AND	( `toolitemproperties`.`to_user_id`='".$_uid."' OR `toolitemproperties`.`to_group_id` IN (0, ".implode(", ", $group_memberships).") )
				AND `toolitemproperties`.`visibility`='1'
				ORDER BY  start_date ".$sort;
			}
		else
			{
			$sql="SELECT 
				agenda.*, toolitemproperties.* 
				FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
				WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
				AND MONTH(`agenda`.`start_date`)='".$month."'
				AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
				AND ( `toolitemproperties`.`to_user_id`='".$_uid."' OR `toolitemproperties`.`to_group_id`='0')
				AND `toolitemproperties`.`visibility`='1'
				ORDER BY  start_date ".$sort;
			}
		}
	$result=api_sql_query($sql,__FILE__,__LINE__);
	$data=array();
	while ($row=mysql_fetch_array($result))
		{
		$datum_item=(int)substr($row["start_date"],8,2);
		//$dag_item=date("d",strtotime($datum_item));
		$data[$datum_item]=intval($datum_item);
		}
	return $data; 
}


/**
* show the mini calender of the given month
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param array an array containing all the agenda items for the given month
* @param integer $month: the integer value of the month we are viewing
* @param integer $year: the 4-digit year indication e.g. 2005
* @param string $monthName: the language variable for the mont name
* @return html code
* @todo refactor this so that $monthName is no longer needed as a parameter
*/
function display_minimonthcalendar($agendaitems, $month, $year, $monthName)
{
	global $DaysShort;
	//Handle leap year
	$numberofdays = array (0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	if (($year % 400 == 0) or ($year % 4 == 0 and $year % 100 <> 0))
		$numberofdays[2] = 29;
	//Get the first day of the month
	$dayone = getdate(mktime(0, 0, 0, $month, 1, $year));
	//Start the week on monday
	$startdayofweek = $dayone['wday'] <> 0 ? ($dayone['wday'] - 1) : 6;
	$backwardsURL = $_SERVER['PHP_SELF']."?coursePath=".$_GET['coursePath']."&courseCode=".$_GET['courseCode']."&month=". ($month == 1 ? 12 : $month -1)."&year=". ($month == 1 ? $year -1 : $year);
	$forewardsURL = $_SERVER['PHP_SELF']."?coursePath=".$_GET['coursePath']."&courseCode=".$_GET['courseCode']."&month=". ($month == 12 ? 1 : $month +1)."&year=". ($month == 12 ? $year +1 : $year);
	
	echo 	"<table id=\"smallcalendar\">\n", 
			"<tr id=\"title\">\n", 
			"<td width=\"10%\"><a href=\"", $backwardsURL, "\">&laquo;</a></td>\n", 
			"<td width=\"80%\" colspan=\"5\">", $monthName, " ", $year, "</td>\n", 
			"<td width=\"10%\"><a href=\"", $forewardsURL, "\">&raquo;</a></td>\n", "</tr>\n";
	
	echo "<tr>\n";
	for ($ii = 1; $ii < 8; $ii ++)
	{
		echo "<td class=\"weekdays\">", $DaysShort[$ii % 7], "</td>\n";
	}
	echo "</tr>\n";
	$curday = -1;
	$today = getdate();
	while ($curday <= $numberofdays[$month])
	{
		echo "<tr>\n";
		for ($ii = 0; $ii < 7; $ii ++)
		{
			if (($curday == -1) && ($ii == $startdayofweek))
			{
				$curday = 1;
			}
			if (($curday > 0) && ($curday <= $numberofdays[$month]))
			{
				$bgcolor = $ii < 5 ? $class="class=\"days_week\"" : $class="class=\"days_weekend\"";
				$dayheader = "$curday";
				if (($curday == $today[mday]) && ($year == $today[year]) && ($month == $today[mon]))
				{
					$dayheader = "$curday";
					$class = "class=\"days_today\"";
				}
				echo "\t<td ".$class.">";
				if ($agendaitems[$curday] <> "")
				{
					echo "<a href=\"".$_SERVER['PHP_SELF']."?action=view&view=day&day=".$curday."&month=".$month."&year=".$year."\">".$dayheader."</a>";
				}
				else
				{
					echo $dayheader;
				}
				// "a".$dayheader." <span class=\"agendaitem\">".$agendaitems[$curday]."</span>\n";
				echo "</td>\n";
				$curday ++;
			}
			else
			{
				echo "<td>&nbsp;</td>\n";
			}
		}
		echo "</tr>\n";
	}
	echo "</table></center>\n";
}


/**
* show the calender of the given month
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param integer $month: the integer value of the month we are viewing
* @param integer $year: the 4-digit year indication e.g. 2005
* @return html code
*/
function display_monthcalendar($month, $year)
{
	global $MonthsLong;
	global $datakalenderitems;
	global $DaysShort;
	global $origin;
	
	// grabbing all the kalender items for this year and storing it in a array
	$data=get_kalender_items($month,$year);
		

	//Handle leap year
	$numberofdays = array(0,31,28,31,30,31,30,31,31,30,31,30,31);
	if (($year%400 == 0) or ($year%4==0 and $year%100<>0)) $numberofdays[2] = 29;
	
	//Get the first day of the month
	$dayone = getdate(mktime(0,0,0,$month,1,$year));   
  	//Start the week on monday
	$startdayofweek = $dayone['wday']<>0 ? ($dayone['wday']-1) : 6;
		
	$backwardsURL = $_SERVER['PHP_SELF']."?origin=$origin&month=".($month==1 ? 12 : $month-1)."&year=".($month==1 ? $year-1 : $year);
	$forewardsURL = $_SERVER['PHP_SELF']."?origin=$origin&month=".($month==12 ? 1 : $month+1)."&year=".($month==12 ? $year+1 : $year);

	   $maand_array_maandnummer=$month-1;

	echo "<table id=\"smallcalendar\">\n",
		"<tr id=\"title\">\n",
		"<td width=\"10%\"><a href=\"",$backwardsURL,"\">&laquo;</a></td>\n",
		"<td width=\"80%\" colspan=\"5\">",$MonthsLong[$maand_array_maandnummer]," ",$year,"</td>\n",
		"<td width=\"10%\"><a href=\"",$forewardsURL,"\">&raquo;</a></td>\n",
		"</tr>\n";

	echo "<tr>\n";
			
	for ($ii=1;$ii<8; $ii++)
	{
	echo "<td id=\"weekdays\">",$DaysShort[$ii%7],"</td>\n";  
  }

	echo "</tr>\n";
	$curday = -1;
	$today = getdate();
	while ($curday <=$numberofdays[$month])
  	{
	echo "<tr>\n";
    	for ($ii=0; $ii<7; $ii++)
	  	{
	  		if (($curday == -1)&&($ii==$startdayofweek))
			{ 
	    		$curday = 1;
			}
			if (($curday>0)&&($curday<=$numberofdays[$month]))
			{
				$bgcolor = $ii<5 ? "class=\"alternativeBgLight\"" : "class=\"alternativeBgDark\"";

				$dayheader = "$curday";
				if (in_array($curday,$data))
					{ $dayheader="<a href='".$_SERVER['PHP_SELF']."?origin=$origin&month=$month&year=$year&day=$curday#$curday'>".$curday."</a>"; }
		  		
				if (($curday==$today['mday'])&&($year ==$today['year'])&&($month == $today[mon]))
				{
			echo "<td id=\"today\" ",$bgcolor,"\">".$dayheader." \n";
      }
				else
				{
			echo "<td id=\"days\" ",$bgcolor,"\">".$dayheader." \n";
				}
			echo "</td>\n";

	      		$curday++;
	    }
	  		else
	    {
	echo "<td>&nbsp;</td>";
  
	    }
		}
	echo "</tr>";
    }
echo "</table>";
}


/**
* returns all the javascript that is required for easily selecting the target people/groups this goes into the $htmlHeadXtra[] array
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return javascript code
*/
function to_javascript()
{
$Send2All=get_lang("Send2All"); 


return "<script type=\"text/javascript\" language=\"JavaScript\">

<!-- Begin javascript menu swapper

function move(fbox,	tbox)
{
	var	arrFbox	= new Array();
	var	arrTbox	= new Array();
	var	arrLookup =	new	Array();

	var	i;
	for	(i = 0;	i <	tbox.options.length; i++)
	{
		arrLookup[tbox.options[i].text]	= tbox.options[i].value;
		arrTbox[i] = tbox.options[i].text;
	}

	var	fLength	= 0;
	var	tLength	= arrTbox.length;

	for(i =	0; i < fbox.options.length;	i++)
	{
		arrLookup[fbox.options[i].text]	= fbox.options[i].value;

		if (fbox.options[i].selected &&	fbox.options[i].value != \"\")
		{
			arrTbox[tLength] = fbox.options[i].text;
			tLength++;
		} 
		else
		{
			arrFbox[fLength] = fbox.options[i].text;
			fLength++;
		}
	}

	arrFbox.sort();
	arrTbox.sort();
	fbox.length	= 0;
	tbox.length	= 0;

	var	c;
	for(c =	0; c < arrFbox.length; c++)
	{
		var	no = new Option();
		no.value = arrLookup[arrFbox[c]];
		no.text	= arrFbox[c];
		fbox[c]	= no;
	}
	for(c =	0; c < arrTbox.length; c++)
	{
		var	no = new Option();
		no.value = arrLookup[arrTbox[c]];
		no.text	= arrTbox[c];
		tbox[c]	= no;
	}
}

function validate()
{
	var	f =	document.new_calendar_item;
	f.submit();
	return true;
}

function selectAll(cbList,bSelect,showwarning)
{
	if (cbList.length <	1) {
		alert(\"$Send2All\");
		return;
	}
	for	(var i=0; i<cbList.length; i++)	
		cbList[i].selected = cbList[i].checked = bSelect
}

function reverseAll(cbList)
{
	for	(var i=0; i<cbList.length; i++)
	{
		cbList[i].checked  = !(cbList[i].checked) 
		cbList[i].selected = !(cbList[i].selected)
	}
}
//	End	-->
</script>";
}


/**
* returns the javascript for setting a filter. This is a jump menu
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return javascript code
*/
function user_group_filter_javascript()
{
return "<script language=\"JavaScript\" type=\"text/JavaScript\">
<!--
function MM_jumpMenu(targ,selObj,restore){ 
  eval(targ+\".location='\"+selObj.options[selObj.selectedIndex].value+\"'\");
  if (restore) selObj.selectedIndex=0;
}
//-->
</script>
";
}


/**
* this function gets all the users of the current course
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return array: associative array where the key is the id of the user and the value is an array containing
			the first name, the last name, the user id
*/
function get_course_users()
{
global $tbl_user; 
global $tbl_courseUser; 
global $_cid; 

// not 100% if this is necessary, this however prevents a notice
if (!isset($courseadmin_filter))
	{$courseadmin_filter='';}
	

$sql =	"SELECT u.lastname lastName, u.firstname firstName, u.user_id uid
		         FROM ".$tbl_user." u, ".$tbl_courseUser." cu
		         WHERE cu.course_code = '".$_cid."' 
		         AND cu.user_id = u.user_id $courseadmin_filter
		         ORDER BY u.lastname, u.firstname";
$result = api_sql_query($sql,__FILE__,__LINE__) or die(mysql_error()); 
while ($user_data = mysql_fetch_array($result))
	{
	$user_list [$user_data['uid']] = $user_data;
	}
return $user_list; 
}


/**
* this function gets all the groups of the course
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return array
*/
function get_course_groups()
{
global $tbl_group; 
global $tbl_groupUser;

$sql = "SELECT g.id, g.name, COUNT(gu.id) userNb 
		        FROM ".$tbl_group." AS g LEFT JOIN ".$tbl_groupUser." gu 
		        ON g.id = gu.group_id 
		        GROUP BY g.id";
				
$result = api_sql_query($sql,__FILE__,__LINE__) or die(mysql_error());
while ($group_data = mysql_fetch_array($result))
	{
	$group_list [$group_data['id']] = $group_data;
	}
return $group_list; 
}


/**
* this function shows the form for sending a message to a specific group or user. 
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return html code
*/
function show_to_form($to_already_selected)
{
$user_list=get_course_users(); 
$group_list=get_course_groups(); 

echo "\n<table>\n";
	echo "\t<tr>\n";
	// the form containing all the groups and all the users of the course
	echo "\t\t<td>\n";
		construct_not_selected_select_form($group_list,$user_list,$to_already_selected);
	echo "\t\t</td>\n";
	// the buttons for adding or removing groups/users
	echo "\n\t\t<td valign=\"middle\">\n";
	echo "\t\t<input	type=\"button\"	",
				"onClick=\"move(this.form.elements[3],this.form.elements[6])\" ",
				"value=\"   >>   \">",

				"\n\t\t<p>&nbsp;</p>",

				"\n\t\t<input	type=\"button\"",
				"onClick=\"move(this.form.elements[6],this.form.elements[3])\" ", 
				"value=\"   <<   \">";
	echo "\t\t</td>\n";
	echo "\n\t\t<td>\n";
		construct_selected_select_form($group_list,$user_list,$to_already_selected);
	echo "\t\t</td>\n";
	echo "\t</tr>\n";
echo "</table>";
}


/**
* this function shows the form with the user that were not selected
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return html code
*/
function construct_not_selected_select_form($group_list=null, $user_list=null,$to_already_selected)
{
	echo "\t\t<select name=\"not_selected_form[]\" size=5 style=\"width:200px\" multiple>\n";
	
	// adding the groups to the select form
	if (is_array($group_list))
	{
		foreach($group_list as $this_group)
		{
			//api_display_normal_message("group " . $thisGroup[id] . $thisGroup[name]);
			if (!in_array("GROUP:".$this_group[id],$to_already_selected)) // $to_already_selected is the array containing the groups (and users) that are already selected
				{
				echo	"\t\t<option value=\"GROUP:".$this_group[id]."\">",
					"G: ",$this_group[name]," - " . $this_group[userNb] . " " . get_lang('Users') .
					"</option>\n";
			}
		}
		// a divider
		echo	"\t\t<option value=\"\">---------------------------------------------------------</option>\n";
	}
	
	// adding the individual users to the select form
	foreach($user_list as $this_user)
	{
		if (!in_array("USER:".$this_user['uid'],$to_already_selected)) // $to_already_selected is the array containing the users (and groups) that are already selected
		{
			echo	"\t\t<option value=\"USER:",$this_user[uid],"\">",
				"",$this_user[lastName]," ",$this_user[firstName],
				"</option>\n";
		}
	}
	echo "\t\t</select>\n"; 
}



/**
* this function shows the form with the user that were selected
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return html code
*/
function construct_selected_select_form($group_list=null, $user_list=null,$to_already_selected)
{
	// we separate the $to_already_selected array (containing groups AND users into
	// two separate arrays
	if (is_array($groupuser))
	{
		 $groupuser=separate_users_groups($to_already_selected); 
	}
	$groups_to_already_selected=$groupuser['groups'];
	$users_to_already_selected=$groupuser['users'];
	
	// we load all the groups and all the users into a reference array that we use to search the name of the group / user
	$ref_array_groups=get_course_groups();
	$ref_array_users=get_course_users();
	
	// we construct the form of the already selected groups / users
	echo "\t\t<select name=\"selectedform[]\" size=\"5\" multiple style=\"width:200px\" width=\"200px\">";
	foreach($to_already_selected as $groupuser)
	{
		list($type,$id)=explode(":",$groupuser);
		if ($type=="GROUP")
		{
			echo "\t\t<option value=\"".$groupuser."\">G: ".$ref_array_groups[$id]['name']."</option>";	
		}
		else
		{
			echo "\t\t<option value=\"".$groupuser."\">".$ref_array_users[$id]['lastName']." ".$ref_array_users[$id]['firstName']."</option>";	
		}
	}
	echo "</select>\n";
}



/**
* This function stores the Agenda Item in the table calendar_event and updates the item_property table also
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return integer the id of the last added agenda item
*/
function store_new_agenda_item()
{
global $TABLEAGENDA; 
global $_uid; 

// some filtering of the input data
$title=strip_tags(trim($_POST['title'])); // no html allowed in the title
$content=trim($_POST['content']);
$start_date=(int)$_POST['fyear']."-".(int)$_POST['fmonth']."-".(int)$_POST['fday']." ".(int)$_POST['fhour'].":".(int)$_POST['fminute'].":00";
$end_date=(int)$_POST['end_fyear']."-".(int)$_POST['end_fmonth']."-".(int)$_POST['end_fday']." ".(int)$_POST['end_fhour'].":".(int)$_POST['end_fminute'].":00";


// store in the table calendar_event
$sql = "INSERT INTO ".$TABLEAGENDA."
				        (title,content, start_date, end_date)
				        VALUES
				        ('".$title."','".$content."', '".$start_date."','".$end_date."')";

$result = api_sql_query($sql,__FILE__,__LINE__) or die (mysql_error());
$last_id=mysql_insert_id();


// store in last_tooledit (first the groups, then the users
$to=$_POST['selectedform'];
if ($_SESSION['allow_individual_calendar']=="show" and !is_null($to)) // !is_null($to): when no user is selected we send it to everyone
	{
	$send_to=separate_users_groups($to);
	// storing the selected groups
	if (is_array($send_to['groups']))
		{
		foreach ($send_to['groups'] as $group)
			{ 
				//update_last_tooledit($_course, $nameTools, $last_id, get_lang('new_agenda'), $_uid, $group); 
				item_property_update($_course, TOOL_CALENDAR_EVENT, $last_id,"AgendaAdded", $_uid, $group,'',$start_visible, $end_visible);
			}
		}
	// storing the selected users
	if (is_array($send_to['users']))
		{
		foreach ($send_to['users'] as $user)
			{
				//update_last_tooledit($_course, $nameTools, $last_id, get_lang('new_agenda'), $_uid, '', $user);
				item_property_update($_course, TOOL_CALENDAR_EVENT, $last_id,"AgendaAdded", $_uid,'',$user, $start_visible,$end_visible);
			}
		}
	}
else // the message is sent to everyone, so we set the group to 0
	{
	//update_last_tooledit($_course, $nameTools, $last_id, get_lang('new_agenda'), $_uid, '0');
	item_property_update($_course, TOOL_CALENDAR_EVENT, $last_id,"AgendaAdded", $_uid, '','',$start_visible,$end_visible);
	}
	
// storing the resources
store_resources($_SESSION['source_type'],$last_id);	

return $last_id; 
}


/**
* This function separates the users from the groups
* users have a value USER:XXX (with XXX the dokeos id
* groups have a value GROUP:YYY (with YYY the group id)
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return array
*/
function separate_users_groups($to)
{
foreach($to as $to_item)
	{
	list($type, $id) = explode(':', $to_item);

	switch($type)
		{
		case 'GROUP':
			$grouplist[] =$id;
			break;
		case 'USER':
			$userlist[] =$id;
			break;
		}
	}
$send_to['groups']=$grouplist;
$send_to['users']=$userlist;
return $send_to; 
}



/**
* returns all the users and all the groups a specific Agenda item has been sent to
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @return array
*/
function sent_to($tool, $id)
{
global $_course; 
$TABLE_ITEM_PROPERTY = Database::get_course_table(LAST_TOOL_EDIT_TABLE);

$sql="SELECT * FROM $TABLE_ITEM_PROPERTY WHERE tool='".$tool."' AND ref='".$id."'";
$result=api_sql_query($sql,__FILE__,__LINE__);
while ($row=mysql_fetch_array($result))
	{
	// if to_group_id is null then it is sent to a specific user
	// if to_group_id = 0 then it is sent to everybody
	if (!is_null($row['to_group_id']) )
		{
		$sent_to_group[]=$row['to_group_id'];
		//echo $row['to_group_id']; 
		}
	// if to_user_id <> 0 then it is sent to a specific user
	if ($row['to_user_id']<>0)
		{
		$sent_to_user[]=$row['to_user_id'];
		}
	}
if (isset($sent_to_group))
	{
	$sent_to['groups']=$sent_to_group;
	}
if (isset($sent_to_user))
	{
	$sent_to['users']=$sent_to_user;
	}
return $sent_to;
}



/**
* constructs the form to display all the groups and users the message has been sent to
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param  array $sent_to_array: a 2 dimensional array containing the groups and the users
*				the first level is a distinction between groups and users: $sent_to_array['groups'] and $sent_to_array['users']
*				$sent_to_array['groups'] (resp. $sent_to_array['users']) is also an array containing all the id's of the 		
*				groups (resp. users) who have received this message. 
* @return html
*/
function sent_to_form($sent_to_array)
{
// we find all the names of the groups
$group_names=get_course_groups();

count($sent_to_array);

// we count the number of users and the number of groups
if (isset($sent_to_array['users']))
	{
	$number_users=count($sent_to_array['users']);
	}
else
	{
	$number_users=0;
	}
if (isset($sent_to_array['groups']))
	{
	$number_groups=count($sent_to_array['groups']);
	}
else
	{
	$number_groups=0;
	}
$total_numbers=$number_users+$number_groups; 

// starting the form if there is more than one user/group 
if ($total_numbers >1)
	{
	$output="<select name=\"sent to\">\n";
	$output.="<option>".get_lang("SentTo")."</option>";
	// outputting the name of the groups
	if (is_array($sent_to_array['groups']))
		{
		foreach ($sent_to_array['groups'] as $group_id)
			{
			$output.="\t<option value=\"\">G: ".$group_names[$group_id]['name']."</option>\n"; 
			}
		}
	if (isset($sent_to_array['users']))
	{
		if (is_array($sent_to_array['users']))
			{
			foreach ($sent_to_array['users'] as $user_id)
				{
				$user_info=api_get_user_info($user_id);
				$output.="\t<option value=\"\">".$user_info['firstName']." ".$user_info['lastName']."</option>\n"; 
				}
			}
	}
	
	// ending the form
	$output.="</select>\n";
	}
else // there is only one user/group
	{
	if (is_array($sent_to_array['users']))
		{
		$user_info=api_get_user_info($sent_to_array['users'][0]);
		echo $user_info['firstName']." ".$user_info['lastName'];
		}
	if (is_array($sent_to_array['groups']) and $sent_to_array['groups'][0]!==0)
		{
		$group_id=$sent_to_array['groups'][0];
		echo $group_names[$group_id]['name'];
		}
	if (is_array($sent_to_array['groups']) and $sent_to_array['groups'][0]==0)
		{
		echo get_lang("Everybody");
		}
	//.$sent_to_array['groups'][0];
	}
	
echo $output; 
}


/**
* This function displays a dropdown list that allows the course administrator do view the calendar items of one specific group
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/
function show_group_filter_form()
{
$group_list=get_course_groups();

echo "<select name=\"select\" onChange=\"MM_jumpMenu('parent',this,0)\">";
echo "<option value=\"agenda.php?group=none\">show all groups</option>";
foreach($group_list as $this_group)
	{
	// echo "<option value=\"agenda.php?isStudentView=true&group=".$this_group['id']."\">".$this_group['name']."</option>";
	echo "<option value=\"agenda.php?group=".$this_group['id']."\" ";
	echo ($this_group['id']==$_SESSION['group'])? " selected":"" ;
	echo ">".$this_group['name']."</option>";
	}
echo "</select>";
}



/**
* This function displays a dropdown list that allows the course administrator do view the calendar items of one specific group
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/
function show_user_filter_form()
{
$user_list=get_course_users();

echo "<select name=\"select\" onChange=\"MM_jumpMenu('parent',this,0)\">";
echo "<option value=\"agenda.php?user=none\">show all users</option>";
foreach($user_list as $this_user)
	{
	// echo "<option value=\"agenda.php?isStudentView=true&user=".$this_user['uid']."\">".$this_user['lastName']." ".$this_user['firstName']."</option>";
	echo "<option value=\"agenda.php?user=".$this_user['uid']."\" ";
	echo ($this_user['uid']==$_SESSION['user'])? " selected":"" ;
	echo ">".$this_user['lastName']." ".$this_user['firstName']."</option>";
	}
echo "</select>";
}



/**
* This function displays a dropdown list that allows the course administrator do view the calendar items of one specific group
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/
function show_user_group_filter_form()
{
	echo "<select name=\"select\" onChange=\"MM_jumpMenu('parent',this,0)\">";
	echo "<option value=\"agenda.php?user=none\">".get_lang("ShowAll")."</option>";
	
	// Groups
	echo "<optgroup label=\"".get_lang("Groups")."\">";
	$group_list=get_course_groups();
	foreach($group_list as $this_group)
		{
		// echo "<option value=\"agenda.php?isStudentView=true&group=".$this_group['id']."\">".$this_group['name']."</option>";
		echo "<option value=\"agenda.php?group=".$this_group['id']."\" ";
		echo ($this_group['id']==$_SESSION['group'])? " selected":"" ;
		echo ">".$this_group['name']."</option>";
		}

	// Users	
	echo "<optgroup label=\"".get_lang("Users")."\">";	
	$user_list=get_course_users();	
	foreach($user_list as $this_user)
		{
		// echo "<option value=\"agenda.php?isStudentView=true&user=".$this_user['uid']."\">".$this_user['lastName']." ".$this_user['firstName']."</option>";
		echo "<option value=\"agenda.php?user=".$this_user['uid']."\" ";
		echo ($this_user['uid']==$_SESSION['user'])? " selected":"" ;
		echo ">".$this_user['lastName']." ".$this_user['firstName']."</option>";
		}
	echo "</select>";
}



/**
* This tools loads all the users and all the groups who have received a specific item (in this case an agenda item)  
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/
function load_edit_users($tool, $id)
{
global $_course; 
$TABLE_ITEM_PROPERTY = Database::get_course_table(LAST_TOOL_EDIT_TABLE);

$sql="SELECT * FROM $TABLE_ITEM_PROPERTY WHERE tool='$tool' AND ref='$id'";
$result=api_sql_query($sql,__FILE__,__LINE__) or die (mysql_error());
while ($row=mysql_fetch_array($result))
	{
	$to_group=$row['to_group_id'];
	switch ($to_group)
		{
		// it was send to one specific user
		case null:
			$to[]="USER:".$row['to_user_id'];
			break;
		// it was sent to everyone
		case 0:
			 return "everyone";
			 exit; 
			break;
		default:
			$to[]="GROUP:".$row['to_group_id'];
		}
	}
return $to; 
}



/**
* This functions swithes the visibility a course resource using the visible field in 'last_tooledit' values: 0 = invisible
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/
function change_visibility($tool,$id)
{
	global $_course; 
	$TABLE_ITEM_PROPERTY = Database::get_course_table(LAST_TOOL_EDIT_TABLE);
	
	$sql="SELECT * FROM $TABLE_ITEM_PROPERTY WHERE tool='".TOOL_CALENDAR_EVENT."' AND ref='$id'";
	$result=api_sql_query($sql,__FILE__,__LINE__) or die (mysql_error());
	$row=mysql_fetch_array($result);
	
	if ($row['visibility']=='1')
	{
		$sql_visibility="UPDATE $TABLE_ITEM_PROPERTY SET visibility='0' WHERE tool='$tool' AND ref='$id'";
		item_property_update($_course,TOOL_CALENDAR_EVENT,$id,"invisible");
	}
	else
	{
		$sql_visibility="UPDATE $TABLE_ITEM_PROPERTY SET visibility='1' WHERE tool='$tool' AND ref='$id'";
		item_property_update($_course,TOOL_CALENDAR_EVENT,$id,"visible");
	}
}



/**
* The links that allows the course administrator to add a new agenda item, to filter on groups or users
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/	
function display_courseadmin_links()
{	
	echo "<li><a href='".$_SERVER['PHP_SELF']."?action=add&origin=".$_GET['origin']."'><img src=\"../img/calendar_add.gif\" align=\"absmiddle\" border=\"0\"> ".get_lang("AgendaAdd")."</a><br/></li>";
	echo "<li>".get_lang(UserGroupFilter)."<br>";
	echo "<form name=\"filter\">";
	show_user_group_filter_form();
	echo "</form>";
	echo "</li>";
	echo "<br/>";		
}



/**
* The links that allows the student AND course administrator to show all agenda items and sort up/down
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/	
function display_student_links()
{
	global $show; 
	if ($_SESSION['sort'] == 'DESC')
	{
		echo "<li><a href='".$_SERVER['PHP_SELF']."?sort=asc&origin=".$_GET['origin']."'><img src=\"../img/calendar_up.gif\" border=\"0\" align=\"absmiddle\"> ".get_lang("AgendaSortChronologicallyUp")."</a></li>";
	}
	else
	{
		echo "<li><a href='".$_SERVER['PHP_SELF']."?sort=desc&origin=".$_GET['origin']."'><img src=\"../img/calendar_down.gif\" border=\"0\" align=\"absmiddle\"> ".get_lang("AgendaSortChronologicallyDown")."</a></li>";
	}

	// showing the link to show all items or only those of the current month
	if ($_SESSION['show']=="showcurrent")
	{
		echo "<li><a href='".$_SERVER['PHP_SELF']."?action=showall&origin=".$_GET['origin']."'><img src=\"../img/calendar_select.gif\" border=\"0\" align=\"absmiddle\"> ".get_lang("ShowAll")."</a></li>";
	}
	else
	{
		echo "<li><a href='".$_SERVER['PHP_SELF']."?action=showcurrent&origin=".$_GET['origin']."'><img src=\"../img/calendar_month.gif\" border=\"0\" align=\"absmiddle\"> ".get_lang("ShowCurrent")."</a></li>";
	}
}



/**
* get all the information of the agenda_item from the database
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param integer the id of the agenda item we are getting all the information of
* @return an associative array that contains all the information of the agenda item. The keys are the database fields
*/	
function get_agenda_item($id)
{
	global $TABLEAGENDA; 
	$id=(int)addslashes($_GET['id']);
	$sql 			= "SELECT * FROM ".$TABLEAGENDA." WHERE id='".$id."'";
	$result			= api_sql_query($sql,__FILE__,__LINE__);
	$entry_to_edit 	= mysql_fetch_array($result);
	$item['title']	= $entry_to_edit["title"];
	$item['content']		= $entry_to_edit["content"];
	$item['start_date']	= $entry_to_edit["start_date"];
	$item['end_date']		= $entry_to_edit["end_date"];
	$item['to']=load_edit_users(TOOL_CALENDAR_EVENT, $id);
	// if the item has been sent to everybody then we show the compact to form
	if ($item['to']=="everyone")
	{
		$_SESSION['allow_individual_calendar']="hide";
	}
	else 
	{
		$_SESSION['allow_individual_calendar']="show";
	}		
	//echo "<br>IN get_agenda_item".$_SESSION['allow_individual_calendar']; 
	return $item; 
}
/**
* This is the function that updates an agenda item. It does 3 things
* 1. storethe start_date, end_date, title and message in the calendar_event table
* 2. store the groups/users who this message is meant for in the item_property table
* 3. modify the attachments (if needed)
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/	
function store_edited_agenda_item()
{
	global $_uid; 
	
	// database definitions
	$TABLE_ITEM_PROPERTY = Database::get_course_table(LAST_TOOL_EDIT_TABLE);
	
	// STEP 1: editing the calendar_event table
	// 1.a.  some filtering of the input data
	$id=(int)$_POST['id'];
	$title=strip_tags(trim($_POST['title'])); // no html allowed in the title
	$content=trim($_POST['content']);
	$start_date=(int)$_POST['fyear']."-".(int)$_POST['fmonth']."-".(int)$_POST['fday']." ".(int)$_POST['fhour'].":".(int)$_POST['fminute'].":00";
	$end_date=(int)$_POST['end_fyear']."-".(int)$_POST['end_fmonth']."-".(int)$_POST['end_fday']." ".(int)$_POST['end_fhour'].":".(int)$_POST['end_fminute'].":00";
	$to=$_POST['selectedform'];
	// 1.b. the actual saving in calendar_event table
	$edit_result=save_edit_agenda_item($id,$title,$content,$start_date,$end_date);
	
	// step 2: editing the item_propery table (=delete all and add the new destination users/groups)
	if ($edit_result=true)
	{
		// 2.a. delete everything for the users
		$sql_delete="DELETE FROM ".$TABLE_ITEM_PROPERTY." WHERE ref='$id' AND tool='".TOOL_CALENDAR_EVENT."'";
		
		$result = api_sql_query($sql_delete,__FILE__,__LINE__) or die (mysql_error());
		// 2.b. storing the new users/groups 
		if ($_SESSION['allow_individual_calendar']=="show" and !is_null($to)) // !is_null($to): when no user is selected we send it to everyone
		{
			$send_to=separate_users_groups($to);
			// storing the selected groups
			if (is_array($send_to['groups']))
			{
				foreach ($send_to['groups'] as $group)
				{ 
					item_property_update($_course, TOOL_CALENDAR_EVENT, $id,"AgendaModified", $_uid, $group,'',$start_visible, $end_visible);
				}
			}
			// storing the selected users
			if (is_array($send_to['users']))
			{
				foreach ($send_to['users'] as $user)
				{
					item_property_update($_course, TOOL_CALENDAR_EVENT, $id,"AgendaModified", $_uid,'',$user, $start_visible,$end_visible);
				}
			}
		}
		else // the message is sent to everyone, so we set the group to 0
		{
			//update_last_tooledit($_course, $nameTools, $id, get_lang('new_agenda'), $_uid, '0');
			item_property_update($_course, TOOL_CALENDAR_EVENT, $id,"AgendaModified", $_uid, '','',$start_visible,$end_visible);
		}
		
	} //if ($edit_result=true)
	
	// step 3: update the attachments (=delete all and add those in the session
	update_added_resources("Agenda", $id);
	
	// return the message;
	Display::display_normal_message(get_lang("EditSuccess"));

}

/**
* This function stores the Agenda Item in the table calendar_event and updates the item_property table also (after an edit)
* @author: Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/
function save_edit_agenda_item($id,$title,$content,$start_date,$end_date)
{
	$TABLEAGENDA 		= Database::get_course_table(AGENDA_TABLE);
	
	// store the modifications in the table calendar_event
	$sql = "UPDATE ".$TABLEAGENDA."
								SET title='".$title."',
									content='".$content."',
									start_date='".$start_date."',
									end_date='".$end_date."'
								WHERE id='".$id."'";
	$result = api_sql_query($sql,__FILE__,__LINE__) or die (mysql_error());
	return true; 	
}

/**
* This is the function that deletes an agenda item.
* The agenda item is no longer fycically deleted but the visibility in the item_property table is set to 2
* which means that it is invisible for the student AND course admin. Only the platform administrator can see it.
* This will in a later stage allow the platform administrator to recover resources that were mistakenly deleted
* by the course administrator
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param integer the id of the agenda item wa are deleting
*/	
function delete_agenda_item($id)
{
	if (is_allowed_to_edit())
		{
		if (isset($_GET['id'])&&$_GET['id']&&isset($_GET['action'])&&$_GET['action']=="delete")
			{
			//$sql = "DELETE FROM ".$TABLEAGENDA." WHERE id='$id'";
			//$sql= "UPDATE ".$TABLE_ITEM_PROPERTY." SET visibility='2' WHERE tool='Agenda' and ref='$id'";
			//$result = api_sql_query($sql,__FILE__,__LINE__) or die (mysql_error());
			$id=(int)addslashes($_GET['id']);
			item_property_update($_course,TOOL_CALENDAR_EVENT,$id,"delete");
			
			// delete the resources that were added to this agenda item
			// 2DO: as we no longer fysically delete the agenda item (to make it possible to 'restore' 
			//		deleted items, we should not delete the added resources either. 
			// delete_added_resource("Agenda", $id); // -> this is no longer needed as the message is not really deleted but only visibility=2 (only platform admin can see it)

			//resetting the $id; 
			$id=null;
			
			// displaying the result message in the yellow box
			Display::display_normal_message(get_lang("AgendaDeleteSuccess"));
			}	  // if (isset($id)&&$id&&isset($action)&&$action=="delete")
		} // if ($is_allowedToEdit)

}
/**
* Makes an agenda item visible or invisible for a student
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param integer id the id of the agenda item we are changing the visibility of
*/	
function showhide_agenda_item($id)
{
	/*==================================================
				SHOW / HIDE A CALENDAR ITEM
	  ==================================================*/
	//  and $_GET['isStudentView']<>"false" is added to prevent that the visibility is changed after you do the following:
	// change visibility -> studentview -> course manager view
	if (is_allowed_to_edit() and $_GET['isStudentView']<>"false") 
	{
		if (isset($_GET['id'])&&$_GET['id']&&isset($_GET['action'])&&$_GET['action']=="showhide")
		{
			$id=(int)addslashes($_GET['id']);
			change_visibility($nameTools,$id);
			Display::display_normal_message(get_lang("VisibilityChanged"));
		}
	}
}
/**
* Displays all the agenda items
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/	
function display_agenda_items()
{
	global $TABLEAGENDA;
	global $TABLE_ITEM_PROPERTY;
	global $select_month, $select_year;
	global $DaysShort, $DaysLong, $MonthsLong;
	global $is_courseAdmin;
	global $dateFormatLong, $timeNoSecFormat;
	global $_uid; 
	//echo "displaying agenda items";
	
	// getting the group memberships
	$group_memberships=GroupManager::get_group_ids($_course['dbName'],$_uid);
	
	// getting the name of the groups
	$group_names=get_course_groups();
	
	/*--------------------------------------------------
			CONSTRUCT THE SQL STATEMENT
	  --------------------------------------------------*/
	  
	// this is to make a difference between showing everything (all months) or only the current month)
	// $show_all_current is a part of the sql statement
	if ($_SESSION['show']!=="showall")
	{
		$show_all_current=" AND MONTH(start_date)=$select_month AND year(start_date)=$select_year";
	}
	else 
	{
		$show_all_current="";
	}

	// by default we use the id of the current user. The course administrator can see the agenda of other users by using the user / group filter
	$user_id=$_uid;
	if ($_SESSION['user']!==null)
	{
		$user_id=$_SESSION['user'];
	}
	if ($_SESSION['group']!==null)
	{
		$group_id=$_SESSION['group'];
	}
	//echo "user:".$_SESSION['user']."group: ".$_SESSION['group'];
	// A. you are a course admin
	//if ($is_courseAdmin) 
	if (is_allowed_to_edit())
	{
		// A.1. you are a course admin with a USER filter
		// => see only the messages of this specific user + the messages of the group (s)he is member of. 
		if ($_SESSION['user']!==null) 
		{
			$group_memberships=GroupManager::get_group_ids($_course['dbName'],$_SESSION['user']);
			if (is_array($group_memberships))
			{
				$sql="SELECT 
					agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND	( `toolitemproperties`.`to_user_id`=$user_id OR `toolitemproperties`.`to_group_id` IN (0, ".implode(", ", $group_memberships).") )
					AND `toolitemproperties`.`visibility`='1'
					ORDER BY start_date ".$_SESSION['sort'];
			}
			else
			{
				$sql="SELECT 
					agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND ( `toolitemproperties`.`to_user_id`=$user_id OR `toolitemproperties`.`to_group_id`='0')
					AND `toolitemproperties`.`visibility`='1'
					ORDER BY start_date ".$_SESSION['sort'];
			}
		}
		// A.2. you are a course admin with a GROUP filter
		// => see only the messages of this specific group
		elseif ($_SESSION['group']!==null) 
		{
			$sql="SELECT 
				agenda.*, toolitemproperties.* 
				FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
				WHERE `agenda`.`id` = `toolitemproperties`.`ref`  ".$show_all_current."
				AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
				AND ( `toolitemproperties`.`to_group_id`=$group_id OR `toolitemproperties`.`to_group_id`='0')
				AND `toolitemproperties`.`visibility`='1'
				GROUP BY `toolitemproperties`.`ref` 
				ORDER BY start_date ".$_SESSION['sort'];

		}
		// A.3 you are a course admin without any group or user filter
		else
		{
			// A.3.a you are a course admin without user or group filter but WITH studentview 
			// => see all the messages of all the users and groups without editing possibilities
			if ($isStudentView=="true")
			{ 
				$sql="SELECT 
					agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`  ".$show_all_current."
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND `toolitemproperties`.`visibility`='1'
					GROUP BY `toolitemproperties`.`ref` 
					ORDER BY start_date ".$_SESSION['sort'];

			}
			// A.3.b you are a course admin without user or group filter and WTIHOUT studentview (= the normal course admin view)
			// => see all the messages of all the users and groups with editing possibilities
			else
			{ 
				$sql="SELECT 
					agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`  ".$show_all_current."
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND ( `toolitemproperties`.`visibility`='0' or `toolitemproperties`.`visibility`='1')
					GROUP BY `toolitemproperties`.`ref` 
					ORDER BY start_date ".$_SESSION['sort'];
			}
		}

	} //if (is_allowed_to_edit())

	// B. you are a student
	else 
	{
		if (is_array($group_memberships))
		{
			$sql="SELECT 
				agenda.*, toolitemproperties.* 
				FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
				WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
				AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
				AND	( `toolitemproperties`.`to_user_id`=$user_id OR `toolitemproperties`.`to_group_id` IN (0, ".implode(", ", $group_memberships).") )
				AND `toolitemproperties`.`visibility`='1'
				ORDER BY start_date ".$_SESSION['sort'];
		}
		else
		{
			if ($_uid)
			{
				$sql="SELECT 
					agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND ( `toolitemproperties`.`to_user_id`=$user_id OR `toolitemproperties`.`to_group_id`='0')
					AND `toolitemproperties`.`visibility`='1'
					ORDER BY start_date ".$_SESSION['sort'];
			}
			else
			{
				$sql="SELECT 
					agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`   ".$show_all_current."
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND `toolitemproperties`.`to_group_id`='0'
					AND `toolitemproperties`.`visibility`='1'
					ORDER BY start_date ".$_SESSION['sort'];
			}
		}
	} // you are a student

	//echo "<pre>".$sql."</pre>"; 
	$result=api_sql_query($sql,__FILE__,__LINE__) or die(mysql_error());
	$number_items=mysql_num_rows($result);


	/*--------------------------------------------------
			DISPLAY: NO ITEMS
	  --------------------------------------------------*/
	if ($number_items==0)
		{
		 echo "<table id=\"agenda_list\" ><tr><td>".get_lang("NoAgendaItems")."</td></tr></table>";
		}

	/*--------------------------------------------------
			DISPLAY: THE ITEMS
	  --------------------------------------------------*/
	echo "<table id=\"agenda_list\">\n";
	
	$month_bar="";
	while ($myrow=mysql_fetch_array($result))
{	

/*--------------------------------------------------
		display: the month bar
  --------------------------------------------------*/
// Make the month bar appear only once.
	if ($month_bar != date("m",strtotime($myrow["start_date"])).date("Y",strtotime($myrow["start_date"])))
		{
		$month_bar = date("m",strtotime($myrow["start_date"])).date("Y",strtotime($myrow["start_date"]));
			echo "\t<tr>\n\t\t<td class=\"agenda_month_divider\" colspan=\"2\" valign=\"top\">".
			ucfirst(format_locale_date("%B %Y",strtotime($myrow["start_date"]))).
			"</td>\n\t</tr>\n";
		}
		
/*--------------------------------------------------
 display: the icon, title, destinees of the item
  --------------------------------------------------*/
	echo "\t<tr>\n";
		
	// highlight: if a date in the small calendar is clicked we highlight the relevant items
	$db_date=(int)date("d",strtotime($myrow["start_date"])).date("n",strtotime($myrow["start_date"])).date("Y",strtotime($myrow["start_date"]));
	if ($_GET["day"].$_GET["month"].$_GET["year"] <>$db_date)
	{
		if ($myrow['visibility']=='0')
		{
			$style="data_hidden";
			$stylenotbold="datanotbold_hidden";
			$text_style="text_hidden";
		}
		else 
		{
			$style="data";
			$stylenotbold="datanotbold";
			$text_style="text";
		}

	}
	else
	{
		$style="datanow";
		$stylenotbold="datanotboldnow";
		$text_style="textnow";
	}

	
	
	echo "\t\t<td class=\"".$style."\">\n";
	
	// adding an internal anchor
	echo "\t\t\t<a name=\"".(int)date("d",strtotime($myrow["start_date"]))."\"></a>";
	
	// the icons. If the message is sent to one or more specific users/groups
	// we add the groups icon
	// 2do: if it is sent to groups we display the group icon, if it is sent to a user we show the user icon
	echo "<img src=\"../img/agenda.gif\" align=\"absmiddle\" border=\"0\">";
	if ($myrow['to_group_id']!=='0')
		{
		echo "<img src=\"../img/group.gif\" align=\"absmiddle\" border=\"0\">";
		}
	echo " ".$myrow['title']."\n";
	echo "\t\t</td>\n";
	
	// the message has been sent to
	echo "\t\t<td class=\"".$stylenotbold."\">".get_lang("SentTo").": ";
	$sent_to=sent_to(TOOL_CALENDAR_EVENT, $myrow["ref"]);
	$sent_to_form=sent_to_form($sent_to);
	echo $sent_to_form; 
	echo "</td>\n\t</tr>\n";
		
/*--------------------------------------------------
 			display: the title
  --------------------------------------------------*/
	echo "\t<tr class=\"".$stylenotbold."\">\n";
	echo "\t\t<td>".get_lang("StartTime").": ";
	echo ucfirst(format_locale_date($dateFormatLong,strtotime($myrow["start_date"])))."&nbsp;&nbsp;&nbsp;";
	echo ucfirst(strftime($timeNoSecFormat,strtotime($myrow["start_date"])))."";
	echo "</td>\n";
	echo "\t\t<td>";
	if ($myrow["end_date"]<>"0000-00-00 00:00:00")
	{
		echo get_lang("EndTime").": ";
		echo ucfirst(format_locale_date($dateFormatLong,strtotime($myrow["end_date"])))."&nbsp;&nbsp;&nbsp;";
		echo ucfirst(strftime($timeNoSecFormat,strtotime($myrow["end_date"])))."";
	}
	echo "</td>\n";
	echo "\n\t</tr>\n";
	
/*--------------------------------------------------
 			display: the content
  --------------------------------------------------*/
	$content = $myrow['content'];
	$content = make_clickable($content);
	$content = api_parse_tex($content);
	echo "\t<tr>\n\t\t<td class=\"".$text_style."\" colspan='2'>";
	echo $content;
	echo "</td></tr>";

/*--------------------------------------------------
 			display: the added resources
  --------------------------------------------------*/
	if (check_added_resources("Agenda", $myrow["id"]))
		{
		echo "<tr><td colspan='2'>";
		echo "<i>".get_lang("AddedResources")."</i><br/>";
		if ($myrow['visibility']==0)
		{
			$addedresource_style="invisible";
		}
		display_added_resources("Agenda", $myrow["id"], $addedresource_style);
		echo "</td></tr>";
		}
		
/*--------------------------------------------------
	display: edit delete button (course admin only)
  --------------------------------------------------*/
	echo "<tr><td>";
	if (is_allowed_to_edit())
		{
		// edit
		echo 	"<a href=\"".$_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=edit&id=".$myrow['id']."\">",
				"<img src=\"../img/edit.gif\" border=\"0\" align=\"absmiddle\" alt=\"".get_lang("ModifyCalendarItem")."\"/></a>",
				"<a href=\"".$_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=delete&id=".$myrow['id']."\" onclick=\"javascript:if(!confirm('".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."')) return false;\">",
				"<img src=\"../img/delete.gif\" border=\"0\" align=\"absmiddle\" alt=\"".get_lang("Delete")."\"/></a>";
		if ($myrow['visibility']==1)
			{
			$image_visibility="visible";
			}
		else
			{
			$image_visibility="invisible";
			}		
		echo 	"<a href=\"".$_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=showhide&id=".$myrow['id']."\">",
				"<img src=\"../img/".$image_visibility.".gif\" border=\"0\" align=\"absmiddle\" alt=\"".get_lang("Visible")."\"/></a><br><br>";
		}
	echo "</td>";
	
/*--------------------------------------------------
	display: jump-to-top icon
  --------------------------------------------------*/
	echo "<td><a href=\"#top\"><img src=\"../img/top.gif\" border=\"0\" alt=\"".get_lang("ToTop")."\" align=\"right\"></a></td></tr>";
} // end while ($myrow=mysql_fetch_array($result))
echo "</table>"; 

// closing the layout table
echo "</td>",
	"</tr>",
	"</table>";
}

/**
* Displays only 1 agenda item. This is used when an agenda item is added to the learning path. 
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
*/	
function display_one_agenda_item($agenda_id)
{
	global $TABLEAGENDA;
	global $TABLE_ITEM_PROPERTY;
	global $select_month, $select_year;
	global $DaysShort, $DaysLong, $MonthsLong;
	global $is_courseAdmin;
	global $dateFormatLong, $timeNoSecFormat;
	global $_uid; 
	//echo "displaying agenda items";
	
	
	// getting the name of the groups
	$group_names=get_course_groups();
	
	/*--------------------------------------------------
			CONSTRUCT THE SQL STATEMENT
	  --------------------------------------------------*/
	  
	$sql="SELECT agenda.*, toolitemproperties.* 
					FROM ".$TABLEAGENDA." agenda, ".$TABLE_ITEM_PROPERTY." toolitemproperties 
					WHERE `agenda`.`id` = `toolitemproperties`.`ref`  
					AND `toolitemproperties`.`tool`='".TOOL_CALENDAR_EVENT."'
					AND `toolitemproperties`.`visibility`='1'
					AND `agenda`.`id`='$agenda_id'";
	$result=api_sql_query($sql,__FILE__,__LINE__) or die(mysql_error());
	$number_items=mysql_num_rows($result);
	$myrow=mysql_fetch_array($result); // there should be only one item so no need for a while loop

	/*--------------------------------------------------
			DISPLAY: NO ITEMS
	  --------------------------------------------------*/
	if ($number_items==0)
		{
		 echo "<table id=\"agenda_list\" ><tr><td>".get_lang("NoAgendaItems")."</td></tr></table>";
		}

	/*--------------------------------------------------
			DISPLAY: THE ITEMS
	  --------------------------------------------------*/
	echo "<table id=\"agenda_list\">\n";
	
	


	/*--------------------------------------------------
	 DISPLAY : the icon, title, destinees of the item
	  --------------------------------------------------*/
	echo "\t<tr>\n";
		
	// highlight: if a date in the small calendar is clicked we highlight the relevant items
	$db_date=(int)date("d",strtotime($myrow["start_date"])).date("n",strtotime($myrow["start_date"])).date("Y",strtotime($myrow["start_date"]));
	if ($_GET["day"].$_GET["month"].$_GET["year"] <>$db_date)
	{
		if ($myrow['visibility']=='0')
		{
			$style="data_hidden";
			$stylenotbold="datanotbold_hidden";
			$text_style="text_hidden";
		}
		else 
		{
			$style="data";
			$stylenotbold="datanotbold";
			$text_style="text";
		}

	}
	else
	{
		$style="datanow";
		$stylenotbold="datanotboldnow";
		$text_style="textnow";
	}

		
	echo "\t\t<td class=\"".$style."\">\n";
	
	// adding an internal anchor
	echo "\t\t\t<a name=\"".(int)date("d",strtotime($myrow["start_date"]))."\"></a>";
	
	// the icons. If the message is sent to one or more specific users/groups
	// we add the groups icon
	// 2do: if it is sent to groups we display the group icon, if it is sent to a user we show the user icon
	echo "<img src=\"../img/agenda.gif\" align=\"absmiddle\" border=\"0\">";
	if ($myrow['to_group_id']!=='0')
		{
		echo "<img src=\"../img/group.gif\" align=\"absmiddle\" border=\"0\">";
		}
	echo " ".$myrow['title']."\n";
	echo "\t\t</td>\n";
	
	// the message has been sent to
	echo "\t\t<td class=\"".$stylenotbold."\">".get_lang("SentTo").": ";
	$sent_to=sent_to(TOOL_CALENDAR_EVENT, $myrow["ref"]);
	$sent_to_form=sent_to_form($sent_to);
	echo $sent_to_form; 
	echo "</td>\n\t</tr>\n";
		
	/*--------------------------------------------------
	 			DISPLAY: the title
	  --------------------------------------------------*/
	echo "\t<tr class=\"".$stylenotbold."\">\n";
	echo "\t\t<td>".get_lang("StartTime").": ";
	echo ucfirst(format_locale_date($dateFormatLong,strtotime($myrow["start_date"])))."&nbsp;&nbsp;&nbsp;";
	echo ucfirst(strftime($timeNoSecFormat,strtotime($myrow["start_date"])))."";
	echo "</td>\n";
	echo "\t\t<td>".get_lang("EndTime").": ";
	echo ucfirst(format_locale_date($dateFormatLong,strtotime($myrow["end_date"])))."&nbsp;&nbsp;&nbsp;";
	echo ucfirst(strftime($timeNoSecFormat,strtotime($myrow["end_date"])))."";
	echo "</td>\n";
	echo "\n\t</tr>\n";
	
	/*--------------------------------------------------
	 			DISPLAY: the content
	  --------------------------------------------------*/
	$content = $myrow['content'];
	$content = make_clickable($content);
	$content = api_parse_tex($content);
	echo "\t<tr>\n\t\t<td class=\"".$text_style."\" colspan='2'>";
	echo $content;
	echo "</td></tr>";

	/*--------------------------------------------------
	 			DISPLAY: the added resources
	  --------------------------------------------------*/
	if (check_added_resources("Agenda", $myrow["id"]))
		{
		echo "<tr><td colspan='2'>";
		echo "<i>".get_lang("AddedResources")."</i><br/>";
		if ($myrow['visibility']==0)
		{
			$addedresource_style="invisible";
		}
		display_added_resources("Agenda", $myrow["id"], $addedresource_style);
		echo "</td></tr>";
		}
		
	/*--------------------------------------------------
		DISPLAY: edit delete button (course admin only)
	  --------------------------------------------------*/
	echo "<tr><td>";
	if (is_allowed_to_edit())
		{
		// edit
		echo 	"<a href=\"".$_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=edit&id=".$myrow['id']."\">",
				"<img src=\"../img/edit.gif\" border=\"0\" align=\"absmiddle\" alt=\"".get_lang("ModifyCalendarItem")."\"/></a>",
				"<a href=\"".$_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=delete&id=".$myrow['id']."\" onclick=\"javascript:if(!confirm('".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."')) return false;\">",
				"<img src=\"../img/delete.gif\" border=\"0\" align=\"absmiddle\" alt=\"".get_lang("Delete")."\"/></a>";
		if ($myrow['visibility']==1)
			{
			$image_visibility="visible";
			}
		else
			{
			$image_visibility="invisible";
			}		
		echo 	"<a href=\"".$_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=showhide&id=".$myrow['id']."\">",
				"<img src=\"../img/".$image_visibility.".gif\" border=\"0\" align=\"absmiddle\" alt=\"".get_lang("Visible")."\"/></a><br><br>";
		}
	echo "</td>";
	echo "</table>"; 

	// closing the layout table
	echo "</td>",
		"</tr>",
		"</table>";
}




/**
* Show the form for adding a new agenda item. This is the same function that is used whenever we are editing an
* agenda item. When the id parameter is empty (default behaviour), then we show an empty form, else we are editing and 
* we have to retrieve the information that is in the database and use this information in the forms.
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @param integer id, the id of the agenda itme we are editing. By default this is empty which means that we are adding an 
*		 agenda item.
*/	
function show_add_form($id='')
{
	global $MonthsLong; 
	
	// the default values for the forms
	if ($_GET['originalresource']!=="no")
	{
		$day	= date("d");
		$month	= date("m");
		$year	= date("Y");
		$hours	= date("H");
		$minutes= date("i");
		
		$end_day	= date("d");
		$end_month	= date("m");
		$end_year	= date("Y");
		$end_hours	= date("H");
		$end_minutes= date("i");
	}
	else 
	{
		
		// we are coming from the resource linker so there might already have been some information in the form.
		// When we clicked on the button to add resources we stored every form information into a session and now we
		// are doing the opposite thing: getting the information out of the session and putting it into variables to
		// display it in the forms. 
		$form_elements=$_SESSION['formelements'];
		$day=$form_elements["day"];
		$month=$form_elements["month"];
		$year=$form_elements["year"];
		$hours=$form_elements["hour"];
		$minutes=$form_elements["minutes"];
		$end_day=$form_elements["end_day"];
		$end_month=$form_elements["end_month"];
		$end_year=$form_elements["end_year"];
		$end_hours=$form_elements["end_hours"];
		$end_minutes=$form_elements["end_minutes"];
		$title=$form_elements["title"];
		$content=$form_elements["content"];
		$id=$form_elements["id"];
		$to=$form_elements['to']; 
	}
	

	//	switching the send to all/send to groups/send to users
	if ($_POST['To'])
	{
			$day			= $_POST['fday'];
			$month			= $_POST['fmonth'];
			$year			= $_POST['fyear'];
			$hours			= $_POST['fhour'];
			$minutes		= $_POST['fminute'];
			$end_day		= $_POST['end_fday'];
			$end_month		= $_POST['end_fmonth'];
			$end_year		= $_POST['end_fyear'];
			$end_hours		= $_POST['end_fhour'];
			$end_minutes	= $_POST['end_fminute'];			
			$title 			= $_POST['title'];
			$content		= $_POST['content'];
			// the invisible fields
			$action			= $_POST['action'];
			$id			= $_POST['id'];
		}
	
	
	// if the id is set then we are editing an agenda item
	if (is_int($id))
	{
		//echo "before get_agenda_item".$_SESSION['allow_individual_calendar']; 
		$item_2_edit=get_agenda_item($id);
		$title	= $item_2_edit['title'];
		$content= $item_2_edit['content'];
		// start date
		list($datepart, $timepart) = split(" ", $item_2_edit['start_date']);
		list($year, $month, $day) = explode("-", $datepart);
		list($hours, $minutes, $seconds) = explode(":", $timepart);
		// end date
		list($datepart, $timepart) = split(" ", $item_2_edit['end_date']);
		list($end_year, $end_month, $end_day) = explode("-", $datepart);
		list($end_hours, $end_minutes, $end_seconds) = explode(":", $timepart);
		// attachments
		edit_added_resources("Agenda", $id);
		$to=$item_2_edit['to'];
		//echo "<br>after get_agenda_item".$_SESSION['allow_individual_calendar']; 
	}

	// we start a completely new item, we do not come from the resource linker
	if ($_GET['originalresource']!=="no" and $_GET['action']=="add")
	{
		
		$_SESSION["formelements"]=null;
		unset_session_resources();
	}
?>
	
<!-- START OF THE FORM  -->
<form action="<?php echo $_SERVER['PHP_SELF']."?origin=".$_GET['origin']."&action=".$_GET['action']; ?>" method="POST" name="new_calendar_item">
<input type="hidden" name="id" value="<?php if (isset($id)) echo $id; ?>" />
<input type="hidden" name="action" value="<?php if (isset($_GET['action'])) echo $_GET['action']; ?>" />

<table border="0" cellpadding="5" cellspacing="0" width="100%" id="newedit_form">
	<!-- the title -->
	<tr id="title">
		<td colspan="3">
		<h4><?php echo (isset($id) AND $id<>"")?get_lang("ModifyCalendarItem"):get_lang("AddCalendarItem"); ?></h4>
		</td>
	</tr>
	
	<!--  the select specific users / send to all form -->
	<tr id="subtitle">
		<td valign="top" colspan="3">
			<?php 
			// this variable defines if the course administrator can send a message to a specific user / group
			// or not 
			echo "<input type=\"submit\" name=\"To\" value=\"".get_lang("SelectGroupsUsers")."\" style=\"float:left\">" ;
			
			//echo "sessiewaarde: ".$_SESSION['allow_individual_calendar'];
			if ($_SESSION['allow_individual_calendar']=="hide")
				{
				echo "<select name=\"selectedform[]\" size=\"1\" multiple style=\"width:200px\" width=\"200px\"><option>".get_lang("Everybody")."</option></select>";
				}
			if ($_SESSION['allow_individual_calendar']=="show")
				{
				show_to_form($to);
				}
			?>
			<hr noshade color="#cccccc">
		</td>
	</tr>
	
	
	<!-- This has been replaced by dividing it into date and hour. It saves a line
	<tr id="subtitle">
		<td><?php echo get_lang("Day"); ?></td>
		<td><?php echo get_lang("Month"); ?></td>
		<td><?php echo get_lang("Year"); ?></td>
		<td><?php echo get_lang("Hour"); ?></td>
		<td><?php echo get_lang("Minutes"); ?></td>
		<td><?php echo get_lang("Lasting"); ?></td>
	</tr> -->

<!-- START date and time -->
		<tr id="subtitle">
			<td>
				<!-- date: 1 -> 31 -->
				<?php echo get_lang("StartDate").": \n";?>
				<select name="fday">
					<?php 
					// small loop for filling all the dates 
					// 2do: the available dates should be those of the selected month => february is from 1 to 28 (or 29) and not to 31
					echo "\n";
					for ($i=1; $i<=31; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current day is indicated with [] around the date
						if ($value==$day)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected> ".$i." </option>\n";}
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$i."</option>\n"; }
						}?>
				</select>
				
				<!-- month: january -> december -->
				<select name="fmonth">
					<?php 
					echo "\n";
					for ($i=1; $i<=12; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						if ($value==$month)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected>".$MonthsLong[$i-1]."</option>\n"; }
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$MonthsLong[$i-1]."</option>\n"; }
						}?>
				</select>
					
				<select name="fyear">
					<option value="<?php echo ($year-1) ?>"><?php echo ($year-1) ?></option>
					<option value="<?php echo $year ?>" selected> <?php echo $year ?> </option>
					<?php
					echo "\n";
					for ($i=1; $i<=5; $i++)
						{
						$value=$year+$i;
						echo "\t\t\t\t<option value=\"".$value."\">".$value."</option>\n";
						}
					?>
				</select>
				<?php echo "<a title=\"".get_lang('DateRollover')."\" href=\"javascript:openCalendar('new_calendar_item', 'f')\"><img src=\"../img/calendar_select.gif\" border=\"0\" align=\"absmiddle\"/></a>"; ?>
			</td>
			
			<td>
				<?php echo get_lang("StartTime").": ";?>
				<select name="fhour">
					<option value="--">--</option>
					<?php
					echo "\n";
					for ($i=1; $i<=24; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current hour is indicated with [] around the hour
						if ($hours==$value)
							{ echo "\t\t\t\t<option value=\"".$value."\" selected> ".$value." </option>\n"; }
						else
							{ echo "\t\t\t\t<option value=\"".$value."\"> ".$value." </option>\n"; }
						}
					?>
				</select>
			  <?php echo get_lang("HourMinuteDivider");?> 
          <select name="fminute">
            <option value="<?php echo $minutes ?>"><?php echo $minutes ?></option>
            <option value="--">--</option>
            <option value="00">00</option>
            <option value="05">05</option>
            <option value="10">10</option>
            <option value="15">15</option>
            <option value="20">20</option>
            <option value="25">25</option>
            <option value="30">30</option>
            <option value="35">35</option>
            <option value="40">40</option>
            <option value="45">45</option>
            <option value="50">50</option>
            <option value="55">55</option>
          </select>
        </td>
      </tr>
      
<!-- END date and time -->
		<tr id="subtitle">
			<td>
				<!-- date: 1 -> 31 -->
				<?php echo get_lang("EndDate").": \n";?>
				<select name="end_fday">
					<?php 
					// small loop for filling all the dates 
					// 2do: the available dates should be those of the selected month => february is from 1 to 28 (or 29) and not to 31
					echo "\n";
					for ($i=1; $i<=31; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current day is indicated with [] around the date
						if ($value==$end_day)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected> ".$i." </option>\n";}
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$i."</option>\n"; }
						}?>
				</select>
				
				<!-- month: january -> december -->
				<select name="end_fmonth">
					<?php 
					echo "\n";
					for ($i=1; $i<=12; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						if ($value==$end_month)
							{ echo "\t\t\t\t <option value=\"".$value."\" selected>".$MonthsLong[$i-1]."</option>\n"; }
						else
							{ echo "\t\t\t\t <option value=\"".$value."\">".$MonthsLong[$i-1]."</option>\n"; }
						}?>
				</select>
					
				<select name="end_fyear">
					<option value="<?php echo ($end_year-1) ?>"><?php echo ($end_year-1) ?></option>
					<option value="<?php echo $end_year ?>" selected> <?php echo $end_year ?> </option>
					<?php
					echo "\n";
					for ($i=1; $i<=5; $i++)
						{
						$value=$end_year+$i;
						echo "\t\t\t\t<option value=\"".$value."\">".$value."</option>\n";
						}
					?>
				</select>
				<?php echo "<a title=\"".get_lang('DateRollover')."\" href=\"javascript:openCalendar('new_calendar_item', 'end_f')\"><img src=\"../img/calendar_select.gif\" border=\"0\" align=\"absmiddle\"/></a>"; ?>
			</td>
			
			<td>
				<?php echo get_lang("EndTime").": ";?>
				<select name="end_fhour">
					<option value="--">--</option>
					<?php
					echo "\n";
					for ($i=1; $i<=24; $i++)
						{
						// values have to have double digits
						if ($i<=9)
							{$value="0".$i;}
						else
							{$value=$i;}
						// the current hour is indicated with [] around the hour
						if ($end_hours==$value)
							{ echo "\t\t\t\t<option value=\"".$value."\" selected> ".$value." </option>\n"; }
						else
							{ echo "\t\t\t\t<option value=\"".$value."\"> ".$value." </option>\n"; }
						}
					?>
				</select>
			  <?php echo get_lang("HourMinuteDivider");?> 
          <select name="end_fminute">
            <option value="<?php echo $end_minutes ?>"><?php echo $end_minutes ?></option>
            <option value="--">--</option>
            <option value="00">00</option>
            <option value="05">05</option>
            <option value="10">10</option>
            <option value="15">15</option>
            <option value="20">20</option>
            <option value="25">25</option>
            <option value="30">30</option>
            <option value="35">35</option>
            <option value="40">40</option>
            <option value="45">45</option>
            <option value="50">50</option>
            <option value="55">55</option>
          </select>
        </td>
      </tr>
      
      
      
	  
		<tr id="subtitle">
			<td colspan="3" valign="top"><hr noshade color="#cccccc"><?php echo get_lang("ItemTitle"); ?> :
			<textarea name="title" cols="50" rows="2" wrap="virtual" style="vertical-align: top; width:75%; height:50px;"><?php  if (isset($title)) echo $title ?></textarea>
			<!-- <input type="text" size="60" name="title" value="<?php  if (isset($title)) echo $title ?>">-->
			</td>
		</tr>

		<tr>
        <td colspan="7"><?php echo get_lang("Detail"); ?> :</td>
      </tr>
      <tr>
        <td colspan="7">
   <?php
         api_disp_html_area('content',$content,'300px');
   ?>
          <br>
        </td>
      </tr>
      <?php // ADDED BY UGENT, Patrick Cool, march 2004 ?>
      <tr>
        <td colspan="7">
    <?php 
		//onClick="selectAll(this.form.elements[6],true)"
		if ($_SESSION['allow_individual_calendar']=="show")
			{ show_addresource_button("onClick=\"selectAll(this.form.elements[6],true)\""); }
		else
			{ show_addresource_button(); }
			$form_elements=$_SESSION['formelements'];
		?>
       </td>
      </tr>
      <?php
   //if ($_SESSION['addedresource'])
   echo "<tr>";
   echo "<td colspan='7'>";
   echo display_resources(0);
   $test=$_SESSION['addedresource'];
   echo "</td></tr>";
   // END ADDED BY UGENT, Patrick Cool, march 2004
   ?>
      <tr>
       <td colspan="7">
						<input type="Submit" name="submit_event" value="<?php echo get_lang("Ok") ?>" onClick="selectAll(this.form.elements[6],true)"/>
						
       </td>
      </tr>
    </table>
	</form>
	<p>&nbsp;</p>

<?php
}
?>
