<?php
// $Id: profile.php,v 1.72.2.2 2005/09/06 08:59:25 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Roan Embrechts (Vrije Universiteit Brussel)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* This file displays the user's profile,
* optionally it allows users to modify their profile as well.
*
* See inc/conf/profile.conf.inc.php to modify settings
*
* Notes
*
* Don't confuse
* $profileIsEditable - is is possible at all to (try to) change the profile
* $userSettingChangeAllowed - are the currently posted changes to the profile acceptable
*
* @package dokeos.auth
* @todo move code like the picture code into separate functions
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/

$langFile = 'registration';
$cidReset = true;

#default - don't edit default !!! change in config files
$userOfficialCodeCanBeEmpty = true;
$userMailCanBeEmpty = true;

require ('../inc/claro_init_global.inc.php');
api_block_anonymous_users();

$htmlHeadXtra[] = "<script>
function confirmation (name)
{
	if (confirm(\" ".get_lang('AreYouSureToDelete')." \"+ name + \" ?\"))
		{return true;}
	else
		{return false;}
}
</script>";

if (!empty ($_GET['coursePath']))
{
	$course_url = api_get_path(WEB_COURSE_PATH).$_GET["coursePath"]."/index.php";
	$interbredcrump[] = array ("url" => $course_url, "name" => $_GET['courseCode']);
}

/*
-----------------------------------------------------------
	Configuration file
-----------------------------------------------------------
*/
require_once (api_get_configuration_path()."/profile.conf.inc.php");

/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
include_once (api_get_library_path()."/text.lib.php");
include_once (api_get_library_path()."/fileManage.lib.php");
include_once (api_get_library_path()."/fileUpload.lib.php");

if ($profileIsEditable)
	$nameTools = get_lang('ModifProfile');
else
	$nameTools = get_lang('ViewProfile');

$tbl_user = Database :: get_main_table(MAIN_USER_TABLE);

if (!isset ($userImageRepositorySys))
	$userImageRepositorySys = $clarolineRepositorySys.'upload/users/';
if (!isset ($userImageRepositoryWeb))
	$userImageRepositoryWeb = $clarolineRepositoryWeb.'upload/users/';
if (!isset ($userProductionsRepositorySys))
	$userProductionsRepositorySys = $clarolineRepositorySys."upload/users/$_uid/";

/*
==============================================================================
		DISPLAY FUNCTIONS
==============================================================================
*/

/**
*	Display a <td></td> table cell with
*
*	@param	$align	the alignment of the cell
*	@param $content the html content of the table cell
*/
function display_table_cell($content, $align)
{
	if (isset ($align) && $align != '')
	{
		$align_option = "align=\"$align\"";
	}
	else
		$align_option = "";

	echo "<td $align_option nowrap=\"nowrap\">$content</td>";
}

/**
*	Display a profile entry
*
*	@param $label, the label for the profile setting
*	@param $content, html code for the setting, usually a form field
*/
function display_profile_entry($label, $content)
{
	global $form_openarea;

	echo "<tr>\n";
	display_table_cell($label, "right");
	if ($content == "openarea")
	{
		echo "<td>";
		api_disp_html_area('form_openarea', $form_openarea, '300px');
		echo "</td>";
	}
	else
	{
		display_table_cell($content, "");
	}
	echo "</tr>";
}

/**
*	Display productions
*
*	@param $_uid, User id
*/
function display_productions($_uid)
{
	global $clarolineRepositorySys, $clarolineRepositoryWeb, $disabled_output;
	$sysdir = $clarolineRepositorySys."upload/users/$_uid";
	$webdir = $clarolineRepositoryWeb."upload/users/$_uid";

	if (is_dir($sysdir))
	{
		$handle = opendir($sysdir);
		$content .= "<table>";
		while ($file = readdir($handle))
		{
			if ($file == "." || $file == ".." || $file == '.htaccess')
			{
				continue; // Skip current and parent directories
			}
			$filename = urlencode($file);
			$content .= "<tr><td><a href=\"$webdir/$filename\" target=_blank>".$file." </td><td><a href='".$PHP_SELF."?delfile=".$filename."' onClick=\"return confirmation('".$file."');\"><img src='../img/delete.gif' alt=".get_lang('Delete')." title=".get_lang('Delete')."></a></td></tr>";
		}

		$content .= "</table>";
		$label = "<label for=\"form_productions\">".get_lang("MyProductions")." </label>&nbsp;&nbsp;";
		$content .= "<input type=\"file\" ".$disabled_output." name=\"form_productions\" id=\"form_productions\" />\n";

		display_profile_entry($label, $content);
	}
}

/*
==============================================================================
		LOGIC FUNCTIONS
==============================================================================
*/

function is_profile_editable()
{
	return $GLOBALS["profileIsEditable"];
}

/*
==============================================================================
		DATABASE FUNCTIONS
==============================================================================
*/

/**
* Checks to see wether there is already another user (different user id)
* with the same username (login)
* @param $form_user_name - the login/username of the user
* @param $user_id - the id of the user
*/
function username_already_exists($form_user_name, $user_id)
{
	$user_table = Database :: get_main_table(MAIN_USER_TABLE);
	$sql_query = "SELECT `user_id`
								FROM ".$user_table."
								WHERE `username` = '".addslashes($form_user_name)."' AND `user_id` != '".$user_id."'";
	$sql_result = api_sql_query($sql_query, __FILE__, __LINE__);
	while ($result_line = mysql_fetch_array($sql_result))
	{
		if ($result_line["user_id"] != $user_id)
			return true;
	}
	return false;
}

/*
==============================================================================
		MAIN CODE
==============================================================================
*/

///// COMMAND ///

$msgArrBody = array ();

if ($delfile)
{ //deletes a file from My Productions

	$toDelete = $clarolineRepositorySys."upload/users/$_uid/$delfile";
	unlink($toDelete);

	$msgClass = "success"; // success | warning | error
	$msgArrBody[] = get_lang('FileDeleted');

}

/*
 * Get current values for all fields
 * When the form is submitted, these fields are overwritten by the submitted
 * data
 */
$sql = "SELECT *  FROM  ".$tbl_user." WHERE user_id = '".$_uid."'";
$result = api_sql_query($sql, __FILE__, __LINE__);
if ($result)
{
	$user_data = mysql_fetch_array($result);
	$form_lastName = $user_data['lastname'];
	$form_firstName = $user_data['firstname'];
	$form_userName = $user_data['username'];
	$form_official_code = $user_data['official_code'];
	$form_email = $user_data['email'];
	$form_competences = $user_data['competences'];
	$form_diplomas = $user_data['diplomas'];
	$form_openarea = $user_data['openarea'];
	$form_teach = $user_data['teach'];
	$form_productions = $user_data['productions'];
	$disp_picture = $user_data['picture_uri'];
}

if ($_POST['applyChange'])
{
	/*
	 *==========================
	 * DATA CHECKING
	 *==========================
	 */
	$form_password1 = trim(stripslashes($_POST['form_password1']));
	$form_password2 = trim(stripslashes($_POST['form_password2']));
	if (get_setting('profile', 'login') == "true")
	{
		$form_userName = trim(stripslashes($_POST['form_userName']));
	}
	if (get_setting('profile', 'officialcode') == "true")
	{
		$form_official_code = trim(stripslashes($_POST['form_official_code']));
	}
	if (get_setting('profile', 'name') == "true")
	{
		$form_lastName = trim(stripslashes($_POST['form_lastName']));
		$form_firstName = trim(stripslashes($_POST['form_firstName']));
	}
	if (get_setting('profile', 'email') == "true")
	{
		$form_email = trim(stripslashes($_POST['form_email']));
	}
	if (get_setting('profile', 'picture') == "true")
	{
		$form_del_picture = trim(stripslashes($_POST['form_del_picture']));
	}

	$form_competences = trim(stripslashes($_POST['form_competences']));
	$form_diplomas = trim(stripslashes($_POST['form_diplomas']));
	$form_openarea = trim(stripslashes($_POST['form_openarea']));
	$form_teach = trim(stripslashes($_POST['form_teach']));
	$form_productions = trim(stripslashes($_POST['form_productions']));

	$form_userName = eregi_replace('[^a-z0-9_.-]', '_', strtr($form_userName, '', 'AAAAAAaaaaaaOOOOOOooooooEEEEeeeeCcIIIIiiiiUUUUuuuuyNn'));

	/*
	 * Check wether the username is already taken by another user
	 */
	if (username_already_exists($form_userName, $_uid))
	{
		$userNameOk = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('UserTaken');
	}
	else
	{
		$userNameOk = true;
	}

	$sql_ActualUserInfo = " SELECT
											`username` `userName`,
											`lastname` `lastName`,
											`firstname` `firstName`,
											`picture_uri` `actual_ImageFile`
										FROM ".$tbl_user."
										WHERE `user_id` = '".$_uid."'";
	$res_ActualUserInfo = api_sql_query($sql_ActualUserInfo, __FILE__, __LINE__);
	$data_ActualUserInfo = mysql_fetch_array($res_ActualUserInfo, MYSQL_ASSOC);

	/*
	 * Check to see if both passwords entered are the same.
	 */

	if ($form_password2 !== $form_password1)
	{
		$passwordOK = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('langPassTwice');
		$form_password = '';
	}
	else
	{
		$passwordOK = true;
		$form_password = $form_password2;
	}

	/*
	 * Check if the password isn't too easy
	 */

	if ($form_password1 && CHECK_PASS_EASY_TO_FIND)
	{
		if (!api_check_password($form_password))
		{
			$passwordOK = false;
			$msgClass = "error"; // success | warning | error
			$msgArrBody[] = get_lang('PassTooEasy')." :\n"."<i>".api_generate_password()."</i>\n";
		}
		else
		{
			$passwordOK = true;
		}
	}

	/*
	 * Check to see wether all required fields are filled in
	 */
	$importantFieldFilled = true;
	if (empty($form_lastName)) {
		$importantFieldFilled = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('langEmptySurname');
	}
	if (empty($form_firstName)) {
		$importantFieldFilled = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('langEmptyName');
	}
	if (empty($form_userName)) {
		$importantFieldFilled = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('PleaseEnterValidLogin');
	}
	if (empty($form_email)) {
		$importantFieldFilled = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('EmailWrong');
	}

	/*
	 * CHECK EMAIL SYNTAX
	 */

	$emailRegex = "^[0-9a-z_\.-]+@(([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-z][0-9a-z-]*[0-9a-z]\.)+[a-z]{2,4})$";

	if (!empty ($form_email) && !eregi($emailRegex, $form_email))
	{
		$emailOk = false;
		$msgClass = "error"; // success | warning | error
		$msgArrBody[] = get_lang('EmailWrong');
	}
	else
	{
		$emailOk = true;
	}

	/*
	 * RESUME ALL THE CHECKIN
	 */

	if ($importantFieldFilled && $emailOk && $userNameOk && $passwordOK)
	{
		$userSettingChangeAllowed = true;
	}
	else
	{
		$userSettingChangeAllowed = false;
		$msgClass = "error"; // success | warning | error
		//$msgArrBody[] = '<b>'.get_lang('Again').'</b>';
	}

	/*
	 *--------------------------------------
	 * PROCEED TO THE USER SETTINGS CHANGE
	 *--------------------------------------
	 */

	if ($userSettingChangeAllowed)
	{
		/*
		 * UPLOAD A USER IMAGE
		 *
		 * Originally added by Miguel (miguel@cesga.es) - 04/11/2003
		 * Image resizing  added by Patrick Cool Ugent - 24/11/2003
		 * Code Refactoring Hugues Peeters (hugues.peeters@claroline.net) 24/11/2003
		 */

		$actualImage = $data_ActualUserInfo['actual_ImageFile'];

		if ($_FILES['form_picture']['size'])
		{
			$fileExtension = explode('.', $_FILES['form_picture']['name']);
			$fileExtension = strtolower($fileExtension[sizeof($fileExtension) - 1]);

			if (!strstr($_FILES['form_picture']['type'], 'jpeg') && !strstr($_FILES['form_picture']['type'], 'gif') && !strstr($_FILES['form_picture']['type'], 'png'))
			{
				die('<center>The accepted formats are JPG, PNG and GIF</center>');
			}

			if (!file_exists($userImageRepositorySys))
			{
				mkpath($userImageRepositorySys);
			}

			$user_have_pic = (trim($actualImage) != '') ? true : false;

			if ($user_have_pic)
			{
				if (KEEP_THE_NAME_WHEN_CHANGE_IMAGE)
				{
					$picture_FileName = $actualImage;
					$old_picture_FileName = "saved_".date("Y_m_d_H_i_s")."_".uniqid('')."_".$actualImage;
				}
				else
				{
					$old_picture_FileName = $actualImage;
					$picture_FileName = (PREFIX_IMAGE_FILENAME_WITH_UID ? "u".$_uid."_" : "").uniqid('').".".$fileExtension;
				}

				if (KEEP_THE_OLD_IMAGE_AFTER_CHANGE)
				{
					rename($userImageRepositorySys.$actualImage, $userImageRepositorySys.$old_picture_FileName);
				}
				else
				{
					unlink($userImageRepositorySys.$actualImage);
				}

			}
			else
			{
				$picture_FileName = (PREFIX_IMAGE_FILENAME_WITH_UID ? $_uid."_" : "").uniqid('').".".$fileExtension;
			}

			if (move_uploaded_file($_FILES['form_picture']['tmp_name'], $userImageRepositorySys.$picture_FileName))
			{
				@chmod($userImageRepositorySys.$picture_FileName, 0777);
				/*
				 *--------------------------------------
				 *            Image resizing
				 *--------------------------------------
				 */
				/*
								if(extension_loaded('gd')) // Check the GD library is available
								{
									$error=false;
				
									$dimensions=getimagesize($userImageRepositorySys.$picture_FileName);
				
									$prop=$dimensions[0] / $dimensions[1];
				
									$hauteur=RESIZE_IMAGE_TO_THIS_HEIGTH;
									$largeur=$hauteur * $prop;
				
									if(function_exists('imagecreatetruecolor') && ($image=@imagecreatetruecolor($largeur,$hauteur)))
									{
										if($dimensions[2] == 2)
										{
											$image2=imagecreatefromjpeg($userImageRepositorySys.$picture_FileName);
										}
										elseif($dimensions[2] == 3)
										{
											$image2=imagecreatefrompng($userImageRepositorySys.$picture_FileName);
										}
										else
										{
											$error=true;
										}
									}
									else
									{
										$error=true;
									}
				
									if(!$error)
									{
										if(function_exists('imagecopyresampled') && @imagecopyresampled($image,$image2,0,0,0,0,$largeur,$hauteur,$dimensions[0],$dimensions[1]))
										{
											imagejpeg($image,$userImageRepositorySys.$picture_FileName);
										}
									}
				
									if(is_resource($image))
									{
										imagedestroy($image);
									}
								}				// end if GD extension loaded
				*/
				$picture = $picture_FileName;
			} // end if move_uploaded file
		} // end if is_uploaded_file $form_picture

		if ($userPasswordCrypted)
			$form_password1 = md5(trim($form_password1));

		$sql = "UPDATE  ".$tbl_user."
						
								        SET lastname        = '".addslashes($form_lastName)."',
								            firstname     = '".addslashes($form_firstName)."',
								            username   = '".addslashes($form_userName)."',
								            competences = '".addslashes($form_competences)."',
								            diplomas   = '".addslashes($form_diplomas)."',
								            openarea   = '".addslashes($form_openarea)."',
								            teach      = '".addslashes($form_teach)."',
								            productions = '".addslashes($form_productions)."',
								            official_code   = '".addslashes($form_official_code)."',
								            email      = '".addslashes($form_email)."' ";

		if ($form_password)
		{
			if ($userPasswordCrypted)
			{
				$sql .= ", password   = MD5('".addslashes($form_password)."') ";
			}
			else
			{
				$sql .= ", password   = '".addslashes($form_password)."' ";
			}
		}

		if ($_FILES['form_productions']['size'])
		{
			if (!file_exists($userProductionsRepositorySys))
			{
				mkpath($userProductionsRepositorySys);
			}

			$filename = replace_dangerous_char($_FILES['form_productions']['name']);
			$filename = php2phps($filename);
			move_uploaded_file($_FILES['form_productions']['tmp_name'], $userProductionsRepositorySys.$filename);
			@chmod($userProductionsRepositorySys.$filename, 0777);
		}

		if ($_FILES['form_picture']['size'] || $form_del_picture)
		{
			if ($form_del_picture == "yes")
			{
				$sql .= ", picture_uri = null ";
				if (KEEP_THE_OLD_IMAGE_AFTER_CHANGE)
				{
					rename($userImageRepositorySys.$actualImage, $userImageRepositorySys."deleted_".date("Y_m_d_H_i_s")."_".$actualImage);
				}
				else
				{
					unlink($userImageRepositorySys.$actualImage);
				}
			}
			else
			{
				$sql .= ", picture_uri = \"".$picture."\" ";
			}
		}

		$sql .= " WHERE user_id  = \"".$_uid."\"";
		api_sql_query($sql, __FILE__, __LINE__);

		$disp_picture = $picture;

		/*
		 * re-init the system to take new settings in account
		 */

		$uidReset = true;
		include (api_get_include_path().'/claro_init_local.inc.php');
		$msgClass = "success"; // success | warning | error
		$msgArrBody[] = get_lang('ProfileReg')."<br>\n"."<a href=\"../../index.php\">".get_lang('Home')."</a>";

	} // end if $userSettingChangeAllowed

} // end iF applyChange
else
{

	//////////////////////////////////////////////////////////////////////////////

}

$sql = "SELECT picture_uri FROM  ".$tbl_user." WHERE user_id = '".$_uid."'";
$result = api_sql_query($sql, __FILE__, __LINE__);
if ($result)
{
	$myrow = mysql_fetch_array($result);
	$disp_picture = $myrow['picture_uri'];
}

/*
==============================================================================
		MAIN DISPLAY SECTION
==============================================================================
*/
/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/
Display :: display_header($nameTools);
api_display_tool_title($nameTools);

if (!is_profile_editable())
	$disabled_output = "disabled";

echo "<hr noshade=\"noshade\" size=\"1\" />
	<a href='../tracking/personnalLog.php'>".get_lang("MyStats")."</a> | <a href='../../index.php'>".get_lang("MyCourses")."</a>";
echo '<h4>'.get_lang('UseOnlyEnglishChars').'</h4>';
/*
-----------------------------------------------------------
	Data Form
-----------------------------------------------------------
*/

echo "<p><form method=\"post\" action=\"".$_SERVER['PHP_SELF']."?coursePath=".$_GET['coursePath']."&courseCode=".$_GET['courseCode']."\" \n", " enctype=\"multipart/form-data\">\n";

if ($disp_picture != '')
{
	//user-specified picture
	$size = @ getImageSize('../upload/users/'.$disp_picture);
	$image_file = "../upload/users/".$disp_picture;
	$vertical_space = (($size[1] > 200) ? 'width="200"' : '');
}
else
{
	//default picture
	$image_file = "../img/unknown.jpg";
	$vertical_space = "";
}

echo "<img align=\"right\" ", "alt=\"".$form_lastName." ".$form_firstName."\" ", "src=\"$image_file?rand=".time()."\"	", "border=\"0\" ", "hspace=\"5\" ", "vspace=\"5\" ".$vertical_space." />";

//	START TABLE

echo "<table width=\"500\" border=\"0\" >\n";
?>

<tr>
  <td colspan="2">

<?php


if (sizeof($msgArrBody))
{
	api_display_array($msgArrBody);

	echo "<br>";
}
?>

  </td>
</tr>

<?php

$textinput_size = ' style="width: 200px;"';
//	LAST NAME
$label = "<label for=\"form_lastName\" >".get_lang("Lastname")."</label>:&nbsp;";
if (get_setting('profile', 'name') == "true")
{
	$content = "<input type=\"text\" ".$disabled_output.$textinput_size." id=\"form_lastName\" name=\"form_lastName\" value=\"".htmlspecialchars($form_lastName)."\" />\n";
}
else
{
	$content = htmlspecialchars($form_lastName);
}
display_profile_entry($label, $content);

//	FIRST NAME
$label = "<label for=\"form_firstName\">".get_lang("Firstname")."</label>:&nbsp;";
if (get_setting('profile', 'name') == "true")
{
	$content = "<input type=\"text\" ".$disabled_output.$textinput_size." name=\"form_firstName\" id=\"form_firstName\" value=\"".htmlspecialchars($form_firstName)."\" />\n";
}
else
{
	$content = htmlspecialchars($form_firstName);
}
display_profile_entry($label, $content);

/* DO NOT DISPLAY OFFICIAL CODE ANYMORE
if (CONFVAL_ASK_FOR_OFFICIAL_CODE)
{
	$label = "<label for=\"form_official_code\">".get_lang("OfficialCode")."</label>:&nbsp;";
	if (get_setting('profile', 'officialcode') == "true")
	{
		$content = "<input type=\"text\"  ".$disabled_output.$textinput_size." name=\"form_official_code\" id=\"form_official_code\" value=\"".htmlspecialchars($form_official_code)."\" />\n";
	}
	else
	{
		$content = htmlspecialchars($form_official_code);
	}
}
display_profile_entry($label, $content);
*/

//	EMAIL

$label = "<label for=\"form_email\">\n".get_lang("Email")."</label>:&nbsp;";
if (get_setting('profile', 'email') == "true")
{
	$content = "<input type=\"text\" ".$disabled_output.$textinput_size." name=\"form_email\" id=\"form_email\" value=\"".$form_email."\" />\n";
}
else
{
	$content = $form_email;
}
display_profile_entry($label, $content);

//	PICTURE
if (get_setting('profile', 'picture') == "true")
{
	$label = "<label for=\"form_picture\">". ($disp_picture ? get_lang('UpdateImage') : get_lang('AddImage'))."</label>:&nbsp;";
	$content = "<input type=\"file\" ".$disabled_output." style=\"width: 283px;\" name=\"form_picture\" id=\"form_picture\" />\n". ($disp_picture ? "<br/><label for=\"form_del_picture\">".get_lang("DelImage")."</label> <input ".$disabled_output." class=\"checkbox\" type=\"checkbox\" name=\"form_del_picture\" id=\"form_del_picture\" value=\"yes\" />\n" : "");
	display_profile_entry($label, $content);
}

//	USER NAME

$label = "<label for=\"form_userName\">".get_lang("Username")."</label>:&nbsp;";
if (get_setting('profile', 'login') == "true")
{
	$content = "<input type=\"text\" ".$disabled_output.$textinput_size." name=\"form_userName\" maxlength=\"20\" id=\"form_userName\" value=\"".htmlspecialchars($form_userName)."\" />\n";
}
else
{
	$content = htmlspecialchars($form_userName);
}
display_profile_entry($label, $content);

if (get_setting('extended_profile') == 'true')
{
	// my competences, my diplomas, My personal open area, What I am able to teach, My productions
	//upload more than one but on the model of www.dokeos.com/admin/

	echo "<tr><td height=\"5\"></td></tr><tr>\n", "<td align=right><i>\n", get_lang("OptionalTextFields"), "</i>&nbsp;&nbsp;&nbsp;</td><td></td>\n", "</tr><tr><td height=\"5\"></td></tr>\n";

	$label = "<label for=\"form_competences\">".get_lang("MyCompetences")."</label>:&nbsp;";
	$content = "<textarea ".$disabled_output." name=\"form_competences\" id=\"form_competences\" cols=\"30\" rows=\"2\">".$form_competences."</textarea>\n";

	display_profile_entry($label, $content);

	$label = "<label for=\"form_diplomas\">".get_lang("MyDiplomas")."</label>:&nbsp;";
	$content = "<textarea ".$disabled_output." name=\"form_diplomas\" id=\"form_diplomas\" cols=\"30\" rows=\"2\">".$form_diplomas."</textarea>\n";

	display_profile_entry($label, $content);

	$label = "<label for=\"form_teach\">".get_lang("MyTeach")."</label>:&nbsp;";
	$content = "<textarea ".$disabled_output." name=\"form_teach\" id=\"form_teach\" cols=\"30\" rows=\"2\">".$form_teach."</textarea>\n";

	display_profile_entry($label, $content);

	display_productions($_uid);

	$label = "<label for=\"form_openarea\">".get_lang("MyPersonalOpenArea")."</label>:&nbsp;";
	$content = "openarea";

	display_profile_entry($label, $content);
}
//	PASSWORD
if (get_setting('profile', 'password') == "true")
{
	echo "<tr><td height=\"5\"></td></tr><tr>\n", "<td colspan=\"2\" ><i>\n", get_lang("Enter2passToChange"), "</i></td>\n", "</tr><tr><td height=\"5\"></td></tr>\n";

	$label = "<label for=\"form_password1\">".get_lang("Pass")."</label>:&nbsp;";
	$content = "<input type=\"password\" ".$disabled_output.$textinput_size." name=\"form_password1\" id=\"form_password1\" value=\"\" />\n";
	display_profile_entry($label, $content);

	//	PASSWORD CONFIRMATION
	//	user must enter password twice so we can be prevent some user errors

	$label = "<label for=\"form_password2\">".get_lang("Confirmation")."</label>:&nbsp;";
	$content = "<input type=\"password\" ".$disabled_output.$textinput_size." name=\"form_password2\" id=\"form_password2\" value=\"\">\n";
	display_profile_entry($label, $content);
}

//	SUBMIT

echo "<tr>\n"."<td></td>\n", "<td>\n";

if ($profileIsEditable)
	echo "<input type=\"submit\" name=\"applyChange\" value=\"", get_lang("Ok"), "\" />\n";

echo "</td>\n", "</tr>\n", "</table>\n", "</form>\n</p>";

/*
if(!empty($form_competences) || !empty($form_can_teach))
{
	echo "<hr noshade=\"noshade\" size=\"1\" />";
}

if(!empty($form_competences))
{
	echo "<b>".get_lang("YourCompetences")."</b><div style=\"margin-top: 10px; margin-bottom: 10px;\">".nl2br($form_competences)."</div>";
}

if(!empty($form_can_teach))
{
	echo "<b>".get_lang("WhatYouCanTeach")."</b><div style=\"margin-top: 10px; margin-bottom: 10px;\">".nl2br($form_can_teach)."</div>";
}
*/

/*
==============================================================================
		FOOTER
==============================================================================
*/

Display :: display_footer();
?>