<?php
// $Id: lost_password.lib.php,v 1.4 2005/06/06 13:05:59 olivierb78 Exp $ 
/*
============================================================================== 
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
============================================================================== 
*/
/**
 * generates randomly a new password
 *
 * @author Damien Seguy
 * @param - void
 * @return string the new password
 */
function generate_passwd()
{
	if (func_num_args() == 1)
		$nb = func_get_arg(0);
	else
		$nb = 8;
	// on utilise certains chiffres : 1 = i, 5 = S, 6=b, 3=E, 9=G, 0=O
	$lettre = array ();
	$lettre[0] = array ('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'o', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'D', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '9', '0', '6', '5', '1', '3');
	$lettre[1] = array ('a', 'e', 'i', 'o', 'u', 'y', 'A', 'E', 'I', 'O', 'U', 'Y', '1', '3', '0');
	$lettre[-1] = array ('b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'z', 'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z', '5', '6', '9');
	$retour = "";
	$prec = 1;
	$precprec = -1;
	srand((double) microtime() * 20001107);
	while (strlen($retour) < $nb)
	{
		// To generate the password string we follow these rules : (1) If two
		// letters are consonnance (vowel), the following one have to be a vowel
		// (consonnace) - (2) If letters are from different type, we choose a
		// letter from the alphabet.
		$type = ($precprec + $prec) / 2;
		$r = $lettre[$type][array_rand($lettre[$type], 1)];
		$retour .= $r;
		$precprec = $prec;
		$prec = in_array($r, $lettre[-1]) - in_array($r, $lettre[1]);
	}
	return $retour;
}
/*** By Olivier Cauberghe, UGent ***/
//-----------------------------------------------------------------------------
function get_email_headers()
{
	global $charset;
	$emailHeaders = "MIME-Version: 1.0\r\n";
	$emailHeaders .= "Content-Type: text/html; charset=utf-8\r\n";
	//$emailHeaders .= "From: \"".addslashes(get_setting('administratorName'))."\" <".get_setting('emailAdministrator').">\r\n";
	$emailHeaders .= "From: ".get_setting('administratorSurname')." ".get_setting('administratorName')." <".get_setting('emailAdministrator').">\r\n";
	$emailHeaders .= "Reply-To: ".get_setting('emailAdministrator')."\r\n";
	$emailHeaders .= "Return-Path: ".get_setting('emailAdministrator');
	//$emailHeaders .= "X-Sender: ".get_setting('emailAdministrator')."\n";
	//$emailHeaders .= "X-Mailer: PHP / ".phpversion()."\n";
	return $emailHeaders;
}
/*** By Olivier Cauberghe, UGent ***/
//-----------------------------------------------------------------------------
function get_user_account_list($user, $reset = false)
{
	global $rootWeb;
	foreach ($user as $thisUser)
	{
		$secretword = get_secret_word($thisUser["email"]);
		if ($reset) {
			$tmp = $rootWeb . "claroline/auth/lostPassword.php?reset=$secretword&id=$thisUser[uid]";
			$reset_link = 'Reset link : <a href="'.$tmp.'">'.$tmp.'</a>';
		} else {
			$reset_link = get_lang('Pass')." : $thisUser[password]";
		}
		$userAccountList[] = get_lang('Username').' : '.$thisUser["loginName"].'<br>'.$reset_link;
	}
	if ($userAccountList)
		$userAccountList = implode("<br>------------------------<br>", $userAccountList);
	return $userAccountList;
}
/*** By Olivier Cauberghe, UGent ***/
//-----------------------------------------------------------------------------
function send_password_to_user($user, $success_msg)
{
	global $charset, $includePath, $languageInterface;
	global $rootWeb;
	$emailHeaders = get_email_headers(); // Email Headers
	$emailSubject = "Login Request";
	$userAccountList = get_user_account_list($user); // BODY
	include($includePath.'/../lang/'.$languageInterface.'/send_new_passwd.inc.php');
	$emailBody = $langNewPasswd;
	// SEND MESSAGE
	$emailTo = $user[0]["email"];
	if (@ api_send_mail($emailTo, $emailSubject, $emailBody, $emailHeaders))
		return $success_msg;
	else
		echo "<p>The system is unable to send you an e-mail.<br/>Please contact the ".Display :: encrypted_mailto_link(get_setting('emailAdministrator'), "Platform administrator").".</p>";
	return "";
}
//-----------------------------------------------------------------------------
/*** By Olivier Cauberghe, UGent ***/
function handle_encrypted_password($user)
{
	global $security_key;
	global $charset, $includePath, $languageInterface;
	global $rootWeb;
	$emailHeaders = get_email_headers(); // Email Headers
	$emailSubject = "Login Request";
	$userAccountList = get_user_account_list($user, true); // BODY
	$emailTo = $user[0]["email"];
	$secretword = get_secret_word($emailTo);
	//$emailBody = get_lang("password_request")."\n\n\n".get_lang("YourAccountParam")." $rootWeb\n\n".$userAccountList;
	include($includePath.'/../lang/'.$languageInterface.'/reset_passwd.inc.php');
	//$emailBody = get_lang("password_request")."\n\n".$userAccountList;
	$emailBody = $langResetPasswd;

	if (@ api_send_mail($emailTo, $emailSubject, $emailBody, $emailHeaders))
		return get_lang("lang_your_password_link_has_been_emailed_to_you");
	else
		echo "<p>", "The system is unable to send you an e-mail.<br/>", "Please contact the ", Display::encrypted_mailto_link(get_setting('emailAdministrator'),"platform administrator"), ".<p>";
	return "";
}
//-----------------------------------------------------------------------------
function get_secret_word($add)
{
	global $security_key;
	return $secretword = md5($security_key.$add);
}
//-----------------------------------------------------------------------------
function reset_password($secret, $id)
{
	global $your_password_has_been_reset,$userPasswordCrypted;
	$tbl_user = Database::get_main_table(MAIN_USER_TABLE);
	$sql = "SELECT user_id AS uid, lastname AS lastName, firstname AS firstName, username AS loginName, password, email FROM ".$tbl_user." WHERE `user_id`=$id";
	$result = api_sql_query($sql,__FILE__,__LINE__);
	if ($result && mysql_num_rows($result))
		$user[] = mysql_fetch_array($result);
	else
		return "Could not reset password.";
	if (get_secret_word($user[0]["email"]) == $secret) // OK, secret word is good. Now change password and mail it.
	{
		$user[0]["password"] = generate_passwd();
		$crypted = $user[0]["password"];
		if( $userPasswordCrypted)
		{
			$crypted = md5($crypted);	
		}
		api_sql_query("UPDATE ".$tbl_user." SET `password`='$crypted' WHERE `user_id`=$id");
		return send_password_to_user($user, $your_password_has_been_reset);
	}
	else
		return "Not allowed.";
}
?>