<?php // $Id: inscription.php,v 1.35 2005/06/27 11:06:16 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	This script displays a form for registering new users.
*	See claro_main.conf for settings:
*
*	$allowSelfReg determines wether self-registration is allowed at all
*	$allowSelfRegProf determines wether or not users can register as teachers
*
*	@package dokeos.auth
==============================================================================
*/

$langFile = "registration";

include("../inc/claro_init_global.inc.php");

$nameTools=get_lang('Registration');

Display::display_header($nameTools);

// Forbidden to self-register
//if(!$allowSelfReg and isset($allowSelfReg))
if (get_setting('allow_registration')=="false")
{
 echo "<br/><br/>You are not allowed here<br/><br/>";
}
else
{
api_display_tool_title($nameTools);
echo '<h4>' . get_lang('UseOnlyEnglishChars') . '</h4>';
$textinput_size = ' style="width: 200px;"';
?>

<form action="inscription_second.php" method="post">
<table cellspacing="3" cellpadding="2" border="0">
  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Lastname") ?><span class="required">*</span>:</td>
    <td></td>
    <td><input type="text"<?php echo $textinput_size;?> id="name" name="lastname" value="<?php if(isset($_GET['lastname'])) echo htmlspecialchars(stripslashes($_GET['lastname'])); ?>" /></td>
  </tr>
  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Firstname") ?><span class="required">*</span>:</td>
    <td></td>
    <td><input type="text"<?php echo $textinput_size;?> name="firstname" id="surname" value="<?php if(isset($_GET['firstname'])) echo htmlspecialchars(stripslashes($_GET['firstname'])); ?>"/></td>
  </tr>
  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Username") ?><span class="required">*</span>:</td>
    <td></td>
    <td><input type="text"<?php echo $textinput_size;?> name="uname" id="username" maxlength="20" value="<?php if(isset($_GET['uname'])) echo htmlspecialchars(stripslashes($_GET['uname'])); ?>"/></td>
  </tr>
<!--<div style="margin-bottom: 5px;"><label class="left"><?php echo get_lang("OfficialCode") ?><?php if (get_setting('registration','officialcode')=="true") {echo "<span class=\"required\">*</span>";}?>:</label>
<input type="text" size="40" name="official_code" id="official_code" value="<?php if(isset($_GET['official_code'])) echo htmlspecialchars(stripslashes($_GET['official_code'])); ?>"/></div>-->
  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Pass") ?><span class="required">*</span>:</td>
    <td></td>
    <td><input type="password"<?php echo $textinput_size;?> name="password1" id="pass1" /></td>
  </tr>
  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Confirmation") ?><span class="required">*</span>:</td>
    <td></td>
    <td><input type="password"<?php echo $textinput_size;?> name="password" id="pass2" /></td>
  </tr>
  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Email") ?><?php if (get_setting('registration','email')=="true") {echo "<span class=\"required\">*</span>";}?>:</td>
    <td></td>
    <td><input type="text"<?php echo $textinput_size;?> name="email" id="email" value="<?php if(isset($_GET['email'])) echo htmlspecialchars(stripslashes($_GET['email'])); ?>" /></td>
  </tr>
<!--  <tr>
    <td align="right" nowrap="nowrap"><?php echo get_lang("Status") ?>:</td>
    <td></td>
    <td>

<?php
// Deactivate Self-registration as Teacher
//if ($is_platformAdmin OR $allowSelfRegProf)
//if (get_setting('allow_registration_as_teacher')=="true")
//if (0) {
?>
<input class="checkbox" type="radio" name="status" value="<?php echo STUDENT; ?>" <?php if(!isset($_GET['status']) || $_GET['status'] != COURSEMANAGER) echo 'checked="checked"'; ?> /> <?php echo get_lang("RegStudent") ?><br/>
<label class="left">&nbsp;</label>
<input class="checkbox" type="radio" name="status" value="<?php echo COURSEMANAGER; ?>" <?php if(isset($_GET['status']) && $_GET['status'] == COURSEMANAGER) echo 'checked="checked"'; ?> /> <?php echo get_lang("RegAdmin") ?>
<?php
//} else {
?>
<input type="hidden" name="status" id="language" value="STUDENT"/><?php echo get_lang('RegStudent') ?>
<?php
//}
?>
    </td>
  </tr> -->
</table>
 <input type="hidden" name="submitRegistration" value="true"/>
 <br/>
 <div style="margin-bottom: 5px;"><label class="left">&nbsp;</label>
 <input type="submit" value="<?php echo get_lang("Ok") ?>" /></div>
 <div><span class="required">*</span>: <?php echo get_lang("required");?></div>
 </form>
<a href="<?php echo api_get_path(WEB_PATH); ?>">&lt;&lt; <?php echo get_lang('Back'); ?></a>

<?php
}        // END else == $allowSelfReg

/*
==============================================================================
		FOOTER
==============================================================================
*/

Display::display_footer();
?>
