<?php // $Id: user_edit.php,v 1.7 2005/06/28 13:49:06 olivierb78 Exp $

/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	@package dokeos.admin
==============================================================================
*/

$langFile=array('admin','registration');

$cidReset=true;

include('../inc/claro_init_global.inc.php');
api_protect_admin_script();
include(api_get_library_path().'/fileManage.lib.php');
$user_id=intval($_GET['user_id']);
$course=$_GET['course'];
$formSent=0;
$errorMsg='';

$tbl_admin=$mysqlMainDb."`.`admin";
$tbl_user=$mysqlMainDb."`.`user";
//$tbl_cours_user=$mysqlMainDb."`.`cours_user";
//updated for 1.6 - YW
$tbl_course_user=Database::get_main_table(MAIN_COURSE_USER_TABLE);

$noPHP_SELF=true;

$tool_name=get_lang('ModifyUserInfo');

$interbredcrump[]=array("url" => "index.php","name" => get_lang('AdministrationTools'));
$interbredcrump[]=array("url" => "user_list.php","name" => get_lang('AdminUsers'));
unset($errorMsg);
	if($_POST['formSent'])
	{
		$formSent=1;

		$lastName=trim(stripslashes($_POST['lastName']));
		$firstName=trim(stripslashes($_POST['firstName']));
		$official_code=trim(stripslashes($_POST['official_code']));
		$email=trim(stripslashes($_POST['email']));
		$phone=trim(stripslashes($_POST['phone']));
		$userName=trim(stripslashes($_POST['userName']));
		$status=(intval($_POST['status']) == 1)?1:5;
		$picture=$_FILES['picture'];
		$picture_uri=trim(stripslashes($_POST['picture_uri']));
		$deletePicture=$_POST['deletePicture']?1:0;
		$platformAdmin=$_POST['platformAdmin']?1:0;
		$resetPassword = $_POST['resetPassword']?1:0;
		$userName=eregi_replace('[^a-z0-9_.-]','_',strtr(stripslashes($userName),'','AAAAAAaaaaaaOOOOOOooooooEEEEeeeeCcIIIIiiiiUUUUuuuuyNn'));

		if(empty($lastName)) $errorMsg=get_lang('PleaseEnterLastName');
		elseif(empty($firstName)) $errorMsg=get_lang('PleaseEnterFirstName');
		elseif(!empty($email) && !eregi("^[a-z0-9]+([._-][a-z0-9]+)*@[a-z0-9]+([.-][a-z0-9]+)*\.[a-z]{2,4}$",$email)) $errorMsg=get_lang('PleaseEnterValidEmail');
		elseif(empty($userName)) $errorMsg=get_lang('PleaseEnterValidLogin');
		else
		{
			if($deletePicture)
			{
				@unlink('../upload/users/'.$picture_uri);

				$picture_uri='';
			}

			if($picture['size'])
			{
				$fileExtension=explode('.',$picture['name']);
				$fileExtension=strtolower($fileExtension[sizeof($fileExtension)-1]);

				if(!strstr($picture['type'],'jpeg') && !strstr($picture['type'],'gif') && !strstr($picture['type'],'png'))
				{
					$errorMsg=get_lang('AcceptedPictureFormats');
				}
				else
				{
					if(!file_exists('../upload/users/'))
					{
						mkpath('../upload/users/');
					}

					if(!empty($picture_uri))
					{
						@unlink('../upload/users/'.$picture_uri);
					}

					$picture_uri='u'.$_uid.'_'.uniqid('').'.'.$fileExtension;

					if(move_uploaded_file($picture['tmp_name'],'../upload/users/'.$picture_uri))
					{
						@chmod('../upload/users/'.$picture_uri, 0777);
					} else {
						$picture_uri='';
					}
				}
			}
			if(empty($errorMsg))
			{
				$sql = "UPDATE `$tbl_user`
									   SET lastname='".addslashes($lastName)."',
										   firstname='".addslashes($firstName)."',
										   username='".addslashes($userName)."',
										   email='".addslashes($email)."',
										   ".(empty($course)?"status='$status',":"")."
										   official_code='".addslashes($official_code)."',
										   phone='".addslashes($phone)."',
										   picture_uri='".addslashes($picture_uri)."'
									   WHERE user_id='$user_id'";
				$result=api_sql_query($sql,__FILE__,__LINE__);
				if(!$result)
				{
					$errorMsg=get_lang('LoginAlreadyTaken');
				}
				else
				{

					if(!$platformAdmin)
					{
						api_sql_query("DELETE FROM `$tbl_admin` WHERE user_id='$user_id'",__FILE__,__LINE__);
					}
					else
					{
						api_sql_query("REPLACE INTO `$tbl_admin`(user_id) VALUES('$user_id')",__FILE__,__LINE__);
					}
					if($resetPassword)
					{
						require_once('../auth/lost_password.lib.php');
						reset_password(get_secret_word($email),$user_id);
					}
					header('Location: user_list.php');
					exit();
				}
			}
		}
	}


$sql = "SELECT lastname,firstname,username,email,status,official_code,phone,picture_uri FROM `$tbl_user` WHERE user_id='$user_id'";

		$result=api_sql_query($sql,__FILE__,__LINE__);


	if(!$infos_user=mysql_fetch_array($result))
	{
		header('Location: user_list.php');
		exit();
	}

	$picture_uri=$infos_user['picture_uri'];

	$result=api_sql_query("SELECT 1 FROM `$tbl_admin` WHERE user_id='$user_id'");

	$infos_user['platformAdmin']=mysql_num_rows($result)?true:false;


Display::display_header($tool_name);

api_display_tool_title($tool_name);

if( isset($errorMsg))
{
	Display::display_error_message($errorMsg);
}
?>

<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?user_id=<?php echo $user_id; ?>&course=<?php echo urlencode($course); ?>" enctype="multipart/form-data" style="margin:0px;">
<input type="hidden" name="formSent" value="1">
<input type="hidden" name="picture_uri" value="<?php echo htmlspecialchars($picture_uri); ?>">

<table>
<tr>
  <td width="30%"><?php echo get_lang('LastName'); ?> : </td>
  <td width="70%"><input type="text" name="lastName" size="40" value="<?php if($formSent) echo htmlspecialchars($lastName); else echo htmlspecialchars($infos_user['lastname']); ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('FirstName'); ?> :</td>
  <td><input type="text" name="firstName" size="40" value="<?php if($formSent) echo htmlspecialchars($firstName); else echo htmlspecialchars($infos_user['firstname']); ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('OfficialCode'); ?> :</td>
  <td><input type="text" name="official_code" size="40" value="<?php if($formSent) echo htmlspecialchars($official_code); else echo htmlspecialchars($infos_user['official_code']); ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('Email'); ?> :</td>
  <td><input type="text" name="email" size="40" value="<?php if($formSent) echo htmlspecialchars($email); else echo htmlspecialchars($infos_user['email']); ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('PhoneNumber'); ?> :</td>
  <td><input type="text" name="phone" size="40" value="<?php if($formSent) echo htmlspecialchars($phone); else echo htmlspecialchars($infos_user['phone']); ?>"></td>
</tr>
<tr>
  <td valign="top"><?php echo empty($picture_uri)?get_lang('AddPicture'):get_lang('ChangePicture'); ?> :</td>
  <td><input type="file" name="picture" size="40"><?php if(!empty($picture_uri)): ?><br><?php echo get_lang('DeletePicture'); ?> <input class="checkbox" type="checkbox" name="deletePicture" value="1"><?php endif; ?></td>
<tr>
<tr>
  <td><?php echo get_lang('LoginName'); ?> :</td>
  <td><input type="text" name="userName" size="40" maxlength="20" value="<?php if($formSent) echo htmlspecialchars($userName); else echo htmlspecialchars($infos_user['username']); ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('Status'); ?> :</td>
  <td><select name="status">
	<option value="1"><?php echo get_lang('Teacher'); ?></option>
	<option value="5" <?php if((!$formSent && $infos_user['status'] == 5) || ($formSent && $status == 5)) echo 'selected="selected"'; ?>><?php echo get_lang('User'); ?></option>
  </select></td>
</tr>
<tr>
  <td><?php echo get_lang('PlatformAdmin'); ?> :</td>
  <td>
	<input class="checkbox" type="radio" name="platformAdmin" value="1" <?php if((!$formSent && $infos_user['platformAdmin']) || ($formSent && $platformAdmin)) echo 'checked="checked"'; ?>> <?php echo get_lang('Yes'); ?>&nbsp;
	<input class="checkbox" type="radio" name="platformAdmin" value="0" <?php if((!$formSent && !$infos_user['platformAdmin']) || ($formSent && !$platformAdmin)) echo 'checked="checked"'; ?>> <?php echo get_lang('No'); ?>&nbsp;
  </td>
</tr>
<tr>
  <td><?php echo get_lang('ResetPassword'); ?> :</td>
  <td>
	<input class="checkbox" type="checkbox" name="resetPassword" value="1" <?php if((!$formSent && $infos_user['resetPassword']) || ($formSent && $resetPassword)) echo 'checked="checked"'; ?>><?php echo get_lang('CheckToSendNewPassword'); ?>
  </td>
</tr>
<tr>
  <td colspan="2" align="center"><input type="submit" value="<?php echo get_lang('Ok'); ?>"></td>
</tr>

<?php if(!empty($picture_uri)): ?>
<tr>
  <td colspan="2" align="center"><img src="../upload/users/<?php echo $picture_uri; ?>" border="0"></td>
</tr>
<?php endif; ?>

</table>

</form>

<?php
/*
==============================================================================
		FOOTER
==============================================================================
*/
Display::display_footer();
?>
