<?php
// $Id: system_announcements.php,v 1.9 2005/06/20 07:02:57 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Bart Mollet

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	@author Bart Mollet
*	@package dokeos.admin
==============================================================================
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
$langFile = array('admin','agenda');
$cidReset = true;
include ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
include (api_get_library_path().'/system_announcements.lib.php');
$tool_name = get_lang('SystemAnnouncements');
$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));

/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/
Display :: display_header($tool_name);
api_display_tool_title($tool_name);
/*
==============================================================================
		MAIN CODE
==============================================================================
*/
if ($_GET['action'] != 'add' && $_GET['action'] != 'edit')
{
	echo '<a href="?action=add">'.get_lang('AddAnnouncement').'</a>';
}
$form_action = "";
if (isset ($_GET['setTeacherVisibility']))
{
	SystemAnnouncementManager :: set_visibility($_GET['id'], VISIBLE_TEACHER, $_GET['setTeacherVisibility']);
}
if (isset ($_GET['setStudentVisibility']))
{
	SystemAnnouncementManager :: set_visibility($_GET['id'], VISIBLE_STUDENT, $_GET['setStudentVisibility']);
}
if (isset ($_GET['setGuestVisibility']))
{
	SystemAnnouncementManager :: set_visibility($_GET['id'], VISIBLE_GUEST, $_GET['setGuestVisibility']);
}
// Add a new announcement
if (isset ($_POST['action']) && $_POST['action'] == "add")
{
	$_POST['visible_teacher'] == 'true' ? 'true' : 'false';
	$_POST['visible_student'] == 'true' ? 'true' : 'false';
	$_POST['visible_guest'] == 'true' ? 'true' : 'false';
	if (SystemAnnouncementManager :: add_announcement(htmlspecialchars($_POST['title']), $_POST['content'], $_POST['start'], $_POST['end'], $_POST['visible_teacher'], $_POST['visible_student'], $_POST['visible_guest']))
	{
		Display :: display_normal_message(get_lang('AnnouncementAdded'));
	}
	else
	{
		$form_title = $_POST['title'];
		$form_content = $_POST['content'];
		$form_date_start = $_POST['start'];
		$form_date_end = $_POST['end'];
		$form_visible_teacher = $_POST['visible_teacher'];
		$form_visible_student = $_POST['visible_student'];
		$form_visible_guest = $_POST['visible_guest'];
		$form_action = 'add';
	}
}
// Delete an announcement
if (isset ($_GET['action']) && $_GET['action'] == 'delete')
{
	SystemAnnouncementManager :: delete_announcement($_GET['id']);
	Display :: display_normal_message(get_lang('AnnouncementDeleted'));
}
// Add an announcement
if (isset ($_GET['action']) && $_GET['action'] == 'add')
{
	$form_action = "add";
	$time_next_week = time() + 60*60*24*7;
	$form_date_start = array (0 => date('j'), 1 => date('m'), 2 => date('Y'), 3 => date('G'), 0);
	$form_date_end = array (0 => date('j',$time_next_week), 1 => date('m',$time_next_week), 2 => date('Y',$time_next_week), 3 => date('G',$time_next_week), 0);
	$form_visible_teacher = false;
	$form_visible_student = false;
	$form_visible_guest = false;
}
// Edit an announcement
if (isset ($_GET['action']) && $_GET['action'] == 'edit')
{
	$announcement = SystemAnnouncementManager :: get_announcement($_GET['id']);
	$form_id = $announcement->id;
	$form_title = $announcement->title;
	$form_content = $announcement->content;
	$form_date_start = array ($announcement->dateS['d'], $announcement->dateS['m'], $announcement->dateS['y'], $announcement->dateS['h'], $announcement->dateS['i']);
	$form_date_end = array ($announcement->dateE['d'], $announcement->dateE['m'], $announcement->dateE['y'], $announcement->dateE['h'], $announcement->dateE['i']);
	$form_visible_teacher = $announcement->visible_teacher == 'true';
	$form_visible_student = $announcement->visible_student == 'true';
	$form_visible_guest = $announcement->visible_guest == 'true';
	$form_action = 'edit';
}
// Edit an announcement
if (isset ($_POST['action']) && $_POST['action'] == 'edit')
{
	$_POST['visible_user'] == 'true' ? 'true' : 'false';
	$_POST['visible_guest'] == 'true' ? 'true' : 'false';
	if (SystemAnnouncementManager :: update_announcement($_POST['id'], htmlspecialchars($_POST['title']), $_POST['content'], $_POST['start'], $_POST['end'], $_POST['visible_teacher'], $_POST['visible_student'], $_POST['visible_guest']))
	{
		$form_id = '';
		$form_title = '';
		$form_content = '';
		$form_date_start = array (0 => date('j'), 1 => date('m'), 2 => date('Y'), 3 => date('G'), 0);
		$form_date_end = array (0 => date('j'), 1 => date('m'), 2 => date('Y'), 3 => date('G'), 0);
		$form_visible_teacher = false;
		$form_visible_student = false;
		$form_visible_guest = false;
		$form_action = '';
		Display :: display_normal_message(get_lang('AnnouncementUpdated'));
	}
	else
	{
		$form_id = $_POST['id'];
		$form_title = $_POST['title'];
		$form_content = $_POST['content'];
		$form_date_start = $_POST['start'];
		$form_date_end = $_POST['end'];
		$form_visible_teacher = $_POST['visible_teacher'];
		$form_visible_student = $_POST['visible_student'];
		$form_visible_guest = $_POST['visible_guest'];
		$form_action = 'edit';
	}
}
if ($form_action == 'edit' || $form_action == 'add')
{
?>
		<blockquote> 
		  <form method="post" action="<?php

	echo $_SERVER['PHP_SELF'];
?>">
		    <input type="hidden" name="id" value="<?php

	echo $form_id;
?>"/>
		    <table cellpadding="5" cellspacing="0">
		      <tr> 
		        <td align="right"><b><?php

	echo get_lang('Title');
?> : </b></td>
		        <td><input type="text" name="title" size="30" value="<?php   echo $form_title ?>"/></td>
		      </tr>
		      <tr> 
		        <td valign="top" align="right"><b><?php

	echo get_lang('Content');
?> : </b></td>
		        <td> 
			<?php

	api_disp_html_area('content', $content = $form_content, '500px');
?>
		        </td>
		      </tr>
		      <tr> 
		        <td align="right"><b><?php

	echo get_lang('StartDate');
?> : </b></td>
		        <td> 
		          <?php   SystemAnnouncementManager :: display_date_form_element("start", $form_date_start) ?>
		        </td>
		      </tr>
		      <tr> 
		        <td align="right"><b><?php

	echo get_lang('EndDate');
?> : </b></td>
		        <td> 
		          <?php   SystemAnnouncementManager :: display_date_form_element("end", $form_date_end) ?>
		        </td>
		      </tr>
			<tr><td align="right" valign="top"><b><?php

	echo get_lang('Visible');
?> : </b></td>
		
			<td><input type="checkbox"  class="checkbox" name="visible_teacher"  id="visible_teacher" value='true' <?php

	echo ($form_visible_teacher ? "checked" : "");
?>/> 
<label for="visible_teacher">
<?php

	echo get_lang('Teacher');
?></label><br/>
	<input type="checkbox" class="checkbox"  name="visible_student" id="visible_student" value='true' <?php

	echo ($form_visible_student ? "checked" : "");
?>/><label for="visible_student">
<?php	echo get_lang('Student') ?> </label><br/>
		<input type="checkbox"  class="checkbox"  name="visible_guest"   id="visible_guest" value='true'  <?php

	echo ($form_visible_guest ? "checked" : "");
?>/>
		<label for="visible_guest"><?php	echo get_lang('Guest') ?></label><br/>
</td>
			</tr>
		      <tr> 
		        <td>&nbsp;</td>
		        <td>
		        <input type="submit" value="<?php   echo get_lang('Ok') ?>"/>
		        </td>
		      </tr>
		    </table>
		    <input type="hidden" name="action" value="<?php   echo $form_action ?>"/>
		  </form>
		</blockquote>
		<?php

}
if ($_GET['action'] != 'edit' && $_GET['action'] != 'add')
{
	$announcements = SystemAnnouncementManager :: get_all_announcements();
	if (count($announcements) > 0)
	{
		$announcement_data = array ();
		foreach ($announcements as $index => $announcement)
		{
			$row = array ();
			$row[] = "<img src=\"../img/". ($announcement->visible ? 'visible.gif' : 'invisible.gif')."\"/>";
			$row[] = $announcement->date_start;
			$row[] = $announcement->date_end;
			$row[] = "<a href=\"?id=".$announcement->id."&setTeacherVisibility=". ($announcement->visible_teacher == 'true' ? 'false' : 'true')."\"><img src=\"../img/". ($announcement->visible_teacher == 'true' ? 'visible.gif' : 'invisible.gif')."\" border=\"0\"></a>";
			$row[] = "<a href=\"?id=".$announcement->id."&setStudentVisibility=". ($announcement->visible_student == 'true' ? 'false' : 'true')."\"><img src=\"../img/". ($announcement->visible_student == 'true' ? 'visible.gif' : 'invisible.gif')."\" border=\"0\"></a>";
			$row[] = "<a href=\"?id=".$announcement->id."&setGuestVisibility=". ($announcement->visible_guest == 'true' ? 'false' : 'true')."\"><img src=\"../img/". ($announcement->visible_guest == 'true' ? 'visible.gif' : 'invisible.gif')."\" border=\"0\"></a>";
			$row[] = $announcement->title;
			$row[] = "<a href=\"?action=edit&id=".$announcement->id."\"><img src=\"../img/edit.gif\"  title=\"".get_lang('Edit')."\" border=\"0\"/></a> <a href=\"?action=delete&id=".$announcement->id."\"  onclick=\"javascript:if(!confirm('".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."')) return false;\"><img src=\"../img/delete.gif\" border=\"0\"/></a>";
			$announcement_data[] = $row;
		}
		$column_header[] = array ('', false, 'width="20"');
		$column_header[] = array (get_lang('StartDate'), true, '');
		$column_header[] = array (get_lang('EndDate'), true, '');
		$column_header[] = array (get_lang('Teacher'), true, 'width="50"');
		$column_header[] = array (get_lang('Student'), true, 'width="50"');
		$column_header[] = array (get_lang('Guest'), true, 'width="50"');
		$column_header[] = array (get_lang('Title'), true, '');
		$column_header[] = array (get_lang('Modify'), false, 'width="50"');
		Display :: display_sortable_table($column_header, $announcement_data);
	}
}
/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?>
