<?php // $Id: subscribe_user2course.php,v 1.8 2005/05/24 12:55:31 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software
	
	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	
	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	See the GNU General Public License for more details.
	
	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
============================================================================== 
*	This script allows platform admins to add users to courses.
*	It displays a list of users and a list of courses;
*	you can select multiple users and courses and then click on
*	'Add to this(these) course(s)'.
*
*	@package dokeos.admin
============================================================================== 
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/ 

$langFile='admin';

$cidReset=true;

require('../inc/claro_init_global.inc.php');
api_protect_admin_script();
/*
-----------------------------------------------------------
	Global constants and variables
-----------------------------------------------------------
*/ 

$users=$_GET['users'];
$formSent=0;
$errorMsg=$firstLetterUser=$firstLetterCourse='';
$courses=array();

//$tbl_cours=$mysqlMainDb."`.`cours";
//$tbl_cours_user=$mysqlMainDb."`.`cours_user";
//updated for 1.6 - YW
$tbl_course       = Database::get_main_table(MAIN_COURSE_TABLE); 
$tbl_course_user  = Database::get_main_table(MAIN_COURSE_USER_TABLE);
$tbl_user=$mysqlMainDb."`.`user";


/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/ 
$tool_name=get_lang('AddUsersToACourse');

$interbredcrump[]=array("url" => "index.php","name" => get_lang('AdministrationTools'));

/*
==============================================================================
		MAIN CODE
==============================================================================
*/ 
Display::display_header($tool_name);
api_display_tool_title($tool_name);
/*
-----------------------------------------------------------
	React on POSTed request
-----------------------------------------------------------
*/ 
if($_POST['formSent'])
{
	$formSent=$_POST['formSent'];
	$UserList=$_POST['UserList'];
	$CourseList=$_POST['CourseList'];
	$firstLetterUser=$_POST['firstLetterUser'];
	$firstLetterCourse=$_POST['firstLetterCourse'];

	if(!is_array($UserList))
	{
		$UserList=array();
	}

	if(!is_array($CourseList))
	{
		$CourseList=array();
	}

	if($formSent == 1)
	{
		if(!sizeof($UserList) || !sizeof($CourseList)) $errorMsg=get_lang('AtLeastOneUserAndOneCourse');
		else
		{
			$query="INSERT IGNORE INTO $tbl_course_user(course_code,user_id,status) VALUES";

			foreach($CourseList as $enreg_cours)
			{
				foreach($UserList as $enreg_user)
				{
					$query.="('$enreg_cours','$enreg_user','5'),";
				}
			}

			$query=substr($query,0,-1);

			api_sql_query($query,__FILE__,__LINE__);
			Display::display_normal_message(get_lang('UsersAreSubscibedToCourse'));
		}
	}

	if(sizeof($UserList))
	{
		$users=$UserList;
	}

	if(sizeof($CourseList))
	{
		$courses=$CourseList;
	}
}

/*
-----------------------------------------------------------
	Display GUI
-----------------------------------------------------------
*/ 




if(empty($users))
{
	$users=array();
}
elseif(!is_array($users))
{
	$users=explode(',',$users);

	foreach($users as $key=>$enreg)
	{
		$users[$key]=intval($enreg);
	}
}
else
{
	foreach($users as $key=>$enreg)
	{
		$users[$key]=intval($enreg);
	}
}

foreach($courses as $key=>$enreg)
{
	$courses[$key]="'$enreg'";
}

$result=api_sql_query("SELECT user_id,lastname,firstname,username FROM `$tbl_user` WHERE lastname LIKE '".$firstLetterUser."%' ORDER BY ".(sizeof($users)?"(user_id IN(".implode(',',$users).")) DESC,":"")." lastname",__FILE__,__LINE__);

$Users=api_store_result($result);

$result=api_sql_query("SELECT code,visual_code,title FROM $tbl_course WHERE visual_code LIKE '".$firstLetterCourse."%' ORDER BY ".(sizeof($courses)?"(code IN(".implode(',',$courses).")) DESC,":"")." visual_code",__FILE__,__LINE__);

$Courses=api_store_result($result);
?>

<form name="formulaire" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" style="margin:0px;">
<input type="hidden" name="formSent" value="1">

<?php
if(!empty($errorMsg))
{
	Display::display_normal_message($errorMsg); //main API
}
?>

<table border="0" cellpadding="5" cellspacing="0" width="100%">
<tr>
  <td width="40%" align="center"><b><?php echo get_lang('UserList'); ?> :</b><br><br>
  <?php echo get_lang('FirstLetterUser'); ?> : <select name="firstLetterUser" onchange="javascript:document.formulaire.formSent.value='2'; document.formulaire.submit();">
  <option value="">--</option>
  <option value="A" <?php if($formSent && $firstLetterUser == 'A') echo 'selected="selected"'; ?>>A</option>
  <option value="B" <?php if($formSent && $firstLetterUser == 'B') echo 'selected="selected"'; ?>>B</option>
  <option value="C" <?php if($formSent && $firstLetterUser == 'C') echo 'selected="selected"'; ?>>C</option>
  <option value="D" <?php if($formSent && $firstLetterUser == 'D') echo 'selected="selected"'; ?>>D</option>
  <option value="E" <?php if($formSent && $firstLetterUser == 'E') echo 'selected="selected"'; ?>>E</option>
  <option value="F" <?php if($formSent && $firstLetterUser == 'F') echo 'selected="selected"'; ?>>F</option>
  <option value="G" <?php if($formSent && $firstLetterUser == 'G') echo 'selected="selected"'; ?>>G</option>
  <option value="H" <?php if($formSent && $firstLetterUser == 'H') echo 'selected="selected"'; ?>>H</option>
  <option value="I" <?php if($formSent && $firstLetterUser == 'I') echo 'selected="selected"'; ?>>I</option>
  <option value="J" <?php if($formSent && $firstLetterUser == 'J') echo 'selected="selected"'; ?>>J</option>
  <option value="K" <?php if($formSent && $firstLetterUser == 'K') echo 'selected="selected"'; ?>>K</option>
  <option value="L" <?php if($formSent && $firstLetterUser == 'L') echo 'selected="selected"'; ?>>L</option>
  <option value="M" <?php if($formSent && $firstLetterUser == 'M') echo 'selected="selected"'; ?>>M</option>
  <option value="N" <?php if($formSent && $firstLetterUser == 'N') echo 'selected="selected"'; ?>>N</option>
  <option value="O" <?php if($formSent && $firstLetterUser == 'O') echo 'selected="selected"'; ?>>O</option>
  <option value="P" <?php if($formSent && $firstLetterUser == 'P') echo 'selected="selected"'; ?>>P</option>
  <option value="Q" <?php if($formSent && $firstLetterUser == 'Q') echo 'selected="selected"'; ?>>Q</option>
  <option value="R" <?php if($formSent && $firstLetterUser == 'R') echo 'selected="selected"'; ?>>R</option>
  <option value="S" <?php if($formSent && $firstLetterUser == 'S') echo 'selected="selected"'; ?>>S</option>
  <option value="T" <?php if($formSent && $firstLetterUser == 'T') echo 'selected="selected"'; ?>>T</option>
  <option value="U" <?php if($formSent && $firstLetterUser == 'U') echo 'selected="selected"'; ?>>U</option>
  <option value="V" <?php if($formSent && $firstLetterUser == 'V') echo 'selected="selected"'; ?>>V</option>
  <option value="W" <?php if($formSent && $firstLetterUser == 'W') echo 'selected="selected"'; ?>>W</option>
  <option value="X" <?php if($formSent && $firstLetterUser == 'X') echo 'selected="selected"'; ?>>X</option>
  <option value="Y" <?php if($formSent && $firstLetterUser == 'Y') echo 'selected="selected"'; ?>>Y</option>
  <option value="Z" <?php if($formSent && $firstLetterUser == 'Z') echo 'selected="selected"'; ?>>Z</option>
  </select></td>
  <td width="20%">&nbsp;</td>
  <td width="40%" align="center"><b><?php echo get_lang('CourseList'); ?> :</b><br><br>
  <?php echo get_lang('FirstLetterCourse'); ?> : <select name="firstLetterCourse" onchange="javascript:document.formulaire.formSent.value='2'; document.formulaire.submit();">
  <option value="">--</option>
  <option value="A" <?php if($formSent && $firstLetterCourse == 'A') echo 'selected="selected"'; ?>>A</option>
  <option value="B" <?php if($formSent && $firstLetterCourse == 'B') echo 'selected="selected"'; ?>>B</option>
  <option value="C" <?php if($formSent && $firstLetterCourse == 'C') echo 'selected="selected"'; ?>>C</option>
  <option value="D" <?php if($formSent && $firstLetterCourse == 'D') echo 'selected="selected"'; ?>>D</option>
  <option value="E" <?php if($formSent && $firstLetterCourse == 'E') echo 'selected="selected"'; ?>>E</option>
  <option value="F" <?php if($formSent && $firstLetterCourse == 'F') echo 'selected="selected"'; ?>>F</option>
  <option value="G" <?php if($formSent && $firstLetterCourse == 'G') echo 'selected="selected"'; ?>>G</option>
  <option value="H" <?php if($formSent && $firstLetterCourse == 'H') echo 'selected="selected"'; ?>>H</option>
  <option value="I" <?php if($formSent && $firstLetterCourse == 'I') echo 'selected="selected"'; ?>>I</option>
  <option value="J" <?php if($formSent && $firstLetterCourse == 'J') echo 'selected="selected"'; ?>>J</option>
  <option value="K" <?php if($formSent && $firstLetterCourse == 'K') echo 'selected="selected"'; ?>>K</option>
  <option value="L" <?php if($formSent && $firstLetterCourse == 'L') echo 'selected="selected"'; ?>>L</option>
  <option value="M" <?php if($formSent && $firstLetterCourse == 'M') echo 'selected="selected"'; ?>>M</option>
  <option value="N" <?php if($formSent && $firstLetterCourse == 'N') echo 'selected="selected"'; ?>>N</option>
  <option value="O" <?php if($formSent && $firstLetterCourse == 'O') echo 'selected="selected"'; ?>>O</option>
  <option value="P" <?php if($formSent && $firstLetterCourse == 'P') echo 'selected="selected"'; ?>>P</option>
  <option value="Q" <?php if($formSent && $firstLetterCourse == 'Q') echo 'selected="selected"'; ?>>Q</option>
  <option value="R" <?php if($formSent && $firstLetterCourse == 'R') echo 'selected="selected"'; ?>>R</option>
  <option value="S" <?php if($formSent && $firstLetterCourse == 'S') echo 'selected="selected"'; ?>>S</option>
  <option value="T" <?php if($formSent && $firstLetterCourse == 'T') echo 'selected="selected"'; ?>>T</option>
  <option value="U" <?php if($formSent && $firstLetterCourse == 'U') echo 'selected="selected"'; ?>>U</option>
  <option value="V" <?php if($formSent && $firstLetterCourse == 'V') echo 'selected="selected"'; ?>>V</option>
  <option value="W" <?php if($formSent && $firstLetterCourse == 'W') echo 'selected="selected"'; ?>>W</option>
  <option value="X" <?php if($formSent && $firstLetterCourse == 'X') echo 'selected="selected"'; ?>>X</option>
  <option value="Y" <?php if($formSent && $firstLetterCourse == 'Y') echo 'selected="selected"'; ?>>Y</option>
  <option value="Z" <?php if($formSent && $firstLetterCourse == 'Z') echo 'selected="selected"'; ?>>Z</option>
  </select></td>
</tr>
<tr>
  <td width="40%" align="center"><select name="UserList[]" multiple="multiple" size="20" style="width:230px;">

<?php
foreach($Users as $enreg)
{
?>

	<option value="<?php echo $enreg['user_id']; ?>" <?php if((!$formSent && in_array($enreg['user_id'],$users)) || ($formSent && in_array($enreg['user_id'],$UserList))) echo 'selected="selected"'; ?>><?php echo $enreg['lastname'].' '.$enreg['firstname'].' ('.$enreg['username'].')'; ?></option>

<?php
}

unset($Users);
?>

  </select></td>
  <td width="20%" valign="middle" align="center"><input type="submit" value="<?php echo get_lang('AddToThatCourse'); ?> &gt;&gt;"></td>
  <td width="40%" align="center"><select name="CourseList[]" multiple="multiple" size="20" style="width:230px;">

<?php
foreach($Courses as $enreg)
{
?>

	<option value="<?php echo $enreg['code']; ?>" <?php if($formSent && in_array($enreg['code'],$CourseList)) echo 'selected="selected"'; ?>><?php echo '('.$enreg['visual_code'].') '.$enreg['title']; ?></option>

<?php
}

unset($Courses);
?>

  </select></td>
</tr>
</table>

</form>

<?php
/*
==============================================================================
		FOOTER 
==============================================================================
*/ 
Display::display_footer();
?>
