<?php
// $Id: settings.php,v 1.32 2005/05/13 08:43:03 pcool Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Dokeos, 44 rue des palais, B-1030 Brussels, Belgium
	Mail: info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* With this tool you can easily adjust non critical configuration settings.
* Non critical means that changing them will not result in a broken campus. 
*	
* @author Patrick Cool
* @since Dokeos 1.6
* @package dokeos.admin
* @todo reorganise - functions should be above the main code
==============================================================================
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
// stating the language file
$langFile = 'admin';
// including some necessary dokeos files
include ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
// storing the forms
if ($_POST)
{
	if (store_settings($_GET['storecategory']))
	{
		header("Location: settings.php?action=stored"); // we redirect to see the settings immediately in action
		exit;
	}
}
$table_settings_current = Database::get_main_table(MAIN_SETTINGS_CURRENT_TABLE);
// setting breadcrumbs
$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));
// setting the name of the tool
$tool_name = get_lang('DokeosConfigSettings');
// including the header (banner)
Display :: display_header($tool_name);
api_display_tool_title($tool_name);
// displaying the message that the settings have been stored
if ($_GET['action'] == "stored")
{
	Display :: display_normal_message($SettingsStored);
}
// grabbing the categories
$selectcategories = "SELECT DISTINCT category FROM ".$table_settings_current;
$resultcategories = api_sql_query($selectcategories,__FILE__,__LINE__);
echo "\n<div><ul>";
while ($row = mysql_fetch_array($resultcategories))
{
	echo "\n\t<li><a href=\"".$_SERVER['PHP_SELF']."?category=".$row['category']."\">".get_lang($row['category'])."</a></li>";
}
echo "\n\t<li><a href=\"".$_SERVER['PHP_SELF']."?category=plugins\">".get_lang('Plugins')."</a></li>";
echo "\n</ul></div>";
// displaying all the variables of this category
if ($_GET['category'] and !$_POST and $_GET['category'] <> "plugins")
{
	$sqlsettings = "SELECT DISTINCT * FROM $table_settings_current WHERE category='".$_GET['category']."' GROUP BY variable ORDER BY id ASC";
	$resultsettings = api_sql_query($sqlsettings,__FILE__,__LINE__);
	echo "\n\n<div>\n<form name=\"form1\" method=\"post\" action=\"".$_SERVER['PHP_SELF']."?storecategory=".$_GET['category']."\">\n";
	while ($row = mysql_fetch_array($resultsettings))
	{
		echo "<div class=\"settingtitle\">".get_lang($row['title'])."</div>";
		echo "<div class=\"settingcomment\">".get_lang($row['comment'])."</div>";
		echo "<div class=\"settingvalue\">";
		$result = display_form($row['variable'], $row['type'], $row['selected_value']);
		echo "</div>";
	}
	echo "<p><input type=\"submit\" name=\"Submit\" value=\"".get_lang('Ok')."\">";
	echo "</form>\n</div>\n";
}
// displaying the plugins
if ($_GET['category'] and !$_POST and $_GET['category'] == "plugins")
{
	echo get_lang('AvailablePlugins');
}
/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
//***********************************************	
// The function that retrieves all the possible 
// settings for a certain config setting
//***********************************************
function get_settings_options($var)
{
	$table_settings_options = Database::get_main_table(MAIN_SETTINGS_OPTIONS_TABLE);
	$sql = "SELECT * FROM $table_settings_options WHERE variable='$var'";
	$result = api_sql_query($sql,__FILE__,__LINE__);
	while ($row = mysql_fetch_array($result))
	{
		$temp_array = array ('value' => $row['value'], 'display_text' => $row['display_text']);
		$settings_options_array[] = $temp_array;
	}
	return $settings_options_array;
}
//***********************************************	
// The function that displays the form
//***********************************************
function display_form($variable, $type, $selected_value)
{
	switch ($type)
	{
		case "textfield" :
			echo "<input type=\"text\" name=\"adminsetting_".$variable."\" value=\"".$selected_value."\">";
			break;
		case "textarea" :
			echo "<textarea name=\"adminsetting_".$variable."\">".$selected_value."</textarea>";
			break;
		case "radio" :
			$values = get_settings_options($variable);
			foreach ($values as $key => $value)
			{
				echo "<input class=\"radio\" type=\"radio\" id=\"adminsetting_".$variable.$key."\" name=\"adminsetting_".$variable."\" value=\"".$value['value']."\"";
				if ($selected_value == $value['value'])
				{
					echo " checked ";
				}
				echo "/> <label for=\"adminsetting_".$variable.$key."\">".get_lang($value['display_text'])."</label><br>";
			}
			break;
		case "checkbox";
			$sql = "SELECT * FROM settings_current WHERE variable='".$variable."'";
			$result = api_sql_query($sql,__FILE__,__LINE__);
			while ($rowkeys = mysql_fetch_array($result))
			{
				echo "\n<input type=\"checkbox\" class=\"checkbox\" id=\"adminsetting_".$variable."*".$rowkeys['subkey']."\" name=\"adminsetting_".$variable."*".$rowkeys['subkey']."\" value=\"true\"";
				if ($rowkeys['selected_value'] == "true")
				{
					echo " checked ";
				}
				echo "/> ";
				echo '<label for="adminsetting_'.$variable.'*'.$rowkeys['subkey'].'">';
				echo get_lang($rowkeys['subkeytext'])."</label><br>";
				$used_checkbox_forms[] = $variable."*".$rowkeys['subkey'];
			}
			break;
		case "link" :
			echo get_lang('CurrentValue')." : ".$selected_value;
	} // switch ($type)
}
//***********************************************
// the function that stores the values into the database
//***********************************************
function store_settings($storecategory)
{
	$table_settings_current = Database::get_main_table(MAIN_SETTINGS_CURRENT_TABLE);
	
	// the first step is to set all the variables that have type=checkbox of the category 
	// to false as the checkbox that is unchecked is not in the $_POST data and can 
	// therefore not be set to false
	$sql = "UPDATE $table_settings_current SET selected_value='false' WHERE category='".$storecategory."' AND type='checkbox'";
	$result = api_sql_query($sql,__FILE__,__LINE__);
	// treating the form data
	foreach ($_POST as $postkey => $postvalue)
	{
		if (strstr($postkey, "adminsetting_"))
		{
			if (strstr($postkey, "*"))
			{
				// case checkbox
				$setting_variable = str_replace("adminsetting_", "", $postkey);
				$naming_array = explode("*", $setting_variable);
				$sql = "UPDATE $table_settings_current SET selected_value='true' WHERE variable='".$naming_array[0]."' AND subkey='".$naming_array[1]."'";
				$result = api_sql_query($sql,__FILE__,__LINE__);
				$form_session_array[] = $naming_array[1];
			}
			else
			{
				// case textfield, textarea, radio, link
				$setting_variable = str_replace("adminsetting_", "", $postkey);
				$sql = "UPDATE $table_settings_current SET selected_value='$postvalue' WHERE variable='$setting_variable'";
				$result = api_sql_query($sql,__FILE__,__LINE__);
			}
		}
	}
	if (is_array($form_session_array)) 
	{
		foreach ($form_session_array as $key => $value)
		{
			unset ($_SESSION[$naming_array[0]]);
		}
	}
	return true;
}
?>

