<?php // $Id: languages.php,v 1.16 2005/04/28 07:09:44 sandrama Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2005 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
* This page allows the platform admin to decide which languages should
* be available in the language selection menu in the login page. This can be
* useful for countries with more than one official language (like Belgium: 
* Dutch, French and German) or international organisations that are active in	
* a limited number of countries. 
* 
* @author Patrick Cool, main author
* @author Roan EMbrechts, code cleaning
* @since Dokeos 1.6
* @package dokeos.admin
==============================================================================
*/

/*
============================================================================== 
	   INIT SECTION
============================================================================== 
*/
// language file to be included 
$langFile='admin';

// we are in the admin area so we do not need a course id
$cidReset=true;

// include global script
include('../inc/claro_init_global.inc.php');
api_protect_admin_script();
// setting the table that is needed for the styles management (there is a check if it exists later in this code)
$tbl_admin_languages=Database::get_main_table(MAIN_LANGUAGE_TABLE);
$tbl_settings_current=Database::get_main_table(MAIN_SETTINGS_CURRENT_TABLE);

/*
============================================================================== 
		STORING THE CHANGES
============================================================================== 
*/
// we change the availability
if ($_GET['action']=="makeinavailable")
{
	$sqlmakeinavailable="UPDATE $tbl_admin_languages SET available='0' WHERE id='".$_GET['id']."'";
	$result=api_sql_query($sqlmakeinavailable); 
}
if ($_GET['action']=="makeavailable")
{
	$sqlmakeavailable="UPDATE $tbl_admin_languages SET available='1' WHERE id='".$_GET['id']."'";
	$result=api_sql_query($sqlmakeavailable); 
}

if ($_POST['Submit'] and $_GET['id'])
{
	// changing the name
	$sqlupdate="UPDATE $tbl_admin_languages SET original_name='".$_POST["txt_name"]."' WHERE id='".$_GET['id']."'";
	$result=api_sql_query($sqlupdate); 
	// changing the Platform language
	if ($_POST['platformlanguage'] && $_POST['platformlanguage']<>"")
	{ 
		$sqlupdate2="UPDATE $tbl_settings_current SET selected_value='".$_POST['platformlanguage']."' WHERE variable='platformLanguage'";
		$result2=api_sql_query($sqlupdate2); 
	}
}



/*
============================================================================== 
		MAIN CODE
============================================================================== 
*/
// setting the name of the tool
$tool_name=get_lang('PlatformLanguages');

// setting breadcrumbs
$interbredcrump[]=array("url" => "index.php","name" => get_lang('AdministrationTools'));

// including the header file (which includes the banner itself)
Display::display_header($tool_name);

// displaying the naam of the tool 
api_display_tool_title($tool_name);

// displaying the explanation for this tool
echo '<p>'.get_lang('PlatformLanguagesExplanation').'</p>';

// selecting all the languages	
$sqlselect="SELECT * FROM $tbl_admin_languages";
$resultselect=api_sql_query($sqlselect); 

/*
--------------------------------------
		DISPLAY THE TABLE
--------------------------------------
*/
// The table headers
$column_header[] = array("<strong>".get_lang('OriginalName')."</strong>",true,'');
$column_header[] = array("<strong>".get_lang('EnglishName')."</strong>",true,'');
$column_header[] = array("<strong>".get_lang('DokeosFolder')."</strong>",true,'');
$column_header[] = array("<strong>".get_lang('Properties')."</strong>",true,'','style="text-align:center"');

// the table data
$language_data = array();
while ($row=mysql_fetch_array($resultselect))
{
	$row_td = array ();
	// the first column is the original name of the language OR a form containing the original name
	if ($_GET['action']=="edit" and $row['id']==$_GET['id'])
		{
		$row_td[]="<form name='edit' method='post' action='".$_SERVER['PHP_SELF']."?id=".$_GET['id']."'><input type='text' name='txt_name' value='".$row['original_name']."'><input type=\"checkbox\" name=\"platformlanguage\" value=\"".$row['english_name']."\">".$row['original_name'].' '.get_lang('AsPlatformLanguage')."<input type='submit' name='Submit' value='".get_lang('Ok')."'></form>";
		}
	else
		{
		$row_td[]=$row['original_name']; 
		}
	// the second column
	$row_td[]=$row['english_name'];
	// the third column
	$row_td[]=$row['dokeos_folder'];
	// the fourth column with the visibility icon and the edit icon
	if ($row['available']==1)
	{
		$row_td[]= "<a href='".$_SERVER['PHP_SELF']."?action=makeinavailable&id=".$row['id']."'><img src='../img/visible.gif' border='0' title=\"".get_lang('Visible')."\"></a> <a href='".$_SERVER['PHP_SELF']."?action=edit&id=".$row['id']."'><img src='../img/edit.gif' title='".get_lang('Edit')."' border='0'></a>";
	}
	else
	{
		$row_td[]= "<a href='".$_SERVER['PHP_SELF']."?action=makeavailable&id=".$row['id']."'><img src='../img/invisible.gif' border='0' title=\"".get_lang('Visible')."\"></a> <a href='".$_SERVER['PHP_SELF']."?action=edit&id=".$row['id']."'><img src='../img/edit.gif' title='".get_lang('Edit')."' border='0'></a>";	
	}

	$language_data[]=$row_td; 
}

// setting the paging options and the visibility options
$paging_options['per_page_default'] = count($language_data);
$paging_options['page_nr'] = (isset ($_GET['page_nr']) ? $_GET['page_nr'] : 1);
$paging_options['per_page'] = (isset ($_GET['per_page']) ? $_GET['per_page'] : count($language_data));
$sorting_options['column'] = (isset ($_GET['column']) ? $_GET['column'] : 0);
$sorting_options['direction'] = (isset ($_GET['direction']) ? $_GET['direction'] : SORT_ASC);

Display::display_sortable_table($column_header, $language_data, $sorting_options, $paging_options);

/*
==============================================================================
		FOOTER 
==============================================================================
*/ 
Display::display_footer();
?>