<?php
// $Id: course_list.php,v 1.15 2005/07/01 11:53:21 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
============================================================================== 
	@author Bart Mollet
*	@package dokeos.admin
============================================================================== 
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
$langFile = 'admin';
$cidReset = true;
require ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
require_once (api_get_library_path()."/course.lib.php");
if (isset ($_POST['action']))
{
	switch ($_POST['action'])
	{
		// Delete selected courses
		case 'delete_courses' :
			$course_codes = $_POST['course'];
			if (count($course_codes) > 0)
			{
				foreach ($course_codes as $index => $course_code)
				{
					CourseManager :: delete_course($course_code);
				}
			}
			break;
	}
}
if (isset ($_GET['search']) && $_GET['search'] == 'advanced')
{
	$category_table = Database :: get_main_table(MAIN_CATEGORY_TABLE);
	$sql = "SELECT * FROM $category_table";
	$res = api_sql_query($sql,__FILE__,__LINE__);
	$categories = array ();
	while ($category = mysql_fetch_array($res, MYSQL_ASSOC))
	{
		$categories[] = $category;
	}
	$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));
	$interbredcrump[] = array ("url" => 'course_list.php', "name" => get_lang('CourseList'));
	$tool_name = get_lang('SearchACourse');
	Display :: display_header($tool_name);
	api_display_tool_title($tool_name);
?>
		<form method="get" action="course_list.php">
	<table>
	<tr>
	<td>
	<?php echo get_lang('Title'); ?>
	</td>
	<td>
	<input type="text" name="keyword_title"/>
	</td>
	</tr>
	<tr>
	<td>
	<?php echo get_lang('Code'); ?>
	</td>
	<td>
	<input type="text" name="keyword_code"/>
	</td>
	</tr>
	<tr>
	<td>
	<?php echo get_lang('Category'); ?>
	</td>
	<td>
	<select name="keyword_category">
	<option value="%"><?php echo get_lang('All') ?></option>
	<?php

	foreach ($categories as $index => $category)
	{
		echo '<option value="'.$category['code'].'">'.$category['name'].'</option>';
	}
?>
	</select>
	</td>
	</tr>
		<tr>
	<td>
	<?php echo get_lang('Language'); ?>
	</td>
	<td>
	<select name="keyword_language">
	<option value="%"><?php echo get_lang('All') ?></option>
	<?php
	$languages = api_get_languages();
	foreach ($languages['name'] as $index => $name)
	{
		echo '<option value="'.$languages['folder'][$index].'">'.$name.'</option>';
	}
?>
	</select>
	</td>
	</tr>
	
	
<tr>
<td valign="top"><?php echo get_lang("CourseAccess")?></td>
<td>
<input class="checkbox" type="radio" name="keyword_visibility" id="visibility_all" value="%" checked="checked"> <label for="visibility_all"><?php echo get_lang('All'); ?></label> 
<br/>
<input class="checkbox" type="radio" name="keyword_visibility" id="visibility_open_world" value="<?php echo COURSE_VISIBILITY_OPEN_WORLD ?>"> <label for="visibility_open_world"><?php echo get_lang("OpenToTheWorld") ?></label>
<br/>
<input class="checkbox" type="radio" name="keyword_visibility" id="visibility_open_platform" value="<?php echo COURSE_VISIBILITY_OPEN_PLATFORM ?>"> <label for="visibility_open_platform"><?php echo  get_lang("OpenToThePlatform") ?></label>
<br/>
<input class="checkbox" type="radio" name="keyword_visibility" id="visibility_registered"  value="<?php echo COURSE_VISIBILITY_REGISTERED ?>"> <label for="visibility_registered"><?php echo  get_lang("Private") ?></label>
<br/>
<input class="checkbox" type="radio" name="keyword_visibility" id="visibility_closed"  value="<?php echo COURSE_VISIBILITY_CLOSED ?>"> <label for="visibility_closed"><?php echo  get_lang("CourseVisibilityClosed") ?></label>
</td></tr>


<tr>
<td valign="top"><?php echo get_lang("Subscription"); ?></td>
<td>
<input class="checkbox" type="radio" name="keyword_subscribe" id="subscribe_all" value="%" checked="checked"> <label for="subscribe_all"><?php echo get_lang('All'); ?></label> 
<input class="checkbox" type="radio" name="keyword_subscribe" id="allowedToSubscribeTrue"  value="<?php echo SUBSCRIBE_ALLOWED ?>"> <label for="allowedToSubscribeTrue"><?php echo get_lang("Allowed"); ?></label> 

<input class="checkbox" type="radio" name="keyword_subscribe" id="allowedToSubscribeFalse"  value="<?php echo SUBSCRIBE_NOT_ALLOWED ?>"> <label for="allowedToSubscribeFalse"><?php echo get_lang("Denied"); ?></label>
</td>
</tr>


<tr>
<td valign="top"><?php echo  get_lang("Unsubscription") ?></td>
<td>
<input class="checkbox" type="radio" name="keyword_unsubscribe" id="unsubscribe_all" value="%" checked="checked"> <label for="unsubscribe_all"><?php echo get_lang('All'); ?></label> 
<input class="checkbox" type="radio" name="keyword_unsubscribe" id="allowedToUnsubscribeTrue" value="<?php echo UNSUBSCRIBE_ALLOWED ?>"> <label for="allowedToUnsubscribeTrue"><?php echo get_lang("Allowed") ?></label> 
<input class="checkbox" type="radio" name="keyword_unsubscribe" id="allowedToUnsubscribeFalse" value="<?php echo UNSUBSCRIBE_NOT_ALLOWED ?>"> <label for="allowedToUnsubscribeFalse"><?php echo  get_lang("Denied") ?></label>
</td>
</tr>
	
	
	
	<tr>
	<td>
	</td>
	<td>
	<input type="submit" value="<?php echo get_lang('Ok'); ?>"/>
	</td>
	</table>
	</form>
	<?php

}
else
{
	$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));
	$tool_name = get_lang('CourseList');
	Display :: display_header($tool_name);
	api_display_tool_title($tool_name);
	if (isset ($_GET['delete_course']))
	{
		CourseManager :: delete_course($_GET['delete_course']);
	}
?>
	<form method="get" action="course_list.php">
	
	<input type="text" name="keyword" value="<?php echo $_GET['keyword']; ?>"/>
	<input type="submit" value="<?php echo get_lang('Search'); ?>"/>
	<a href="course_list.php?search=advanced"><?php echo get_lang('AdvancedSearch'); ?></a>
	</form>
<?php

	$course_table = Database :: get_main_table(MAIN_COURSE_TABLE);
	if (isset ($_GET['keyword']))
	{
		$keyword = addslashes($_GET['keyword']);
		$sql = "SELECT * FROM ".$course_table." WHERE title LIKE '%".$keyword."%' OR code LIKE '%".$keyword."%'";
		$parameters = array ('keyword' => $_GET['keyword']);
	}
	elseif (isset ($_GET['keyword_title']))
	{
		$keyword_title = addslashes($_GET['keyword_title']);
		$keyword_code = addslashes($_GET['keyword_code']);
		$keyword_category = addslashes($_GET['keyword_category']);
		$keyword_language = addslashes($_GET['keyword_language']);
		$keyword_visibility = addslashes($_GET['keyword_visibility']);
		$keyword_subscribe = addslashes($_GET['keyword_subscribe']);
		$keyword_unsubscribe = addslashes($_GET['keyword_unsubscribe']);
		$sql = "SELECT * FROM ".$course_table." WHERE title LIKE '%".$keyword_title."%' AND code LIKE '%".$keyword_code."%' AND category_code LIKE '%".$keyword_category."%' AND course_language LIKE '%".$keyword_language."%' AND visibility LIKE '%".$keyword_visibility."%' AND subscribe LIKE '%".$keyword_subscribe."%'  AND unsubscribe LIKE '%".$keyword_unsubscribe."%'";
		$parameters['keyword_title'] = $_GET['keyword_title'];
		$parameters['keyword_code'] = $_GET['keyword_code'];
		$parameters['keyword_category'] = $_GET['keyword_category'];
		$parameters['keyword_language'] = $_GET['keyword_language'];
		$parameters['keyword_visibility'] = $_GET['keyword_visibility'];
		$parameters['keyword_subscribe'] = $_GET['keyword_subscribe'];
		$parameters['keyword_unsubscribe'] = $_GET['keyword_unsubscribe'];
	}
	else
	{
		$sql = "SELECT * FROM ".$course_table;
		$parameters = array ();
	}
	$res = api_sql_query($sql,__FILE__,__LINE__);
	if (mysql_num_rows($res) > 0)
	{
		$courses = array ();
		while ($obj = mysql_fetch_object($res))
		{
			$course = array ();
			$course[] = '<input type="checkbox" name="course[]" value="'.$obj->code.'"/>';
			$course[] = $obj->code;
			$course[] = $obj->title;
			$course[] = $obj->course_language;
			$course[] = $obj->category_code;
			$course[] = $obj->subscribe == SUBSCRIBE_ALLOWED ? get_lang('Yes') : get_lang('No');
			$course[] = $obj->unsubscribe == UNSUBSCRIBE_ALLOWED ? get_lang('Yes') : get_lang('No');
			$course[] = CourseManager :: is_virtual_course_from_system_code($obj->code) ? get_lang('Yes') : get_lang('No');
			$course[] = '<a href="course_information.php?code='.$obj->code.'"><img src="../img/info_small.gif" border="0" align="absmiddle" alt="'.get_lang('Info').'"/></a>'.'<a href="'.api_get_path(WEB_COURSE_PATH).$obj->directory.'"><img src="../img/home_small.gif" border="0" align="absmiddle" title="'.get_lang('CourseHome').'"></a>'.'<a href="course_edit.php?id='.$obj->code.'"><img src="../img/edit.gif" border="0" align="absmiddle" alt="'.get_lang('Edit').'"/></a>'.'<a href="course_list.php?delete_course='.$obj->code.'"  onclick="javascript:if(!confirm('."'".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."'".')) return false;"><img src="../img/delete.gif" border="0" align="absmiddle" alt="'.get_lang('Delete').'"/></a>';
			$courses[] = $course;
		}
		$table_header[] = array (' ', false);
		$table_header[] = array (get_lang('Code'), true);
		$table_header[] = array (get_lang('Title'), true);
		$table_header[] = array (get_lang('Language'), true);
		$table_header[] = array (get_lang('Category'), true);
		$table_header[] = array (get_lang('SubscriptionAllowed'), true);
		$table_header[] = array (get_lang('UnsubscriptionAllowed'), true);
		$table_header[] = array (get_lang("IsVirtualCourse"), true, '');
		$table_header[] = array ('', false);
		echo '<form method="post" action="course_list.php">';
		Display :: display_sortable_table($table_header, $courses, array (), array (), $parameters);
		echo '<select name="action">';
		echo '<option value="delete_courses">'.get_lang('DeleteCourse').'</option>';
		echo '</select>';
		echo '<input type="submit" value="'.get_lang('Ok').'" onclick="javascript:if(!confirm('."'".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."'".')) return false;"/>';
		echo '</form>';
	}
	else
	{
		echo get_lang('NoSearchResults');
	}
}
/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?> 




