<?php
// $Id: course_information.php,v 1.13 2005/07/01 11:57:26 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
============================================================================== 
	@author Bart Mollet
*	@package dokeos.admin
============================================================================== 
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
$langFile = 'admin';
$cidReset = true;
require ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
/**
 * 
 */
function get_course_usage($course_code)
{
	$table = Database::get_main_table(MAIN_COURSE_TABLE);
	$sql = "SELECT * FROM $table WHERE code='".$course_code."'";
	$res = api_sql_query($sql,__FILE__,__LINE__);
	$course = mysql_fetch_object($res);
	// Learnpaths
	$table = Database :: get_course_table(LEARNPATH_MAIN_TABLE, $course->db_name);
	$usage[] = array (get_lang(TOOL_LEARNPATH), Database::count_rows($table));
	// Forums
	$table = Database :: get_course_table(FORUM_TABLE, $course->db_name);
	$usage[] = array (get_lang(TOOL_BB_FORUM), Database::count_rows($table));
	// Quizzes
	$table = Database :: get_course_table(QUIZ_TEST_TABLE, $course->db_name);
	$usage[] = array (get_lang(TOOL_QUIZ), Database::count_rows($table));
	// Documents
	$table = Database :: get_course_table(DOCUMENT_TABLE, $course->db_name);
	$usage[] = array (get_lang(TOOL_DOCUMENT), Database::count_rows($table));
	// Groups
	$table = Database :: get_course_table(GROUP_TABLE, $course->db_name);
	$usage[] = array (get_lang(TOOL_GROUP), Database::count_rows($table));
	// Calendar
	$table = Database :: get_course_table(AGENDA_TABLE, $course->db_name);
	$usage[] = array (get_lang(TOOL_CALENDAR_EVENT), Database::count_rows($table));
	// Link
	$table = Database::get_course_table(LINK_TABLE, $course->db_name);
	$usage[] = array(get_lang(TOOL_LINK), Database::count_rows($table));
	// Announcements
	$table = Database::get_course_table(ANNOUNCEMENT_TABLE, $course->db_name);
	$usage[] = array(get_lang(TOOL_ANNOUNCEMENT), Database::count_rows($table));
	return $usage;
}
/*****************************************************************/
if (!isset ($_GET['code']))
{
	api_not_allowed();
}
$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));
$interbredcrump[] = array ("url" => 'course_list.php', "name" => get_lang('Courses'));
$table_course = Database :: get_main_table(MAIN_COURSE_TABLE);
$code = $_GET['code'];
$sql = "SELECT * FROM $table_course WHERE code = '".$code."'";
$res = api_sql_query($sql,__FILE__,__LINE__);
$course = mysql_fetch_object($res);
$tool_name = $course->title.' ('.$course->code.')';
Display::display_header($tool_name);
api_display_tool_title($tool_name);
?>
<p>
<a href="<?php echo api_get_path(WEB_COURSE_PATH).$course->directory; ?>"><img src="../img/home_small.gif" border="0" align="absmiddle" /> <?php echo api_get_path(WEB_COURSE_PATH).$course->directory; ?></a>
<br/>
<?php
if( get_setting('server_type') == 'test')
{
	?>
	<a href="course_create_content.php?course_code=<?php echo $course->code ?>"><?php echo get_lang('AddDummyContentToCourse') ?></a>
	<?php
}
?>
</p>
<?php

echo '<h4>'.get_lang('CourseUsage').'</h4>';
echo '<blockquote>';
$table_header[] = array (get_lang('Tool'), true);
$table_header[] = array (get_lang('NumberOfItems'), true);
Display :: display_sortable_table($table_header, get_course_usage($course->code), array (), array (), array ('code' => $_GET['code']));
echo '</blockquote>';
/**
 * Show all users subscribed in this course
 */
echo '<h4>'.get_lang('Users').'</h4>';
echo '<blockquote>';
$table_course_user = Database :: get_main_table(MAIN_COURSE_USER_TABLE);
$table_user = Database :: get_main_table(MAIN_USER_TABLE);
$sql = 'SELECT *,cu.status as course_status FROM '.$table_course_user.' cu, '.$table_user." u WHERE cu.user_id = u.user_id AND cu.course_code = '".$code."' ";
$res = api_sql_query($sql,__FILE__,__LINE__);
if (mysql_num_rows($res) > 0)
{
	$table_header = array ();
	$table_header[] = array (get_lang('OfficialCode'), true);
	$table_header[] = array (get_lang('FirstName'), true);
	$table_header[] = array (get_lang('LastName'), true);
	$table_header[] = array (get_lang('Email'), true);
	$table_header[] = array (get_lang('Status'), true);
	$table_header[] = array ('', false);
	$data = array ();
	while ($obj = mysql_fetch_object($res))
	{
		$user = array ();
		$user[] = $obj->official_code;
		$user[] = $obj->firstname;
		$user[] = $obj->lastname;
		$user[] = Display :: encrypted_mailto_link($obj->email, $obj->email);
		$user[] = $obj->course_status == 5 ? get_lang('Student') : get_lang('Teacher');
		$user[] = '<a href="user_information.php?user_id='.$obj->user_id.'"><img src="../img/info_small.gif" border="0" align="absmiddle" title="'.get_lang('Info').'"/></a>';
		$users[] = $user;
	}
	Display :: display_sortable_table($table_header, $users, array (), array (), array ('code' => $_GET['code']));
}
else
{
	echo get_lang('NoUsersInCourse');
}
echo '</blockquote>';
/**
 * Show all classes subscribed in this course
 */
$table_course_class = Database :: get_main_table(MAIN_COURSE_CLASS_TABLE);
$table_class = Database :: get_main_table(MAIN_CLASS_TABLE);
$sql = 'SELECT * FROM '.$table_course_class.' cc, '.$table_class.' c WHERE cc.class_id = c.id AND cc.course_code = '."'".$_GET['code']."'";
$res = api_sql_query($sql,__FILE__,__LINE__);
if (mysql_num_rows($res) > 0)
{
	$header[] = array (get_lang('Title'), true);
	$header[] = array ('', false);
	$data = array ();
	while ($class = mysql_fetch_object($res))
	{
		$row = array ();
		$row[] = $class->name;
		$row[] = '<a href="class_information.php?id='.$class->id.'"><img src="../img/info_small.gif" border="0" align="absmiddle"  title="'.get_lang('Info').'"/></a>';
		$data[] = $row;
	}
	echo '<p><b>'.get_lang('AdminClasses').'</b></p>';
	echo '<blockquote>';
	Display :: display_sortable_table($header, $data, array (), array (), array ('code' => $_GET['code']));
	echo '</blockquote>';
}
else
{
	echo '<p>'.get_lang('NoClassesForThisCourse').'</p>';
}
/*
==============================================================================
		FOOTER 
==============================================================================
*/ 
Display::display_footer();
?> 

