<?php

// $Id: course_edit.php,v 1.11 2005/07/08 13:25:54 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	@package dokeos.admin
==============================================================================
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
$langFile = 'admin';
$cidReset = true;
include ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
include (api_get_library_path().'/fileManage.lib.php');
$id = $_GET['id'];
$tbl_course = Database :: get_main_table(MAIN_COURSE_TABLE);
$tbl_category = Database :: get_main_table(MAIN_CATEGORY_TABLE);
$noPHP_SELF = true;
$tool_name = get_lang('ModifyCourseInfo');
$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));
$interbredcrump[] = array ("url" => "course_list.php", "name" => get_lang('AdminCourses'));
$coursePathWeb = api_get_path(WEB_COURSE_PATH);
$coursePathSys = api_get_path(SYS_COURSE_PATH);
/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
/*
==============================================================================
		FUNCTIONS
==============================================================================
*/
$maxFilledSpace = get_setting('default_document_quotum');
$course_code = $id; //note confusion again: int id - string id - string code...
function get_course_quota()
{
	global $course_code, $maxFilledSpace;
	$course_table = Database :: get_main_table(MAIN_COURSE_TABLE);
	$sql_query = "SELECT disk_quota FROM $course_table WHERE code='$course_code'";
	$sql_result = api_sql_query($sql_query, __FILE__, __LINE__);
	$result = mysql_fetch_array($sql_result);
	$course_quota = $result['disk_quota'];
	if (is_null($course_quota))
	{
		//course table entry for quota was null
		//use default value
		$course_quota = $maxFilledSpace;
	}
	return $course_quota;
}
/*
==============================================================================
		MAIN CODE
==============================================================================
*/
if ($_POST['action'] == 'update_course')
{
	$dbName = $_POST['dbName'];
	$visual_code = trim(strtoupper(stripslashes($_POST['visual_code'])));
	$tutor_name = trim(stripslashes($_POST['tutor_name']));
	$title = trim(stripslashes($_POST['title']));
	$category_code = trim(stripslashes($_POST['category']));
	$department_name = trim(stripslashes($_POST['department_name']));
	$department_url = trim(stripslashes($_POST['department_url']));
	$course_language = trim(stripslashes($_POST['course_language']));
	$courseAccess = ($_POST['courseAccess'] == 'private') ? 'private' : 'public';
	$inscription = ($_POST['inscription'] == 'denied') ? 'denied' : 'allowed';
	$disk_quota = doubleval($_POST['disk_quota']);
	$visibility = intval($_POST['visibility']);
	$subscribe = intval($_POST['allowedToSubscribe']);
	$unsubscribe = intval($_POST['allowedToUnsubscribe']);
	if (empty ($visual_code))
		$error_message = get_lang('PleaseEnterCourseCode');
	elseif (empty ($tutor_name)) $error_message = get_lang('PleaseEnterTitularName');
	elseif (empty ($title)) $error_message = get_lang('PleaseEnterCourseTitle');
	else
	{
		if (!stristr($department_url, 'http://'))
		{
			$department_url = 'http://'.$department_url;
		}
		$sql = "UPDATE $tbl_course
										   SET course_language='".addslashes($course_language)."',
											   title='".addslashes($title)."',
											   category_code='".addslashes($category_code)."',
											   tutor_name='".addslashes($tutor_name)."',
											   visual_code='".addslashes($visual_code)."',
											   department_name='".addslashes($department_name)."',
											   department_url='".addslashes($department_url)."',
											   disk_quota='$disk_quota',
											   visibility = '".addslashes($visibility)."', 
											   subscribe = '".addslashes($subscribe)."',
											   unsubscribe='".addslashes($unsubscribe)."'
										   WHERE code='$id'";
		api_sql_query($sql, __FILE__, __LINE__);
		include ("../lang/english/create_course.inc.php");
		include ("../lang/".$_POST['course_language']."/create_course.inc.php");
		$tbl_bb_config = $courseTablePrefix.$dbName.$dbGlu."bb_config";
		$sql = "UPDATE `".$tbl_bb_config."` SET default_lang='".$_POST['course_language']."'";
		//$tbl_tool = $courseTablePrefix.$dbName.$dbGlu."tool";
		//api_sql_query($sql, __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('CourseDesc'))."' WHERE link LIKE 'course_description/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Agenda'))."' WHERE link LIKE 'calendar/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Doc'))."' WHERE link LIKE 'document/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Announcements'))."' WHERE link LIKE 'announcements/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Forums'))."' WHERE link LIKE 'phpbb/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Links'))."' WHERE link LIKE 'link/%'", __FILE__, __LINE__);
		//api_sql_query("Update `".$tbl_tool."` SET name='".addslashes(get_lang('Dropbox'))."' WHERE link LIKE 'dropbox/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Exercices'))."' WHERE link LIKE 'exercice/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Users'))."' WHERE link LIKE 'user/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Groups'))."' WHERE link LIKE 'group/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Chat'))."' WHERE link LIKE 'chat/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('OnlineConference'))."' WHERE link LIKE 'online/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Works'))."' WHERE link LIKE 'work/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Statistics'))."' WHERE link LIKE 'tracking/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('LinkSite'))."' WHERE link LIKE 'external_module/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('ModifyInfo'))."' WHERE link LIKE 'course_info/%'", __FILE__, __LINE__);
		//api_sql_query("UPDATE `".$tbl_tool."` SET name='".addslashes(get_lang('Scormtool'))."' WHERE link LIKE 'scorm/%'", __FILE__, __LINE__);

		$tbl_tool = Database :: get_course_tool_list_table($dbName);
		//next lines are temporary and can be deleted when course tool names are updated to their language independent values in the dokeos update script.
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_COURSE_DESCRIPTION."' WHERE link LIKE 'course_description/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_CALENDAR_EVENT."' WHERE link LIKE 'calendar/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_DOCUMENT."' WHERE link LIKE 'document/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_ANNOUNCEMENT."' WHERE link LIKE 'announcements/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_BB_FORUM."' WHERE link LIKE 'phpbb/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_LINK."' WHERE link = 'link/link.php'", __FILE__, __LINE__);
		api_sql_query("Update ".$tbl_tool." SET name='".TOOL_DROPBOX."' WHERE link LIKE 'dropbox/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_QUIZ."' WHERE link LIKE 'exercice/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_USER."' WHERE link LIKE 'user/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_GROUP."' WHERE link LIKE 'group/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_CHAT."' WHERE link LIKE 'chat/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_CONFERENCE."' WHERE link LIKE 'online/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_STUDENTPUBLICATION."' WHERE link LIKE 'work/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_TRACKING."' WHERE link LIKE 'tracking/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_HOMEPAGE_LINK."' WHERE link = 'link/link.php?action=addlink'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_COURSE_SETTING."' WHERE link LIKE 'course_info/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_LEARNPATH."' WHERE link LIKE 'scorm/%'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_BACKUP."' WHERE link = 'coursecopy/backup.php'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_COPY_COURSE_CONTENT."' WHERE link = 'coursecopy/copy_course.php'", __FILE__, __LINE__);
		api_sql_query("UPDATE ".$tbl_tool." SET name='".TOOL_RECYCLE_COURSE."' WHERE link = 'coursecopy/recycle_course.php'", __FILE__, __LINE__);

		header('Location: course_list.php');
		exit ();
	}
}
else
{
	$sql = "SELECT * FROM $tbl_course WHERE code='$id'";
	$result = api_sql_query($sql, __FILE__, __LINE__);
	if (mysql_num_rows($result) != 1)
	{
		header('Location: course_list.php');
		exit ();
	}
	$course = mysql_fetch_object($result);
	$dbName = $course->db_name;
	$visual_code = $course->visual_code;
	$tutor_name = $course->tutor_name;
	$title = $course->title;
	$category_code = $course->category_code;
	$department_name = $course->department_name;
	$department_url = $course->department_url;
	$course_language = $course->course_language;
	$disk_quota = $course->disk_quota;
	$visibility = $course->visibility;
	$subscribe = $course->subscribe;
	$unsubscribe = $course->unsubscribe;
}

Display :: display_header($tool_name);
api_display_tool_title($tool_name);
if (isset ($error_message))
{
	Display :: display_error_message($error_message);
}
$result = api_sql_query("SELECT code,name FROM $tbl_category ORDER BY tree_pos", __FILE__, __LINE__);
$Categories = api_store_result($result);
?>

<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?id=<?php echo $id; ?>" style="margin:0px;">
<input type="hidden" name="action" value="update_course">
<input type="hidden" name="dbName" value="<?php echo $dbName ?>">
<input type="hidden" name="directory" value="<?php echo $directory ?>">

<table>

<tr>
  <td><?php echo get_lang('CourseCode'); ?> </td>
  <td><input type="text" name="visual_code" size="40" value="<?php echo htmlspecialchars($visual_code) ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseTitular'); ?> </td>
  <td><input type="text" name="tutor_name" size="40" value="<?php  echo htmlspecialchars($tutor_name) ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseTitle'); ?> </td>
  <td><input type="text" name="title" size="40" value="<?php echo htmlspecialchars($title) ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseFaculty'); ?> </td>
  <td><select name="category">

<?php


foreach ($Categories as $enreg)
{
?>

  <option value="<?php echo $enreg['code']; ?>" <?php if($enreg['code'] == $category_code) echo 'selected="selected"'; ?>><?php echo '('.$enreg['code'].') '.$enreg['name']; ?></option>

<?php


}
unset ($Categories);
?>
  </select></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseDepartment'); ?> </td>
  <td><input type="text" name="department_name" size="40" value="<?php echo htmlspecialchars($department_name) ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseDepartmentURL'); ?> </td>
  <td><input type="text" name="department_url" size="40" value="<?php echo htmlspecialchars($department_url) ?>"></td>
<tr>
<tr>
  <td><?php echo get_lang('CourseLanguage'); ?> </td>
  <td><select name="course_language">

<?php


$languages = api_get_languages();
foreach ($languages['name'] as $index => $name)
{
?>
<option value="<?php echo $languages['folder'][$index] ?>" <?php if($course_language == $languages['folder'][$index]) echo 'selected="selected"'; ?>><?php echo $name ?></option>
<?php


}
?>

</select>
</tr>


<tr>
<td valign="top"><?php echo get_lang("CourseAccess")?></td>
<td>
<input class="checkbox" type="radio" name="visibility" id="visibility_open_world" value="<?php echo COURSE_VISIBILITY_OPEN_WORLD ?>"   <?php echo $visibility == COURSE_VISIBILITY_OPEN_WORLD ? ' checked="checked"' : '' ?>> <label for="visibility_open_world"><?php echo get_lang("OpenToTheWorld") ?></label>
<br/>
<input class="checkbox" type="radio" name="visibility" id="visibility_open_platform" value="<?php echo COURSE_VISIBILITY_OPEN_PLATFORM ?>" <?php echo $visibility == COURSE_VISIBILITY_OPEN_PLATFORM ? ' checked="checked"' : '' ?> > <label for="visibility_open_platform"><?php echo  get_lang("OpenToThePlatform") ?></label>
<br/>
<input class="checkbox" type="radio" name="visibility" id="visibility_registered"  value="<?php echo COURSE_VISIBILITY_REGISTERED ?>" <?php echo $visibility == COURSE_VISIBILITY_REGISTERED ? ' checked="checked"' : '' ?>> <label for="visibility_registered"><?php echo  get_lang("Private") ?></label>
<br/>
<input class="checkbox" type="radio" name="visibility" id="visibility_closed"  value="<?php echo COURSE_VISIBILITY_CLOSED ?>" <?php echo $visibility == COURSE_VISIBILITY_CLOSED ? ' checked="checked"' : '' ?>> <label for="visibility_closed"><?php echo  get_lang("CourseVisibilityClosed") ?></label>
</td></tr>


<tr>
<td valign="top"><?php echo get_lang("Subscription"); ?></td>
<td>
<input class="checkbox" type="radio" name="allowedToSubscribe" id="allowedToSubscribeTrue"  value="<?php echo SUBSCRIBE_ALLOWED ?>" <?php echo $subscribe == SUBSCRIBE_ALLOWED ? ' checked="checked"' : '' ?>> <label for="allowedToSubscribeTrue"><?php echo get_lang("Allowed"); ?></label><br/>

<input class="checkbox" type="radio" name="allowedToSubscribe" id="allowedToSubscribeFalse"  value="<?php echo SUBSCRIBE_NOT_ALLOWED ?>" <?php echo $subscribe == SUBSCRIBE_NOT_ALLOWED ? ' checked="checked"' : '' ?>> <label for="allowedToSubscribeFalse"><?php echo get_lang("Denied"); ?></label>
</td>
</tr>


<tr>
<td valign="top"><?php echo  get_lang("Unsubscription") ?></td>
<td>
<input class="checkbox" type="radio" name="allowedToUnsubscribe" id="allowedToUnsubscribeTrue" value="<?php echo UNSUBSCRIBE_ALLOWED ?>" <?php echo $unsubscribe == UNSUBSCRIBE_ALLOWED ? ' checked="checked"' : '' ?>> <label for="allowedToUnsubscribeTrue"><?php echo get_lang("Allowed") ?></label><br/>
<input class="checkbox" type="radio" name="allowedToUnsubscribe" id="allowedToUnsubscribeFalse" value="<?php echo UNSUBSCRIBE_NOT_ALLOWED ?>" <?php echo $unsubscribe == UNSUBSCRIBE_NOT_ALLOWED ? ' checked="checked"' : '' ?>> <label for="allowedToUnsubscribeFalse"><?php echo  get_lang("Denied") ?></label>
</td>
</tr>
<tr>
  <td><?php echo get_lang('CourseQuota'); ?></td>
  <td><input type="text" value="<?php echo get_course_quota(); ?>" size="20" maxlength="10" name="disk_quota"></td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td><input type="submit" value="<?php echo get_lang('Ok'); ?>"></td>
</tr>
</table>

</form>



<?php


/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?>


