<?php
// $Id: course_add.php,v 1.10 2005/05/30 11:46:48 bmol Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
==============================================================================
*	@package dokeos.admin
==============================================================================
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
$langFile = 'admin';
$cidReset = true;
require_once ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
require_once (api_get_library_path().'/fileManage.lib.php');
require_once (api_get_configuration_path()."/add_course.conf.php");
require_once (api_get_library_path()."/add_course.lib.inc.php");
$table_category = Database :: get_main_table(MAIN_CATEGORY_TABLE);
$table_user = Database :: get_main_table(MAIN_USER_TABLE);
$table_course = Database::get_main_table(MAIN_COURSE_TABLE);
$tool_name = get_lang('AddCourse');
$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));
$coursePathWeb = api_get_path(WEB_COURSE_PATH);
$coursePathSys = api_get_path(SYS_COURSE_PATH);
/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
/*
==============================================================================
		FUNCTIONS
==============================================================================
*/
/*
==============================================================================
		MAIN CODE
==============================================================================
*/
if ($_POST['action'] == 'add_course')
{
	$sql = "SELECT * FROM $table_user WHERE user_id='".intval($_POST['teacher'])."'";
	$res = api_sql_query($sql,__FILE__,__LINE__);
	$teacher = mysql_fetch_object($res);
	$code = trim(strtoupper(stripslashes($_POST['visual_code'])));
	$tutor_name = $teacher->lastname.' '.$teacher->firstname;
	$teacher_id = $teacher->user_id;
	$title = trim(stripslashes($_POST['title']));
	$category = trim(stripslashes($_POST['category']));
	$department_name = trim(stripslashes($_POST['department_name']));
	$department_url = trim(stripslashes($_POST['department_url']));
	$course_language = trim(stripslashes($_POST['course_language']));
	$disk_quota = doubleval($_POST['disk_quota']);
	if (empty ($code))
		$error_message = get_lang('PleaseEnterCourseCode');
	elseif (empty ($tutor_name)) $error_message = get_lang('PleaseEnterTitularName');
	elseif (empty ($title)) $error_message = get_lang('PleaseEnterCourseTitle');
	else
	{
		if (!stristr($department_url, 'http://'))
		{
			$department_url = 'http://'.$department_url;
		}
		$keys = define_course_keys($code, "", $dbNamePrefix);
		if (sizeof($keys))
		{
			$currentCourseCode = $keys["currentCourseCode"];
			$currentCourseId = $keys["currentCourseId"];
			$currentCourseDbName = $keys["currentCourseDbName"];
			$currentCourseRepository = $keys["currentCourseRepository"];
			$expiration_date = time() + $firstExpirationDelay;
			prepare_course_repository($currentCourseRepository, $currentCourseId);
			update_Db_course($currentCourseDbName);
			fill_course_repository($currentCourseRepository);
			fill_Db_course($currentCourseDbName, $currentCourseRepository, $course_language);
			register_course($currentCourseId, $currentCourseCode, $currentCourseRepository, $currentCourseDbName, $tutor_name, $category, $title, $course_language, $teacher_id, $expiration_date);
			
			$sql = "UPDATE $table_course SET disk_quota = '".addslashes(intval($_POST['disk_quota']))."', visibility = '".addslashes($_POST['visibility'])."', subscribe = '".addslashes($_POST['allowedToSubscribe'])."', unsubscribe='".addslashes($_POST['allowedToUnsubscribe'])."' WHERE code = '".$currentCourseId."'";
			api_sql_query($sql,__FILE__,__LINE__);
			header('Location: course_list.php');
			exit ();
		}
	}
}
Display::display_header($tool_name);
api_display_tool_title($tool_name);
if( isset($error_message) )
{
	Display::display_error_message($error_message);	
}
$result = api_sql_query("SELECT code,name FROM $table_category ORDER BY tree_pos", __FILE__, __LINE__);
$Categories = api_store_result($result);
$sql = "SELECT * FROM $table_user WHERE status=1 ORDER BY lastname,firstname";
$res = api_sql_query($sql,__FILE__,__LINE__);
$teachers = api_store_result($res);
?>

<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
<input type="hidden" name="action" value="add_course"/>
<table>
<tr>
  <td><?php echo get_lang('CourseCode'); ?>&nbsp;</td>
  <td><input type="text" name="visual_code" size="40" value="<?php echo $code ?>"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseTitular'); ?>&nbsp;</td>
  <td>
  	<select name="teacher">
  	<?php

foreach ($teachers as $index => $teacher)
{
	echo '<option value="'.$teacher['user_id'].'"';
	echo $teacher_id == $teacher['user_id'] ? ' selected="selected"' : '';
	echo '>'.$teacher['lastname'].' '.$teacher['firstname'].'</option>';
}
?>
  	</select>
  </td>
</tr>
<tr>
  <td><?php echo get_lang('CourseTitle'); ?>&nbsp;</td>
  <td><input type="text" name="title" size="40"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseFaculty'); ?>&nbsp;</td>
  <td><select name="category">

<?php

foreach ($Categories as $enreg)
{
?>

  <option value="<?php echo $enreg['code']; ?>"><?php echo '('.$enreg['code'].') '.$enreg['name']; ?></option>

<?php

}
unset ($Categories);
?>
 </select></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseDepartment'); ?>&nbsp;</td>
  <td><input type="text" name="department_name" size="40"></td>
</tr>
<tr>
  <td><?php echo get_lang('CourseDepartmentURL'); ?>&nbsp;</td>
  <td><input type="text" name="department_url" size="40"></td>
<tr>
<tr>
  <td><?php echo get_lang('CourseLanguage'); ?>&nbsp;</td>
  <td><select name="course_language">

<?php

$languages = api_get_languages();
foreach ($languages['name'] as $index => $name)
{
?>
<option value="<?php echo $languages['folder'][$index] ?>"><?php echo $name ?></option>
<?php

}
?>

</select>
</tr>

<tr>
<td valign="top"><?php echo get_lang("CourseAccess")?></td>
<td>
<input class="checkbox" type="radio" name="visibility" id="visibility_open_world" value="<?php echo COURSE_VISIBILITY_OPEN_WORLD ?>"> <label for="visibility_open_world"><?php echo get_lang("OpenToTheWorld") ?></label>
<br/>
<input class="checkbox" type="radio" name="visibility" id="visibility_open_platform" value="<?php echo COURSE_VISIBILITY_OPEN_PLATFORM ?>"  checked="checked"> <label for="visibility_open_platform"><?php echo  get_lang("OpenToThePlatform") ?></label>
<br/>
<input class="checkbox" type="radio" name="visibility" id="visibility_registered"  value="<?php echo COURSE_VISIBILITY_REGISTERED ?>"> <label for="visibility_registered"><?php echo  get_lang("Private") ?></label>
<br/>
<input class="checkbox" type="radio" name="visibility" id="visibility_closed"  value="<?php echo COURSE_VISIBILITY_CLOSED ?>"> <label for="visibility_closed"><?php echo  get_lang("CourseVisibilityClosed") ?></label>
</td></tr>


<tr>
<td valign="top"><?php echo get_lang("Subscription"); ?></td>
<td>
<input class="checkbox" type="radio" name="allowedToSubscribe" id="allowedToSubscribeTrue"  value="<?php echo SUBSCRIBE_ALLOWED ?>"  checked="checked"> <label for="allowedToSubscribeTrue"><?php echo get_lang("Allowed"); ?></label><br/>

<input class="checkbox" type="radio" name="allowedToSubscribe" id="allowedToSubscribeFalse"  value="<?php echo SUBSCRIBE_NOT_ALLOWED ?>"> <label for="allowedToSubscribeFalse"><?php echo get_lang("Denied"); ?></label>
</td>
</tr>


<tr>
<td valign="top"><?php echo  get_lang("Unsubscription") ?></td>
<td>
<input class="checkbox" type="radio" name="allowedToUnsubscribe" id="allowedToUnsubscribeTrue" value="<?php echo UNSUBSCRIBE_ALLOWED ?>" checked="checked"> <label for="allowedToUnsubscribeTrue"><?php echo get_lang("AllowedToUnsubscribe") ?></label><br/>
<input class="checkbox" type="radio" name="allowedToUnsubscribe" id="allowedToUnsubscribeFalse" value="<?php echo UNSUBSCRIBE_NOT_ALLOWED ?>"> <label for="allowedToUnsubscribeFalse"><?php echo  get_lang("NotAllowedToUnsubscribe") ?></label>
</td>
</tr>


<tr>
 <td></td>
 <td><font color="gray"><?php echo get_lang("ConfTip"); ?></font></td>
</tr>

<tr>
  <td><?php echo get_lang('CourseQuota'); ?></td>
  <td><input type="text" value="<?php echo get_setting('default_document_quotum'); ?>" size="20" maxlength="10" name="disk_quota"></td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td><input type="submit" value="<?php echo get_lang('Ok'); ?>"></td>
</tr>
</table>

</form>



<?php

/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?>