<?php
// $Id: class_list.php,v 1.13 2005/07/01 11:58:54 olivierb78 Exp $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Dokeos, 181 rue Royale, B-1000 Brussels, Belgium, info@dokeos.com
==============================================================================
*/
/**
============================================================================== 
*	@package dokeos.admin
============================================================================== 
*/
$langFile = 'admin';
$cidReset = true;
require ('../inc/claro_init_global.inc.php');
api_protect_admin_script();
require (api_get_library_path().'/fileManage.lib.php');
require (api_get_library_path().'/classmanager.lib.php');
$keyword = trim(stripslashes($_GET['keyword']));
$tbl_class = Database :: get_main_table(MAIN_CLASS_TABLE);
$tbl_class_user = Database :: get_main_table(MAIN_CLASS_USER_TABLE);
$tbl_course = Database :: get_main_table(MAIN_COURSE_TABLE);
$tbl_course_user = Database :: get_main_table(MAIN_COURSE_USER_TABLE);
$tbl_course_class = Database :: get_main_table(MAIN_COURSE_CLASS_TABLE);
$tool_name = get_lang('ClassList');
$interbredcrump[] = array ("url" => "index.php", "name" => get_lang('AdministrationTools'));

Display::display_header($tool_name);
api_display_tool_title($tool_name);
if (isset ($_POST['action']))
{
	switch ($_POST['action'])
	{
		// Delete selected courses
		case 'delete_classes' :
			$classes = $_POST['class'];
			if (count($classes) > 0)
			{
				foreach ($classes as $index => $class_id)
				{
					ClassManager :: delete_class($class_id);
				}
				Display::display_normal_message(get_lang('ClassesDeleted'));	
			}
			break;
	}
}
if( isset($_GET['action']))
{
	switch($_GET['action'])
	{
		case 'delete_class':
			ClassManager::delete_class($_GET['class_id']);
			Display::display_normal_message(get_lang('ClassDeleted'));	
	}	
}
?>
<form method="get" action="class_list.php">
		<input type="text" name="keyword" value="<?php echo $_GET['keyword']; ?>"/>
	<input type="submit" value="<?php echo get_lang('Search'); ?>"/>
	</form>
<?php
$sql = "SELECT id,name,COUNT(user_id) AS number_of_users FROM $tbl_class LEFT JOIN $tbl_class_user ON id=class_id ".(empty($keyword)?"":"WHERE (name LIKE '%".addslashes($keyword)."%')")." GROUP BY id,name ORDER BY name";;
$classes = api_sql_query($sql, __FILE__, __LINE__);
if (mysql_num_rows($classes) > 0)
{
	while ($class = mysql_fetch_object($classes))
	{
		$row = array ();
		$row[] = '<input type="checkbox" name="class[]" value="'.$class->id.'"/>';
		$row[] = $class->name;
		$row[] = $class->number_of_users;
		$row[] = '<a href="class_information.php?id='.$class->id.'"><img src="../img/info_small.gif" border="0" align="absmiddle" title="'.get_lang('ClassInfo').'"></a>'.'<a href="class_edit.php?idclass='.$class->id.'"><img src="../img/edit.gif" title="'.get_lang('Modify').'" border="0" align="absmiddle"></a>'.'<a href="class_list.php?action=delete_class&class_id='.$class->id.'" onclick="javascript:if(!confirm('."'".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."'".')) return false;"><img src="../img/delete.gif" title="'.get_lang('Delete').'" border="0" align="absmiddle"></a>'.'<a href="subscribe_user2class.php?idclass='.$class->id.'"><img src="../img/group_small.gif" border="0" align="absmiddle" title="'.get_lang('SubscribeUser2Class').'"></a>';
		$data[] = $row;
	}
	$table_header[] = array ('', false);
	$table_header[] = array (get_lang("ClassName"), true);
	$table_header[] = array (get_lang("NumberOfUsers"), true);
	$table_header[] = array (get_lang("Actions"), true);
	echo '<form method="post" action="class_list.php">';
	Display :: display_sortable_table($table_header, $data);
	echo '<select name="action">';
	echo '<option value="delete_classes">'.get_lang('DeleteSelectedClasses').'</option>';
	echo '</select>';
	echo '<input type="submit" value="'.get_lang('Ok').'" onclick="javascript:if(!confirm('."'".addslashes(htmlspecialchars(get_lang("ConfirmYourChoice")))."'".')) return false;"/>';
	echo '</form>';
}
else
{
	echo get_lang('NoSearchResults');
}
/*
==============================================================================
		FOOTER 
==============================================================================
*/ 
Display::display_footer();
?>


